/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class UriInfoImpl
implements UriInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(UriInfoImpl.class);
    private static final String CASE_INSENSITIVE_QUERIES = "org.apache.cxf.http.case_insensitive_queries";
    private static final String PARSE_QUERY_VALUE_AS_COLLECTION = "parse.query.value.as.collection";
    private MultivaluedMap<String, String> templateParams;
    private Message message;
    private OperationResourceInfoStack stack;
    private boolean caseInsensitiveQueries;
    private boolean queryValueIsCollection;
    static final long serialVersionUID = -3325157586518236844L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UriInfoImpl(Message m) {
        this(m, (MultivaluedMap<String, String>)((MultivaluedMap)((MessageImpl)m).getTemplateParameters()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "<init>", new Object[]{m});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UriInfoImpl(Message m, MultivaluedMap<String, String> templateParams) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "<init>", new Object[]{m, templateParams});
        }
        this.message = m;
        this.templateParams = templateParams;
        if (m != null) {
            this.stack = (OperationResourceInfoStack)((MessageImpl)m).getOperationResourceInfoStack();
            this.caseInsensitiveQueries = MessageUtils.getContextualBoolean((Message)m, (String)CASE_INSENSITIVE_QUERIES);
            this.queryValueIsCollection = MessageUtils.getContextualBoolean((Message)m, (String)PARSE_QUERY_VALUE_AS_COLLECTION);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI getAbsolutePath() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePath", new Object[0]);
        }
        String path = this.getAbsolutePathAsString();
        URI uRI = URI.create(path);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePath", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UriBuilder getAbsolutePathBuilder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePathBuilder", new Object[0]);
        }
        UriBuilderImpl uriBuilderImpl = new UriBuilderImpl(this.getAbsolutePath());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uriBuilderImpl = uriBuilderImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePathBuilder", uriBuilderImpl);
        }
        return uriBuilderImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI getBaseUri() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getBaseUri", new Object[0]);
        }
        URI u = URI.create(HttpUtils.getEndpointAddress(this.message));
        URI uRI = HttpUtils.toAbsoluteUri(u, this.message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getBaseUri", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UriBuilder getBaseUriBuilder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getBaseUriBuilder", new Object[0]);
        }
        UriBuilderImpl uriBuilderImpl = new UriBuilderImpl(this.getBaseUri());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uriBuilderImpl = uriBuilderImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getBaseUriBuilder", uriBuilderImpl);
        }
        return uriBuilderImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPath", new Object[0]);
        }
        String string = this.getPath(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath(boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPath", new Object[]{decode});
        }
        String value = this.doGetPath(decode, true);
        if (value.length() > 1 && value.startsWith("/")) {
            String string = value.substring(1);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPath", string);
            }
            return string;
        }
        String string = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<PathSegment> getPathSegments() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathSegments", new Object[0]);
        }
        List<PathSegment> list = this.getPathSegments(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathSegments", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<PathSegment> getPathSegments(boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathSegments", new Object[]{decode});
        }
        List<PathSegment> list = JAXRSUtils.getPathSegments(this.getPath(false), decode);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathSegments", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MultivaluedMap<String, String> getQueryParameters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getQueryParameters", new Object[0]);
        }
        MultivaluedMap<String, String> multivaluedMap = this.getQueryParameters(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getQueryParameters", multivaluedMap);
        }
        return multivaluedMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getQueryParameters", new Object[]{decode});
        }
        MetadataMap<String, String> queries = !this.caseInsensitiveQueries ? new MetadataMap<String, String>() : new MetadataMap(false, true);
        JAXRSUtils.getStructuredParams(queries, ((MessageImpl)this.message).getQueryString(), "&", decode, decode, this.queryValueIsCollection);
        MetadataMap<String, String> metadataMap = queries;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getQueryParameters", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI getRequestUri() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getRequestUri", new Object[0]);
        }
        String path = this.getAbsolutePathAsString();
        String queries = ((MessageImpl)this.message).getQueryString();
        if (queries != null) {
            path = path + "?" + queries;
        }
        URI uRI = URI.create(path);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getRequestUri", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UriBuilder getRequestUriBuilder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getRequestUriBuilder", new Object[0]);
        }
        UriBuilderImpl uriBuilderImpl = new UriBuilderImpl(this.getRequestUri());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uriBuilderImpl = uriBuilderImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getRequestUriBuilder", uriBuilderImpl);
        }
        return uriBuilderImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MultivaluedMap<String, String> getPathParameters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathParameters", new Object[0]);
        }
        MultivaluedMap<String, String> multivaluedMap = this.getPathParameters(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedMap = multivaluedMap;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathParameters", multivaluedMap);
        }
        return multivaluedMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathParameters", new Object[]{decode});
        }
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        if (this.templateParams == null) {
            MetadataMap<String, String> metadataMap = values;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                metadataMap = metadataMap;
                LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathParameters", metadataMap);
            }
            return metadataMap;
        }
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add((String)entry.getKey(), decode ? HttpUtils.pathDecode((String)((List)entry.getValue()).get(0)) : (String)((List)entry.getValue()).get(0));
        }
        MetadataMap<String, String> metadataMap = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getPathParameters", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Object> getMatchedResources() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedResources", new Object[0]);
        }
        if (this.stack != null) {
            ArrayList<Object> resources = new ArrayList<Object>(this.stack.size());
            for (MethodInvocationInfo invocation : this.stack) {
                resources.add(0, invocation.getRealClass());
            }
            ArrayList<Object> arrayList = resources;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedResources", arrayList);
            }
            return arrayList;
        }
        LOG.fine("No resource stack information, returning empty list");
        List<Object> list = Collections.emptyList();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedResources", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getMatchedURIs() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedURIs", new Object[0]);
        }
        List<String> list = this.getMatchedURIs(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedURIs", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getMatchedURIs(boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedURIs", new Object[]{decode});
        }
        if (this.stack != null) {
            ArrayList<String> objects = new ArrayList<String>();
            LinkedList<String> uris = new LinkedList<String>();
            StringBuilder sumPath = new StringBuilder("");
            for (MethodInvocationInfo invocation : this.stack) {
                List<String> templateObjects = invocation.getTemplateValues();
                OperationResourceInfo ori = invocation.getMethodInfo();
                URITemplate[] paths = new URITemplate[]{ori.getClassResourceInfo().getURITemplate(), ori.getURITemplate()};
                if (paths[0] != null) {
                    int count = paths[0].getVariables().size();
                    ArrayList<String> rootObjects = new ArrayList<String>(count);
                    for (int i = 0; i < count && i < templateObjects.size(); ++i) {
                        rootObjects.add(templateObjects.get(i));
                    }
                    uris.add(0, UriInfoImpl.createMatchedPath(paths[0].getValue(), rootObjects, decode));
                }
                if (paths[1] == null || paths[1].getValue().length() <= 1) continue;
                for (URITemplate t : paths) {
                    if (t == null) continue;
                    sumPath.append('/').append(t.getValue());
                }
                objects.addAll(templateObjects);
                uris.add(0, UriInfoImpl.createMatchedPath(sumPath.toString(), objects, decode));
            }
            LinkedList<String> linkedList = uris;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                linkedList = linkedList;
                LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedURIs", linkedList);
            }
            return linkedList;
        }
        LOG.fine("No resource stack information, returning empty list");
        List<String> list = Collections.emptyList();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getMatchedURIs", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String createMatchedPath(String uri, List<? extends Object> vars, boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "createMatchedPath", new Object[]{uri, vars, decode});
        }
        String uriPath = UriBuilder.fromPath((String)uri).buildFromEncoded(vars.toArray()).getRawPath();
        String string = uriPath = decode ? HttpUtils.pathDecode(uriPath) : uriPath;
        if (uriPath.startsWith("/")) {
            uriPath = uriPath.substring(1);
        }
        String string2 = uriPath;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string2 = string2;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "createMatchedPath", string2);
        }
        return string2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String doGetPath(boolean decode, boolean addSlash) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "doGetPath", new Object[]{decode, addSlash});
        }
        String path = HttpUtils.getPathToMatch(this.message, addSlash);
        String string = decode ? HttpUtils.pathDecode(path) : path;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "doGetPath", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getAbsolutePathAsString() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePathAsString", new Object[0]);
        }
        String address = this.getBaseUri().toString();
        if (MessageUtils.isRequestor((Message)this.message)) {
            String string = address;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePathAsString", string);
            }
            return string;
        }
        String path = this.doGetPath(false, false);
        if (path.startsWith("/") && address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        if (!(path.isEmpty() || path.startsWith("/") || address.endsWith("/"))) {
            address = address + "/";
        }
        String string = address + path;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "getAbsolutePathAsString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI relativize(URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "relativize", new Object[]{uri});
        }
        URI resolved = HttpUtils.resolve(this.getBaseUriBuilder(), uri);
        URI uRI = HttpUtils.relativize(this.getRequestUri(), resolved);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "relativize", uRI);
        }
        return uRI;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URI resolve(URI uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.UriInfoImpl", "resolve", new Object[]{uri});
        }
        URI uRI = HttpUtils.resolve(this.getBaseUriBuilder(), uri);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRI = uRI;
            LOG.exiting("org.apache.cxf.jaxrs.impl.UriInfoImpl", "resolve", uRI);
        }
        return uRI;
    }
}

