/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.BaseMetrics;
import com.ibm.ws.microprofile.metrics.WriterFactory;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.HTTPMethodNotAllowedException;
import com.ibm.ws.microprofile.metrics.exceptions.HTTPNotAcceptableException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.microprofile.metrics.writer.JSONMetadataWriter;
import com.ibm.ws.microprofile.metrics.writer.JSONMetricWriter;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BaseMetricsHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(BaseMetricsHandler.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected BaseMetrics bm;
    protected SharedMetricRegistries sharedMetricRegistry;
    protected WriterFactory writerFactory;
    static final long serialVersionUID = 8084714295839074717L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchMetricException.class, NoSuchRegistryException.class, HTTPNotAcceptableException.class, HTTPMethodNotAllowedException.class})
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        Locale locale = null;
        String regName = "";
        String attName = "";
        String acceptHeader = "";
        String method = "";
        try {
            locale = request.getLocale();
            regName = request.getPathVariable("sub");
            attName = request.getPathVariable("attribute");
            acceptHeader = request.getHeader("Accept");
            method = request.getMethod();
            this.setInitialContentType(request, response);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.metrics.BaseMetricsHandler", (String)"59", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"internal.error.CWMMC0006E", (Object[])new Object[]{e}));
        }
        try {
            OutputWriter outputWriter = this.getOutputWriter(request, response, locale);
            String attribute = request.getPathVariable("attribute");
            String sub = request.getPathVariable("sub");
            if (outputWriter instanceof JSONMetricWriter) {
                response.setContentType("application/json; charset=utf-8");
            } else if (outputWriter instanceof JSONMetadataWriter) {
                response.setContentType("application/json; charset=utf-8");
            } else {
                response.setContentType("text/plain; charset=utf-8");
            }
            if (attribute != null) {
                attribute = this.checkSlash(attribute);
                outputWriter.write(sub, attribute);
            } else if (sub != null) {
                sub = this.checkSlash(sub);
                outputWriter.write(sub);
            } else {
                outputWriter.write();
            }
        }
        catch (EmptyRegistryException e) {
            Tr.event((TraceComponent)tc, (String)("The " + regName + " registry is empty."), (Object[])new Object[0]);
            response.setStatus(204);
        }
        catch (NoSuchRegistryException e) {
            Tr.event((TraceComponent)tc, (String)("The registry" + regName + " was not found."), (Object[])new Object[0]);
            response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"registryNotFound.info.CWMMC0003I", (Object[])new Object[]{regName}));
        }
        catch (NoSuchMetricException e) {
            Tr.event((TraceComponent)tc, (String)("The metric " + attName + " was not found."), (Object[])new Object[0]);
            response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"metricNotFound.info.CWMMC0002I", (Object[])new Object[]{attName}));
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.metrics.BaseMetricsHandler", (String)"94", (Object)this, (Object[])new Object[]{request, response});
            Tr.event((TraceComponent)tc, (String)"internal.error.CWMMC0006E", (Object[])new Object[0]);
            response.sendError(500, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"internal.error.CWMMC0006E", (Object[])new Object[0]));
        }
        catch (HTTPNotAcceptableException e) {
            Tr.event((TraceComponent)tc, (String)("Accept Header: " + acceptHeader + ", is invalid."), (Object[])new Object[0]);
            response.sendError(406, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"notAcceptable.info.CWMMC0000I", (Object[])new Object[]{acceptHeader}));
        }
        catch (HTTPMethodNotAllowedException e) {
            Tr.event((TraceComponent)tc, (String)("HTTP method: " + method + ", is not allowed."), (Object[])new Object[0]);
            response.sendError(405, Tr.formatMessage((TraceComponent)tc, (Locale)locale, (String)"requestType.info.CWMMC0001I", (Object[])new Object[0]));
        }
    }

    private OutputWriter getOutputWriter(RESTRequest request, RESTResponse response, Locale locale) throws IOException, HTTPNotAcceptableException, HTTPMethodNotAllowedException {
        String method = request.getMethod();
        String accept = request.getHeader("Accept");
        Writer writer = response.getWriter();
        if (accept == null) {
            accept = "text/plain";
        }
        if ("GET".equals(method)) {
            if (accept.contains("text/plain")) {
                return this.writerFactory.getPrometheusMetricsWriter(writer, locale);
            }
            if (accept.contains("application/json")) {
                return this.writerFactory.getJSONMetricWriter(writer);
            }
            Tr.event((TraceComponent)tc, (String)"The Accept header is invalid.", (Object[])new Object[0]);
            return this.writerFactory.getPrometheusMetricsWriter(writer, locale);
        }
        if ("OPTIONS".equals(method)) {
            if (accept.contains("application/json")) {
                return this.writerFactory.getJSONMetadataWriter(writer, locale);
            }
            throw new HTTPNotAcceptableException();
        }
        throw new HTTPMethodNotAllowedException();
    }

    private void setInitialContentType(RESTRequest request, RESTResponse response) {
        String accept = request.getHeader("Accept");
        if (accept == null) {
            accept = "text/plain";
        }
        if (accept.contains("text/plain")) {
            response.setContentType("text/plain; charset=utf-8");
        } else if (accept.contains("application/json")) {
            response.setContentType("application/json; charset=utf-8");
        } else {
            response.setContentType("text/plain; charset=utf-8");
        }
    }

    private String checkSlash(String s) {
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

