/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.common.jwk.impl.Jose4jEllipticCurveJWK;
import com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK;
import com.ibm.ws.security.common.jwk.impl.PemKeyUtil;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwKRetriever {
    private static final TraceComponent tc = Tr.register(JwKRetriever.class, null, null);
    static final String PEM_BEGIN_TOKEN = "-----BEGIN";
    static final String PEM_END_TOKEN = "--END--";
    static final String JWKS = "keys";
    static final String JSON_START = "{";
    String configId = null;
    String sslConfigurationName = null;
    String jwkEndpointUrl = null;
    String sigAlg = null;
    JWKSet jwkSet = null;
    SSLSupport sslSupport = null;
    String keyFileName = null;
    boolean hostNameVerificationEnabled = true;
    String jwkClientId = null;
    String jwkClientSecret = null;
    String keyLocation = null;
    String publicKeyText = null;
    String locationUsed = null;
    KeyAlgorithmChecker keyAlgChecker = new KeyAlgorithmChecker();
    static final long serialVersionUID = 8473291040416458511L;

    public JwKRetriever(String configId, String sslConfigurationName, String jwkEndpointUrl, JWKSet jwkSet, SSLSupport sslSupport, boolean hnvEnabled, String jwkClientId, @Sensitive String jwkClientSecret, String signatureAlgorithm) {
        this(configId, sslConfigurationName, jwkEndpointUrl, jwkSet, sslSupport, hnvEnabled, jwkClientId, jwkClientSecret, signatureAlgorithm, null, null);
    }

    public JwKRetriever(String configId, String sslConfigurationName, String jwkEndpointUrl, JWKSet jwkSet, SSLSupport sslSupport, boolean hnvEnabled, String jwkClientId, @Sensitive String jwkClientSecret, String signatureAlgorithm, String publicKeyText, String keyLocation) {
        this.configId = configId;
        this.sslConfigurationName = sslConfigurationName;
        this.jwkEndpointUrl = jwkEndpointUrl;
        this.jwkSet = jwkSet;
        this.sslSupport = sslSupport;
        this.hostNameVerificationEnabled = hnvEnabled;
        this.jwkClientId = jwkClientId;
        this.jwkClientSecret = jwkClientSecret;
        this.sigAlg = signatureAlgorithm;
        this.publicKeyText = publicKeyText;
        this.keyLocation = keyLocation;
    }

    public PublicKey getPublicKeyFromJwk(String kid, String x5t, boolean useSystemPropertiesForHttpClientConnections) throws PrivilegedActionException, IOException, KeyStoreException, InterruptedException {
        return this.getPublicKeyFromJwk(kid, x5t, null, useSystemPropertiesForHttpClientConnections);
    }

    @FFDCIgnore(value={KeyStoreException.class})
    public PublicKey getPublicKeyFromJwk(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections) throws PrivilegedActionException, IOException, KeyStoreException, InterruptedException {
        PublicKey key = null;
        KeyStoreException errKeyStoreException = null;
        InterruptedException errInterruptedException = null;
        boolean isHttp = this.remoteHttpCall(this.jwkEndpointUrl, this.publicKeyText, this.keyLocation);
        try {
            key = isHttp ? this.getJwkRemote(kid, x5t, use, useSystemPropertiesForHttpClientConnections) : this.getJwkLocal(kid, x5t, this.publicKeyText, this.keyLocation, use);
        }
        catch (KeyStoreException e) {
            errKeyStoreException = e;
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"154", (Object)this, (Object[])new Object[]{kid, x5t, use, useSystemPropertiesForHttpClientConnections});
            errInterruptedException = e;
        }
        if (key == null) {
            if (errKeyStoreException != null) {
                throw errKeyStoreException;
            }
            if (errInterruptedException != null) {
                throw errInterruptedException;
            }
        }
        return key;
    }

    private PublicKey getJwkFromJWKSet(String setId, String kid, String x5t, String use, String keyText) {
        PublicKey key = null;
        if (kid != null) {
            key = this.jwkSet.getPublicKeyBySetIdAndKid(setId, kid);
        } else if (x5t != null) {
            key = this.jwkSet.getPublicKeyBySetIdAndx5t(setId, x5t);
        } else if (use != null) {
            key = this.jwkSet.getPublicKeyBySetIdAndUse(setId, use);
        }
        if (key != null) {
            return key;
        }
        if (keyText != null) {
            return this.jwkSet.getPublicKeyBySetIdAndKeyText(setId, keyText);
        }
        return this.jwkSet.getPublicKeyBySetId(setId);
    }

    protected boolean remoteHttpCall(String jwksUri, String publicKeyText, String keyLocation) {
        boolean isHttp = true;
        if (jwksUri == null) {
            if (publicKeyText != null) {
                isHttp = false;
            } else if (keyLocation != null && !keyLocation.startsWith("http")) {
                isHttp = false;
            }
        }
        return isHttp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    protected PublicKey getPublicKeyFromFile(String location, String kid, String x5t, String use) {
        PublicKey publicKey;
        block9: {
            publicKey = null;
            String keyString = null;
            String classLoadingCacheSelector = null;
            String fileSystemCacheSelector = null;
            File jwkFile = null;
            try {
                String keyFile;
                classLoadingCacheSelector = Thread.currentThread().getContextClassLoader().toString() + location;
                if (location.startsWith("file:")) {
                    URI uri = new URI(location);
                    keyFile = uri.getPath();
                } else {
                    keyFile = location;
                }
                jwkFile = new File(keyFile);
                fileSystemCacheSelector = jwkFile.getCanonicalPath();
                JWKSet jWKSet = this.jwkSet;
                synchronized (jWKSet) {
                    InputStream is;
                    publicKey = this.getJwkFromJWKSet(fileSystemCacheSelector, kid, x5t, use, null);
                    if (publicKey == null) {
                        publicKey = this.getJwkFromJWKSet(classLoadingCacheSelector, kid, x5t, use, null);
                    }
                    if (publicKey == null && (is = this.getInputStream(jwkFile, fileSystemCacheSelector, location, classLoadingCacheSelector)) != null) {
                        keyString = this.getKeyAsString(is);
                        this.parseJwk(keyString, null, this.jwkSet, this.sigAlg);
                        publicKey = this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, keyString);
                    }
                }
            }
            catch (Exception e2) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("Caught exception opening file from location [" + location + "]: " + e2), (Object[])new Object[0]);
            }
        }
        return publicKey;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    protected InputStream getInputStream(final File f, String fileSystemSelector, String location, String classLoadingSelector) throws IOException {
        if (f != null) {
            FileInputStream is = null;
            try {
                is = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 692077785079817151L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        if (f.exists()) {
                            return new FileInputStream(f);
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (is != null) {
                this.locationUsed = fileSystemSelector;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("input stream obtained from file system and locationUsed set to: " + this.locationUsed), (Object[])new Object[0]);
                }
                return is;
            }
        }
        URL u = Thread.currentThread().getContextClassLoader().getResource(location);
        this.locationUsed = classLoadingSelector;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("input stream obtained from classloader and  locationUsed set to: " + this.locationUsed), (Object[])new Object[0]);
        }
        if (u != null) {
            return u.openStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PublicKey getJwkLocal(String kid, String x5t, String publicKeyText, String location, String use) {
        if (publicKeyText == null && location != null) {
            return this.getPublicKeyFromFile(location, kid, x5t, use);
        }
        if (publicKeyText != null) {
            JWKSet jWKSet = this.jwkSet;
            synchronized (jWKSet) {
                PublicKey publicKey = this.getJwkFromJWKSet(publicKeyText, kid, x5t, use, publicKeyText);
                if (publicKey == null) {
                    this.parseJwk(publicKeyText, null, this.jwkSet, this.sigAlg);
                    publicKey = this.getJwkFromJWKSet(publicKeyText, kid, x5t, use, publicKeyText);
                }
                return publicKey;
            }
        }
        return null;
    }

    protected String getKeyAsString(InputStream fis) {
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader r = new InputStreamReader(fis, "UTF-8");
            int ch = r.read();
            while (ch >= 0) {
                sb.append((char)ch);
                ch = r.read();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"316", (Object)this, (Object[])new Object[]{fis});
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"318", (Object)this, (Object[])new Object[]{fis});
        }
        return sb.toString();
    }

    protected boolean isPEM(String key) {
        return key != null && key.startsWith(PEM_BEGIN_TOKEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={KeyStoreException.class})
    protected PublicKey getJwkRemote(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections) throws KeyStoreException, InterruptedException {
        this.locationUsed = this.jwkEndpointUrl;
        if (this.locationUsed == null) {
            this.locationUsed = this.keyLocation;
        }
        if (this.locationUsed == null || !this.locationUsed.startsWith("http")) {
            return null;
        }
        PublicKey key = null;
        JWKSet jWKSet = this.jwkSet;
        synchronized (jWKSet) {
            key = this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, null);
            if (key == null) {
                key = this.doJwkRemote(kid, x5t, use, useSystemPropertiesForHttpClientConnections);
            }
        }
        return key;
    }

    @FFDCIgnore(value={Exception.class, KeyStoreException.class})
    protected PublicKey doJwkRemote(String kid, String x5t, String use, boolean useSystemPropertiesForHttpClientConnections) throws KeyStoreException {
        String jsonString;
        block7: {
            jsonString = null;
            this.locationUsed = this.jwkEndpointUrl;
            if (this.locationUsed == null) {
                this.locationUsed = this.keyLocation;
            }
            try {
                HttpClient client;
                boolean bJwk;
                SSLSocketFactory sslSocketFactory = null;
                if (this.locationUsed != null && this.locationUsed.toLowerCase().startsWith("https")) {
                    sslSocketFactory = this.getSSLSocketFactory(this.locationUsed, this.sslConfigurationName, this.sslSupport);
                }
                if (!(bJwk = this.parseJwk(jsonString = this.getHTTPRequestAsString(client = this.createHTTPClient(sslSocketFactory, this.locationUsed, this.hostNameVerificationEnabled, useSystemPropertiesForHttpClientConnections), this.locationUsed), null, this.jwkSet, this.sigAlg)) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No JWK can be found through '" + this.locationUsed + "'"), (Object[])new Object[0]);
                }
            }
            catch (KeyStoreException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Fail to retrieve remote key: ", (Object[])new Object[]{e.getCause()});
                }
                throw e;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Fail to retrieve remote key: ", (Object[])new Object[]{e.getCause()});
            }
        }
        return this.getJwkFromJWKSet(this.locationUsed, kid, x5t, use, jsonString);
    }

    public boolean parseJwk(String keyText, FileInputStream inputStream, JWKSet jwkset, String signatureAlgorithm) {
        boolean bJwk = false;
        if (keyText != null) {
            bJwk = this.parseKeyText(keyText, this.locationUsed, jwkset, signatureAlgorithm);
        } else if (inputStream != null) {
            String keyAsString = this.getKeyAsString(inputStream);
            bJwk = this.parseKeyText(keyAsString, this.locationUsed, jwkset, signatureAlgorithm);
        }
        return bJwk;
    }

    protected boolean parseKeyText(String keyText, String location, JWKSet jwkset, String signatureAlgorithm) {
        HashSet<JWK> jwks = new HashSet<JWK>();
        JWK jwk = null;
        if (this.isPEM(keyText) && this.isPemSupportedAlgorithm(signatureAlgorithm)) {
            jwk = this.parsePEMFormat(keyText, signatureAlgorithm);
        } else {
            JSONObject jsonObject = this.parseJsonObject(keyText);
            if (jsonObject != null && (jwk = this.parseJwkFormat(jsonObject, signatureAlgorithm)) == null && jsonObject.containsKey((Object)JWKS)) {
                jwks.addAll(this.parseJwksFormat(jsonObject, signatureAlgorithm));
            }
        }
        if (jwk != null) {
            jwks.add(jwk);
        }
        for (JWK aJwk : jwks) {
            if (this.isPEM(keyText)) {
                this.jwkSet.addPemKey(location, keyText, jwk);
            }
            if (location != null) {
                this.jwkSet.add(location, aJwk);
                continue;
            }
            this.jwkSet.add(keyText, aJwk);
        }
        return !jwks.isEmpty();
    }

    boolean isPemSupportedAlgorithm(String signatureAlgorithm) {
        return this.keyAlgChecker.isRSAlgorithm(signatureAlgorithm) || this.keyAlgChecker.isESAlgorithm(signatureAlgorithm);
    }

    @FFDCIgnore(value={Exception.class})
    private JWK parsePEMFormat(String keyText, String signatureAlgorithm) {
        JWK jwk = null;
        try {
            PublicKey pubKey = PemKeyUtil.getPublicKey(keyText);
            if (this.keyAlgChecker.isESAlgorithm(signatureAlgorithm)) {
                return this.getEcJwk(pubKey, signatureAlgorithm);
            }
            return this.getRsaJwk(pubKey, signatureAlgorithm);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing PEM file: " + e), (Object[])new Object[0]);
            }
            return jwk;
        }
    }

    @FFDCIgnore(value={Exception.class})
    private Jose4jEllipticCurveJWK getEcJwk(PublicKey publicKey, String signatureAlgorithm) {
        Jose4jEllipticCurveJWK jwk;
        block4: {
            if (!(publicKey instanceof ECPublicKey)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Provided public key was not of type ECPublicKey", (Object[])new Object[0]);
                }
                return null;
            }
            jwk = null;
            try {
                jwk = Jose4jEllipticCurveJWK.getInstance((ECPublicKey)publicKey, signatureAlgorithm, "sig");
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception instantiating EC JWK object: " + e), (Object[])new Object[0]);
            }
        }
        return jwk;
    }

    @FFDCIgnore(value={Exception.class})
    private Jose4jRsaJWK getRsaJwk(PublicKey pubKey, String signatureAlgorithm) {
        Jose4jRsaJWK jwk = null;
        try {
            jwk = new Jose4jRsaJWK((RSAPublicKey)pubKey);
            jwk.setAlgorithm(signatureAlgorithm);
            jwk.setUse("sig");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jwk;
    }

    private JWK parseJwkFormat(JSONObject jsonObject, String signatureAlgorithm) {
        JWK jwk = null;
        Object ktyEntry = jsonObject.get((Object)"kty");
        if (ktyEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JSON object is missing 'kty' entry", (Object[])new Object[0]);
            }
            return null;
        }
        if (!(ktyEntry instanceof String)) {
            return null;
        }
        String kty = (String)ktyEntry;
        jwk = this.createJwkBasedOnKty(kty, jsonObject, signatureAlgorithm);
        if (jwk != null) {
            jwk.parse();
        }
        return jwk;
    }

    private Set<JWK> parseJwksFormat(JSONObject jsonObject, String signatureAlgorithm) {
        Set<JWK> jwks = Collections.emptySet();
        JSONArray keys = new JSONArray();
        Object keysEntry = jsonObject.get((Object)JWKS);
        if (keysEntry != null) {
            jwks = new HashSet<JWK>();
            keys = this.parseJsonArray(keysEntry.toString());
            for (Object element : keys) {
                JWK jwk;
                JSONObject jwkJson = this.parseJsonObject(element.toString());
                if (jwkJson == null || (jwk = this.parseJwkFormat(jwkJson, signatureAlgorithm)) == null) continue;
                jwks.add(jwk);
            }
        }
        return jwks;
    }

    @FFDCIgnore(value={Exception.class})
    JSONObject parseJsonObject(String jsonString) {
        JSONObject jsonObject;
        block3: {
            jsonObject = null;
            try {
                if (!jsonString.startsWith(JSON_START)) {
                    jsonString = new String(Base64.decodeBase64((String)jsonString), "UTF-8");
                }
                jsonObject = JSONObject.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonObject;
    }

    @FFDCIgnore(value={Exception.class})
    JSONObject parseJsonObject(InputStream is) {
        JSONObject jsonObject;
        block2: {
            jsonObject = null;
            try {
                jsonObject = JSONObject.parse((InputStream)is);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing input stream [" + is.toString() + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonObject;
    }

    @FFDCIgnore(value={Exception.class})
    JSONArray parseJsonArray(String jsonString) {
        JSONArray jsonArray;
        block2: {
            jsonArray = null;
            try {
                jsonArray = JSONArray.parse((String)jsonString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e), (Object[])new Object[0]);
            }
        }
        return jsonArray;
    }

    JWK createJwkBasedOnKty(String kty, JSONObject keyEntry, String signatureAlgorithm) {
        JWK jwk = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("kty of JWK is '" + kty + "'"), (Object[])new Object[0]);
        }
        if ("RSA".equalsIgnoreCase(kty)) {
            jwk = this.getRsaJwk(keyEntry);
        } else if ("EC".equalsIgnoreCase(kty)) {
            jwk = this.getEllipticCurveJwk(keyEntry, signatureAlgorithm);
        }
        return jwk;
    }

    JWK getRsaJwk(JSONObject thing) {
        return Jose4jRsaJWK.getInstance(thing);
    }

    JWK getEllipticCurveJwk(JSONObject thing, String signatureAlgorithm) {
        if (signatureAlgorithm != null && signatureAlgorithm.startsWith("ES")) {
            return Jose4jEllipticCurveJWK.getInstance(thing);
        }
        return null;
    }

    protected JSSEHelper getJSSEHelper(SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        if (sslSupport != null) {
            return sslSupport.getJSSEHelper();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected SSLSocketFactory getSSLSocketFactory(String requestUrl, String sslConfigurationName, SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = sslSupport.getSSLSocketFactory(sslConfigurationName);
        }
        catch (SSLException sSLException) {
            void e;
            FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"630", (Object)this, (Object[])new Object[]{requestUrl, sslConfigurationName, sslSupport});
            throw new com.ibm.websphere.ssl.SSLException((Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sslSocketFactory () get: " + sslSocketFactory), (Object[])new Object[0]);
        }
        if (sslSocketFactory == null && requestUrl != null && requestUrl.startsWith("https")) {
            throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"JWT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", this.configId}));
        }
        return sslSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={KeyStoreException.class})
    protected String getHTTPRequestAsString(HttpClient httpClient, String url) throws Exception {
        String json;
        block8: {
            json = null;
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            HttpResponse result = null;
            try {
                result = httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException iOException) {
                void ioex;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.jwk.impl.JwKRetriever", (String)"656", (Object)this, (Object[])new Object[]{httpClient, url});
                this.logCWWKS6049E(url, 0, "IOException: " + ioex.getMessage() + " " + ioex.getCause());
                throw ioex;
            }
            StatusLine statusLine = result.getStatusLine();
            int iStatusCode = statusLine.getStatusCode();
            if (iStatusCode == 200) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{json});
                }
                if (json == null || json.isEmpty()) {
                    throw new Exception(this.logCWWKS6049E(url, iStatusCode, json));
                }
                break block8;
            }
            String errMsg = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + errMsg), (Object[])new Object[0]);
            }
            throw new Exception(this.logCWWKS6049E(url, iStatusCode, errMsg));
        }
        return json;
    }

    private String logCWWKS6049E(String url, int iStatusCode, String errMsg) {
        String defaultMessage = "CWWKS6049E: A JSON Web Key (JWK) was not returned from the URL [" + url + "]. The response status was [" + iStatusCode + "] and the content returned was [" + errMsg + "].";
        String message = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages", (String)"JWT_JWK_RETRIEVE_FAILED", (Object[])new Object[]{url, iStatusCode, errMsg}, (String)defaultMessage);
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        return message;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) {
        HttpClient client = null;
        boolean addBasicAuthHeader = false;
        if (this.jwkClientId != null && this.jwkClientSecret != null) {
            addBasicAuthHeader = true;
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (addBasicAuthHeader) {
            credentialsProvider = this.createCredentialsProvider();
        }
        client = this.createHttpClient(url.startsWith("https:"), isHostnameVerification, sslSocketFactory, addBasicAuthHeader, credentialsProvider, useSystemPropertiesForHttpClientConnections);
        return client;
    }

    protected HttpClientBuilder getBuilder(boolean useSystemPropertiesForHttpClientConnections) {
        return useSystemPropertiesForHttpClientConnections ? HttpClientBuilder.create().useSystemProperties() : HttpClientBuilder.create();
    }

    private HttpClient createHttpClient(boolean isSecure, boolean isHostnameVerification, SSLSocketFactory sslSocketFactory, boolean addBasicAuthHeader, BasicCredentialsProvider credentialsProvider, boolean useSystemPropertiesForHttpClientConnections) {
        CloseableHttpClient client = null;
        if (isSecure) {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new NoopHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (HostnameVerifier)new DefaultHostnameVerifier());
            client = addBasicAuthHeader ? this.getBuilder(useSystemPropertiesForHttpClientConnections).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build() : this.getBuilder(useSystemPropertiesForHttpClientConnections).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        } else {
            client = addBasicAuthHeader ? this.getBuilder(useSystemPropertiesForHttpClientConnections).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build() : this.getBuilder(useSystemPropertiesForHttpClientConnections).build();
        }
        return client;
    }

    private BasicCredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.jwkClientId, this.jwkClientSecret));
        return credentialsProvider;
    }
}

