/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public class JmsMetaDataImpl
implements ConnectionMetaData {
    private static TraceComponent tc = SibTr.register(JmsMetaDataImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final int jmsMajorVersion = 2;
    private static final int jmsMinorVersion = 0;
    private static String provName = null;
    private static String provVersion = null;
    private static int provMajorVersion = -1;
    private static int provMinorVersion = -1;
    private static final String[] supportedJMSXProps = new String[]{"JMSXUserID", "JMSXDeliveryCount", "JMSXAppID", "JMSXGroupID", "JMSXGroupSeq"};
    private static final String packageName = "com.ibm.ws.sib.api.jms.impl";
    private static final String regexSibBuildLevel = "(\\w+(\\d{4})\\.(\\d{2,3}))";
    private static final Pattern sibBuildLevelPattern = Pattern.compile("(\\w+(\\d{4})\\.(\\d{2,3}))");
    private static final Pattern sibOldVersionPattern = Pattern.compile(".*[\\w\\.]+\\s+\\[(\\w+(\\d{4})\\.(\\d{2,3}))\\].*");

    public String getJMSVersion() throws JMSException {
        return this.getJMSMajorVersion() + "." + this.getJMSMinorVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        return 2;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 0;
    }

    public String getJMSProviderName() throws JMSException {
        if (provName == null) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        return provName;
    }

    public String getProviderVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderVersion");
        }
        if (provVersion == null) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderVersion", (Object)provVersion);
        }
        return provVersion;
    }

    public int getProviderMajorVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderMajorVersion");
        }
        if (provMajorVersion == -1) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderMajorVersion", (Object)provMajorVersion);
        }
        return provMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderMinorVersion");
        }
        if (provMinorVersion == -1) {
            JmsMetaDataImpl.retrieveManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderMinorVersion", (Object)provMinorVersion);
        }
        return provMinorVersion;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>(supportedJMSXProps.length);
        for (int i = 0; i < supportedJMSXProps.length; ++i) {
            v.add(supportedJMSXProps[i]);
        }
        return v.elements();
    }

    private static void retrieveManifestData() {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveManifestData");
            }
            try {
                JmsMetaDataImpl.setProblemDefaults();
                Package thisPackage = Package.getPackage(packageName);
                if (thisPackage != null) {
                    String version;
                    String tempProv = thisPackage.getImplementationVendor();
                    if (tempProv != null) {
                        provName = tempProv;
                    }
                    if ((version = thisPackage.getImplementationVersion()) != null) {
                        Matcher m = sibOldVersionPattern.matcher(version);
                        if (!m.matches()) {
                            version = "1.0.0";
                            m = sibBuildLevelPattern.matcher(version);
                        }
                        if (m.matches()) {
                            provVersion = m.group(1);
                            try {
                                provMajorVersion = Integer.valueOf(m.group(2));
                                provMinorVersion = Integer.valueOf(m.group(3));
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("provMajorVersion=" + provMajorVersion + "provMinorVersion=" + provMinorVersion));
                                }
                                break block16;
                            }
                            catch (RuntimeException e2) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Unable to convert major or minor version number from build level " + version + " to int"), (Object)e2);
                                }
                                break block16;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Unable to find a valid build level in " + version));
                        }
                        break block16;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Implementation version from manifest was null");
                    }
                    break block16;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The package was null - unable to retrieve information");
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsMetaDataImpl", (String)"retrieveManifestData#1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                SibTr.debug((TraceComponent)tc, (String)"Error retrieving manifest information", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveManifestData");
        }
    }

    private static void setProblemDefaults() {
        provName = "IBM";
        provVersion = "1.0";
        provMajorVersion = 1;
        provMinorVersion = 0;
    }
}

