/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class Reliability
implements Comparable {
    private static TraceComponent tc = SibTr.register(Reliability.class, (String)"SIBMfpApi", (String)"com.ibm.websphere.sib.CWSIEMessages");
    private static final String NONE_STRING = "None";
    public static final String BEST_EFFORT_NONPERSISTENT_STRING = "BestEffortNonPersistent";
    public static final String EXPRESS_NONPERSISTENT_STRING = "ExpressNonPersistent";
    public static final String RELIABLE_NONPERSISTENT_STRING = "ReliableNonPersistent";
    public static final String RELIABLE_PERSISTENT_STRING = "ReliablePersistent";
    public static final String ASSURED_PERSISTENT_STRING = "AssuredPersistent";
    public static final Reliability NONE = new Reliability("None", 0, -1, 0);
    public static final Reliability BEST_EFFORT_NONPERSISTENT = new Reliability("BestEffortNonPersistent", 5, 0, 1);
    public static final Reliability EXPRESS_NONPERSISTENT = new Reliability("ExpressNonPersistent", 15, 1, 1);
    public static final Reliability RELIABLE_NONPERSISTENT = new Reliability("ReliableNonPersistent", 25, 2, 1);
    public static final Reliability RELIABLE_PERSISTENT = new Reliability("ReliablePersistent", 35, 3, 2);
    public static final Reliability ASSURED_PERSISTENT = new Reliability("AssuredPersistent", 45, 4, 2);
    private static final Reliability[] set = new Reliability[]{NONE, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, BEST_EFFORT_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, EXPRESS_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, RELIABLE_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT, ASSURED_PERSISTENT};
    private static final Reliability[] indexSet = new Reliability[]{NONE, BEST_EFFORT_NONPERSISTENT, EXPRESS_NONPERSISTENT, RELIABLE_NONPERSISTENT, RELIABLE_PERSISTENT, ASSURED_PERSISTENT};
    private static final String[] nameSet = new String[]{"None", "BestEffortNonPersistent", "ExpressNonPersistent", "ReliableNonPersistent", "ReliablePersistent", "AssuredPersistent"};
    public static final int MAX_INDEX = ASSURED_PERSISTENT.getIndex();
    private final String name;
    private final Byte value;
    private final int intValue;
    private final int index;
    private final Byte persistence;

    private Reliability(String aName, byte aValue, int aIndex, byte aPersistence) {
        this.name = aName;
        this.value = aValue;
        this.intValue = aValue;
        this.index = aIndex;
        this.persistence = aPersistence;
    }

    public final String toString() {
        return this.name;
    }

    public final int compareTo(Object other) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("this: " + this + ", other: " + other.toString() + ", result: " + (this.intValue - ((Reliability)other).intValue)));
        }
        return this.intValue - ((Reliability)other).intValue;
    }

    public static final Reliability getReliability(int aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return set[aValue];
    }

    public final int toInt() {
        return this.intValue;
    }

    public static final Reliability getReliabilityByName(String name) throws NullPointerException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Name = " + name));
        }
        if (name == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i <= MAX_INDEX + 1; ++i) {
            if (!name.equals(nameSet[i])) continue;
            return indexSet[i];
        }
        throw new IllegalArgumentException();
    }

    public static final Reliability getReliabilityByIndex(int mpIndex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Index = " + mpIndex));
        }
        return indexSet[mpIndex + 1];
    }

    public final int getIndex() {
        return this.index;
    }

    public static final Reliability getReliability(Byte aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.info((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return set[aValue.intValue()];
    }

    public final Byte toByte() {
        return this.value;
    }

    public final Byte getPersistence() {
        return this.persistence;
    }
}

