/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteNode;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.NodeStack;

public class DeleteStack
extends NodeStack {
    private Linearizer _linearizer = new Linearizer();
    private HeightNote _heightNote = new HeightNote();
    private FringeNote _fringeNote = new FringeNote();
    private InsertStack _insertStack;
    private DeleteNode _deleteNode;

    DeleteStack(GBSTree tree) {
        super(tree);
        this._insertStack = new InsertStack(tree);
        this._deleteNode = new DeleteNode();
    }

    @Override
    public void reset() {
        super.reset();
        this._linearizer.reset();
        this._heightNote.reset();
        this._fringeNote.reset();
        this._insertStack.reset();
        this._deleteNode.reset();
    }

    Linearizer linearizer() {
        return this._linearizer;
    }

    HeightNote heightNote() {
        return this._heightNote;
    }

    FringeNote fringeNote() {
        return this._fringeNote;
    }

    InsertStack insertStack() {
        return this._insertStack;
    }

    DeleteNode deleteNode() {
        return this._deleteNode;
    }

    @Override
    public boolean processNode(GBSNode p) {
        boolean done = false;
        this.lastNode().addRightMostKey(p.leftMostKey());
        p.overlayLeftShift(0);
        if (!p.isFull()) {
            done = true;
        }
        p.decrementPopulation();
        return done;
    }

    void start(GBSNode node, String starter) {
        super.stackStart(node, starter);
    }

    void add(int state, GBSNode node) {
        this._state[this.index() + 1] = state;
        this._node[this.index() + 1] = node;
    }

    void setState(int x, int state) {
        if (x < 0) {
            throw new RuntimeException("x < 0");
        }
        if (x > this.index()) {
            throw new RuntimeException("x = " + x + ", index() = " + this.index());
        }
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new RuntimeException("Help!, state = " + state + ".");
            }
        }
        this._state[x] = state;
    }

    static class FringeNote {
        boolean depthDecrease;
        boolean conditionalDecrease;
        int conditionalBalance;
        GBSNode newg;
        GBSNode newf;

        FringeNote() {
        }

        private void reset() {
            this.depthDecrease = false;
            this.conditionalDecrease = false;
            this.conditionalBalance = 0;
            this.newg = null;
            this.newf = null;
        }
    }

    static class HeightNote {
        boolean depthDecrease;
        GBSNode bnew;

        HeightNote() {
        }

        private void reset() {
            this.depthDecrease = false;
            this.bnew = null;
        }
    }

    static class Linearizer {
        GBSNode lastp;
        GBSNode headp;
        int depth;

        Linearizer() {
        }

        private void reset() {
            this.lastp = null;
            this.headp = null;
            this.depth = 0;
        }
    }
}

