/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.FilterList;
import com.ibm.ws.tcpchannel.internal.FilterListFastStr;
import com.ibm.ws.tcpchannel.internal.FilterListSlowStr;
import com.ibm.ws.tcpchannel.internal.FilterListStr;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AccessLists {
    private FilterList excludeAccess = null;
    private FilterList includeAccess = null;
    private FilterListStr excludeAccessNames = null;
    private FilterListStr includeAccessNames = null;
    private boolean caseInsensitiveHostnames = true;
    private static final TraceComponent tc = Tr.register(AccessLists.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public AccessLists(FilterList _excludeAccess, FilterListStr _excludeAccessNames, FilterList _includeAccess, FilterListStr _includeAccessNames, boolean _caseInsensitiveHostnames) {
        this.excludeAccess = _excludeAccess;
        this.includeAccess = _includeAccess;
        this.excludeAccessNames = _excludeAccessNames;
        this.includeAccessNames = _includeAccessNames;
        this.caseInsensitiveHostnames = _caseInsensitiveHostnames;
    }

    protected static AccessLists getInstance(TCPChannelConfiguration config) {
        AccessLists retVal = null;
        boolean haveAList = false;
        FilterList excludeAccess = null;
        FilterList includeAccess = null;
        FilterListStr excludeAccessNames = null;
        FilterListStr includeAccessNames = null;
        String[] sExclude = config.getAddressExcludeList();
        excludeAccess = new FilterList();
        if (sExclude != null) {
            excludeAccess.buildData(sExclude, false);
            excludeAccess.setActive(true);
            haveAList = true;
        }
        sExclude = config.getHostNameExcludeList();
        excludeAccessNames = new FilterListFastStr();
        if (sExclude != null) {
            if (!excludeAccessNames.buildData(sExclude)) {
                excludeAccessNames = new FilterListSlowStr();
                excludeAccessNames.buildData(sExclude);
            }
            excludeAccessNames.setActive(true);
            haveAList = true;
        }
        String[] sInclude = config.getAddressIncludeList();
        includeAccess = new FilterList();
        if (sInclude != null) {
            includeAccess.buildData(sInclude, false);
            includeAccess.setActive(true);
            haveAList = true;
        }
        sInclude = config.getHostNameIncludeList();
        includeAccessNames = new FilterListFastStr();
        if (sInclude != null) {
            if (!includeAccessNames.buildData(sInclude)) {
                includeAccessNames = new FilterListSlowStr();
                includeAccessNames.buildData(sInclude);
            }
            includeAccessNames.setActive(true);
            haveAList = true;
        }
        if (haveAList) {
            retVal = new AccessLists(excludeAccess, excludeAccessNames, includeAccess, includeAccessNames, config.getCaseInsensitiveHostnames());
        }
        return retVal;
    }

    public boolean accessDenied(InetAddress remoteAddr) {
        boolean closeSocket;
        String hostname = null;
        if (this.includeAccess.getActive() || this.includeAccessNames.getActive()) {
            closeSocket = true;
            if (this.includeAccess.getActive()) {
                if (remoteAddr instanceof Inet6Address) {
                    if (this.includeAccess.findInList6(remoteAddr.getAddress())) {
                        closeSocket = false;
                    }
                } else if (this.includeAccess.findInList(remoteAddr.getAddress())) {
                    closeSocket = false;
                }
            }
            if (closeSocket && this.includeAccessNames.getActive()) {
                hostname = remoteAddr.getHostName();
                if (this.caseInsensitiveHostnames && hostname != null) {
                    hostname = hostname.toLowerCase();
                }
                if (this.includeAccessNames.findInList(hostname)) {
                    closeSocket = false;
                }
            }
            if (closeSocket) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address and host name not in include list, address: " + remoteAddr.getHostAddress() + " host name: " + remoteAddr.getHostName()), (Object[])new Object[0]);
                }
                return true;
            }
        }
        if (this.excludeAccess.getActive() || this.excludeAccessNames.getActive()) {
            closeSocket = false;
            if (this.excludeAccess.getActive()) {
                if (remoteAddr instanceof Inet6Address) {
                    if (this.excludeAccess.findInList6(remoteAddr.getAddress())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Address (IPv6) in exclude list, address: " + remoteAddr.getHostAddress()), (Object[])new Object[0]);
                        }
                        return true;
                    }
                } else if (this.excludeAccess.findInList(remoteAddr.getAddress())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Address in exclude list, address: " + remoteAddr.getHostAddress()), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
            if (!closeSocket && this.excludeAccessNames.getActive()) {
                hostname = remoteAddr.getHostName();
                if (this.caseInsensitiveHostnames && hostname != null) {
                    hostname = hostname.toLowerCase();
                }
                if (this.excludeAccessNames.findInList(hostname)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Host name in exclude list, host name: " + remoteAddr.getHostName()), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

