/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BindingsHelper;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.csi.HomeWrapperSet;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.container.service.naming.LocalColonEJBNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.HomeRecordImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBJavaColonNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBRemoteReferenceBinding;
import com.ibm.ws.ejbcontainer.runtime.NameSpaceBinder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NameSpaceBinderImpl
implements NameSpaceBinder<EJBBinding> {
    private static TraceComponent tc = Tr.register(NameSpaceBinderImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String JNDI_SERVICENAME = "osgi.jndi.service.name";
    protected final EJBModuleMetaDataImpl moduleMetaData;
    private final EJBJavaColonNamingHelper ejbJavaColonHelper;
    private final EJBLocalNamingHelper<EJBBinding> ejbLocalNamingHelper;
    private final LocalColonEJBNamingHelper<EJBBinding> localColonNamingHelper;
    private final AtomicServiceReference<EJBRemoteRuntime> ejbRemoteRuntimeServiceRef;
    private static final List<ServiceRegistration<?>> registrations = Collections.synchronizedList(new ArrayList());
    static final long serialVersionUID = 3603112862551292945L;

    NameSpaceBinderImpl(EJBModuleMetaDataImpl mmd, EJBJavaColonNamingHelper jcnh, EJBLocalNamingHelper<EJBBinding> ejblocal, LocalColonEJBNamingHelper<EJBBinding> localColon, AtomicServiceReference<EJBRemoteRuntime> remoteRuntimeRef) {
        this.moduleMetaData = mmd;
        this.ejbJavaColonHelper = jcnh;
        this.ejbLocalNamingHelper = ejblocal;
        this.localColonNamingHelper = localColon;
        this.ejbRemoteRuntimeServiceRef = remoteRuntimeRef;
    }

    @Override
    public void beginBind() {
    }

    @Override
    public EJBBinding createBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local) {
        return new EJBBinding(hr, interfaceName, interfaceIndex, local);
    }

    @Override
    public EJBBinding createJavaBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local, EJBBinding bindingObject) {
        return bindingObject;
    }

    @Override
    public void bindJavaGlobal(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaGlobalName(name);
        this.ejbJavaColonHelper.addGlobalBinding(bindingName, bindingObject);
    }

    @Override
    public void bindJavaApp(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaAppName(name);
        this.ejbJavaColonHelper.addAppBinding(this.moduleMetaData, bindingName, bindingObject);
    }

    @Override
    public void bindJavaModule(String name, EJBBinding bindingObject) {
        this.ejbJavaColonHelper.addModuleBinding(this.moduleMetaData, name, bindingObject);
    }

    @Override
    public void bindDefaultEJBLocal(EJBBinding bindingObject, HomeRecord hr) {
        HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
        if (hrImpl.bindToContextRoot()) {
            boolean priorToVersion3;
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
            if (priorToVersion3) {
                String bindingName = "ejb/" + hrImpl.getEJBName();
                this.localColonNamingHelper.bind((Object)bindingObject, bindingName);
                BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
                bh.ivLocalColonBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "local:" + bindingName, bmd);
                this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
                bh.ivEJBLocalBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
            } else {
                J2EEName eeName = hrImpl.getJ2EEName();
                String bindingName = null;
                bindingName = bmd.ivComponent_Id != null ? bmd.ivComponent_Id + "#" + bindingObject.interfaceName : eeName.getApplication() + "/" + eeName.getModule() + "/" + eeName.getComponent() + "#" + bindingObject.interfaceName;
                this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
                BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
                bh.ivEJBLocalBindings.add(bindingName);
                this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
                if (BindingsHelper.shortDefaultBindingsEnabled(hrImpl.getAppName()).booleanValue()) {
                    this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingObject.interfaceName);
                    bh.ivEJBLocalBindings.add(bindingObject.interfaceName);
                    this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingObject.interfaceName, bmd);
                }
            }
        }
    }

    @Override
    public void bindDefaultEJBRemote(EJBBinding bindingObject, HomeRecord hr) {
        HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
        if (hrImpl.bindToContextRoot()) {
            boolean priorToVersion3;
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
            if (priorToVersion3) {
                String bindingName = "ejb/" + hrImpl.getEJBName();
                this.bindLegacyRemoteBinding(bindingObject, hr, bindingName);
            } else {
                String bindingName = null;
                if (bmd.ivComponent_Id != null) {
                    bindingName = "ejb/" + bmd.ivComponent_Id + "#" + bindingObject.interfaceName;
                } else {
                    J2EEName eeName = hrImpl.getJ2EEName();
                    bindingName = "ejb/" + eeName.getApplication() + "/" + eeName.getModule() + "/" + eeName.getComponent() + "#" + bindingObject.interfaceName;
                }
                this.bindLegacyRemoteBinding(bindingObject, hr, bindingName);
                if (BindingsHelper.shortDefaultBindingsEnabled(hrImpl.getAppName()).booleanValue()) {
                    bindingName = bindingObject.interfaceName;
                    this.bindLegacyRemoteBinding(bindingObject, hr, bindingName);
                }
            }
        }
    }

    private void bindLegacyRemoteBinding(EJBBinding bindingObject, HomeRecord hr, String bindingName) {
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (remoteRuntime != null) {
            BindingsHelper bh = BindingsHelper.getRemoteHelper(hr);
            bh.ivRemoteBindings.add(bindingName);
            BundleContext bc = this.ejbRemoteRuntimeServiceRef.getReference().getBundle().getBundleContext();
            BeanMetaData bmd = hr.getBeanMetaData();
            Hashtable<String, String> properties = new Hashtable<String, String>(1);
            ((Dictionary)properties).put(JNDI_SERVICENAME, bindingName);
            ((Dictionary)properties).put("objectClass", Reference.class.getName());
            EJBRemoteReferenceBinding ref = new EJBRemoteReferenceBinding(bindingObject);
            ServiceRegistration registration = bc.registerService(Reference.class, (Object)ref, properties);
            registrations.add(registration);
            this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Remote Runtime Service isn't enabled, not adding remote binding.", (Object[])new Object[0]);
        }
    }

    @Override
    public void bindSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, boolean local, boolean generateDisambiguatedSimpleBindingNames) {
        BeanMetaData bmd = hr.getBeanMetaData();
        if (local) {
            this.bindLocalSimpleBindingName(bindingObject, hr, bmd.simpleJndiBindingName, generateDisambiguatedSimpleBindingNames);
        } else {
            this.bindRemoteSimpleBindingName(bindingObject, hr, bmd.simpleJndiBindingName, generateDisambiguatedSimpleBindingNames);
        }
    }

    private void bindLocalSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, String bindingName, boolean generateDisambiguatedSimpleBindingNames) {
        boolean priorToVersion3;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        BeanMetaData bmd = hr.getBeanMetaData();
        boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
        if (generateDisambiguatedSimpleBindingNames && isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"EJB with simple-binding-name has multiple interfaces, appending interface to simple-binding-name", (Object[])new Object[0]);
        }
        if (priorToVersion3) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"binding to local:", (Object[])new Object[0]);
            }
            String localColonBindingName = "ejb/" + bindingName;
            if (generateDisambiguatedSimpleBindingNames) {
                localColonBindingName = localColonBindingName + "#" + bindingObject.interfaceName;
            }
            this.localColonNamingHelper.bind((Object)bindingObject, localColonBindingName);
            BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
            bh.ivLocalColonBindings.add(localColonBindingName);
            this.sendBindingMessage(bindingObject.interfaceName, "local:" + localColonBindingName, bmd);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"binding to ejblocal:", (Object[])new Object[0]);
        }
        if (generateDisambiguatedSimpleBindingNames) {
            bindingName = bindingName + "#" + bindingObject.interfaceName;
        }
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
    }

    private void bindRemoteSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, String bindingName, boolean generateDisambiguatedSimpleBindingNames) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (generateDisambiguatedSimpleBindingNames) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJB with simple-binding-name has multiple interfaces, appending interface to simple-binding-name", (Object[])new Object[0]);
            }
            bindingName = bindingName + "#" + bindingObject.interfaceName;
        }
        this.bindLegacyRemoteBinding(bindingObject, hr, bindingName);
    }

    @Override
    public void bindLocalHomeBindingName(EJBBinding bindingObject, HomeRecord hr) {
        BeanMetaData bmd = hr.getBeanMetaData();
        String bindingName = bmd.localHomeJndiBindingName;
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
    }

    @Override
    public void bindLocalBusinessInterface(EJBBinding bindingObject, HomeRecord hr) {
        BeanMetaData bmd = hr.getBeanMetaData();
        String interfaceName = bindingObject.interfaceName;
        String bindingName = bmd.businessInterfaceJndiBindingNames.get(interfaceName);
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
    }

    private void sendBindingMessage(String interfaceName, String jndiName, BeanMetaData bmd) {
        Tr.info((TraceComponent)tc, (String)"JNDI_BINDING_LOCATION_INFO_CNTR0167I", (Object[])new Object[]{interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), jndiName});
    }

    @Override
    public void bindBindings(EJBBinding bindingObject, HomeRecord hr, int numInterfaces, boolean singleGlobalInterface, int interfaceIndex, String interfaceName, boolean local, boolean deferred) {
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (!local && remoteRuntime != null) {
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData == null) {
                BeanMetaData bmd = hr.getBeanMetaData();
                EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
                EJBApplicationMetaData amd = mmd.getEJBApplicationMetaData();
                String appLogicalName = amd.isStandaloneModule() ? null : amd.getLogicalName();
                hrImpl.remoteBindingData = remoteRuntime.createBindingData(bmd, appLogicalName, mmd.ivLogicalName);
            }
            remoteRuntime.bind(hrImpl.remoteBindingData, interfaceIndex, interfaceName);
        }
        if (ContainerProperties.customBindingsEnabledBeta) {
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean hasCustomBindings = false;
            if (bmd.simpleJndiBindingName != null) {
                hasCustomBindings = true;
                this.bindSimpleBindingName(bindingObject, hr, local, numInterfaces > 1);
            }
            if (bmd.localHomeJndiBindingName != null && local && interfaceIndex == -1) {
                hasCustomBindings = true;
                this.bindLocalHomeBindingName(bindingObject, hr);
            }
            if (bmd.remoteHomeJndiBindingName != null && !local && interfaceIndex == -1) {
                hasCustomBindings = true;
                this.bindLegacyRemoteBinding(bindingObject, hr, bmd.remoteHomeJndiBindingName);
            }
            if (bmd.businessInterfaceJndiBindingNames != null && interfaceIndex >= 0 && bmd.businessInterfaceJndiBindingNames.containsKey(interfaceName)) {
                hasCustomBindings = true;
                if (local) {
                    this.bindLocalBusinessInterface(bindingObject, hr);
                } else {
                    this.bindLegacyRemoteBinding(bindingObject, hr, bmd.businessInterfaceJndiBindingNames.get(interfaceName));
                }
            }
            if (!hasCustomBindings) {
                if (local) {
                    this.bindDefaultEJBLocal(bindingObject, hr);
                } else {
                    this.bindDefaultEJBRemote(bindingObject, hr);
                }
            }
        }
    }

    @Override
    public void bindEJBFactory() {
    }

    @Override
    public void beginUnbind(boolean error) {
    }

    @Override
    public void unbindJavaGlobal(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaGlobalName(name));
        }
        this.ejbJavaColonHelper.removeGlobalBindings(fullNames);
    }

    @Override
    public void unbindJavaApp(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaAppName(name));
        }
        this.ejbJavaColonHelper.removeAppBindings(this.moduleMetaData, fullNames);
    }

    @Override
    public void unbindBindings(HomeRecord hr) throws NamingException {
        EJBRemoteRuntime remoteRuntime = (EJBRemoteRuntime)this.ejbRemoteRuntimeServiceRef.getService();
        if (remoteRuntime != null) {
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData != null) {
                remoteRuntime.unbindAll(hrImpl.remoteBindingData);
            }
            BindingsHelper remoteBH = BindingsHelper.getRemoteHelper(hr);
            this.unbindRemote(remoteBH.ivRemoteBindings);
        }
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        this.unbindEJBLocal(bh.ivEJBLocalBindings);
        this.unbindLocalColonEJB(bh.ivLocalColonBindings);
    }

    @Override
    public void unbindEJBFactory() {
    }

    @Override
    public void end() {
    }

    private String buildJavaGlobalName(String name) {
        StringBuffer bindingName = new StringBuffer();
        if (!this.moduleMetaData.getEJBApplicationMetaData().isStandaloneModule()) {
            bindingName.append(this.moduleMetaData.getEJBApplicationMetaData().getLogicalName());
            bindingName.append("/");
        }
        bindingName.append(this.moduleMetaData.ivLogicalName);
        bindingName.append("/");
        bindingName.append(name);
        return bindingName.toString();
    }

    private String buildJavaAppName(String name) {
        return this.moduleMetaData.ivLogicalName + "/" + name;
    }

    @Override
    public void unbindEJBLocal(List<String> names) throws NamingException {
        this.ejbLocalNamingHelper.removeBindings(names);
    }

    @Override
    public void unbindLocalColonEJB(List<String> names) throws NamingException {
        this.localColonNamingHelper.removeBindings(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindRemote(List<String> names) {
        List<ServiceRegistration<?>> list = registrations;
        synchronized (list) {
            for (String name : names) {
                Iterator<ServiceRegistration<?>> it = registrations.iterator();
                while (it.hasNext()) {
                    ServiceRegistration<?> registration = it.next();
                    if (!name.equals(registration.getReference().getProperty(JNDI_SERVICENAME))) continue;
                    registration.unregister();
                    registrations.remove(it);
                    it.remove();
                }
            }
        }
    }
}

