/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import org.apache.yoko.rmi.impl.AbstractObjectArrayDescriptor;
import org.apache.yoko.rmi.impl.BooleanArrayDescriptor;
import org.apache.yoko.rmi.impl.ByteArrayDescriptor;
import org.apache.yoko.rmi.impl.CharArrayDescriptor;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.DoubleArrayDescriptor;
import org.apache.yoko.rmi.impl.FloatArrayDescriptor;
import org.apache.yoko.rmi.impl.IntArrayDescriptor;
import org.apache.yoko.rmi.impl.LongArrayDescriptor;
import org.apache.yoko.rmi.impl.ObjectArrayDescriptor;
import org.apache.yoko.rmi.impl.RemoteArrayDescriptor;
import org.apache.yoko.rmi.impl.ShortArrayDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueArrayDescriptor;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.util.SerialFilterHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

abstract class ArrayDescriptor<ARR extends Serializable>
extends ValueDescriptor {
    final Class elementType;
    final Class basicType;
    private final int order;
    private volatile String _elementRepid = null;

    protected ArrayDescriptor(Class<? extends ARR> type, Class elemType, TypeRepository rep) {
        super(type, rep);
        logger.fine("Creating an array descriptor for type " + type.getName() + " holding elements of " + elemType.getName());
        this.elementType = elemType;
        int order = 1;
        Class<?> basicType = elemType;
        while (basicType.isArray()) {
            basicType = basicType.getComponentType();
            ++order;
        }
        this.basicType = basicType;
        this.order = order;
    }

    protected final ARR createArray(org.omg.CORBA.portable.InputStream in, Map<Integer, Serializable> offsetMap, Integer key) {
        int len = in.read_long();
        SerialFilterHelper.checkArrayInput(this.type, len, in);
        Serializable arr = (Serializable)Array.newInstance(this.elementType, len);
        offsetMap.put(key, arr);
        return (ARR)arr;
    }

    @Override
    protected String genRepId() {
        if (this.elementType.isPrimitive() || this.elementType == Object.class) {
            return String.format("RMI:%s:%016X", this.type.getName(), 0);
        }
        TypeDescriptor desc = this.repo.getDescriptor(this.elementType);
        String elemRep = desc.getRepositoryID();
        String hash = elemRep.substring(elemRep.indexOf(58, 4));
        return String.format("RMI:%s:%s", this.type.getName(), hash);
    }

    private final String genElemRepId() {
        if (this.elementType.isPrimitive() || this.elementType == Object.class) {
            return String.format("RMI:%s:%016X", this.type.getName().substring(1), 0);
        }
        return this.repo.getDescriptor(this.elementType).getRepositoryID();
    }

    public String getElementRepositoryID() {
        if (this._elementRepid == null) {
            this._elementRepid = this.genElemRepId();
        }
        return this._elementRepid;
    }

    @Override
    protected final String genIDLName() {
        StringBuffer sb = new StringBuffer("org_omg_boxedRMI_");
        TypeDescriptor desc = this.repo.getDescriptor(this.basicType);
        String pkgName = desc.getPackageName();
        if (pkgName.length() == 0) {
            sb.append("seq");
            sb.append(this.order);
            sb.append('_');
            sb.append(desc.getTypeName());
        } else {
            String elemName = desc.getIDLName();
            int idx = elemName.lastIndexOf(95);
            pkgName = elemName.substring(0, idx + 1);
            String elmName = elemName.substring(idx + 1);
            sb.append(pkgName);
            sb.append("seq");
            sb.append(this.order);
            sb.append('_');
            sb.append(elmName);
        }
        return sb.toString();
    }

    static ArrayDescriptor get(Class type, TypeRepository rep) {
        logger.fine("retrieving an array descriptor for class " + type.getName());
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array");
        }
        Class<?> elemType = type.getComponentType();
        if (elemType.isPrimitive()) {
            if (elemType == Boolean.TYPE) {
                return new BooleanArrayDescriptor(rep);
            }
            if (elemType == Byte.TYPE) {
                return new ByteArrayDescriptor(rep);
            }
            if (elemType == Character.TYPE) {
                return new CharArrayDescriptor(rep);
            }
            if (elemType == Short.TYPE) {
                return new ShortArrayDescriptor(rep);
            }
            if (elemType == Integer.TYPE) {
                return new IntArrayDescriptor(rep);
            }
            if (elemType == Long.TYPE) {
                return new LongArrayDescriptor(rep);
            }
            if (elemType == Float.TYPE) {
                return new FloatArrayDescriptor(rep);
            }
            if (elemType == Double.TYPE) {
                return new DoubleArrayDescriptor(rep);
            }
            throw new RuntimeException("unknown array type " + type);
        }
        if (Serializable.class.equals(elemType) || Externalizable.class.equals(elemType) || Object.class.equals(elemType)) {
            return new ObjectArrayDescriptor(type, (Class)elemType, rep);
        }
        if (Serializable.class.isAssignableFrom(elemType)) {
            return new ValueArrayDescriptor(type, (Class)elemType, rep);
        }
        if (Remote.class.isAssignableFrom(elemType)) {
            return new RemoteArrayDescriptor(type, (Class)elemType, rep);
        }
        return new AbstractObjectArrayDescriptor(type, (Class)elemType, rep);
    }

    @Override
    public Object read(org.omg.CORBA.portable.InputStream in) {
        InputStream _in = (InputStream)in;
        logger.fine("Reading an array value with repository id " + this.getRepositoryID() + " java class is " + this.type);
        return null == this.type ? _in.read_value(this.getRepositoryID()) : _in.read_value(this.type);
    }

    @Override
    public void write(org.omg.CORBA.portable.OutputStream out, Object value) {
        OutputStream _out = (OutputStream)out;
        _out.write_value((Serializable)value, this.getRepositoryID());
    }

    @Override
    protected final ValueMember[] genValueMembers() {
        ValueMember[] members = new ValueMember[1];
        TypeDescriptor elemDesc = this.repo.getDescriptor(this.elementType);
        String elemRepID = elemDesc.getRepositoryID();
        ORB orb = ORB.init();
        TypeCode memberTC = orb.create_sequence_tc(0, elemDesc.getTypeCode());
        members[0] = new ValueMember("", elemRepID, this.getRepositoryID(), "1.0", memberTC, null, 1);
        return members;
    }

    void addDependencies(Set classes) {
        this.repo.getDescriptor(this.basicType).addDependencies(classes);
    }

    final CorbaObjectReader makeCorbaObjectReader(final org.omg.CORBA.portable.InputStream in, final Map offsetMap, final Serializable obj) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CorbaObjectReader>(){

                @Override
                public CorbaObjectReader run() throws IOException {
                    return new CorbaObjectReader(in, offsetMap, obj);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

