/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.token.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenProxy;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JwtSSOTokenHelper.class}, name="JwtSSOTokenHelper", immediate=true, property={"service.vendor=IBM"})
public class JwtSSOTokenHelper {
    private static final TraceComponent tc = Tr.register(JwtSSOTokenHelper.class, (String)"security", (String)"com.ibm.ws.security.credentials.internal.resources.SecurityCredentialsMessages");
    public static final String JSON_WEB_TOKEN_SSO_PROXY = "JwtSSOTokenProxy";
    protected static final AtomicServiceReference<JwtSSOTokenProxy> jwtSSOTokenProxyRef = new AtomicServiceReference("JwtSSOTokenProxy");
    static final long serialVersionUID = -2736687117752219172L;

    @Reference(service=JwtSSOTokenProxy.class, name="JwtSSOTokenProxy", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJwtSSOToken(ServiceReference<JwtSSOTokenProxy> ref) {
        jwtSSOTokenProxyRef.setReference(ref);
    }

    protected void unsetJwtSSOToken(ServiceReference<JwtSSOTokenProxy> ref) {
        jwtSSOTokenProxyRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        jwtSSOTokenProxyRef.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token helper service is activated", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token helper service is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        jwtSSOTokenProxyRef.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token helper service is deactivated", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Jwt SSO token helper service is activated", (Object[])new Object[0]);
        }
    }

    public static void createJwtSSOToken(Subject subject) throws WSLoginFailedException {
        if (jwtSSOTokenProxyRef.getService() != null) {
            ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).createJwtSSOToken(subject);
        }
    }

    public static String getJwtSSOToken(Subject subject) {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).getJwtSSOToken(subject);
        }
        return null;
    }

    public static Subject handleJwtSSOToken(String jwtssotoken) throws WSLoginFailedException {
        return JwtSSOTokenHelper.handleJwtSSOToken(null, jwtssotoken);
    }

    public static Subject handleJwtSSOToken(Subject subject, String jwtssotoken) throws WSLoginFailedException {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).handleJwtSSOTokenValidation(subject, jwtssotoken);
        }
        return null;
    }

    public static String getCustomCacheKeyFromJwtSSOToken(String encodedjwt) {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).getCustomCacheKeyFromJwtSSOToken(encodedjwt);
        }
        return null;
    }

    public static String getCacheKeyForJwtSSOToken(Subject subject, String encodedjwt) {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).getCacheKeyForJwtSSOToken(subject, encodedjwt);
        }
        return null;
    }

    public static void addAttributesToJwtSSOToken(Subject subject) throws WSLoginFailedException {
        if (jwtSSOTokenProxyRef.getService() != null) {
            ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).addAttributesToJwtSSOToken(subject);
        }
    }

    public static boolean isSubjectValid(Subject subject) {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).isSubjectValid(subject);
        }
        return false;
    }

    public static boolean shouldSetJwtCookiePathToWebAppContext() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).shouldSetJwtCookiePathToWebAppContext();
        }
        return false;
    }

    public static boolean shouldAlsoIncludeLtpaCookie() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).shouldAlsoIncludeLtpaCookie();
        }
        return true;
    }

    public static boolean shouldUseLtpaIfJwtAbsent() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).shouldUseLtpaIfJwtAbsent();
        }
        return true;
    }

    public static String getJwtCookieName() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).getJwtCookieName();
        }
        return null;
    }

    public static boolean isCookieSecured() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).isCookieSecured();
        }
        return true;
    }

    public static long getValidTimeInMinutes() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).getValidTimeInMinutes();
        }
        return 0L;
    }

    public static boolean isDisableJwtCookie() {
        if (jwtSSOTokenProxyRef.getService() != null) {
            return ((JwtSSOTokenProxy)jwtSSOTokenProxyRef.getService()).isDisableJwtCookie();
        }
        return false;
    }
}

