/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.RelatesToType;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class ContextUtils {
    public static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    public static final String ACTION = ContextUtils.class.getName() + ".ACTION";
    private static final EndpointReferenceType NONE_ENDPOINT_REFERENCE = new EndpointReferenceType();
    private static final Logger LOG = LogUtils.getL7dLogger(ContextUtils.class);
    private static final String URN_UUID = "urn:uuid:";
    private static final String MAP_FAULT_NAME_PROPERTY = "org.apache.cxf.ws.addressing.map.fault.name";
    private static final String MAP_FAULT_REASON_PROPERTY = "org.apache.cxf.ws.addressing.map.fault.reason";
    private static final String PARTIAL_RESPONSE_SENT_PROPERTY = "org.apache.cxf.ws.addressing.partial.response.sent";
    static final long serialVersionUID = 2764882149929587265L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ContextUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutbound(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isOutbound", new Object[]{message});
        }
        boolean bl = message != null && message.getExchange() != null && (message == message.getExchange().getOutMessage() || message == message.getExchange().getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isOutbound", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFault(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isFault", new Object[]{message});
        }
        boolean bl = message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isRequestor(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isRequestor", new Object[]{message});
        }
        Boolean requestor = (Boolean)((MessageImpl)message).getRequestorRole();
        boolean bl = requestor != null && requestor != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isRequestor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getMAPProperty(boolean isRequestor, boolean isProviderContext, boolean isOutbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "getMAPProperty", new Object[]{isRequestor, isProviderContext, isOutbound});
        }
        if (isRequestor && isProviderContext) {
            String string = "javax.xml.ws.addressing.context";
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getMAPProperty", string);
            }
            return string;
        }
        String string = isOutbound ? "javax.xml.ws.addressing.context.outbound" : "javax.xml.ws.addressing.context.inbound";
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getMAPProperty", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs", new Object[]{maps, message, isOutbound});
        }
        ContextUtils.storeMAPs(maps, message, isOutbound, ContextUtils.isRequestor(message), false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound, boolean isRequestor) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs", new Object[]{maps, message, isOutbound, isRequestor});
        }
        ContextUtils.storeMAPs(maps, message, isOutbound, isRequestor, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound, boolean isRequestor, boolean isProviderContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs", new Object[]{maps, message, isOutbound, isRequestor, isProviderContext});
        }
        if (maps != null) {
            String mapProperty = ContextUtils.getMAPProperty(isRequestor, isProviderContext, isOutbound);
            LOG.log(Level.FINE, "associating MAPs with context property {0}", mapProperty);
            message.put(mapProperty, maps);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static AddressingProperties retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPs", new Object[]{message, isProviderContext, isOutbound});
        }
        AddressingProperties addressingProperties = ContextUtils.retrieveMAPs(message, isProviderContext, isOutbound, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            addressingProperties = addressingProperties;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPs", addressingProperties);
        }
        return addressingProperties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static AddressingProperties retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound, boolean warnIfMissing) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPs", new Object[]{message, isProviderContext, isOutbound, warnIfMissing});
        }
        boolean isRequestor = ContextUtils.isRequestor(message);
        String mapProperty = ContextUtils.getMAPProperty(isRequestor, isProviderContext, isOutbound);
        LOG.log(Level.FINE, "retrieving MAPs from context property {0}", mapProperty);
        AddressingProperties maps = (AddressingProperties)message.get(mapProperty);
        if (maps == null && isOutbound && !isRequestor && message.getExchange() != null && message.getExchange().getInMessage() != null) {
            maps = (AddressingProperties)message.getExchange().getInMessage().get(mapProperty);
        }
        if (maps != null) {
            LOG.log(Level.FINE, "current MAPs {0}", maps);
        } else if (!isProviderContext) {
            LogUtils.log(LOG, warnIfMissing ? Level.WARNING : Level.FINE, "MAPS_RETRIEVAL_FAILURE_MSG");
        }
        AddressingProperties addressingProperties = maps;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            addressingProperties = addressingProperties;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPs", addressingProperties);
        }
        return addressingProperties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static AttributedURIType getAttributedURI(String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "getAttributedURI", new Object[]{uri});
        }
        AttributedURIType attributedURI = WSA_OBJECT_FACTORY.createAttributedURIType();
        attributedURI.setValue(uri);
        AttributedURIType attributedURIType = attributedURI;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attributedURIType = attributedURIType;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getAttributedURI", attributedURIType);
        }
        return attributedURIType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RelatesToType getRelatesTo(String uri) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "getRelatesTo", new Object[]{uri});
        }
        RelatesToType relatesTo = WSA_OBJECT_FACTORY.createRelatesToType();
        relatesTo.setValue(uri);
        RelatesToType relatesToType = relatesTo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            relatesToType = relatesToType;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getRelatesTo", relatesToType);
        }
        return relatesToType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean startsWith(String value, String ref) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "startsWith", new Object[]{value, ref});
        }
        if (StringUtils.isEmpty(value)) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "startsWith", bl);
            }
            return bl;
        }
        boolean bl = value.startsWith(ref);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "startsWith", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isGenericAddress(EndpointReferenceType ref) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isGenericAddress", new Object[]{ref});
        }
        boolean bl = ref == null || ref.getAddress() == null || ContextUtils.startsWith(ref.getAddress().getValue(), "http://www.w3.org/2005/08/addressing/anonymous") || ContextUtils.startsWith(ref.getAddress().getValue(), "http://www.w3.org/2005/08/addressing/none");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isGenericAddress", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isAnonymousAddress(EndpointReferenceType ref) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isAnonymousAddress", new Object[]{ref});
        }
        boolean bl = ref == null || ref.getAddress() == null || ContextUtils.startsWith(ref.getAddress().getValue(), "http://www.w3.org/2005/08/addressing/anonymous");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isAnonymousAddress", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isNoneAddress(EndpointReferenceType ref) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "isNoneAddress", new Object[]{ref});
        }
        boolean bl = ref != null && ref.getAddress() != null && "http://www.w3.org/2005/08/addressing/none".equals(ref.getAddress().getValue());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "isNoneAddress", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean hasEmptyAction(AddressingProperties maps) {
        boolean empty;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "hasEmptyAction", new Object[]{maps});
        }
        boolean bl = empty = maps.getAction() == null;
        if (maps.getAction() != null && maps.getAction().getValue().isEmpty()) {
            maps.setAction(null);
            empty = false;
        }
        boolean bl2 = empty;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl2 = bl2;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "hasEmptyAction", bl2);
        }
        return bl2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void propogateReceivedMAPs(AddressingProperties inMAPs, Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "propogateReceivedMAPs", new Object[]{inMAPs, exchange});
        }
        if (exchange.getOutMessage() == null) {
            exchange.setOutMessage(ContextUtils.createMessage(exchange));
        }
        ContextUtils.propogateReceivedMAPs(inMAPs, exchange.getOutMessage());
        if (exchange.getOutFaultMessage() == null) {
            exchange.setOutFaultMessage(ContextUtils.createMessage(exchange));
        }
        ContextUtils.propogateReceivedMAPs(inMAPs, exchange.getOutFaultMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "propogateReceivedMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void propogateReceivedMAPs(AddressingProperties inMAPs, Message responseMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "propogateReceivedMAPs", new Object[]{inMAPs, responseMessage});
        }
        if (responseMessage != null) {
            ContextUtils.storeMAPs(inMAPs, responseMessage, false, false, false);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "propogateReceivedMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeMAPFaultName(String faultName, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPFaultName", new Object[]{faultName, message});
        }
        message.put(MAP_FAULT_NAME_PROPERTY, faultName);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPFaultName");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String retrieveMAPFaultName(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPFaultName", new Object[]{message});
        }
        String string = (String)message.get(MAP_FAULT_NAME_PROPERTY);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPFaultName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeMAPFaultReason(String reason, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPFaultReason", new Object[]{reason, message});
        }
        message.put(MAP_FAULT_REASON_PROPERTY, reason);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeMAPFaultReason");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String retrieveMAPFaultReason(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPFaultReason", new Object[]{message});
        }
        String string = (String)message.get(MAP_FAULT_REASON_PROPERTY);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveMAPFaultReason", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storePartialResponseSent(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storePartialResponseSent", new Object[]{message});
        }
        message.put(PARTIAL_RESPONSE_SENT_PROPERTY, Boolean.TRUE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storePartialResponseSent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean retrievePartialResponseSent(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrievePartialResponseSent", new Object[]{message});
        }
        Boolean ret = (Boolean)message.get(PARTIAL_RESPONSE_SENT_PROPERTY);
        boolean bl = ret != null && ret != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrievePartialResponseSent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeDeferUncorrelatedMessageAbort(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeDeferUncorrelatedMessageAbort", new Object[]{message});
        }
        if (message.getExchange() != null) {
            message.getExchange().put("defer.uncorrelated.message.abort", Boolean.TRUE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeDeferUncorrelatedMessageAbort");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean retrieveDeferUncorrelatedMessageAbort(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveDeferUncorrelatedMessageAbort", new Object[]{message});
        }
        Boolean ret = message.getExchange() != null ? (Boolean)message.getExchange().get("defer.uncorrelated.message.abort") : null;
        boolean bl = ret != null && ret != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveDeferUncorrelatedMessageAbort", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void storeDeferredUncorrelatedMessageAbort(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "storeDeferredUncorrelatedMessageAbort", new Object[]{message});
        }
        if (message.getExchange() != null) {
            message.getExchange().put("deferred.uncorrelated.message.abort", Boolean.TRUE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "storeDeferredUncorrelatedMessageAbort");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean retrieveDeferredUncorrelatedMessageAbort(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveDeferredUncorrelatedMessageAbort", new Object[]{message});
        }
        Boolean ret = message.getExchange() != null ? (Boolean)message.getExchange().get("deferred.uncorrelated.message.abort") : null;
        boolean bl = ret != null && ret != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveDeferredUncorrelatedMessageAbort", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean retrieveAsyncPostResponseDispatch(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "retrieveAsyncPostResponseDispatch", new Object[]{message});
        }
        Boolean ret = (Boolean)((MessageImpl)message).getAsyncPostDispatch();
        boolean bl = ret != null && ret != false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "retrieveAsyncPostResponseDispatch", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String generateUUID() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "generateUUID", new Object[0]);
        }
        String string = URN_UUID + UUID.randomUUID();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "generateUUID", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Conduit getConduit(Conduit conduit, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "getConduit", new Object[]{conduit, message});
        }
        if (conduit == null) {
            Exchange exchange = message.getExchange();
            conduit = exchange != null ? exchange.getConduit(message) : null;
        }
        Conduit conduit2 = conduit;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            conduit2 = conduit2;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getConduit", conduit2);
        }
        return conduit2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static EndpointReferenceType getNoneEndpointReference() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "getNoneEndpointReference", new Object[0]);
        }
        EndpointReferenceType endpointReferenceType = NONE_ENDPOINT_REFERENCE;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointReferenceType = endpointReferenceType;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "getNoneEndpointReference", endpointReferenceType);
        }
        return endpointReferenceType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void applyReferenceParam(EndpointReferenceType toEpr, Object el) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "applyReferenceParam", new Object[]{toEpr, el});
        }
        if (null == toEpr.getReferenceParameters()) {
            toEpr.setReferenceParameters(WSA_OBJECT_FACTORY.createReferenceParametersType());
        }
        toEpr.getReferenceParameters().getAny().add(el);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "applyReferenceParam");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Message createMessage(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "createMessage", new Object[]{exchange});
        }
        Endpoint ep = exchange.getEndpoint();
        Message msg = null;
        if (ep != null) {
            msg = new MessageImpl();
            msg.setExchange(exchange);
            if (ep.getBinding() != null) {
                msg = ep.getBinding().createMessage(msg);
            }
        }
        MessageImpl messageImpl = msg;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageImpl = messageImpl;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "createMessage", messageImpl);
        }
        return messageImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Destination createDecoupledDestination(Exchange exchange, final EndpointReferenceType reference) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.ContextUtils", "createDecoupledDestination", new Object[]{exchange, reference});
        }
        final EndpointInfo ei = exchange.getEndpoint().getEndpointInfo();
        Destination destination = new Destination(){
            static final long serialVersionUID = 540410848365538496L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public EndpointReferenceType getAddress() {
                return reference;
            }

            @Override
            public Conduit getBackChannel(Message inMessage) throws IOException {
                Bus bus = inMessage.getExchange().getBus();
                inMessage.getExchange().setOneWay(true);
                ConduitInitiator conduitInitiator = bus.getExtension(ConduitInitiatorManager.class).getConduitInitiatorForUri(reference.getAddress().getValue());
                if (conduitInitiator != null) {
                    Conduit c = conduitInitiator.getConduit(ei, reference, bus);
                    c.setMessageObserver(new MessageObserver(){
                        static final long serialVersionUID = -643857386113038972L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public void onMessage(Message m) {
                            InputStream is = m.getContent(InputStream.class);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.ws.addressing.ContextUtils$1$1", (String)"592", (Object)this, (Object[])new Object[]{m});
                                }
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.ContextUtils$1$1", 1.class, null, null);
                        }
                    });
                    return c;
                }
                return null;
            }

            @Override
            public MessageObserver getMessageObserver() {
                return null;
            }

            @Override
            public void shutdown() {
            }

            @Override
            public void setMessageObserver(MessageObserver observer) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.ContextUtils$1", 1.class, null, null);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            destination = destination;
            LOG.exiting("org.apache.cxf.ws.addressing.ContextUtils", "createDecoupledDestination", destination);
        }
        return destination;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        NONE_ENDPOINT_REFERENCE.setAddress(new AttributedURIType());
        NONE_ENDPOINT_REFERENCE.getAddress().setValue("http://www.w3.org/2005/08/addressing/none");
    }
}

