/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.auth.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LRUCache {
    private static final TraceComponent tc = Tr.register(LRUCache.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
    private final Map<KerberosPrincipal, Subject> cache = Collections.synchronizedMap(new LinkedHashMap<KerberosPrincipal, Subject>(16, 0.75f, true){
        private static final long serialVersionUID = -2909022937597369536L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > LRUCache.this.MAX_ENTRIES;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.kerberos.auth.internal.LRUCache$1", 1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
        }
    });
    private final int MAX_ENTRIES;
    static final long serialVersionUID = -3232017331761630707L;

    public LRUCache(int size) {
        this.MAX_ENTRIES = size;
        if (size < 1) {
            throw new IllegalArgumentException("Size < 1: " + size);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void put(KerberosPrincipal key, Subject value) {
        this.cache.put(key, value);
    }

    public Subject get(KerberosPrincipal principal) {
        return this.cache.computeIfPresent(principal, (p, sub) -> {
            Set<GSSCredential> gssCreds = sub.getPrivateCredentials(GSSCredential.class);
            for (GSSCredential gssCred : gssCreds) {
                int remainingLifetime = -1;
                try {
                    remainingLifetime = gssCred.getRemainingLifetime();
                }
                catch (GSSException gSSException) {
                    // empty catch block
                }
                if (remainingLifetime > 0) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("no match because remaining lifetime is: " + remainingLifetime), (Object[])new Object[0]);
                }
                return null;
            }
            Set<KerberosTicket> kerbTickets = sub.getPrivateCredentials(KerberosTicket.class);
            KerberosTicket renewedTicket = null;
            KerberosTicket oldTicket = null;
            for (KerberosTicket kerbTicket : kerbTickets) {
                if (kerbTicket.isCurrent()) continue;
                if (kerbTicket.isRenewable()) {
                    long renewTillMs = kerbTicket.getRenewTill().getTime();
                    long timeLeft = renewTillMs - System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(10L);
                    if (timeLeft < 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("no match because is renewable but past the renewTill time. timeLeft=" + timeLeft), (Object[])new Object[0]);
                        }
                        return null;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"found match for non-current ticket, but ticket is renewable. Attempting to renew now", (Object[])new Object[0]);
                    }
                    oldTicket = kerbTicket;
                    renewedTicket = LRUCache.cloneTicket(kerbTicket);
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no match because ticket is not current and not renewable", (Object[])new Object[0]);
                }
                return null;
            }
            if (oldTicket != null && renewedTicket != null) {
                kerbTickets.remove(oldTicket);
                kerbTickets.add(renewedTicket);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found cached subject for principal: " + principal), (Object[])new Object[0]);
            }
            return sub;
        });
    }

    private static KerberosTicket cloneTicket(KerberosTicket kt) {
        byte[] asn1Encoding = kt.getEncoded();
        KerberosPrincipal client = kt.getClient();
        KerberosPrincipal server = kt.getServer();
        byte[] sessionKey = kt.getSessionKey().getEncoded();
        int keyType = kt.getSessionKeyType();
        boolean[] flags = kt.getFlags();
        Date authTime = kt.getAuthTime();
        Date startTime = kt.getStartTime();
        Date endTime = kt.getEndTime();
        Date renewTill = kt.getRenewTill();
        InetAddress[] clientAddresses = kt.getClientAddresses();
        return new KerberosTicket(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
    }
}

