/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class StringUtils {
    private static final String ALLOWABLE_CHARS = "[^A-Za-z0-9_]";
    private static Pattern p;
    static final long serialVersionUID = 2521532903653595662L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    StringUtils() {
    }

    public String replaceNonAlpha(String name) {
        String modifiedName = null;
        if (p != null) {
            modifiedName = p.matcher(name).replaceAll("_");
        }
        return modifiedName;
    }

    int getNextLocation(int start, String list) {
        int size = list.length();
        for (int i = start; i < size; ++i) {
            char ch = list.charAt(i);
            if (ch != '\\' && ch != ',') continue;
            return i;
        }
        return -1;
    }

    @Trivial
    String escapeValue(String value) {
        int start = 0;
        int pos = this.getNextLocation(start, value);
        if (pos == -1) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        while (pos != -1) {
            builder.append(value, start, pos);
            builder.append('\\');
            builder.append(value.charAt(pos));
            start = pos + 1;
            pos = this.getNextLocation(start, value);
        }
        builder.append(value, start, value.length());
        return builder.toString();
    }

    @Trivial
    String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0) {
                return "";
            }
            if (list.size() == 1) {
                String strValue = String.valueOf(list.get(0));
                return this.escapeValue(strValue);
            }
            StringBuilder builder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String strValue = String.valueOf(iterator.next());
                strValue = this.escapeValue(strValue);
                builder.append(strValue);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return "";
            }
            if (array.length == 1) {
                return this.escapeValue(array[0]);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                String strValue = this.escapeValue(array[i]);
                builder.append(strValue);
                if (i + 1 >= array.length) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            if (size == 0) {
                return "";
            }
            if (size == 1) {
                String strValue = String.valueOf(Array.get(value, 0));
                return this.escapeValue(strValue);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                String strValue = String.valueOf(Array.get(value, i));
                strValue = this.escapeValue(strValue);
                builder.append(strValue);
                if (i + 1 >= size) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        return value.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.StringUtils", StringUtils.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        p = null;
        p = Pattern.compile(ALLOWABLE_CHARS);
    }
}

