/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.InternalConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.InvalidFrameworkStateException;
import io.openliberty.microprofile.config.internal.serverxml.OSGiConfigUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerXMLVariableConfigSource
extends InternalConfigSource
implements ConfigSource {
    private static final TraceComponent tc = Tr.register(ServerXMLVariableConfigSource.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
    private final ConfigAction configAction = new ConfigAction();
    private BundleContext bundleContext;
    private ConfigVariables configVariables;
    static final long serialVersionUID = 518955393407086337L;

    public ServerXMLVariableConfigSource() {
        this(500, Tr.formatMessage((TraceComponent)tc, (String)"server.xml.variables.config.source", (Object[])new Object[0]));
    }

    protected ServerXMLVariableConfigSource(int ordinal, String id) {
        super(ordinal, id);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Map<String, String> serverXMLVariables = null;
        serverXMLVariables = System.getSecurityManager() == null ? this.getServerXMLVariables() : AccessController.doPrivileged(this.configAction);
        if (serverXMLVariables != null) {
            props.putAll(serverXMLVariables);
        }
        return props;
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = OSGiConfigUtils.getBundleContext(((Object)((Object)this)).getClass());
        }
        return this.bundleContext;
    }

    @FFDCIgnore(value={InvalidFrameworkStateException.class})
    protected ConfigVariables getConfigVariables() {
        BundleContext bundleContext;
        if (this.configVariables == null && (bundleContext = this.getBundleContext()) != null) {
            try {
                this.configVariables = OSGiConfigUtils.getConfigVariables(bundleContext);
            }
            catch (InvalidFrameworkStateException invalidFrameworkStateException) {
                // empty catch block
            }
        }
        return this.configVariables;
    }

    protected Map<String, String> getServerXMLVariables() {
        Map<String, String> props = new HashMap<String, String>();
        ConfigVariables configVariables = this.getConfigVariables();
        if (configVariables != null) {
            props = OSGiConfigUtils.getVariablesFromServerXML(configVariables);
        }
        return props;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ConfigAction
    implements PrivilegedAction<Map<String, String>> {
        static final long serialVersionUID = 2565582921916747674L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConfigAction() {
        }

        @Override
        public Map<String, String> run() {
            return ServerXMLVariableConfigSource.this.getServerXMLVariables();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.serverxml.ServerXMLVariableConfigSource$ConfigAction", ConfigAction.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
        }
    }
}

