/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld.injection;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.EjbEndpointService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.DefinitionException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceRef;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EEValidationUtils {
    private static final TraceComponent tc = Tr.register(EEValidationUtils.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    static final long serialVersionUID = 4777170818878306666L;

    private static boolean isProducer(Annotated annotated) {
        boolean isProducer = false;
        Produces produces = (Produces)annotated.getAnnotation(Produces.class);
        if (produces != null) {
            isProducer = true;
        }
        return isProducer;
    }

    private static void throwDefinitionException(Class<?> declaringClass, String memberName, Class<?> fieldType) throws DefinitionException {
        String producerFieldName = declaringClass.getName() + "." + memberName;
        String fieldTypeName = fieldType.getName();
        throw new DefinitionException(Tr.formatMessage((TraceComponent)tc, (String)"resource.producer.validation.error.CWOWB1007E", (Object[])new Object[]{producerFieldName, fieldTypeName}));
    }

    private static void throwDefinitionException(Class<?> declaringClass, Annotated annotated) throws DefinitionException {
        EEValidationUtils.throwDefinitionException(declaringClass, EEValidationUtils.getInjectedMemberName(annotated), EEValidationUtils.getInjectedClass(annotated));
    }

    @ManualTrace
    private static Class<?> getInjectedClass(Annotated annotated) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectedClass", (Object[])new Object[]{Util.identity((Object)annotated)});
        }
        if (annotated instanceof AnnotatedField) {
            return ((AnnotatedField)annotated).getJavaMember().getType();
        }
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedCallable callable = ((AnnotatedParameter)annotated).getDeclaringCallable();
            Class<?>[] paramaterTypes = null;
            if (callable instanceof AnnotatedMethod) {
                Method method = ((AnnotatedMethod)callable).getJavaMember();
                paramaterTypes = method.getParameterTypes();
            } else if (callable instanceof AnnotatedConstructor) {
                Constructor constructor = ((AnnotatedConstructor)callable).getJavaMember();
                paramaterTypes = constructor.getParameterTypes();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectedClass");
            }
            return paramaterTypes[((AnnotatedParameter)annotated).getPosition()];
        }
        throw new UnsupportedOperationException("Only AnnotatedFields or AnnotatedMethods should be here");
    }

    @ManualTrace
    private static String getInjectedMemberName(Annotated annotated) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectedMemberName", (Object[])new Object[]{Util.identity((Object)annotated)});
        }
        if (annotated instanceof AnnotatedField) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectedClass");
            }
            return ((AnnotatedField)annotated).getJavaMember().getName();
        }
        if (annotated instanceof AnnotatedParameter) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInjectedClass");
            }
            return ((AnnotatedParameter)annotated).getDeclaringCallable().getJavaMember().getName();
        }
        throw new UnsupportedOperationException("Only AnnotatedFields or AnnotatedMethods should be here");
    }

    @ManualTrace
    @FFDCIgnore(value={ClassCastException.class})
    public static void validateEjb(EJB ejb, Class<?> declaringClass, Annotated annotated, CDIArchive cdiArchive) {
        CDIRuntime cdiRuntime;
        EjbEndpointService ejbEndpointService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateEjb", (Object[])new Object[]{Util.identity((Object)annotated), cdiArchive});
        }
        if ((ejbEndpointService = (cdiRuntime = cdiArchive.getCDIRuntime()).getEjbEndpointService()) != null && EEValidationUtils.isProducer(annotated)) {
            try {
                ejbEndpointService.validateEjbInjection(ejb, cdiArchive, EEValidationUtils.getInjectedClass(annotated));
            }
            catch (CDIException cDIException) {
                FFDCFilter.processException((Throwable)cDIException, (String)"com.ibm.ws.cdi.impl.weld.injection.EEValidationUtils", (String)"139", null, (Object[])new Object[]{ejb, declaringClass, annotated, cdiArchive});
            }
            catch (ClassCastException e) {
                EEValidationUtils.throwDefinitionException(declaringClass, annotated);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateEjb");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private static void validateJndiLookup(String lookupString, Annotated annotated, Class<?> declaringClass, CDIArchive cdiArchive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateJndiLookup", (Object[])new Object[]{Util.identity((Object)annotated), declaringClass, cdiArchive});
        }
        CDIRuntime cdiRuntime = cdiArchive.getCDIRuntime();
        try {
            cdiRuntime.beginContext(cdiArchive);
            InitialContext c = new InitialContext();
            EEValidationUtils.validateJndiLookup(c, lookupString, annotated, declaringClass, cdiArchive);
        }
        catch (NamingException c) {
            FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.cdi.impl.weld.injection.EEValidationUtils", (String)"170", null, (Object[])new Object[]{lookupString, annotated, declaringClass, cdiArchive});
        }
        catch (CDIException c) {
            void e;
            FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.cdi.impl.weld.injection.EEValidationUtils", (String)"172", null, (Object[])new Object[]{lookupString, annotated, declaringClass, cdiArchive});
            throw new IllegalStateException((Throwable)e);
        }
        finally {
            cdiRuntime.endContext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateJndiLookup", (Object)new Object[]{Util.identity((Object)annotated)});
        }
    }

    @ManualTrace
    private static void validateJndiLookup(InitialContext c, String lookupString, Annotated annotated, Class<?> declaringClass, CDIArchive cdiArchive) throws NamingException, CDIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateJndiLookup", (Object[])new Object[]{c, lookupString, Util.identity((Object)annotated), declaringClass});
        }
        Name lookupName = c.getNameParser("").parse(lookupString);
        String name = lookupName.get(lookupName.size() - 1);
        Name prefix = lookupName.getPrefix(lookupName.size() - 1);
        Class<?> injectedClass = EEValidationUtils.getInjectedClass(annotated);
        if (!(injectedClass instanceof Class)) {
            return;
        }
        if (injectedClass.isPrimitive() || injectedClass.isArray()) {
            return;
        }
        NamingEnumeration<NameClassPair> contents = c.list(prefix);
        while (contents.hasMore()) {
            NameClassPair pair = contents.next();
            if (!name.equals(pair.getName())) continue;
            try {
                String className = pair.getClassName();
                Class<?> jndiClass = cdiArchive.getClassLoader().loadClass(className);
                if (!injectedClass.isAssignableFrom(jndiClass)) {
                    Class<?> lookupClass = EEValidationUtils.getLookupClass(c, lookupName);
                    if (lookupClass == null || !injectedClass.isAssignableFrom(lookupClass)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Injected class not assignable to jndiClass. injectedClass=" + injectedClass + " jndiClass=" + jndiClass + " lookupClass=" + lookupClass), (Object[])new Object[0]);
                        }
                        EEValidationUtils.throwDefinitionException(declaringClass, annotated);
                        continue;
                    }
                    return;
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.cdi.impl.weld.injection.EEValidationUtils", (String)"235", null, (Object[])new Object[]{c, lookupString, annotated, declaringClass, cdiArchive});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateJndiLookup", (Object)new Object[]{Util.identity((Object)annotated)});
        }
    }

    @FFDCIgnore(value={RuntimeException.class})
    private static Class<?> getLookupClass(InitialContext c, Name lookupName) throws NamingException, CDIException {
        try {
            Object o = c.lookup(lookupName);
            if (o != null) {
                return o.getClass();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @ManualTrace
    public static void validateWebServiceRef(WebServiceRef wsRef, Class<?> declaringClass, Annotated annotated) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateWebServiceRef", (Object[])new Object[]{wsRef, declaringClass, Util.identity((Object)annotated)});
        }
        Class ipClass = EEValidationUtils.getInjectedClass(annotated);
        if (!wsRef.lookup().isEmpty()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validating WebServiceRef injection point", (Object[])new Object[]{wsRef});
        }
        Class serviceClass = wsRef.value();
        Class effectiveClass = ipClass;
        if (ipClass.isAssignableFrom(wsRef.type())) {
            effectiveClass = wsRef.type();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Found service type and effective injection types", (Object[])new Object[]{serviceClass, effectiveClass});
        }
        if (Service.class.isAssignableFrom(effectiveClass)) {
            if (effectiveClass.getName().equals(Service.class.getName())) {
                if (!Service.class.isAssignableFrom(serviceClass) || serviceClass.getName().equals(Service.class.getName())) {
                    EEValidationUtils.throwDefinitionException(declaringClass, annotated);
                }
            } else if (!serviceClass.getName().equals(effectiveClass.getName()) && !serviceClass.getName().equals(Service.class.getName())) {
                EEValidationUtils.throwDefinitionException(declaringClass, annotated);
            }
        } else {
            HashSet portTypes = new HashSet();
            for (Method method : serviceClass.getMethods()) {
                if (method.getAnnotation(WebEndpoint.class) == null) continue;
                portTypes.add(method.getReturnType());
            }
            if (!portTypes.isEmpty()) {
                for (Class clazz : portTypes) {
                    if (!effectiveClass.isAssignableFrom(clazz)) continue;
                    return;
                }
                EEValidationUtils.throwDefinitionException(declaringClass, annotated);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateWebServiceRef");
        }
    }

    @ManualTrace
    public static void validateResource(Resource res, Class<?> declaringClass, Annotated annotated, CDIArchive cdiArchive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateResource", (Object[])new Object[]{res, declaringClass, Util.identity((Object)annotated), cdiArchive});
        }
        if (EEValidationUtils.isProducer(annotated)) {
            if (!res.lookup().isEmpty()) {
                EEValidationUtils.validateJndiLookup(res.lookup(), annotated, declaringClass, cdiArchive);
            } else if (!res.name().isEmpty()) {
                EEValidationUtils.validateJndiLookup("java:comp/env/" + res.name(), annotated, declaringClass, cdiArchive);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateResource");
        }
    }

    @ManualTrace
    public static void validatePersistenceContext(PersistenceContext persistenceContext, Class<?> declaringClass, Annotated annotated) {
        Class<EntityManager> ipClass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validatePersistenceContext", (Object[])new Object[]{persistenceContext, declaringClass, Util.identity((Object)annotated)});
        }
        if (EEValidationUtils.isProducer(annotated) && EEValidationUtils.getInjectedClass(annotated) instanceof Class && !(ipClass = EEValidationUtils.getInjectedClass(annotated)).isAssignableFrom(EntityManager.class)) {
            EEValidationUtils.throwDefinitionException(declaringClass, annotated);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validatePersistenceContext");
        }
    }

    @ManualTrace
    public static void validatePersistenceUnit(PersistenceUnit PersistenceUnit2, Class<?> declaringClass, Annotated annotated) {
        Class<EntityManagerFactory> ipClass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validatePersistenceUnit", (Object[])new Object[]{PersistenceUnit2, declaringClass, Util.identity((Object)annotated)});
        }
        if (EEValidationUtils.isProducer(annotated) && EEValidationUtils.getInjectedClass(annotated) instanceof Class && !(ipClass = EEValidationUtils.getInjectedClass(annotated)).isAssignableFrom(EntityManagerFactory.class)) {
            EEValidationUtils.throwDefinitionException(declaringClass, annotated);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validatePersistenceUnit");
        }
    }
}

