/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.internal.InstallLogUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SubsytemEntry {
    private final ZipEntry entry;

    public SubsytemEntry(ZipFile esaFile) throws IOException {
        this.entry = this.findSubsystemEntry(esaFile);
    }

    public SubsytemEntry(ZipFile indexFile, String featureName) throws IOException {
        this.entry = this.findSubsystemEntry(indexFile, featureName);
    }

    private ZipEntry findSubsystemEntry(ZipFile zip) {
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        ZipEntry subsystemEntry = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry nextEntry = zipEntries.nextElement();
            if (!"OSGI-INF/Subsystem.mf".equalsIgnoreCase(nextEntry.getName())) continue;
            if (subsystemEntry != null) {
                Logger logger = Logger.getLogger("com.ibm.ws.install");
                logger.log(Level.WARNING, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.two.subsystem.manifests", subsystemEntry.getName()));
                break;
            }
            subsystemEntry = nextEntry;
        }
        return subsystemEntry;
    }

    private ZipEntry findSubsystemEntry(ZipFile zip, String featureName) {
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        ZipEntry subsystemEntry = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry nextEntry = zipEntries.nextElement();
            if (!String.format("%sOSGI-INF/Subsystem.mf", featureName).equalsIgnoreCase(nextEntry.getName())) continue;
            if (subsystemEntry != null) {
                Logger logger = Logger.getLogger("com.ibm.ws.install");
                logger.log(Level.WARNING, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.two.subsystem.manifests", subsystemEntry.getName()));
                break;
            }
            subsystemEntry = nextEntry;
        }
        return subsystemEntry;
    }

    public ZipEntry getSubsystemEntry() {
        return this.entry;
    }

    public String getSubsystemEntryName() {
        return this.entry.getName();
    }
}

