/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrency.policy.ConcurrencyPolicy;
import com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl;
import com.ibm.ws.concurrent.internal.ScheduledTask;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.concurrent.Trigger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.managedScheduledExecutorService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ExecutorService.class, ManagedExecutorService.class, ResourceFactory.class, ApplicationRecycleComponent.class, ScheduledExecutorService.class, ManagedScheduledExecutorService.class}, reference={@Reference(name="ApplicationRecycleCoordinator", service=ApplicationRecycleCoordinator.class)}, property={"creates.objectClass=java.util.concurrent.ExecutorService", "creates.objectClass=java.util.concurrent.ScheduledExecutorService", "creates.objectClass=javax.enterprise.concurrent.ManagedExecutorService", "creates.objectClass=javax.enterprise.concurrent.ManagedScheduledExecutorService"})
public class ManagedScheduledExecutorServiceImpl
extends ManagedExecutorServiceImpl
implements ManagedScheduledExecutorService {
    private static final TraceComponent tc = Tr.register(ManagedScheduledExecutorServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private static final int FUTURE_PURGE_INTERVAL = 20;
    private volatile int futureCount;
    private final ConcurrentLinkedQueue<ScheduledFuture<?>> futures = new ConcurrentLinkedQueue();
    ScheduledExecutorService scheduledExecSvc;
    static final long serialVersionUID = -6145051554106485804L;

    @Override
    @Trivial
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        super.activate(context, properties);
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Future future = this.futures.poll();
        while (future != null) {
            if (!future.isDone() && future.cancel(true) && trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"canceled scheduled task", (Object[])new Object[]{future});
            }
            future = this.futures.poll();
        }
        super.deactivate(context);
    }

    @Override
    @Trivial
    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        super.modified(context, properties);
    }

    @Trivial
    private final void purgeFutures() {
        Iterator<ScheduledFuture<?>> it = this.futures.iterator();
        while (it.hasNext()) {
            if (!it.next().isDone()) continue;
            it.remove();
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(this, task, true, delay, null, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, Trigger trigger) {
        if (trigger == null) {
            throw new NullPointerException(Trigger.class.getName());
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, true, trigger);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, delay, null, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        if (trigger == null) {
            throw new NullPointerException(Trigger.class.getName());
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, trigger);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (period <= 0L) {
            throw new IllegalArgumentException(Long.toString(period));
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, initialDelay < 0L ? 0L : initialDelay, null, period, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException(Long.toString(delay));
        }
        ScheduledTask scheduledTask = new ScheduledTask(this, task, false, initialDelay < 0L ? 0L : initialDelay, delay, null, unit);
        if (this.futures.add(scheduledTask.future) && ++this.futureCount % 20 == 0) {
            this.purgeFutures();
        }
        return scheduledTask.future;
    }

    @Override
    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setConcurrencyPolicy(ConcurrencyPolicy svc) {
        super.setConcurrencyPolicy(svc);
    }

    @Override
    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setContextService(ServiceReference<WSContextService> ref) {
        super.setContextService(ref);
    }

    @Override
    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        super.setEEVersion(ref);
    }

    @Override
    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(id=unbound)")
    protected void setLongRunningPolicy(ConcurrencyPolicy svc) {
        super.setLongRunningPolicy(svc);
    }

    @Trivial
    @Reference(target="(deferrable=false)")
    protected void setScheduledExecutor(ScheduledExecutorService svc) {
        this.scheduledExecSvc = svc;
    }

    @Override
    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(component.name=com.ibm.ws.transaction.context.provider)")
    protected void setTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        super.setTransactionContextProvider(ref);
    }

    @Override
    @Trivial
    protected void unsetConcurrencyPolicy(ConcurrencyPolicy svc) {
        super.unsetConcurrencyPolicy(svc);
    }

    @Override
    @Trivial
    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        super.unsetContextService(ref);
    }

    @Override
    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
        super.unsetEEVersion(ref);
    }

    @Override
    @Trivial
    protected void unsetLongRunningPolicy(ConcurrencyPolicy svc) {
        super.unsetLongRunningPolicy(svc);
    }

    @Trivial
    protected void unsetScheduledExecutor(ScheduledExecutorService svc) {
        this.scheduledExecSvc = null;
    }

    @Override
    @Trivial
    protected void unsetTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        super.unsetTransactionContextProvider(ref);
    }
}

