/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.interceptors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.interceptors.CacheKeyInterceptor;

public abstract class CacheInterceptor
implements IdentityMap {
    protected IdentityMap targetIdentityMap;
    protected AbstractSession interceptedSession;

    public CacheInterceptor(IdentityMap targetIdentityMap, AbstractSession interceptedSession) {
        this.targetIdentityMap = targetIdentityMap;
        this.interceptedSession = interceptedSession;
    }

    @Override
    public CacheKey acquireDeferredLock(Object primaryKey, boolean isCacheCheckComplete) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireDeferredLock(primaryKey, isCacheCheckComplete));
    }

    @Override
    public CacheKey acquireLock(Object primaryKey, boolean forMerge, boolean isCacheCheckComplete) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireLock(primaryKey, forMerge, isCacheCheckComplete));
    }

    @Override
    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey cacheKeyToBeWrapped = this.targetIdentityMap.acquireLockNoWait(primaryKey, forMerge);
        if (cacheKeyToBeWrapped != null) {
            return this.createCacheKeyInterceptor(cacheKeyToBeWrapped);
        }
        return null;
    }

    @Override
    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey cacheKeyToBeWrapped = this.targetIdentityMap.acquireLockWithWait(primaryKey, forMerge, wait);
        if (cacheKeyToBeWrapped != null) {
            return this.createCacheKeyInterceptor(cacheKeyToBeWrapped);
        }
        return null;
    }

    @Override
    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        return this.createCacheKeyInterceptor(this.targetIdentityMap.acquireReadLockOnCacheKey(primaryKey));
    }

    @Override
    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey cacheKeyToBeWrapped = this.targetIdentityMap.acquireReadLockOnCacheKeyNoWait(primaryKey);
        if (cacheKeyToBeWrapped != null) {
            return this.createCacheKeyInterceptor(cacheKeyToBeWrapped);
        }
        return null;
    }

    @Override
    public void collectLocks(HashMap threadList) {
        this.targetIdentityMap.collectLocks(threadList);
    }

    @Override
    public abstract Object clone();

    @Override
    public boolean containsKey(Object primaryKey) {
        return this.targetIdentityMap.containsKey(primaryKey);
    }

    protected abstract CacheKeyInterceptor createCacheKeyInterceptor(CacheKey var1);

    @Override
    public Enumeration elements() {
        return this.targetIdentityMap.elements();
    }

    @Override
    public Object get(Object primaryKey) {
        return this.targetIdentityMap.get(primaryKey);
    }

    @Override
    public abstract Map<Object, Object> getAllFromIdentityMapWithEntityPK(Object[] var1, ClassDescriptor var2, AbstractSession var3);

    @Override
    public abstract Map<Object, CacheKey> getAllCacheKeysFromIdentityMapWithEntityPK(Object[] var1, ClassDescriptor var2, AbstractSession var3);

    @Override
    public CacheKey getCacheKey(Object primaryKey, boolean forMerge) {
        return this.targetIdentityMap.getCacheKey(primaryKey, forMerge);
    }

    @Override
    public CacheKey getCacheKeyForLock(Object primaryKey) {
        return this.targetIdentityMap.getCacheKeyForLock(primaryKey);
    }

    @Override
    public ClassDescriptor getDescriptor() {
        return this.targetIdentityMap.getDescriptor();
    }

    @Override
    public Class getDescriptorClass() {
        return this.targetIdentityMap.getDescriptorClass();
    }

    @Override
    public int getMaxSize() {
        return this.targetIdentityMap.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.targetIdentityMap.getSize();
    }

    @Override
    public int getSize(Class myClass, boolean recurse) {
        return this.targetIdentityMap.getSize(myClass, recurse);
    }

    public IdentityMap getTargetIdenttyMap() {
        return this.targetIdentityMap;
    }

    @Override
    public Object getWrapper(Object primaryKey) {
        return this.targetIdentityMap.getWrapper(primaryKey);
    }

    @Override
    public Object getWriteLockValue(Object primaryKey) {
        return this.targetIdentityMap.getWriteLockValue(primaryKey);
    }

    @Override
    public Enumeration keys() {
        return this.targetIdentityMap.keys();
    }

    @Override
    public Enumeration keys(boolean checkReadLocks) {
        return this.targetIdentityMap.keys(checkReadLocks);
    }

    @Override
    public void lazyRelationshipLoaded(Object rootEntity, ValueHolderInterface valueHolder, ForeignReferenceMapping mapping) {
        this.targetIdentityMap.lazyRelationshipLoaded(rootEntity, valueHolder, mapping);
    }

    @Override
    public CacheKey put(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return this.targetIdentityMap.put(primaryKey, object, writeLockValue, readTime);
    }

    @Override
    public Object remove(Object primaryKey, Object object) {
        return this.targetIdentityMap.remove(primaryKey, object);
    }

    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey.isWrapper()) {
            return this.targetIdentityMap.remove(cacheKey.getWrappedCacheKey());
        }
        return this.targetIdentityMap.remove(cacheKey);
    }

    @Override
    public void updateMaxSize(int maxSize) {
        this.targetIdentityMap.updateMaxSize(maxSize);
    }

    @Override
    public void setDescriptor(ClassDescriptor descriptor) {
        this.targetIdentityMap.setDescriptor(descriptor);
    }

    @Override
    public void setWrapper(Object primaryKey, Object wrapper) {
        this.targetIdentityMap.setWrapper(primaryKey, wrapper);
    }

    @Override
    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
        this.targetIdentityMap.setWriteLockValue(primaryKey, writeLockValue);
    }

    @Override
    public String toString() {
        return String.valueOf(Helper.getShortClassName("Intercepted " + this.targetIdentityMap.getClass())) + "[" + this.getSize() + "]";
    }
}

