/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility;

import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateFactory;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtility;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyFileUtilityImpl;
import com.ibm.ws.kernel.service.util.UtilityTemplate;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.SecurityUtilityTask;
import com.ibm.ws.security.utility.tasks.CreateLTPAKeysTask;
import com.ibm.ws.security.utility.tasks.CreateSSLCertificateTask;
import com.ibm.ws.security.utility.tasks.EncodeTask;
import com.ibm.ws.security.utility.tasks.HelpTask;
import com.ibm.ws.security.utility.utils.CommandUtils;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import com.ibm.ws.security.utility.utils.FileUtility;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class SecurityUtility
extends UtilityTemplate {
    static final String SCRIPT_NAME = "securityUtility";
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    List<SecurityUtilityTask> tasks = new ArrayList<SecurityUtilityTask>();

    SecurityUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerTask(SecurityUtilityTask task) {
        this.tasks.add(task);
    }

    private SecurityUtilityTask getTask(String taskName) {
        SecurityUtilityTask task = null;
        for (SecurityUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    SecurityUtilityReturnCodes runProgram(String[] args) {
        SecurityUtilityTask task;
        if (this.stdin == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdin"));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stdout == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdout"));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stderr == null) {
            this.stdout.println(CommandUtils.getMessage("error.missingIO", "stderr"));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        HelpTask help = new HelpTask(SCRIPT_NAME, this.tasks);
        this.registerTask(help);
        if (args.length == 0) {
            this.stdout.println(help.getScriptUsage());
            return SecurityUtilityReturnCodes.OK;
        }
        if (args[0].toLowerCase().endsWith(help.getTaskName().toLowerCase())) {
            args[0] = help.getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.stderr.println(CommandUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(help.getScriptUsage());
            return SecurityUtilityReturnCodes.OK;
        }
        try {
            return task.handleTask(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            this.stderr.println(help.getTaskUsage(task));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
        catch (Exception e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.toString()));
            this.stderr.println(help.getTaskUsage(task));
            return SecurityUtilityReturnCodes.ERR_GENERIC;
        }
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        DefaultSSLCertificateCreator certCreator = DefaultSSLCertificateFactory.getDefaultSSLCertificateCreator();
        LTPAKeyFileUtilityImpl ltpaKeyFileCreator = new LTPAKeyFileUtilityImpl();
        SecurityUtility util = new SecurityUtility(console, System.out, System.err);
        FileUtility fileUtil = new FileUtility(util.getUserDir(), util.getOutputDir(null));
        util.registerTask(new EncodeTask(SCRIPT_NAME));
        util.registerTask(new CreateSSLCertificateTask(certCreator, fileUtil, SCRIPT_NAME));
        util.registerTask(new CreateLTPAKeysTask((LTPAKeyFileUtility)ltpaKeyFileCreator, fileUtil, SCRIPT_NAME));
        int rc = util.runProgram(args).getReturnCode();
        System.exit(rc);
    }
}

