/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.NBAcceptChannelSelector;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPPort;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NBAccept {
    private static final String CLASS_NAME = NBAccept.class.getName();
    private static final TraceComponent tc = Tr.register(NBAccept.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private NBAcceptChannelSelector sharedAccept = null;
    private Thread sharedThread = null;
    private final Object workSync = new Object(){};
    private boolean dedicatedAcceptThread = false;
    private boolean waitToAccept = false;
    protected Map<TCPPort, NBAcceptChannelSelector> endPointToAccept = null;
    static final int REGISTER_ENDPOINT = 1;
    static final int REMOVE_ENDPOINT = 0;

    public NBAccept(TCPChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"NBAccept", (Object[])new Object[0]);
        }
        this.endPointToAccept = new HashMap<TCPPort, NBAcceptChannelSelector>();
        this.dedicatedAcceptThread = config.getAcceptThread();
        this.waitToAccept = config.getWaitToAccept();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NBAccept");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPort(TCPPort endPoint) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerPort", (Object[])new Object[]{endPoint.getServerSocket()});
        }
        NBAccept nBAccept = this;
        synchronized (nBAccept) {
            EndPointActionInfo work = new EndPointActionInfo(1, endPoint, this.workSync);
            if (!this.dedicatedAcceptThread && !this.waitToAccept) {
                if (this.sharedAccept == null) {
                    this.sharedAccept = new NBAcceptChannelSelector(this.waitToAccept);
                    this.sharedThread = new Thread(this.sharedAccept);
                    this.sharedThread.setName("Shared TCPChannel NonBlocking Accept Thread");
                    this.sharedThread.setDaemon(true);
                    this.sharedThread.start();
                }
                Object object = this.workSync;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Passing register to selector; " + endPoint.getServerSocket()), (Object[])new Object[0]);
                    }
                    this.sharedAccept.addWork(work);
                    if (CHFWBundle.isServerCompletelyStarted()) {
                        try {
                            this.workSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.endPointToAccept.put(endPoint, this.sharedAccept);
            } else {
                NBAcceptChannelSelector dedicatedAccept = new NBAcceptChannelSelector(this.waitToAccept);
                Thread dedicatedThread = new Thread(dedicatedAccept);
                dedicatedThread.setName("Dedicated TCPChannel NonBlocking Accept Thread:" + endPoint.getListenPort());
                dedicatedThread.setDaemon(true);
                dedicatedThread.start();
                Object object = this.workSync;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Passing register to dedicated selector; " + endPoint.getServerSocket()), (Object[])new Object[0]);
                    }
                    dedicatedAccept.addWork(work);
                    if (CHFWBundle.isServerCompletelyStarted()) {
                        try {
                            this.workSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.endPointToAccept.put(endPoint, dedicatedAccept);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerPort");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePort(TCPPort endPoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removePort", (Object[])new Object[]{endPoint.getServerSocket()});
        }
        NBAccept nBAccept = this;
        synchronized (nBAccept) {
            NBAcceptChannelSelector accept = this.endPointToAccept.get(endPoint);
            if (accept != null) {
                if (3100 <= accept.numExceptions) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Ignoring removePort call on fatal selector/system.exit path", (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"removePort");
                    }
                    return;
                }
                EndPointActionInfo work = new EndPointActionInfo(0, endPoint, this.workSync);
                Object object = this.workSync;
                synchronized (object) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Passing remove to selector: " + endPoint.getServerSocket()), (Object[])new Object[0]);
                    }
                    accept.addWork(work);
                    if (CHFWBundle.isServerCompletelyStarted()) {
                        try {
                            this.workSync.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (accept == this.sharedAccept && accept.getUsageCount() <= 0) {
                    this.sharedAccept = null;
                }
            } else {
                IllegalArgumentException iae = new IllegalArgumentException("TCP Port to be removed is not registered.");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Throwing IllegalArgumentException", (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)iae, (String)(CLASS_NAME + ".removePort"), (String)"387", (Object)this);
                throw iae;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removePort:");
        }
    }

    protected static class EndPointActionInfo {
        protected int action;
        protected TCPPort endPoint;
        Object syncObject = null;

        EndPointActionInfo(int _action, TCPPort _endPoint, Object _syncObject) {
            this.action = _action;
            this.endPoint = _endPoint;
            this.syncObject = _syncObject;
        }
    }
}

