/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.AbortableXAResource;
import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.tx.jta.impl.HeuristicOutcome;
import com.ibm.tx.jta.impl.JTAXAResourceImpl;
import com.ibm.tx.jta.impl.OnePhaseResourceImpl;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TransactionState;
import com.ibm.tx.jta.impl.XARecoveryData;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.HeuristicHazardException;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.JTAResourceBase;
import com.ibm.ws.Transaction.JTA.JTAXAResource;
import com.ibm.ws.Transaction.JTA.ResourceSupportsOnePhaseCommit;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RegisteredResources
implements Comparator<JTAResource> {
    static final TraceComponent tc = Tr.register(RegisteredResources.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static final boolean xaFlowCallbackEnabled = XAFlowCallbackControl.isEnabled();
    protected static final int MAX_PDATA_SIZE = 3072;
    protected final ArrayList<JTAResource> _resourceObjects;
    protected OnePhaseResourceImpl _onePhaseResourceEnlisted;
    protected ArrayList<JTAXAResource> _failedResourceList;
    protected Xid _txServiceXid;
    protected int _branchCount;
    protected boolean _LPSProhibited;
    protected boolean _LPSEnabledTx;
    protected boolean _retryCompletion;
    protected TransactionImpl _transaction;
    private HashMap<XAResource, JTAXAResource> _resourceTable;
    protected RecoverableUnit _logUnit;
    protected RecoverableUnitSection _logSection;
    protected RecoverableUnitSection _xalogSection;
    protected RecoverableUnitSection _hoSection;
    protected boolean _resourcesLogged;
    protected int _heuristicOutcome;
    private int _loggedHeuristicOutcome;
    protected Throwable _systemException;
    protected boolean _retryRequired;
    protected boolean _outcome;
    protected int _errorCode;
    public static final int XA_OK = 0;
    public static final int XA_RDONLY = 3;
    public static final int ONE_PHASE_OPT = 10;
    public static final int ONE_PHASE_OPT_ROLLBACK = 11;
    public static final int ONE_PHASE_OPT_FAILED = 12;
    protected boolean _disableTwoPhase;
    protected boolean _diagnosticsRequired;
    protected boolean _gotPriorityResourcesEnlisted;
    protected boolean _isCheckingSameRM;
    protected JTAXAResourceImpl _sameRMMasterResource;
    protected JTAXAResourceImpl _sameRMResource;
    protected boolean _sorted;
    protected boolean _retryImmediately;
    protected int _prepareResult;
    protected int _okVoteCount;
    private static final Comparator<JTAResource> prepareComparator = new Comparator<JTAResource>(){

        @Override
        public int compare(JTAResource o1, JTAResource o2) {
            int p2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"compare", (Object)new Object[]{o1, o2, this});
            }
            int result = 0;
            int p1 = o1.getPriority();
            if (p1 < (p2 = o2.getPriority())) {
                result = -1;
            } else if (p1 > p2) {
                result = 1;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"compare", (Object)result);
            }
            return result;
        }
    };

    public RegisteredResources(TransactionImpl tran, boolean disableTwoPhase) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RegisteredResources", (Object)new Object[]{tran, disableTwoPhase});
        }
        this._resourceObjects = new ArrayList();
        this._transaction = tran;
        this._txServiceXid = tran.getXid();
        this._disableTwoPhase = disableTwoPhase;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RegisteredResources");
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, SystemException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistResource", (Object)xaRes);
        }
        if (this._disableTwoPhase && this._resourceObjects.size() > 0) {
            String msg = "Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start";
            IllegalStateException ise = new IllegalStateException("Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        OnePhaseResourceImpl jtaRes = new OnePhaseResourceImpl((OnePhaseXAResource)xaRes, this._txServiceXid);
        boolean register = true;
        if (this._onePhaseResourceEnlisted != null) {
            if (this._onePhaseResourceEnlisted.equals(jtaRes)) {
                register = false;
                jtaRes = this._onePhaseResourceEnlisted;
            } else {
                Tr.error((TraceComponent)tc, (String)"WTRN0062_ILLEGAL_ENLIST_FOR_MULTIPLE_1PC_RESOURCES");
                String msg = "Illegal attempt to enlist multiple 1PC XAResources";
                IllegalStateException ise = new IllegalStateException("Illegal attempt to enlist multiple 1PC XAResources");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
                }
                throw ise;
            }
        }
        try {
            this.startRes(jtaRes);
            if (register) {
                jtaRes.setResourceStatus(1);
                this._resourceObjects.add(0, jtaRes);
                this.checkLPSEnablement();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("(SPI) RESOURCE registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + jtaRes));
                }
                this._onePhaseResourceEnlisted = jtaRes;
            }
        }
        catch (RollbackException rbe) {
            FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"480", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)((Object)rbe));
            }
            throw rbe;
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"487", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)((Object)se));
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes, XARecoveryData recData, int branchCoupling) throws RollbackException, SystemException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{xaRes, recData, branchCoupling});
        }
        if (this._disableTwoPhase && this._resourceObjects.size() > 0) {
            String msg = "Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start";
            IllegalStateException ise = new IllegalStateException("Unable to enlist a second resource within the transaction. Two phase support is disabled as the recovery log was not available at transaction start");
            throw ise;
        }
        boolean register = false;
        boolean matchedSameRM = false;
        JTAXAResourceImpl jtaRes = (JTAXAResourceImpl)this.getResourceTable().get(xaRes);
        if (jtaRes == null) {
            Xid xid;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"enlisting XAResource");
            }
            boolean supportsIsSameRM = recData.supportsIsSameRM();
            try {
                if (this._resourceObjects.isEmpty()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"First resource - so we have to make a new branch xid");
                    }
                    xid = this.generateNewBranch();
                    if (supportsIsSameRM) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"First resource - does implement ResourceManagerSupportsIsSameRM");
                        }
                        this._isCheckingSameRM = true;
                    } else if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"First resource - does not implement ResourceManagerSupportsIsSameRM");
                    }
                } else {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Second resource or later, so we should check for isSameRM");
                    }
                    if (this._isCheckingSameRM) {
                        if (xaRes.isSameRM(this._sameRMMasterResource.XAResource()) && this._sameRMMasterResource.getBranchCoupling() == branchCoupling) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"isSameRM match successful");
                            }
                            matchedSameRM = true;
                            this._isCheckingSameRM = false;
                            xid = this._sameRMMasterResource.getXID();
                        } else {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"isSameRM match was not successful, so we create a new branch xid");
                            }
                            xid = this.generateNewBranch();
                        }
                    } else {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"We are not matching using isSameRM so we create a new branch xid");
                        }
                        xid = this.generateNewBranch();
                    }
                }
            }
            catch (XAException xae) {
                this._errorCode = xae.errorCode;
                throw (SystemException)new SystemException("XAResource RM instance matching error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xae);
            }
            jtaRes = new JTAXAResourceImpl(xid, xaRes, recData);
            if (matchedSameRM) {
                jtaRes.setState(6);
            }
            if (this._isCheckingSameRM && this._sameRMMasterResource == null) {
                this._sameRMMasterResource = jtaRes;
            }
            jtaRes.setBranchCoupling(branchCoupling);
            register = true;
            this.getResourceTable().put(xaRes, jtaRes);
        }
        try {
            recData.logRecoveryEntry();
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"483", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", ise});
            }
            throw ise;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"489", (Object)this);
            Throwable toThrow = new SystemException(e.getLocalizedMessage()).initCause((Throwable)e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)new Object[]{"(SPI)", toThrow});
            }
            throw (SystemException)toThrow;
        }
        try {
            this.setXAResourceTransactionTimeout(jtaRes, recData, this._transaction.getExpirationTime());
            this.startRes(jtaRes);
            if (register) {
                jtaRes.setResourceStatus(1);
                if (matchedSameRM) {
                    this._sameRMResource = jtaRes;
                } else {
                    this._resourceObjects.add(jtaRes);
                    if (jtaRes.getPriority() != 0) {
                        this._gotPriorityResourcesEnlisted = true;
                    }
                }
                this.checkLPSEnablement();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("(SPI) RESOURCE registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + jtaRes));
                }
            }
        }
        catch (RollbackException rbe) {
            FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"517", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)((Object)rbe));
            }
            throw rbe;
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.tx.jta.impl.RegisteredResources.enlistResource", (String)"523", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)((Object)se));
            }
            throw se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enlistResource", (Object)Boolean.TRUE);
        }
        return true;
    }

    protected void setXAResourceTransactionTimeout(JTAResource jtaRes, XARecoveryData recData, long expirationTime) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setXAResourceTransactionTimeout", (Object)new Object[]{jtaRes, recData, new Date(expirationTime)});
            }
            if (recData.propagateXAResourceTransactionTimeout()) {
                int timeout = (int)Math.ceil((double)(expirationTime - System.currentTimeMillis()) / 1000.0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAResource.setTransactionTimeout(" + timeout + ")"));
                }
                try {
                    boolean result = jtaRes.XAResource().setTransactionTimeout(timeout);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"setXAResourceTransactionTimeout", (Object)result);
                    }
                    break block8;
                }
                catch (XAException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.RegisteredResources.setXAResourceTransactionTimeout", (String)"710", (Object)this);
                    if (!recData.continuePropagatingXAResourceTimeout()) {
                        recData.disablePropagatingXAResourceTimeout();
                    }
                    break block8;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setXAResourceTransactionTimeout");
            }
        }
    }

    protected boolean delistResource(XAResource xaRes, int flag) throws SystemException {
        block18: {
            JTAResourceBase jtaRes;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"delistResource", (Object)new Object[]{xaRes, Util.printFlag(flag)});
            }
            if ((jtaRes = (JTAResourceBase)((Object)this.getResourceTable().get(xaRes))) == null && this._onePhaseResourceEnlisted != null && this._onePhaseResourceEnlisted.XAResource().equals(xaRes)) {
                jtaRes = this._onePhaseResourceEnlisted;
            }
            if (jtaRes == null) {
                Tr.error((TraceComponent)tc, (String)"WTRN0065_XARESOURCE_NOT_KNOWN", (Object)xaRes);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)Boolean.FALSE);
                }
                return false;
            }
            try {
                jtaRes.end(flag);
            }
            catch (XAException xae) {
                this._errorCode = xae.errorCode;
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.delistResource", (String)"711", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
                }
                Throwable toThrow = null;
                if (this._errorCode >= 100 && this._errorCode <= 107) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction branch has been marked rollback-only by the RM");
                    }
                } else if (this._errorCode == -7) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"RM has failed");
                    }
                    jtaRes.setResourceStatus(6);
                    jtaRes.destroy();
                } else {
                    Tr.error((TraceComponent)tc, (String)"WTRN0079_END_FAILED", (Object)new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xae});
                    toThrow = new SystemException("XAResource end association error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xae);
                }
                try {
                    this._transaction.setRollbackOnly();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction marked as rollback only.");
                    }
                }
                catch (IllegalStateException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.delistResource", (String)"742", (Object)this);
                    toThrow = new SystemException(e.getLocalizedMessage()).initCause((Throwable)e);
                }
                if (toThrow == null) break block18;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)toThrow);
                }
                throw (SystemException)toThrow;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delistResource", (Object)Boolean.TRUE);
        }
        return true;
    }

    protected Xid generateNewBranch() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateNewBranch");
        }
        XidImpl result = new XidImpl(this._txServiceXid, ++this._branchCount);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateNewBranch", (Object)result);
        }
        return result;
    }

    protected HashMap<XAResource, JTAXAResource> getResourceTable() {
        if (this._resourceTable == null) {
            this._resourceTable = new HashMap();
        }
        return this._resourceTable;
    }

    protected void checkLPSEnablement() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkLPSEnablement");
        }
        if (this._LPSEnabledTx) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkLPSEnablement - LPSEnabledTx");
            }
            return;
        }
        boolean debug = tc.isDebugEnabled();
        if (!debug && this._LPSProhibited) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkLPSEnablement");
            }
            return;
        }
        boolean isLPSEnabled = this._transaction._configProvider.getRuntimeMetaDataProvider().isHeuristicHazardAccepted();
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)"LPSEnabled", (Object)isLPSEnabled);
        }
        if (!isLPSEnabled) {
            this._LPSProhibited = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkLPSEnablement : LPSEnabled=" + isLPSEnabled + " LPSProhibited=" + this._LPSProhibited));
        }
    }

    protected void reconstructHeuristics(RecoverableUnit log) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconstructHeuristics", (Object)log);
        }
        this._hoSection = log.lookupSection(8);
        if (this._hoSection != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Recovering heuristic outcome");
            }
            try {
                byte[] logData = this._hoSection.lastData();
                if (logData.length != 1) {
                    throw new SystemException("Invalid heuristic outcome record data in log");
                }
                int ho = logData[0] & 0xFF;
                this.setHeuristicOutcome(ho);
                this._loggedHeuristicOutcome = this._heuristicOutcome;
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.reconstructHeuristics", (String)"764", (Object)this);
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"reconstructHeuristics", "com.ibm.tx.jta.impl.RegisteredResources", e});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to access heuristic outcome log record data");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstructHeuristics", (Object)e);
                }
                throw (SystemException)new SystemException(e.toString()).initCause(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstructHeuristics");
        }
    }

    public void reconstruct(RecoveryManager recoveryManager, RecoverableUnit log) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reconstruct", (Object)new Object[]{recoveryManager, log});
        }
        this._retryCompletion = true;
        this.reconstructHeuristics(log);
        this._xalogSection = log.lookupSection(2);
        if (this._xalogSection != null) {
            byte[] tid = this._transaction.getXidImpl().toBytes();
            LogCursor logData = null;
            try {
                logData = this._xalogSection.data();
                while (logData.hasNext()) {
                    byte[] data = (byte[])logData.next();
                    try {
                        JTAXAResourceImpl res = new JTAXAResourceImpl(recoveryManager.getPartnerLogTable(), tid, data);
                        res.setResourceStatus(2);
                        this._resourceObjects.add(res);
                        if (res.getPriority() == 0) continue;
                        this._gotPriorityResourcesEnlisted = true;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RegisteredResources.reconstruct", (String)"843", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object)new Object[]{Util.toHexString(data), exc});
                        throw exc;
                    }
                }
                logData.close();
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RegisteredResources.reconstruct", (String)"853", (Object)this);
                Tr.fatal((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"reconstruct", "com.ibm.tx.jta.impl.RegisteredResources", exc});
                if (logData != null) {
                    logData.close();
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception raised reconstructing XA resource");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reconstruct");
                }
                throw (SystemException)new SystemException(exc.toString()).initCause(exc);
            }
        }
        this._logUnit = log;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconstruct");
        }
    }

    protected void addRes(JTAResource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRes", (Object)new Object[]{this, resource});
        }
        resource.setResourceStatus(1);
        this._resourceObjects.add(resource);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("(SPI) SERVER registered with Transaction. TX: " + this._transaction.getLocalTID() + ", Resource: " + resource));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRes");
        }
    }

    protected void startRes(JTAResource resource) throws RollbackException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startRes", (Object)new Object[]{this, resource});
        }
        try {
            resource.start();
        }
        catch (XAException xae) {
            this._errorCode = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.startRes", (String)"1053", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
            }
            if (this._errorCode == -9) {
                Throwable toThrow = new RollbackException("XAResource working outside transaction").initCause((Throwable)xae);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XAResource is doing work outside of the transaction.", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Transaction branch has been marked rollback-only by the RM");
                }
                try {
                    this._transaction.setRollbackOnly();
                }
                catch (IllegalStateException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.startRes", (String)"1085", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Exception caught marking Transaction rollback only", (Object)e);
                    }
                    throw (SystemException)new SystemException(e.getLocalizedMessage()).initCause((Throwable)e);
                }
                Throwable toThrow = new RollbackException("Transaction has been marked as rollback only.").initCause((Throwable)xae);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Marked transaction as rollback only.", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0078_START_FAILED", (Object)new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xae});
            throw (SystemException)new SystemException("XAResource start association error:" + XAReturnCodeHelper.convertXACode(this._errorCode)).initCause((Throwable)xae);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startRes");
            }
        }
    }

    public int numRegistered() {
        int result = this._resourceObjects.size();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"numRegistered", (Object)result);
        }
        return result;
    }

    public boolean distributeEnd(int flags) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeEnd", (Object)Util.printFlag(flags));
        }
        boolean result = true;
        int i = this._resourceObjects.size();
        while (--i >= 0) {
            JTAResource resource = this._resourceObjects.get(i);
            if (this.sendEnd(resource, flags)) continue;
            result = false;
        }
        if (this._sameRMResource != null && !this.sendEnd(this._sameRMResource, flags)) {
            result = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeEnd", (Object)result);
        }
        return result;
    }

    boolean sendEnd(JTAResource resource, int flags) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendEnd", (Object)new Object[]{resource, flags, this});
        }
        try {
            resource.end(flags);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"sendEnd", (Object)Boolean.TRUE);
            }
            return true;
        }
        catch (XAException xae) {
            this._errorCode = xae.errorCode;
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XA_RB* from end", (Object)xae);
                }
            } else {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.sendEnd", (String)"1157", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XAException (not XA_RB*) from end", (Object)xae);
                }
                resource.setResourceStatus(6);
                resource.destroy();
            }
            this._transaction.setOriginalException(xae);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.RegisteredResources.sendEnd", (String)"1171", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Throwable (not XAException) from end", (Object)t);
            }
            this._transaction.setOriginalException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendEnd", (Object)Boolean.FALSE);
        }
        return false;
    }

    protected int prepareResource(JTAResource currResource) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareResource", (Object)new Object[]{this, currResource});
        }
        int currResult = 3;
        try {
            boolean informResource = true;
            if (xaFlowCallbackEnabled) {
                informResource = XAFlowCallbackControl.beforeXAFlow(1, 20);
            }
            if (informResource) {
                currResult = currResource.prepare();
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 50);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)XAReturnCodeHelper.convertXACode(currResult));
            }
            return currResult;
        }
        catch (XAException xae) {
            this._errorCode = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.prepareResource", (String)"1216", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            if (this._errorCode >= 100 && this._errorCode <= 107 || this._errorCode == -4) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"XA_RB* or XAER_NOTA on prepare. Marking resource as complete. Rollback tx");
                }
                currResource.setResourceStatus(6);
                currResource.destroy();
                Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            if (this._errorCode == 5) {
                currResource.setResourceStatus(10);
                this.updateHeuristicOutcome(10);
                this._diagnosticsRequired = true;
                Throwable toThrow = new HeuristicMixedException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
                }
                throw (HeuristicMixedException)toThrow;
            }
            if (this._errorCode == 8) {
                currResource.setResourceStatus(11);
                this.updateHeuristicOutcome(11);
                this._diagnosticsRequired = true;
                Throwable toThrow = new HeuristicHazardException().initCause(xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
                }
                throw (HeuristicHazardException)toThrow;
            }
            this.logRmfailOnPreparing(xae);
            if (this._errorCode == -3 || this._errorCode == -7) {
                currResource.setResourceStatus(2);
                currResource.setState(3);
            }
            if (this._errorCode == -7) {
                Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            Throwable toThrow = new SystemException().initCause((Throwable)xae);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RegisteredResources.prepareResource", (String)"1297", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RuntimeException", (Object)exc);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            this._diagnosticsRequired = true;
            Tr.error((TraceComponent)tc, (String)"WTRN0046_PREPARE_FAILED", (Object)new Object[]{exc.getLocalizedMessage(), exc});
            currResource.setResourceStatus(2);
            Throwable toThrow = new SystemException(exc.toString()).initCause(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareResource", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int distributePrepare(boolean subordinate, boolean optimise) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (RegisteredResources.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)new Object[]{this, subordinate, optimise});
        }
        this._diagnosticsRequired = false;
        this._prepareResult = 3;
        try {
            if (subordinate && this._onePhaseResourceEnlisted != null) {
                Tr.error((TraceComponent)RegisteredResources.tc, (String)"WTRN0064_SUBORDINATE_COMMIT_OF_1PC_RESOURCE");
                if (RegisteredResources.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RegisteredResources.tc, (String)"Subordinate contains 1PC resource, rolling back transaction");
                }
                if (RegisteredResources.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)"RollbackException");
                }
                throw new RollbackException();
            }
            startTime = System.currentTimeMillis();
            if (this.gotAsyncResources()) {
                this.prePreparePrepareAsyncResources();
                this.prePrepareGetAsyncPrepareResults(startTime);
            }
            if (this._gotPriorityResourcesEnlisted) {
                if (this._onePhaseResourceEnlisted != null) {
                    this._resourceObjects.remove(0);
                }
                this.sortPreparePriorityResources();
                if (this._onePhaseResourceEnlisted != null) {
                    this._resourceObjects.add(0, this._onePhaseResourceEnlisted);
                }
            }
            i = this._resourceObjects.size();
            while (--i >= 0) {
                block34: {
                    currResource = this._resourceObjects.get(i);
                    if (i != 0 || this._okVoteCount != 0 || !optimise || this.gotAsyncResources() || !(currResource instanceof ResourceSupportsOnePhaseCommit) || this._onePhaseResourceEnlisted != null) break block34;
                    try {
                        this.flowCommitOnePhase(false);
                        this._prepareResult = 10;
                    }
                    catch (RollbackException rbe) {
                        try {
                            this._prepareResult = 11;
                        }
                        catch (Throwable var8_9) {
                            if (RegisteredResources.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)(this._prepareResult == 10 ? "ONE_PHASE_OPT" : (this._prepareResult == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
                            }
                            throw var8_9;
                        }
                        if (RegisteredResources.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)(this._prepareResult == 10 ? "ONE_PHASE_OPT" : (this._prepareResult == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
                        } else {
                            ** GOTO lbl44
                        }
                    }
                    if (RegisteredResources.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)(this._prepareResult == 10 ? "ONE_PHASE_OPT" : (this._prepareResult == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
                    }
                    rbe = this._prepareResult;
                    return rbe;
                }
                if (i == 0 && this._onePhaseResourceEnlisted != null && !subordinate) continue;
                currResult = this.prepareResource(currResource);
                if (currResult == 0) {
                    currResource.setResourceStatus(2);
                    if (this._prepareResult == 3) {
                        this._prepareResult = 0;
                    }
                    ++this._okVoteCount;
                } else {
                    currResource.setResourceStatus(4);
                }
                if (!this._transaction.getRollbackOnly()) continue;
                toThrow = new RollbackException();
                if (RegisteredResources.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)toThrow);
                }
                throw toThrow;
            }
            if (this.gotAsyncResources()) {
                this.postPreparePrepareAsyncResources();
                this.postPrepareGetAsyncPrepareResults(startTime);
            }
            if (this._okVoteCount == 1 && optimise && this._onePhaseResourceEnlisted == null) {
                if (RegisteredResources.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RegisteredResources.tc, (String)"Transaction contains one non-READ-ONLY Resource, attempting to Optimize.");
                }
                this._prepareResult = 10;
                this.distributeCommit();
            } else if (this._okVoteCount > 0) {
                this.logResources();
                if (this._onePhaseResourceEnlisted != null) {
                    this._resourceObjects.remove(0);
                }
                this.sortResources();
                if (this._onePhaseResourceEnlisted != null) {
                    this._resourceObjects.add(0, this._onePhaseResourceEnlisted);
                }
            }
        }
        finally {
            if (this._diagnosticsRequired) {
                this.logDiagnostics(1);
            }
        }
        if (RegisteredResources.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)RegisteredResources.tc, (String)"distributePrepare", (Object)XAReturnCodeHelper.convertXACode(this._prepareResult));
        }
        return this._prepareResult;
    }

    protected boolean gotAsyncResources() {
        return false;
    }

    protected void prePrepareGetAsyncPrepareResults(long startTime) throws HeuristicHazardException, RollbackException, SystemException, HeuristicMixedException {
    }

    protected void postPrepareGetAsyncPrepareResults(long startTime) throws HeuristicHazardException, RollbackException, SystemException, HeuristicMixedException {
    }

    protected void prePreparePrepareAsyncResources() throws SystemException, RollbackException {
    }

    protected void postPreparePrepareAsyncResources() throws SystemException, RollbackException {
    }

    protected void logResources() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logResources", (Object)this._resourcesLogged);
        }
        if (!this._resourcesLogged) {
            for (int i = 0; i < this._resourceObjects.size(); ++i) {
                JTAResource resource = this._resourceObjects.get(i);
                if (resource.getResourceStatus() != 2) continue;
                this.recordLog(resource);
            }
            this._resourcesLogged = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logResources");
        }
    }

    protected boolean deliverOutcome(JTAResource currResource) {
        boolean retryRequired;
        block68: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deliverOutcome", (Object)currResource);
            }
            retryRequired = false;
            boolean informResource = true;
            int flowType = -1;
            boolean preparedResource = true;
            boolean auditing = false;
            try {
                switch (currResource.getResourceStatus()) {
                    case 2: {
                        currResource.setResourceStatus(3);
                    }
                    case 3: {
                        auditing = this._transaction.auditSendCompletion(currResource, this._outcome);
                        if (this._outcome) {
                            if (xaFlowCallbackEnabled) {
                                informResource = XAFlowCallbackControl.beforeXAFlow(2, 30);
                                flowType = 2;
                            }
                            if (informResource) {
                                currResource.commit();
                            }
                            currResource.setResourceStatus(7);
                        } else {
                            if (xaFlowCallbackEnabled) {
                                informResource = XAFlowCallbackControl.beforeXAFlow(3, 40);
                                flowType = 3;
                            }
                            if (informResource) {
                                currResource.rollback();
                            }
                            currResource.setResourceStatus(6);
                        }
                        if (!auditing) break;
                        this._transaction.auditCompletionResponse(0, currResource, this._outcome);
                        break;
                    }
                    case 5: {
                        preparedResource = false;
                        if (this._outcome) {
                            if (xaFlowCallbackEnabled) {
                                informResource = XAFlowCallbackControl.beforeXAFlow(2, 31);
                                flowType = 2;
                            }
                            if (informResource) {
                                currResource.commit_one_phase();
                            }
                            currResource.setResourceStatus(7);
                            break;
                        }
                        if (xaFlowCallbackEnabled) {
                            informResource = XAFlowCallbackControl.beforeXAFlow(3, 40);
                            flowType = 3;
                        }
                        if (informResource) {
                            currResource.rollback();
                        }
                        currResource.setResourceStatus(6);
                        break;
                    }
                    case 1: {
                        preparedResource = false;
                        if (this._outcome) break;
                        currResource.setResourceStatus(3);
                        if (xaFlowCallbackEnabled) {
                            informResource = XAFlowCallbackControl.beforeXAFlow(3, 40);
                            flowType = 3;
                        }
                        if (informResource) {
                            currResource.rollback();
                        }
                        currResource.setResourceStatus(6);
                        break;
                    }
                }
                if (flowType != -1 && xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(flowType, 50);
                }
            }
            catch (XAException xae) {
                this._errorCode = xae.errorCode;
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.deliverOutcome", (String)"1923", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
                }
                if (auditing) {
                    this._transaction.auditCompletionResponse(this._errorCode, currResource, this._outcome);
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(flowType, 51);
                }
                if (this._errorCode == 6) {
                    currResource.setResourceStatus(9);
                    if (this._outcome && !auditing) {
                        this._diagnosticsRequired = true;
                        Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                    }
                } else if (this._errorCode == 7) {
                    currResource.setResourceStatus(8);
                    if (!this._outcome && !auditing) {
                        this._diagnosticsRequired = true;
                        Tr.error((TraceComponent)tc, (String)"WTRN0076_HEURISTIC_ON_ROLLBACK", (Object)this._transaction.getTranName());
                    }
                } else if (this._errorCode == 5) {
                    currResource.setResourceStatus(10);
                    if (!auditing) {
                        this._diagnosticsRequired = true;
                        if (this._outcome) {
                            Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                        } else {
                            Tr.error((TraceComponent)tc, (String)"WTRN0076_HEURISTIC_ON_ROLLBACK", (Object)this._transaction.getTranName());
                        }
                    }
                } else if (this._errorCode == 8) {
                    currResource.setResourceStatus(11);
                    if (!auditing) {
                        this._diagnosticsRequired = true;
                        if (this._outcome) {
                            Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                        } else {
                            Tr.error((TraceComponent)tc, (String)"WTRN0076_HEURISTIC_ON_ROLLBACK", (Object)this._transaction.getTranName());
                        }
                    }
                } else if (this._errorCode == -3) {
                    this.updateHeuristicOutcome(9);
                    currResource.setResourceStatus(6);
                    currResource.destroy();
                    if (this._outcome && !auditing) {
                        this._diagnosticsRequired = true;
                        Tr.error((TraceComponent)tc, (String)"WTRN0047_XAER_RMERR_ON_COMMIT", (Object)currResource);
                    }
                } else if (this._errorCode == -7) {
                    if (!this._outcome && !preparedResource) {
                        currResource.setResourceStatus(6);
                        currResource.destroy();
                    } else {
                        if (!auditing) {
                            this.logRmfailOnCompleting(currResource, xae);
                        }
                        currResource.setState(3);
                        this.updateHeuristicOutcome(11);
                        this.addToFailedResources(currResource);
                        retryRequired = true;
                    }
                } else if (this._errorCode == 4) {
                    currResource.setState(3);
                    this.updateHeuristicOutcome(11);
                    this.addToFailedResources(currResource);
                    retryRequired = true;
                } else if (this._errorCode == -4) {
                    if (currResource.getResourceStatus() == 5) {
                        this.updateHeuristicOutcome(11);
                    } else if (this._outcome && !this._retryCompletion) {
                        this.updateHeuristicOutcome(11);
                    }
                    currResource.setResourceStatus(4);
                    currResource.destroy();
                } else if (this._errorCode >= 100 && this._errorCode <= 107) {
                    currResource.setResourceStatus(6);
                    currResource.destroy();
                } else {
                    currResource.setResourceStatus(4);
                    currResource.destroy();
                    if (!auditing) {
                        this._diagnosticsRequired = true;
                        if (this._outcome) {
                            Tr.error((TraceComponent)tc, (String)"WTRN0050_UNEXPECTED_XA_ERROR_ON_COMMIT", (Object)XAReturnCodeHelper.convertXACode(this._errorCode));
                        } else {
                            Tr.error((TraceComponent)tc, (String)"WTRN0051_UNEXPECTED_XA_ERROR_ON_ROLLBACK", (Object)XAReturnCodeHelper.convertXACode(this._errorCode));
                        }
                    }
                    this._systemException = xae;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.RegisteredResources.deliverOutcome", (String)"2111", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"RuntimeException", (Object)t);
                }
                if (xaFlowCallbackEnabled) {
                    XAFlowCallbackControl.afterXAFlow(flowType, 51);
                }
                this.updateHeuristicOutcome(9);
                currResource.setResourceStatus(4);
                currResource.destroy();
                if (this._outcome) {
                    if (!auditing) {
                        this._diagnosticsRequired = true;
                    }
                    Tr.error((TraceComponent)tc, (String)"WTRN0068_COMMIT_FAILED", (Object)t);
                }
                if (!auditing) break block68;
                Tr.error((TraceComponent)tc, (String)"WTRN0071_ROLLBACK_FAILED", (Object)t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deliverOutcome", (Object)retryRequired);
        }
        return retryRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean distributeOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeOutcome", (Object)this);
        }
        boolean retryRequired = false;
        this._diagnosticsRequired = false;
        try {
            long startTime = System.currentTimeMillis();
            if (this.gotAsyncResources()) {
                retryRequired = this.completeAsyncResources();
            }
            boolean priorityResourceHasFailed = false;
            int failedPriority = 0;
            int resourceCount = this._resourceObjects.size();
            for (int i = 0; i < resourceCount; ++i) {
                JTAResource nextResource;
                JTAResource currResource = this._resourceObjects.get(i);
                if (this.deliverOutcome(currResource)) {
                    retryRequired = true;
                    if (this._gotPriorityResourcesEnlisted && this._outcome && currResource instanceof JTAXAResource) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Bailing because we are committing with priority resources");
                        }
                        priorityResourceHasFailed = true;
                        failedPriority = currResource.getPriority();
                    }
                }
                if (!priorityResourceHasFailed || i >= resourceCount - 1 || (nextResource = this._resourceObjects.get(i + 1)).getPriority() == failedPriority || !(nextResource instanceof JTAXAResource)) continue;
                for (int j = i + 1; j < resourceCount; ++j) {
                    this.addToFailedResources(this._resourceObjects.get(j));
                }
                break;
            }
            if (this.gotAsyncResources()) {
                retryRequired = this.getAsyncCompletionResults(startTime, retryRequired);
            }
        }
        finally {
            this.updateHeuristicOutcome(this.calculateHeuristicOutcome());
            this._retryCompletion = true;
            if (this._diagnosticsRequired) {
                this.logDiagnostics(0);
                this._diagnosticsRequired = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeOutcome", (Object)retryRequired);
        }
        return retryRequired;
    }

    protected boolean getAsyncCompletionResults(long startTime, boolean retryRequired) {
        return retryRequired;
    }

    protected boolean completeAsyncResources() {
        return false;
    }

    protected int calculateHeuristicOutcome() {
        int result = 0;
        for (int i = 0; i < this._resourceObjects.size(); ++i) {
            JTAResource currResource = this._resourceObjects.get(i);
            result = HeuristicOutcome.combineStates(result, currResource.getResourceStatus());
        }
        return result;
    }

    private void updateHeuristicState(boolean commit) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateHeuristicState", (Object)commit);
        }
        if (this._transaction.isSubordinate()) {
            TransactionState ts = this._transaction.getTransactionState();
            int state = ts.getState();
            if (commit) {
                if (state != 7) {
                    ts.setState(7);
                }
            } else if (state != 8 && state != 0) {
                ts.setState(8);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHeuristicState");
        }
    }

    public boolean distributeForget() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeForget", (Object)this);
        }
        boolean retryRequired = false;
        int resourceCount = this._resourceObjects.size();
        block3: for (int i = 0; i < resourceCount; ++i) {
            JTAResource currResource = this._resourceObjects.get(i);
            switch (currResource.getResourceStatus()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (!this.forgetResource(currResource)) continue block3;
                    retryRequired = true;
                    this._retryRequired = true;
                    continue block3;
                }
            }
        }
        if (this._systemException != null) {
            Throwable toThrow = new SystemException().initCause(this._systemException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"distributeForget", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeForget", (Object)retryRequired);
        }
        return retryRequired;
    }

    protected boolean forgetResource(JTAResource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forgetResource", (Object)resource);
        }
        boolean result = false;
        boolean auditing = false;
        try {
            boolean informResource = true;
            auditing = this._transaction.auditSendForget(resource);
            if (xaFlowCallbackEnabled) {
                informResource = XAFlowCallbackControl.beforeXAFlow(0, 10);
            }
            if (informResource) {
                resource.forget();
            }
            resource.setResourceStatus(4);
            if (auditing) {
                this._transaction.auditForgetResponse(0, resource);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 50);
            }
        }
        catch (XAException xae) {
            this._errorCode = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.forgetResource", (String)"2859", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
            }
            if (auditing) {
                this._transaction.auditForgetResponse(this._errorCode, resource);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 51);
            }
            if (this._errorCode == -3) {
                result = true;
                this.addToFailedResources(resource);
            } else if (this._errorCode == -7) {
                resource.setState(3);
                result = true;
                this.addToFailedResources(resource);
            } else if (this._errorCode == -4) {
                resource.setResourceStatus(4);
                resource.destroy();
            } else {
                if (!auditing) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0054_XA_FORGET_ERROR", (Object)new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xae});
                }
                resource.setResourceStatus(4);
                this._systemException = xae;
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.RegisteredResources.forgetResource", (String)"2935", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RuntimeException", (Object)t);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(0, 51);
            }
            result = true;
            this.addToFailedResources(resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forgetResource", (Object)result);
        }
        return result;
    }

    public void distributeCommit() throws SystemException, HeuristicHazardException, HeuristicMixedException, HeuristicRollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeCommit");
        }
        TransactionState ts = this._transaction.getTransactionState();
        ts.setCommittingStateUnlogged();
        this._retryRequired = this.sortResources();
        if (!this._retryRequired) {
            this._outcome = true;
            this._retryRequired = this.distributeOutcome();
        } else {
            this.updateHeuristicOutcome(11);
        }
        if (this._systemException != null) {
            Throwable toThrow = new SystemException().initCause(this._systemException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"distributeCommit", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
            switch (this._heuristicOutcome) {
                case 8: {
                    break;
                }
                case 9: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeCommit", (Object)"HeuristicRollbackException");
                    }
                    throw new HeuristicRollbackException();
                }
                case 11: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeCommit", (Object)"HeuristicHazardException");
                    }
                    throw new HeuristicHazardException();
                }
                default: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeCommit", (Object)"HeuristicMixedException");
                    }
                    throw new HeuristicMixedException();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeCommit");
        }
    }

    protected void flowCommitOnePhase(boolean lastParticipant) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)lastParticipant);
        }
        JTAResource resource = this._resourceObjects.get(0);
        boolean informResource = true;
        boolean retryNeeded = false;
        XAException _xaeCaught = null;
        try {
            resource.setResourceStatus(5);
            if (xaFlowCallbackEnabled) {
                informResource = XAFlowCallbackControl.beforeXAFlow(1, 21);
            }
            if (informResource) {
                resource.commit_one_phase();
            }
            resource.setResourceStatus(7);
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 50);
            }
        }
        catch (XAException xae) {
            _xaeCaught = xae;
            this._errorCode = xae.errorCode;
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.RegisteredResources.flowCommitOnePhase", (String)"3031", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(this._errorCode)), (Object)xae);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            if (this._errorCode >= 100 && this._errorCode <= 107) {
                resource.setResourceStatus(6);
                resource.destroy();
                Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            if (this._errorCode == 7) {
                resource.setResourceStatus(8);
                this.updateHeuristicOutcome(8);
            }
            if (this._errorCode == 6) {
                resource.setResourceStatus(9);
                Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                this.updateHeuristicOutcome(9);
            }
            if (this._errorCode == 5) {
                resource.setResourceStatus(10);
                Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                this.updateHeuristicOutcome(10);
            }
            if (this._errorCode == 8) {
                resource.setResourceStatus(11);
                Tr.error((TraceComponent)tc, (String)"WTRN0075_HEURISTIC_ON_COMMIT", (Object)this._transaction.getTranName());
                this.updateHeuristicOutcome(11);
            }
            if (this._errorCode == -3) {
                Tr.error((TraceComponent)tc, (String)"WTRN0047_XAER_RMERR_ON_COMMIT", (Object)resource);
                resource.setResourceStatus(6);
                resource.destroy();
                Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            if (this._errorCode == -7) {
                if (this.resourceNeedsRetrying(resource)) {
                    retryNeeded = true;
                } else {
                    Tr.warning((TraceComponent)tc, (String)"WTRN0052_XAER_RMFAIL_ON_COMMIT_ONE_PHASE", (Object)resource);
                    resource.setResourceStatus(4);
                    resource.destroy();
                }
                this.updateHeuristicOutcome(11);
            }
            if (this._errorCode == -4) {
                resource.setResourceStatus(4);
                resource.destroy();
                Throwable toThrow = new RollbackException().initCause((Throwable)xae);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
                }
                throw (RollbackException)toThrow;
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0053_UNEXPECTED_XA_ERROR_ON_COMMIT_ONE_PHASE", (Object)XAReturnCodeHelper.convertXACode(this._errorCode));
            resource.setResourceStatus(4);
            resource.destroy();
            Throwable toThrow = new SystemException().initCause((Throwable)xae);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.RegisteredResources.flowCommitOnePhase", (String)"3172", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RuntimeException", (Object)t);
            }
            if (xaFlowCallbackEnabled) {
                XAFlowCallbackControl.afterXAFlow(1, 51);
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0070_ONE_PHASE_COMMIT_FAILED", (Object)t);
            resource.setResourceStatus(4);
            resource.destroy();
            Throwable toThrow = new RollbackException().initCause(t);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
            }
            throw (RollbackException)toThrow;
        }
        if (this._systemException != null) {
            Throwable toThrow = new SystemException().initCause(this._systemException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        if (retryNeeded && !lastParticipant) {
            this._outcome = true;
            this._retryRequired = true;
            if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
                switch (this._heuristicOutcome) {
                    case 8: {
                        break;
                    }
                    case 9: {
                        HeuristicRollbackException toThrow = new HeuristicRollbackException();
                        toThrow.initCause(_xaeCaught);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)((Object)toThrow));
                        }
                        throw toThrow;
                    }
                    case 11: {
                        HeuristicHazardException toThrow = new HeuristicHazardException();
                        toThrow.initCause(_xaeCaught);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
                        }
                        throw toThrow;
                    }
                    default: {
                        HeuristicMixedException toThrow = new HeuristicMixedException();
                        toThrow.initCause(_xaeCaught);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)((Object)toThrow));
                        }
                        throw toThrow;
                    }
                }
            }
        } else if (HeuristicOutcome.isHeuristic(this._heuristicOutcome)) {
            switch (this._heuristicOutcome) {
                case 8: {
                    break;
                }
                case 9: {
                    if (!lastParticipant) {
                        HeuristicRollbackException toThrow = new HeuristicRollbackException();
                        toThrow.initCause(_xaeCaught);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)((Object)toThrow));
                        }
                        throw toThrow;
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"LPS resource rolled-back heuristically.  Throwing RollbackException.");
                    }
                    RollbackException toThrow = new RollbackException();
                    toThrow.initCause(_xaeCaught);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)((Object)toThrow));
                    }
                    throw toThrow;
                }
                case 11: {
                    HeuristicHazardException toThrow = new HeuristicHazardException();
                    toThrow.initCause(_xaeCaught);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)toThrow);
                    }
                    throw toThrow;
                }
                default: {
                    HeuristicMixedException toThrow = new HeuristicMixedException();
                    toThrow.initCause(_xaeCaught);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase", (Object)((Object)toThrow));
                    }
                    throw toThrow;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flowCommitOnePhase");
        }
    }

    protected boolean resourceNeedsRetrying(JTAResource resource) {
        return false;
    }

    public void distributeRollback() throws HeuristicMixedException, HeuristicHazardException, HeuristicCommitException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeRollback");
        }
        TransactionState ts = this._transaction.getTransactionState();
        ts.setRollingBackStateUnlogged();
        int savedHeuristic = this._heuristicOutcome;
        this._outcome = false;
        this._retryRequired = this.distributeOutcome();
        if (this._systemException != null) {
            Throwable toThrow = new SystemException().initCause(this._systemException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"distributeRollback", (Object)toThrow);
            }
            throw (SystemException)toThrow;
        }
        if (HeuristicOutcome.isHeuristic(this._heuristicOutcome) && savedHeuristic == 0) {
            switch (this._heuristicOutcome) {
                case 9: {
                    break;
                }
                case 11: {
                    HeuristicHazardException toThrow = new HeuristicHazardException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeRollback", (Object)toThrow);
                    }
                    throw toThrow;
                }
                case 8: {
                    HeuristicCommitException toThrow = new HeuristicCommitException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeRollback", (Object)((Object)toThrow));
                    }
                    throw toThrow;
                }
                default: {
                    HeuristicMixedException toThrow = new HeuristicMixedException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"distributeRollback", (Object)((Object)toThrow));
                    }
                    throw toThrow;
                }
            }
        }
        if (savedHeuristic != 0) {
            this._heuristicOutcome = savedHeuristic;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeRollback");
        }
    }

    protected void recordLog(JTAResource resource) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recordLog", (Object)new Object[]{this, resource});
        }
        if (this._logUnit == null) {
            this._logUnit = this._transaction.getLog();
        }
        if (this._logUnit != null) {
            RecoverableUnitSection rus;
            if (resource instanceof JTAXAResource) {
                if (this._xalogSection == null) {
                    this._xalogSection = this.createLogSection(2, this._logUnit);
                }
                rus = this._xalogSection;
            } else {
                rus = this.recordOtherResourceTypes(resource);
            }
            resource.log(rus);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recordLog");
        }
    }

    protected RecoverableUnitSection recordOtherResourceTypes(JTAResource resource) throws SystemException {
        return null;
    }

    protected RecoverableUnitSection createLogSection(int sectionId, RecoverableUnit ru) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLogSection", (Object)new Object[]{sectionId, ru});
        }
        RecoverableUnitSection logSection = null;
        try {
            logSection = ru.createSection(sectionId, false);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.createLogSection", (String)"2349", (Object)this);
            Throwable toThrow = new SystemException(e.toString()).initCause((Throwable)e);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception raised creating log section", (Object)e);
            }
            throw (SystemException)toThrow;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createLogSection", (Object)logSection);
            }
        }
        return logSection;
    }

    public ArrayList<JTAResource> getResourceObjects() {
        return this._resourceObjects;
    }

    public boolean isOnlyAgent() {
        boolean result;
        boolean bl = result = this._resourceObjects.size() == 1 && this._resourceObjects.get(0) instanceof ResourceSupportsOnePhaseCommit;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isOnlyAgent", (Object)result);
        }
        return result;
    }

    protected void addToFailedResources(JTAResource jtaRes) {
    }

    public void destroyResources() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyResources");
        }
        ArrayList<JTAResource> resources = this.getResourceObjects();
        for (JTAResource resource : resources) {
            this.destroyResource(resource);
        }
        if (this._sameRMResource != null) {
            this.destroyResource(this._sameRMResource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyResources");
        }
    }

    void destroyResource(JTAResource resource) {
        int resourceStatus;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyResource", (Object)new Object[]{resource, this});
        }
        if ((resourceStatus = resource.getResourceStatus()) != 4 && resourceStatus != 6 && resourceStatus != 7) {
            resource.destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyResource");
        }
    }

    protected void logDiagnostics(int diagType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logDiagnostics", (Object)diagType);
        }
        String name = this._transaction.getTranName();
        switch (diagType) {
            case 1: {
                Tr.error((TraceComponent)tc, (String)"WTRN0086_PREPARE_DIAG", (Object)name);
                break;
            }
            case 0: {
                Tr.error((TraceComponent)tc, (String)"WTRN0087_COMPLETION_DIAG", (Object)name);
            }
        }
        ArrayList<JTAResource> resources = this.getResourceObjects();
        for (JTAResource r : resources) {
            this.diagnoseResource(r, diagType);
        }
        if (this._sameRMResource != null) {
            this._sameRMResource.copyDiagnostics(this._sameRMMasterResource);
            this.diagnoseResource(this._sameRMResource, diagType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logDiagnostics");
        }
    }

    private void diagnoseResource(JTAResource resource, int diagType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"diagnoseResource", (Object)new Object[]{resource, diagType, this});
        }
        if (resource instanceof JTAResourceBase) {
            ((JTAResourceBase)resource).diagnose(diagType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"diagnoseResource");
        }
    }

    void logHeuristicOutcome() throws SystemException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"logHeuristicOutcome");
            }
            if (this._transaction.isSubordinate() && this._loggedHeuristicOutcome != this._heuristicOutcome) {
                boolean force = false;
                if (this._hoSection == null) {
                    if (this._logUnit == null) {
                        this._logUnit = this._transaction.getLog();
                    }
                    if (this._logUnit != null) {
                        this._hoSection = this.createLogSection(8, this._logUnit);
                    }
                } else {
                    force = true;
                }
                if (this._hoSection != null) {
                    byte[] byte_data = new byte[]{(byte)this._heuristicOutcome};
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"logHeuristicOutcome", (Object)ResourceWrapper.printResourceStatus(this._heuristicOutcome));
                        }
                        this._hoSection.addData(byte_data);
                        if (force) {
                            this._hoSection.force();
                        }
                        this._loggedHeuristicOutcome = this._heuristicOutcome;
                    }
                    catch (InternalLogException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RegisteredResources.logHeuristicOutcome", (String)"1576", (Object)this);
                        if (!tc.isEventEnabled()) break block12;
                        Tr.event((TraceComponent)tc, (String)"addData failed during logHeuristicOutcome", (Object)((Object)e));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logHeuristicOutcome");
        }
    }

    public int getHeuristicOutcome() {
        return this._heuristicOutcome;
    }

    public void updateHeuristicOutcome(int status) {
        int ho = HeuristicOutcome.combineStates(this._heuristicOutcome, status);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"updateHeuristicOutcome", (Object)("combining " + ResourceWrapper.printResourceStatus(this._heuristicOutcome) + " with " + ResourceWrapper.printResourceStatus(status) + " to get " + ResourceWrapper.printResourceStatus(ho)));
        }
        this._heuristicOutcome = ho;
    }

    public void setHeuristicOutcome(int status) {
        this._heuristicOutcome = status;
    }

    public void logHeuristic(boolean commit) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logHeuristic", (Object)commit);
        }
        this.logHeuristicOutcome();
        this.updateHeuristicState(commit);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logHeuristic");
        }
    }

    public boolean requireRetry() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"requireRetry", (Object)this._retryRequired);
        }
        return this._retryRequired;
    }

    @Override
    public int compare(JTAResource o1, JTAResource o2) {
        int p2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"compare", (Object)new Object[]{o1, o2, this});
        }
        int result = 0;
        int p1 = o1.getPriority();
        if (p1 < (p2 = o2.getPriority())) {
            result = 1;
        } else if (p1 > p2) {
            result = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"compare", (Object)result);
        }
        return result;
    }

    protected boolean sortResources() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sortResources", (Object)this._resourceObjects.toArray());
        }
        if (!this._sorted) {
            int resourceCount = this._resourceObjects.size();
            if (this._gotPriorityResourcesEnlisted && resourceCount > 1) {
                Collections.sort(this._resourceObjects, this);
            }
            this._sorted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sortResources", (Object)this._resourceObjects.toArray());
        }
        return false;
    }

    protected void sortPreparePriorityResources() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sortPreparePriorityResources", (Object)this._resourceObjects.toArray());
        }
        Collections.sort(this._resourceObjects, prepareComparator);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sortPreparePriorityResources", (Object)this._resourceObjects.toArray());
        }
    }

    boolean retryImmediately() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sortPreparePriorityResources", (Object)this._retryImmediately);
        }
        return this._retryImmediately;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int commitLastAgent(boolean isLPS, boolean xaOKVote) throws RollbackException, SystemException, HeuristicMixedException, HeuristicHazardException, HeuristicRollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commitLastAgent", (Object)new Object[]{this, isLPS, xaOKVote});
        }
        int result = 3;
        if (!isLPS) {
            try {
                this.flowCommitOnePhase(false);
                result = 10;
            }
            catch (RollbackException rbe) {
                try {
                    result = 11;
                }
                catch (Throwable throwable) {
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)"commitLastAgent", (Object)(result == 10 ? "ONE_PHASE_OPT" : (result == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
                    throw throwable;
                }
                if (!tc.isEntryEnabled()) return result;
                Tr.exit((TraceComponent)tc, (String)"commitLastAgent", (Object)(result == 10 ? "ONE_PHASE_OPT" : (result == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
                return result;
            }
            if (!tc.isEntryEnabled()) return result;
            Tr.exit((TraceComponent)tc, (String)"commitLastAgent", (Object)(result == 10 ? "ONE_PHASE_OPT" : (result == 11 ? "ONE_PHASE_OPT_ROLLBACK" : "HEURISTIC")));
            return result;
        }
        try {
            if (this._LPSProhibited && xaOKVote) {
                Tr.error((TraceComponent)tc, (String)"WTRN0063_ILLEGAL_COMMIT_OF_1PC_RESOURCE");
                this.logDiagnostics(1);
                if (!tc.isEventEnabled()) throw new RollbackException();
                Tr.event((TraceComponent)tc, (String)"LPS not enabled, rolling back transaction");
                throw new RollbackException();
            }
            this._transaction.logLPSState();
            this.flowCommitOnePhase(true);
            result = 0;
        }
        catch (RollbackException rbe) {
            if (!tc.isEntryEnabled()) throw rbe;
            Tr.exit((TraceComponent)tc, (String)"commitLastAgent", (Object)((Object)rbe));
            throw rbe;
        }
        catch (HeuristicMixedException hme) {
            result = 12;
        }
        catch (HeuristicHazardException hhe) {
            result = 12;
        }
        if (!tc.isEntryEnabled()) return result;
        Tr.exit((TraceComponent)tc, (String)"commitLastAgent", (Object)XAReturnCodeHelper.convertXACode(result));
        return result;
    }

    public boolean isLastAgentEnlisted() {
        boolean lastAgentEnlisted;
        boolean bl = lastAgentEnlisted = this._onePhaseResourceEnlisted != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isLastAgentEnlisted", (Object)lastAgentEnlisted);
        }
        return lastAgentEnlisted;
    }

    public void logRmfailOnCompleting(JTAResource currResource, XAException xae) {
        if (this._outcome) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0048_XAER_RMFAIL_ON_COMMIT", (Object)currResource);
        } else {
            Tr.warning((TraceComponent)tc, (String)"WTRN0049_XAER_RMFAIL_ON_ROLLBACK", (Object)currResource);
        }
    }

    public void logRmfailOnPreparing(XAException xae) {
        this._diagnosticsRequired = true;
        Tr.error((TraceComponent)tc, (String)"WTRN0046_PREPARE_FAILED", (Object)new Object[]{XAReturnCodeHelper.convertXACode(this._errorCode), xae});
    }

    protected void abort() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort", (Object)this._resourcesLogged);
        }
        for (int i = 0; i < this._resourceObjects.size(); ++i) {
            JTAResource resource = this._resourceObjects.get(i);
            if (resource == null) continue;
            XAResource xares = resource.XAResource();
            if (xares instanceof AbortableXAResource) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("The resource is abortable, so drive abort on XAResource " + resource.XAResource() + ", for transaction " + this._transaction.getTranName()));
                }
                AbortableXAResource abortablexares = (AbortableXAResource)xares;
                abortablexares.abort(this._txServiceXid);
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.info((TraceComponent)tc, (String)("The resource is NOT abortable: " + resource.XAResource() + ", for transaction " + this._transaction.getTranName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort");
        }
    }
}

