/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class EndpointReferenceBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(EndpointReferenceBuilder.class);
    private final JaxWsEndpointImpl endpoint;
    static final long serialVersionUID = 505632129918209880L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReferenceBuilder(JaxWsEndpointImpl e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointReferenceBuilder", "<init>", new Object[]{e});
        }
        this.endpoint = e;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.EndpointReferenceBuilder", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public EndpointReference getEndpointReference() {
        W3CEndpointReference w3CEndpointReference;
        ClassLoader cl;
        block10: {
            String bindingId;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.EndpointReferenceBuilder", "getEndpointReference", new Object[0]);
            }
            List portExtensors = this.endpoint.getEndpointInfo().getExtensors(ExtensibilityElement.class);
            if (portExtensors != null) {
                Iterator extensionElements = portExtensors.iterator();
                QName wsaEpr = new QName("http://www.w3.org/2005/08/addressing", "EndpointReference");
                while (extensionElements.hasNext()) {
                    ExtensibilityElement ext = (ExtensibilityElement)extensionElements.next();
                    if (!(ext instanceof UnknownExtensibilityElement) || !wsaEpr.equals(ext.getElementType())) continue;
                    Element eprEle = ((UnknownExtensibilityElement)ext).getElement();
                    List addressElements = DOMUtils.getChildrenWithName((Element)eprEle, (String)"http://www.w3.org/2005/08/addressing", (String)"Address");
                    if (!addressElements.isEmpty()) {
                        ((Element)addressElements.get(0)).setTextContent(this.endpoint.getEndpointInfo().getAddress());
                    }
                    EndpointReference endpointReference = W3CEndpointReference.readFrom((Source)new DOMSource(eprEle));
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        endpointReference = endpointReference;
                        LOG.exiting("org.apache.cxf.jaxws.EndpointReferenceBuilder", "getEndpointReference", endpointReference);
                    }
                    return endpointReference;
                }
            }
            if (!SOAPBindingImpl.isSoapBinding(bindingId = this.endpoint.getJaxwsBinding().getBindingID())) {
                throw new UnsupportedOperationException(new Message("GET_ENDPOINTREFERENCE_UNSUPPORTED_BINDING", LOG, new Object[]{bindingId}).toString());
            }
            W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
            String eiAddress = this.endpoint.getEndpointInfo().getAddress();
            builder.address(eiAddress);
            builder.serviceName(this.endpoint.getService().getName());
            builder.endpointName(this.endpoint.getEndpointInfo().getName());
            if (this.endpoint.getEndpointInfo().getService().getDescription() != null) {
                String wsdlBaseUri = this.endpoint.getEndpointInfo().getService().getDescription().getBaseURI();
                builder.wsdlDocumentLocation(wsdlBaseUri != null && wsdlBaseUri.startsWith("http://") ? wsdlBaseUri : eiAddress + "?wsdl");
            }
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(EndpointReferenceBuilder.class.getClassLoader());
            W3CEndpointReference w3CEndpointReference2 = builder.build();
            w3CEndpointReference = w3CEndpointReference2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block10;
            w3CEndpointReference = w3CEndpointReference;
            LOG.exiting("org.apache.cxf.jaxws.EndpointReferenceBuilder", "getEndpointReference", w3CEndpointReference);
        }
        return w3CEndpointReference;
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.EndpointReferenceBuilder", "getEndpointReference", new Object[]{clazz});
        }
        if (clazz != W3CEndpointReference.class) {
            throw new WebServiceException("Unsupported EPR type: " + clazz);
        }
        EndpointReference endpointReference = (EndpointReference)clazz.cast(this.getEndpointReference());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointReference = endpointReference;
            LOG.exiting("org.apache.cxf.jaxws.EndpointReferenceBuilder", "getEndpointReference", endpointReference);
        }
        return (T)endpointReference;
    }
}

