/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.ValueMember;

class FVDValueDescriptor
extends ValueDescriptor {
    final FullValueDescription fvd;
    final String repid;

    FVDValueDescriptor(FullValueDescription fvd, Class clazz, TypeRepository rep, String repid, ValueDescriptor super_desc) {
        super(clazz, rep);
        this.repid = repid;
        this.fvd = fvd;
        this.init();
        this._super_descriptor = super_desc;
    }

    @Override
    public void init() {
        super.init();
        ValueMember[] members = this.fvd.members;
        FieldDescriptor[] new_fields = new FieldDescriptor[members.length];
        for (int i = 0; i < members.length; ++i) {
            ValueMember valueMember = members[i];
            new_fields[i] = this.findField(valueMember);
        }
        this._fields = new_fields;
    }

    private FieldDescriptor findField(ValueMember valueMember) {
        FieldDescriptor result = null;
        for (Class c = this.type; c != null; c = c.getSuperclass()) {
            TypeDescriptor td = this.repo.getDescriptor(c);
            if (!(td instanceof ValueDescriptor)) continue;
            ValueDescriptor vd = (ValueDescriptor)td;
            FieldDescriptor[] fds = vd._fields;
            if (fds == null) continue;
            for (int i = 0; i < fds.length; ++i) {
                if (!fds[i].getIDLName().equals(valueMember.name)) continue;
                return fds[0];
            }
        }
        return result;
    }

    @Override
    protected String genRepId() {
        return this.repid;
    }

    @Override
    FullValueDescription getFullValueDescription() {
        return this.fvd;
    }

    @Override
    protected final TypeCode genTypeCode() {
        return this.fvd.type;
    }

    @Override
    public boolean isCustomMarshalled() {
        return this.fvd.is_custom;
    }
}

