/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.CorbaObjectWriter;
import org.apache.yoko.rmi.impl.CustomMarshaledObjectReader;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueHandlerImpl;
import org.apache.yoko.rmi.util.StringUtil;
import org.omg.CORBA.AttributeDescription;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueDefPackage.FullValueDescription;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.CodeBaseHelper;
import org.omg.SendingContext.RunTime;
import sun.reflect.ReflectionFactory;

class ValueDescriptor
extends TypeDescriptor {
    static final Logger logger = Logger.getLogger(ValueDescriptor.class.getName());
    private boolean _is_externalizable;
    private boolean _is_serializable;
    private Method _write_replace_method;
    private Method _read_resolve_method;
    private Constructor _constructor;
    private Method _write_object_method;
    private Method _read_object_method;
    private Field _serial_version_uid_field;
    protected ValueDescriptor _super_descriptor;
    protected FieldDescriptor[] _fields;
    private ObjectDeserializer _object_deserializer;
    private boolean _is_immutable_value;
    private boolean _is_rmi_stub;
    private String _custom_repid;
    private static final Set<? extends Class<? extends Serializable>> _immutable_value_classes = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Integer.class, Character.class, Boolean.class, Byte.class, Long.class, Float.class, Double.class, Short.class)));
    private long _hash_code;
    private static final Comparator compareByName = new Comparator(){

        public int compare(java.lang.Object f1, java.lang.Object f2) {
            String n1 = ((FieldDescriptor)f1).java_name;
            String n2 = ((FieldDescriptor)f2).java_name;
            return n1.compareTo(n2);
        }
    };
    private volatile ValueMember[] valueMembers = null;
    private static final OperationDescription[] ZERO_OPERATIONS = new OperationDescription[0];
    private static final AttributeDescription[] ZERO_ATTRIBUTES = new AttributeDescription[0];
    private static final Initializer[] ZERO_INITIALIZERS = new Initializer[0];
    private static final String[] ZERO_STRINGS = new String[0];

    ValueDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
    }

    protected boolean isEnum() {
        return false;
    }

    @Override
    protected final RemoteInterfaceDescriptor genRemoteInterface() {
        if (!Remote.class.isAssignableFrom(this.type)) {
            return super.genRemoteInterface();
        }
        return RemoteDescriptor.genMostSpecificRemoteInterface(this.type, this.repo);
    }

    @Override
    protected String genRepId() {
        return String.format("RMI:%s:%016X:%016X", StringUtil.convertToValidIDLNames(this.type.getName()), this._hash_code, this.getSerialVersionUID());
    }

    private String genCustomRepId() {
        return String.format("RMI:org.omg.custom.%s", this.getRepositoryID().substring(4));
    }

    public final String getCustomRepositoryID() {
        if (this._custom_repid == null) {
            this._custom_repid = this.genCustomRepId();
        }
        return this._custom_repid;
    }

    protected long getSerialVersionUID() {
        ObjectStreamClass serialForm;
        if (this._serial_version_uid_field != null) {
            try {
                return this._serial_version_uid_field.getLong(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return (serialForm = ObjectStreamClass.lookup(this.type)) != null ? serialForm.getSerialVersionUID() : 0L;
    }

    @Override
    public void init() {
        try {
            this.init0();
            super.init();
            if (this._fields == null) {
                throw new RuntimeException("fields==null after init!");
            }
        }
        catch (Error | RuntimeException ex) {
            logger.log(Level.FINE, "runtime error in ValueDescriptor.init " + ex.getMessage(), ex);
        }
    }

    private void init0() {
        TypeDescriptor superDesc;
        Class superClass = this.type.getSuperclass();
        this._is_rmi_stub = RMIStub.class.isAssignableFrom(this.type);
        this._is_externalizable = Externalizable.class.isAssignableFrom(this.type);
        this._is_serializable = Serializable.class.isAssignableFrom(this.type);
        this._is_immutable_value = _immutable_value_classes.contains(this.type);
        if (superClass != null && superClass != java.lang.Object.class && (superDesc = this.repo.getDescriptor(superClass)) instanceof ValueDescriptor) {
            this._super_descriptor = (ValueDescriptor)superDesc;
        }
        AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                for (Class curr = ValueDescriptor.this.type; curr != null; curr = curr.getSuperclass()) {
                    try {
                        ValueDescriptor.this._write_replace_method = curr.getDeclaredMethod("writeReplace", new Class[0]);
                        ValueDescriptor.this._write_replace_method.setAccessible(true);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                try {
                    ValueDescriptor.this._read_resolve_method = ValueDescriptor.this.type.getDeclaredMethod("readResolve", new Class[0]);
                    ValueDescriptor.this._read_resolve_method.setAccessible(true);
                }
                catch (NoSuchMethodException curr) {
                    // empty catch block
                }
                try {
                    ValueDescriptor.this._read_object_method = ValueDescriptor.this.type.getDeclaredMethod("readObject", ObjectInputStream.class);
                    ValueDescriptor.this._read_object_method.setAccessible(true);
                }
                catch (NoSuchMethodException curr) {
                    // empty catch block
                }
                try {
                    ValueDescriptor.this._write_object_method = ValueDescriptor.this.type.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                    ValueDescriptor.this._write_object_method.setAccessible(true);
                }
                catch (NoSuchMethodException curr) {
                    // empty catch block
                }
                if (ValueDescriptor.this._write_object_method == null || !Modifier.isPrivate(ValueDescriptor.this._write_object_method.getModifiers()) || Modifier.isStatic(ValueDescriptor.this._write_object_method.getModifiers()) || ValueDescriptor.this._write_object_method.getDeclaringClass() != ValueDescriptor.this.type) {
                    ValueDescriptor.this._write_object_method = null;
                }
                if (ValueDescriptor.this._read_object_method == null || !Modifier.isPrivate(ValueDescriptor.this._read_object_method.getModifiers()) || Modifier.isStatic(ValueDescriptor.this._read_object_method.getModifiers())) {
                    ValueDescriptor.this._read_object_method = null;
                }
                try {
                    ValueDescriptor.this._serial_version_uid_field = ValueDescriptor.this.type.getDeclaredField("serialVersionUID");
                    if (Modifier.isStatic(ValueDescriptor.this._serial_version_uid_field.getModifiers())) {
                        ValueDescriptor.this._serial_version_uid_field.setAccessible(true);
                    } else {
                        ValueDescriptor.this._serial_version_uid_field = null;
                    }
                }
                catch (NoSuchFieldException curr) {
                    // empty catch block
                }
                ObjectStreamField[] serial_persistent_fields = null;
                try {
                    Field _serial_persistent_fields_field = ValueDescriptor.this.type.getDeclaredField("serialPersistentFields");
                    _serial_persistent_fields_field.setAccessible(true);
                    serial_persistent_fields = (ObjectStreamField[])_serial_persistent_fields_field.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException _serial_persistent_fields_field) {
                    // empty catch block
                }
                if (ValueDescriptor.this._is_externalizable) {
                    try {
                        ValueDescriptor.this._constructor = ValueDescriptor.this.type.getDeclaredConstructor(new Class[0]);
                        ValueDescriptor.this._constructor.setAccessible(true);
                    }
                    catch (NoSuchMethodException ex) {
                        logger.log(Level.WARNING, "Class " + ValueDescriptor.this.type.getName() + " is not properly externalizable.  It has not default constructor.", ex);
                    }
                } else if (ValueDescriptor.this._is_serializable && !ValueDescriptor.this.type.isInterface()) {
                    Class initClass;
                    for (initClass = ValueDescriptor.this.type; initClass != null && Serializable.class.isAssignableFrom(initClass); initClass = initClass.getSuperclass()) {
                    }
                    if (initClass == null) {
                        logger.warning("Class " + ValueDescriptor.this.type.getName() + " is not properly serializable.  It has no non-serializable super-class");
                    } else {
                        try {
                            Constructor init_cons = initClass.getDeclaredConstructor(new Class[0]);
                            if (!(Modifier.isPublic(init_cons.getModifiers()) || Modifier.isProtected(init_cons.getModifiers()) || ValueDescriptor.this.samePackage(ValueDescriptor.this.type, initClass))) {
                                logger.warning("Class " + ValueDescriptor.this.type.getName() + " is not properly serializable.  The default constructor of its first non-serializable super-class (" + initClass.getName() + ") is not accessible.");
                            }
                            ValueDescriptor.this._constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(ValueDescriptor.this.type, init_cons);
                            if (ValueDescriptor.this._constructor == null) {
                                logger.warning("Unable to get constructor for serialization for class " + ValueDescriptor.this.java_name);
                            } else {
                                ValueDescriptor.this._constructor.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException ex) {
                            logger.log(Level.WARNING, "Class " + ValueDescriptor.this.type.getName() + " is not properly serializable.  First non-serializable super-class (" + initClass.getName() + ") has no default constructor.", ex);
                        }
                    }
                }
                if (serial_persistent_fields == null) {
                    Field[] ff = ValueDescriptor.this.type.getDeclaredFields();
                    if (ff == null || ff.length == 0) {
                        ValueDescriptor.this._fields = new FieldDescriptor[0];
                    } else {
                        ArrayList<FieldDescriptor> flist = new ArrayList<FieldDescriptor>();
                        for (Field f : ff) {
                            int mod = f.getModifiers();
                            if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
                            f.setAccessible(true);
                            FieldDescriptor fd = FieldDescriptor.get(f, ValueDescriptor.this.repo);
                            flist.add(fd);
                        }
                        ValueDescriptor.this._fields = new FieldDescriptor[flist.size()];
                        ValueDescriptor.this._fields = flist.toArray(ValueDescriptor.this._fields);
                        Arrays.sort(ValueDescriptor.this._fields);
                    }
                } else {
                    ValueDescriptor.this._fields = new FieldDescriptor[serial_persistent_fields.length];
                    for (int i = 0; i < serial_persistent_fields.length; ++i) {
                        ObjectStreamField f = serial_persistent_fields[i];
                        FieldDescriptor fd = null;
                        try {
                            Field rf = ValueDescriptor.this.type.getField(f.getName());
                            rf.setAccessible(true);
                            if (rf.getType() == f.getType()) {
                                fd = FieldDescriptor.get(rf, ValueDescriptor.this.repo);
                            }
                        }
                        catch (NoSuchFieldException | SecurityException exception) {
                            // empty catch block
                        }
                        if (fd == null) {
                            fd = FieldDescriptor.get(ValueDescriptor.this.type, f, ValueDescriptor.this.repo);
                        }
                        ValueDescriptor.this._fields[i] = fd;
                    }
                    Arrays.sort(ValueDescriptor.this._fields);
                }
                ValueDescriptor.this._hash_code = ValueDescriptor.this.computeHashCode();
                ValueDescriptor.this._object_deserializer = new ObjectDeserializer(ValueDescriptor.this);
                return null;
            }
        });
    }

    private boolean samePackage(Class type, Class initClass) {
        String pkg1 = this.getPackageName(type);
        String pkg2 = this.getPackageName(initClass);
        return pkg1.equals(pkg2);
    }

    private String getPackageName(Class type) {
        String name = type.getName();
        int idx = name.lastIndexOf(46);
        return idx == -1 ? "" : name.substring(0, idx);
    }

    @Override
    public java.lang.Object read(org.omg.CORBA.portable.InputStream in) {
        return ((InputStream)in).read_value();
    }

    @Override
    public void write(org.omg.CORBA.portable.OutputStream out, java.lang.Object value) {
        ((OutputStream)out).write_value((Serializable)value);
    }

    @Override
    public boolean isCustomMarshalled() {
        return this._is_externalizable || this._write_object_method != null;
    }

    public boolean isChunked() {
        if (this.isCustomMarshalled()) {
            return true;
        }
        return this._super_descriptor != null && this._super_descriptor.isChunked();
    }

    public Serializable writeReplace(Serializable val) {
        if (this._write_replace_method != null) {
            try {
                return (Serializable)this._write_replace_method.invoke((java.lang.Object)val, new java.lang.Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._write_replace_method).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw (UnknownException)new UnknownException(ex.getTargetException()).initCause(ex.getTargetException());
            }
        }
        return val;
    }

    public Serializable readResolve(Serializable val) {
        if (this._read_resolve_method != null) {
            try {
                return (Serializable)this._read_resolve_method.invoke((java.lang.Object)val, new java.lang.Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._read_resolve_method).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw (UnknownException)new UnknownException(ex.getTargetException()).initCause(ex.getTargetException());
            }
        }
        return val;
    }

    public void writeValue(final org.omg.CORBA.portable.OutputStream out, final Serializable value) {
        try {
            ObjectWriter writer = (ObjectWriter)AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    try {
                        return new CorbaObjectWriter(out, value);
                    }
                    catch (IOException ex) {
                        throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
                    }
                }
            });
            this.writeValue(writer, value);
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    protected void defaultWriteValue(ObjectWriter writer, Serializable val) throws IOException {
        logger.finer("writing fields for " + this.type);
        FieldDescriptor[] fields = this._fields;
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            logger.finer("writing field " + this._fields[i].java_name);
            fields[i].write(writer, val);
        }
    }

    protected void writeValue(ObjectWriter writer, Serializable val) throws IOException {
        if (this._is_externalizable) {
            writer.invokeWriteExternal((Externalizable)val);
            return;
        }
        if (this._super_descriptor != null) {
            this._super_descriptor.writeValue(writer, val);
        }
        if (this._write_object_method != null) {
            try {
                writer.invokeWriteObject(this, val, this._write_object_method);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw (UnknownException)new UnknownException(ex.getTargetException()).initCause(ex.getTargetException());
            }
        } else {
            this.defaultWriteValue(writer, val);
        }
    }

    private Serializable createBlankInstance() {
        if (this._constructor != null) {
            try {
                return (Serializable)this._constructor.newInstance(new java.lang.Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw (MARSHAL)new MARSHAL("cannot call " + this._constructor).initCause((Throwable)ex);
            }
            catch (IllegalArgumentException | InstantiationException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw (UnknownException)new UnknownException(ex.getTargetException()).initCause(ex.getTargetException());
            }
            catch (NullPointerException ex) {
                logger.log(Level.WARNING, "unable to create instance of " + this.type.getName(), ex);
                logger.warning("constructor => " + this._constructor);
                throw ex;
            }
        }
        return null;
    }

    public Serializable readValue(final org.omg.CORBA.portable.InputStream in, final Map<Integer, Serializable> offsetMap, Integer offset) {
        final Serializable value = this.createBlankInstance();
        offsetMap.put(offset, value);
        try {
            ObjectReader reader = (ObjectReader)AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    try {
                        return new CorbaObjectReader(in, offsetMap, value);
                    }
                    catch (IOException ex) {
                        throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
                    }
                }
            });
            this.readValue(reader, value);
            Serializable resolved = this.readResolve(value);
            if (value != resolved) {
                offsetMap.put(offset, resolved);
            }
            return resolved;
        }
        catch (IOException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    void print(PrintWriter pw, Map<java.lang.Object, Integer> recurse, java.lang.Object val) {
        Integer old;
        if (val == null) {
            pw.print("null");
        }
        if ((old = recurse.get(val)) != null) {
            pw.print("^" + old);
        } else {
            int key = System.identityHashCode(val);
            recurse.put(val, key);
            pw.println(this.type.getName() + "@" + Integer.toHexString(key) + "[");
            this.printFields(pw, recurse, val);
            pw.println("]");
        }
    }

    void printFields(PrintWriter pw, Map recurse, java.lang.Object val) {
        pw.print("(" + this.getClass().getName() + ")");
        if (this._super_descriptor != null) {
            this._super_descriptor.printFields(pw, recurse, val);
        }
        if (this._fields == null) {
            return;
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (i != 0) {
                pw.print("; ");
            }
            this._fields[i].print(pw, recurse, val);
        }
    }

    protected void defaultReadValue(ObjectReader reader, Serializable value) throws IOException {
        if (this._fields == null) {
            return;
        }
        logger.fine("reading fields for " + this.type.getName());
        for (FieldDescriptor _field : this._fields) {
            logger.fine("reading field " + _field.java_name + " of type " + _field.getType().getName() + " using " + _field.getClass().getName());
            try {
                _field.read(reader, value);
            }
            catch (MARSHAL ex) {
                if (ex.getMessage() != null) {
                    throw ex;
                }
                String msg = String.format("%s, while reading %s.%s", new java.lang.Object[]{ex, this.java_name, _field.java_name});
                throw (MARSHAL)new MARSHAL(msg, ex.minor, ex.completed).initCause((Throwable)ex);
            }
        }
    }

    Map readFields(ObjectReader reader) throws IOException {
        if (this._fields == null || this._fields.length == 0) {
            return Collections.EMPTY_MAP;
        }
        logger.finer("reading fields for " + this.type.getName());
        HashMap map = new HashMap();
        for (FieldDescriptor _field : this._fields) {
            logger.finer("reading field " + _field.java_name);
            _field.readFieldIntoMap(reader, map);
        }
        return map;
    }

    void writeFields(ObjectWriter writer, Map fieldMap) throws IOException {
        if (this._fields == null || this._fields.length == 0) {
            return;
        }
        logger.finer("writing fields for " + this.type.getName());
        for (FieldDescriptor _field : this._fields) {
            logger.finer("writing field " + _field.java_name);
            _field.writeFieldFromMap(writer, fieldMap);
        }
    }

    protected void readValue(ObjectReader reader, Serializable value) throws IOException {
        if (this._is_externalizable) {
            try {
                reader.readExternal((Externalizable)value);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("cannot instantiate class", e);
            }
            return;
        }
        if (this._super_descriptor != null) {
            this._super_descriptor.readValue(reader, value);
        }
        if (this._write_object_method != null) {
            byte cmsfVersion = reader.readByte();
            boolean dwoCalled = reader.readBoolean();
            logger.log(Level.FINE, "Reading value in streamFormatVersion=" + cmsfVersion + " defaultWriteObject=" + dwoCalled);
            if (cmsfVersion == 2) {
                ObjectReader wrapper = CustomMarshaledObjectReader.wrap(reader);
                this.readSerializable(this._read_object_method == null ? reader : wrapper, value);
                wrapper.close();
                return;
            }
        }
        this.readSerializable(reader, value);
    }

    private void readSerializable(ObjectReader reader, Serializable value) throws IOException {
        if (this._read_object_method != null) {
            try {
                reader.setCurrentValueDescriptor(this);
                this._read_object_method.invoke((java.lang.Object)value, reader);
                reader.setCurrentValueDescriptor(null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw (UnknownException)new UnknownException(ex.getTargetException()).initCause(ex.getTargetException());
            }
        } else {
            this.defaultReadValue(reader, value);
        }
    }

    protected long computeHashCode() {
        Class type = this.type;
        if (this._is_externalizable) {
            return 1L;
        }
        if (!Serializable.class.isAssignableFrom(type)) {
            return 0L;
        }
        long hash = 0L;
        try {
            ByteArrayOutputStream barr = new ByteArrayOutputStream(512);
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream digestout = new DigestOutputStream(barr, md);
            DataOutputStream out = new DataOutputStream(digestout);
            Class superType = type.getSuperclass();
            if (superType != null) {
                TypeDescriptor desc = this.repo.getDescriptor(superType);
                out.writeLong(desc.getHashCode());
            }
            if (this._write_object_method == null) {
                out.writeInt(1);
            } else {
                out.writeInt(2);
            }
            FieldDescriptor[] fds = new FieldDescriptor[this._fields.length];
            System.arraycopy(this._fields, 0, fds, 0, this._fields.length);
            if (fds.length > 1) {
                Arrays.sort(fds, compareByName);
            }
            for (FieldDescriptor f : fds) {
                out.writeUTF(f.java_name);
                out.writeUTF(this.makeSignature(f.getType()));
            }
            out.flush();
            byte[] data = md.digest();
            int end = Math.min(8, data.length);
            for (int j = 0; j < end; ++j) {
                hash += (long)(data[j] & 0xFF) << j * 8;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot compute RMI hash code", ex);
        }
        return hash;
    }

    @Override
    long getHashCode() {
        return this._hash_code;
    }

    protected ValueMember[] genValueMembers() {
        ValueMember[] members = new ValueMember[this._fields.length];
        for (int i = 0; i < this._fields.length; ++i) {
            members[i] = this._fields[i].getValueMember(this.repo);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ValueMember[] getValueMembers() {
        this.getTypeCode();
        if (null == this.valueMembers) {
            TypeRepository typeRepository = this.repo;
            synchronized (typeRepository) {
                if (null == this.valueMembers) {
                    this.valueMembers = this.genValueMembers();
                }
            }
        }
        return this.valueMembers;
    }

    @Override
    protected TypeCode genTypeCode() {
        TypeCode tc;
        TypeCode _base;
        ORB orb = ORB.init();
        this.setTypeCode(orb.create_recursive_tc(this.getRepositoryID()));
        TypeCode typeCode = _base = this._super_descriptor == null ? null : this._super_descriptor.getTypeCode();
        if (this.type.isArray()) {
            TypeDescriptor desc = this.repo.getDescriptor(this.type.getComponentType());
            tc = desc.getTypeCode();
            tc = orb.create_sequence_tc(0, tc);
            tc = orb.create_value_box_tc(this.getRepositoryID(), "Sequence", tc);
        } else {
            tc = orb.create_value_tc(this.getRepositoryID(), this.type.getSimpleName(), (short)0, _base, this.getValueMembers());
        }
        return tc;
    }

    FullValueDescription getFullValueDescription() {
        FullValueDescription fvd = new FullValueDescription();
        fvd.name = this.type.getName();
        fvd.id = this.getRepositoryID();
        fvd.is_abstract = false;
        fvd.is_custom = this.isCustomMarshalled();
        fvd.defined_in = "";
        fvd.version = "1.0";
        fvd.operations = ZERO_OPERATIONS;
        fvd.attributes = ZERO_ATTRIBUTES;
        fvd.members = this.getValueMembers();
        fvd.initializers = ZERO_INITIALIZERS;
        fvd.supported_interfaces = ZERO_STRINGS;
        fvd.abstract_base_values = ZERO_STRINGS;
        fvd.is_truncatable = false;
        fvd.base_value = this._super_descriptor == null ? "" : this._super_descriptor.getRepositoryID();
        fvd.type = this.getTypeCode();
        return fvd;
    }

    private ObjectDeserializer getObjectDeserializer(String repositoryID, RunTime runtime) throws IOException {
        if (repositoryID.equals(this.getRepositoryID())) {
            return this._object_deserializer;
        }
        CodeBase codebase = CodeBaseHelper.narrow((Object)runtime);
        if (codebase == null) {
            throw new IOException("cannot narrow RunTime -> CodeBase");
        }
        FullValueDescription desc = codebase.meta(repositoryID);
        return new ObjectDeserializer(desc, (RunTime)codebase);
    }

    private static Class getClassFromTypeCode(TypeCode tc) {
        return null;
    }

    @Override
    public boolean copyWithinState() {
        return !(this._is_immutable_value | this._is_rmi_stub);
    }

    @Override
    java.lang.Object copyObject(java.lang.Object orig, CopyState state) {
        ValueDescriptor wdesc;
        if (this._is_immutable_value || this._is_rmi_stub) {
            return orig;
        }
        Serializable oorig = (Serializable)orig;
        logger.finer("copying " + orig);
        oorig = this.writeReplace(oorig);
        if (oorig == orig) {
            wdesc = this;
        } else {
            wdesc = (ValueDescriptor)this.repo.getDescriptor(oorig.getClass());
            logger.finer("writeReplace -> " + this.type.getName());
        }
        return wdesc.copyObject2(oorig, state);
    }

    private Serializable copyObject2(Serializable oorig, CopyState state) {
        Serializable copy = this.createBlankInstance();
        state.put(oorig, copy);
        ObjectWriter writer = this.writeObject(oorig, state);
        return this.readObject(writer, copy);
    }

    private ObjectWriter writeObject(Serializable oorig, CopyState state) {
        try {
            ObjectWriter writer = state.createObjectWriter(oorig);
            this.writeValue(writer, oorig);
            return writer;
        }
        catch (IOException ex) {
            String msg = String.format("%s writing %s", ex, this.type.getName());
            throw (MARSHAL)new MARSHAL(msg).initCause((Throwable)ex);
        }
    }

    private Serializable readObject(ObjectWriter writer, Serializable copy) {
        try {
            ObjectReader reader = writer.getObjectReader(copy);
            this.readValue(reader, copy);
            return this.readResolve(copy);
        }
        catch (IOException ex) {
            String msg = String.format("%s reading instance of %s", ex, this.type.getName());
            throw (MARSHAL)new MARSHAL(msg).initCause((Throwable)ex);
        }
    }

    @Override
    void writeMarshalValue(PrintWriter pw, String outName, String paramName) {
        pw.print(outName);
        pw.print('.');
        pw.print("write_value");
        pw.print("((java.io.Serializable)");
        pw.print(paramName);
        pw.print(',');
        MethodDescriptor.writeJavaType(pw, this.type);
        pw.print(".class)");
    }

    @Override
    void writeUnmarshalValue(PrintWriter pw, String inName) {
        pw.print(inName);
        pw.print('.');
        pw.print("read_value");
        pw.print('(');
        MethodDescriptor.writeJavaType(pw, this.type);
        pw.print(".class)");
    }

    @Override
    void addDependencies(Set<Class<?>> classes) {
        TypeDescriptor desc;
        Class c = this.type;
        if (c == java.lang.Object.class || classes.contains(c)) {
            return;
        }
        classes.add(c);
        if (c.getSuperclass() != null) {
            TypeDescriptor desc2 = this.repo.getDescriptor(c.getSuperclass());
            desc2.addDependencies(classes);
        }
        Class<?>[] ifaces = c.getInterfaces();
        for (Class<?> iface : ifaces) {
            desc = this.repo.getDescriptor(iface);
            desc.addDependencies(classes);
        }
        if (this._fields != null) {
            for (FieldDescriptor _field : this._fields) {
                if (_field.isPrimitive()) continue;
                desc = this.repo.getDescriptor(_field.type);
                desc.addDependencies(classes);
            }
        }
    }

    class ObjectDeserializer {
        ObjectDeserializer super_descriptor;
        String repository_id;
        final FieldDescriptor[] fields;

        ObjectDeserializer(ValueDescriptor desc) {
            this.fields = desc._fields;
            this.repository_id = desc.getRepositoryID();
            if (desc._super_descriptor != null) {
                this.super_descriptor = desc._super_descriptor._object_deserializer;
            }
        }

        ObjectDeserializer(FullValueDescription desc, RunTime runtime) throws IOException {
            Class clz;
            TypeDescriptor tdesc;
            Class myClass = ValueDescriptor.this.type;
            ValueMember[] members = desc.members;
            this.fields = new FieldDescriptor[members.length];
            for (int i = 0; i < members.length; ++i) {
                Class type = ValueDescriptor.getClassFromTypeCode(members[i].type);
                this.fields[i] = FieldDescriptor.get(myClass, type, members[i].name, null, ValueDescriptor.this.repo);
            }
            if (!"".equals(desc.base_value) && (tdesc = ValueDescriptor.this.repo.getDescriptor(clz = ValueHandlerImpl.getClassFromRepositoryID(desc.base_value))) instanceof ValueDescriptor) {
                this.super_descriptor = ((ValueDescriptor)tdesc).getObjectDeserializer(desc.base_value, runtime);
            }
        }
    }
}

