/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.finder;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.container.finder.FinderResultClientCollection;
import com.ibm.ejs.container.finder.FinderResultServer;
import com.ibm.ws.ejb.portable.Constants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FinderResultClientBase
implements Serializable {
    static final byte[] eyecatcher = Constants.FINDER_RESULT_CLIENT_BASE_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private static final long serialVersionUID = 4403100038030697155L;
    private transient FinderResultServer server;
    protected transient Vector wrappers;
    private transient boolean exhausted;
    private transient Object parentCollection;
    private transient int chunkSize;
    private transient int itrIndex;
    private transient boolean collectionExceptionPending;

    public FinderResultClientBase(FinderResultServer server, Vector colWrappers, Object parentCollection, int chunkSize) {
        this.server = server;
        this.chunkSize = chunkSize;
        this.itrIndex = 0;
        this.exhausted = colWrappers.size() == 0;
        this.wrappers = colWrappers;
        this.parentCollection = parentCollection;
        if (this.server != null) {
            try {
                Class<?> serverImplClass = Class.forName("com.ibm.ejs.container.finder.FinderResultServerImpl");
                Method m = serverImplClass.getMethod("exhaustedCollection", null);
                boolean hasExhaustedCollection = (Boolean)m.invoke((Object)server, null);
                if (hasExhaustedCollection) {
                    this.server = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean hasMoreElements() {
        return !this.exhausted;
    }

    public Object nextElement() {
        if (this.hasMoreElements()) {
            if (this.collectionExceptionPending) {
                throw new CollectionCannotBeFurtherAccessedException();
            }
            Object result = this.wrappers.elementAt(this.itrIndex++);
            if (this.server == null || this.parentCollection != null && ((FinderResultClientCollection)this.parentCollection).hasAllWrappers()) {
                if (this.itrIndex >= this.wrappers.size()) {
                    this.exhausted = true;
                }
            } else if (this.itrIndex >= this.wrappers.size()) {
                try {
                    Vector nextWrappers = this.server.getNextWrapperCollection(this.wrappers.size(), this.chunkSize);
                    if (nextWrappers == null || nextWrappers.size() == 0) {
                        this.exhausted = true;
                        if (this.parentCollection != null) {
                            ((FinderResultClientCollection)this.parentCollection).allWrappersCached();
                        }
                    } else {
                        this.wrappers.addAll(nextWrappers);
                    }
                }
                catch (RemoteException rex) {
                    this.collectionExceptionPending = true;
                }
            }
            return result;
        }
        throw new NoSuchElementException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(eyecatcher);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.server);
        out.writeObject(this.wrappers);
        out.writeBoolean(this.exhausted);
        out.writeInt(this.chunkSize);
        out.writeInt(this.itrIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] ec = new byte[4];
        int bytesRead = 0;
        for (int offset = 0; offset < 4; offset += bytesRead) {
            bytesRead = in.read(ec, offset, 4 - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < eyecatcher.length; ++i) {
            if (eyecatcher[i] == ec[i]) continue;
            String eyeCatcherString = new String(ec);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in FinderResultClientBase input stream");
        }
        in.readShort();
        in.readShort();
        this.server = (FinderResultServer)in.readObject();
        this.wrappers = (Vector)in.readObject();
        this.exhausted = in.readBoolean();
        this.chunkSize = in.readInt();
        this.itrIndex = in.readInt();
    }
}

