/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs21.providers.json;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.json.bind.Jsonb;
import javax.json.bind.spi.JsonbProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Produces(value={"*/*"})
@Consumes(value={"*/*"})
@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JsonBProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object>,
UnaryOperator<Jsonb> {
    private static final TraceComponent tc = Tr.register(JsonBProvider.class, null, null);
    private static final Charset DEFAULT_CHARSET = JsonBProvider.getDefaultCharset();
    private final JsonbProvider jsonbProvider;
    private final AtomicReference<Jsonb> jsonb = new AtomicReference();
    private final Iterable<ProviderInfo<ContextResolver<?>>> contextResolvers;
    static final long serialVersionUID = 183721088268034063L;

    @FFDCIgnore(value={Exception.class})
    private static Charset getDefaultCharset() {
        Charset cs;
        block4: {
            cs = null;
            String csStr = null;
            try {
                csStr = AccessController.doPrivileged(() -> System.getProperty("com.ibm.ws.jaxrs.jsonbprovider.defaultCharset"));
                if (csStr != null) {
                    cs = Charset.forName(csStr);
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Could not load specified default charset: " + csStr), (Object[])new Object[0]);
            }
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        return cs;
    }

    /*
     * WARNING - void declaration
     */
    public JsonBProvider(JsonbProvider jsonbProvider, Iterable<ProviderInfo<ContextResolver<?>>> contextResolvers) {
        this.contextResolvers = contextResolvers;
        if (jsonbProvider != null) {
            this.jsonbProvider = jsonbProvider;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("<init> called with null provider - looking up via META-INF/services/" + JsonbProvider.class.getName()), (Object[])new Object[0]);
            }
            try {
                JsonbProvider provider;
                this.jsonbProvider = provider = AccessController.doPrivileged(new PrivilegedExceptionAction<JsonbProvider>(){
                    static final long serialVersionUID = 3005845380798178578L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public JsonbProvider run() throws Exception {
                        Iterator<JsonbProvider> providers = ServiceLoader.load(JsonbProvider.class).iterator();
                        if (providers.hasNext()) {
                            return providers.next();
                        }
                        providers = ServiceLoader.load(JsonbProvider.class, JsonBProvider.class.getClassLoader()).iterator();
                        if (providers.hasNext()) {
                            return providers.next();
                        }
                        if (Boolean.getBoolean("com.ibm.ws.jaxrs.testing")) {
                            return null;
                        }
                        throw new IllegalArgumentException("jsonbProvider can't be null");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs21.providers.json.JsonBProvider$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException provider) {
                void ex;
                FFDCFilter.processException((Throwable)provider, (String)"com.ibm.ws.jaxrs21.providers.json.JsonBProvider", (String)"121", (Object)this, (Object[])new Object[]{jsonbProvider, contextResolvers});
                Throwable t = ex.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalArgumentException(t);
            }
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean readable = false;
        if (!this.isUntouchable(type) && this.isJsonType(mediaType)) {
            readable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readable=" + readable), (Object[])new Object[0]);
        }
        return readable;
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object obj = null;
        obj = genericType instanceof ParameterizedType && CompletionStage.class.equals((Object)((ParameterizedType)genericType).getRawType()) ? this.getJsonb().fromJson(entityStream, clazz) : this.getJsonb().fromJson(entityStream, genericType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("object=" + obj), (Object[])new Object[0]);
        }
        return obj;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean writeable = false;
        if (!this.isUntouchable(type) && this.isJsonType(mediaType)) {
            writeable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeable=" + writeable), (Object[])new Object[0]);
        }
        return writeable;
    }

    private boolean isUntouchable(Class<?> clazz) {
        String[] jsonpClasses = new String[]{"javax.json.JsonArray", "javax.json.JsonObject", "javax.json.JsonStructure"};
        boolean untouchable = false;
        for (String c : jsonpClasses) {
            if (!clazz.toString().equals(c)) continue;
            untouchable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("untouchable=" + untouchable), (Object[])new Object[0]);
        }
        return untouchable;
    }

    private boolean isJsonType(MediaType mediaType) {
        return mediaType.getSubtype().toLowerCase().startsWith("json") || mediaType.getSubtype().toLowerCase().contains("+json");
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String json = this.getJsonb().toJson(obj);
        entityStream.write(json.getBytes(JsonBProvider.charset(httpHeaders)));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("object=" + obj), (Object[])new Object[0]);
        }
    }

    private Jsonb getJsonb() {
        for (ProviderInfo<ContextResolver<?>> crPi : this.contextResolvers) {
            ContextResolver<?> cr = crPi.getProvider();
            Object o = cr.getContext(null);
            if (!(o instanceof Jsonb)) continue;
            return (Jsonb)o;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Context-injected Providers is null", (Object[])new Object[0]);
        }
        if (this.jsonbProvider == null) {
            return null;
        }
        Jsonb json = this.jsonb.get();
        if (json == null) {
            return this.jsonb.updateAndGet(this);
        }
        return json;
    }

    @Override
    public Jsonb apply(Jsonb t) {
        if (t != null) {
            return t;
        }
        return this.jsonbProvider.create().build();
    }

    private static Charset charset(MultivaluedMap<String, Object> httpHeaders) {
        if (httpHeaders == null) {
            return DEFAULT_CHARSET;
        }
        List charsets = (List)httpHeaders.get((Object)"Accept-Charset");
        return JAXRSUtils.sortCharsets(charsets).stream().findFirst().orElseGet(() -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No matching charsets, using " + DEFAULT_CHARSET.name() + ", client requested " + charsets), (Object[])new Object[0]);
            }
            return DEFAULT_CHARSET;
        });
    }
}

