/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.jaas.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.krb5.Krb5Common;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Krb5LoginModuleWrapper
implements LoginModule {
    private static final TraceComponent tc = Tr.register(Krb5LoginModuleWrapper.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    public CallbackHandler callbackHandler;
    public Subject subject;
    public Map<String, Object> sharedState;
    public Map<String, Object> options;
    public Subject temporarySubject;
    Class<?> krb5LoginModuleClass = null;
    Class[] noparams = new Class[0];
    Method method;
    Object krb5loginModule = null;
    boolean login_called = false;
    static final long serialVersionUID = -6204238221397067509L;

    /*
     * WARNING - void declaration
     */
    public Krb5LoginModuleWrapper() {
        String targetClass = null;
        if (Krb5Common.isIBMJdk18OrLower) {
            targetClass = "com.ibm.security.auth.module.Krb5LoginModule";
        } else if (Krb5Common.isOtherSupportJDKs) {
            targetClass = "com.sun.security.auth.module.Krb5LoginModule";
        } else {
            Tr.error((TraceComponent)tc, (String)"Not support JDK vendor and/or version", (Object[])new Object[0]);
        }
        if (targetClass != null) {
            this.krb5LoginModuleClass = this.getClassForName(targetClass);
            try {
                this.krb5loginModule = this.krb5LoginModuleClass.newInstance();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"64", (Object)this, (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Object useKeytabValue = null;
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.options = new HashMap<String, Object>();
        this.options.putAll(options);
        if (Krb5Common.isOtherSupportJDKs) {
            useKeytabValue = options.get("useKeyTab");
        }
        if (useKeytabValue != null && useKeytabValue.equals("true")) {
            this.options.put("keyTab", this.getSystemProperty("KRB5_KTNAME"));
        }
        Class[] params = new Class[]{Subject.class, CallbackHandler.class, Map.class, Map.class};
        if (this.krb5LoginModuleClass == null) {
            Tr.error((TraceComponent)tc, (String)"Not a supported JDK vendor and/or version in Krb5LoginModuleWrapper", (Object[])new Object[0]);
        }
        try {
            this.method = this.krb5LoginModuleClass.getDeclaredMethod("initialize", params);
            this.method.invoke(this.krb5loginModule, subject, null, sharedState, this.options);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"103", (Object)this, (Object[])new Object[]{subject, callbackHandler, sharedState, options});
            e.printStackTrace();
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Krb5Common.debugKrb5LoginModule((Subject)this.subject, (CallbackHandler)this.callbackHandler, this.sharedState, this.options);
        }
        if (this.krb5LoginModuleClass != null) {
            this.inVokeMethod("login", this.noparams);
            this.login_called = true;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.login_called) {
            this.inVokeMethod("commit", this.noparams);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.login_called) {
            this.inVokeMethod("abort", this.noparams);
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.login_called) {
            this.inVokeMethod("logout", this.noparams);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={InvocationTargetException.class})
    private void inVokeMethod(String methodName, Class[] params) throws LoginException {
        if (this.krb5LoginModuleClass != null) {
            try {
                this.method = this.krb5LoginModuleClass.getDeclaredMethod(methodName, params);
                this.method.invoke(this.krb5loginModule, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                void e;
                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"151", (Object)this, (Object[])new Object[]{methodName, params});
                throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"153", (Object)this, (Object[])new Object[]{methodName, params});
                throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"155", (Object)this, (Object[])new Object[]{methodName, params});
                throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"157", (Object)this, (Object[])new Object[]{methodName, params});
                throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"161", (Object)this, (Object[])new Object[]{methodName, params});
                throw new AuthenticationException(e.getLocalizedMessage(), e);
            }
        }
    }

    private String getSystemProperty(final String propName) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 7613258310577502908L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper$1", 1.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
            }
        });
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getClassForName(String tg) {
        Class<?> cl = null;
        try {
            cl = Class.forName(tg);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.authentication.jaas.modules.Krb5LoginModuleWrapper", (String)"183", (Object)this, (Object[])new Object[]{tg});
            Tr.error((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return cl;
    }
}

