/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.policy.PolicyCalculator;
import org.apache.cxf.policy.PolicyDataEngine;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Assertor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.CXFAuthenticator;
import org.apache.cxf.transport.http.ChunkedUtil;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.Cookies;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.ProxyFactory;
import org.apache.cxf.transport.http.TrustDecisionUtil;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.cxf.transport.http.auth.DigestAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthHeader;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transport.http.auth.SpnegoAuthSupplier;
import org.apache.cxf.transport.http.policy.impl.ClientPolicyCalculator;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class HTTPConduit
extends AbstractConduit
implements Configurable,
Assertor,
PropertyChangeListener {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    private static final String KEY_VISITED_URLS = "VisitedURLs";
    private static final String KEY_AUTH_URLS = "AuthURLs";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private static boolean hasLoggedAsyncWarning;
    private static final String SC_HTTP_CONDUIT_SUFFIX = ".http-conduit";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_PUT_METHOD = "PUT";
    protected HttpsURLConnectionFactory connectionFactory;
    private final Bus bus;
    private final EndpointInfo endpointInfo;
    private URL defaultEndpointURL;
    private String defaultEndpointURLString;
    private boolean fromEndpointReferenceType;
    private ProxyFactory proxyFactory;
    private HTTPClientPolicy clientSidePolicy;
    private AuthorizationPolicy authorizationPolicy;
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    private TLSClientParameters tlsClientParameters;
    private MessageTrustDecider trustDecider;
    private HttpAuthSupplier authSupplier;
    private HttpAuthSupplier proxyAuthSupplier;
    private Cookies cookies;
    private CertConstraints certConstraints;
    static final long serialVersionUID = -4356010188318610003L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "<init>", new Object[]{b, ei});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(HTTPConduit.getTargetReference((EndpointInfo)ei, (EndpointReferenceType)t, (Bus)b));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "<init>", new Object[]{b, ei, t});
        }
        this.bus = b;
        this.endpointInfo = ei;
        if (t != null) {
            this.fromEndpointReferenceType = true;
        }
        this.proxyFactory = new ProxyFactory();
        this.connectionFactory = new HttpsURLConnectionFactory();
        this.cookies = new Cookies();
        this.updateClientPolicy();
        CXFAuthenticator.addAuthenticator();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void updateClientPolicy() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "updateClientPolicy", new Object[0]);
        }
        PolicyDataEngine policyEngine = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        if (policyEngine != null && this.endpointInfo.getService() != null) {
            this.clientSidePolicy = (HTTPClientPolicy)((Object)policyEngine.getClientEndpointPolicy(this.endpointInfo, (Conduit)this, (PolicyCalculator)new ClientPolicyCalculator()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "updateClientPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Logger getLogger() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getLogger", new Object[0]);
        }
        Logger logger = LOG;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            logger = logger;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getLogger", logger);
        }
        return logger;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final String getConduitName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getConduitName", new Object[0]);
        }
        String string = this.endpointInfo.getName() + SC_HTTP_CONDUIT_SUFFIX;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getConduitName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void configureConduitFromEndpointInfo(HTTPConduit conduit, EndpointInfo endpointInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "configureConduitFromEndpointInfo", new Object[]{conduit, endpointInfo});
        }
        if (conduit.getClient() == null) {
            conduit.setClient((HTTPClientPolicy)((Object)endpointInfo.getTraversedExtensor((Object)new HTTPClientPolicy(), HTTPClientPolicy.class)));
        }
        if (conduit.getAuthorization() == null) {
            conduit.setAuthorization((AuthorizationPolicy)endpointInfo.getTraversedExtensor((Object)new AuthorizationPolicy(), AuthorizationPolicy.class));
        }
        if (conduit.getProxyAuthorization() == null) {
            conduit.setProxyAuthorization((ProxyAuthorizationPolicy)endpointInfo.getTraversedExtensor((Object)new ProxyAuthorizationPolicy(), ProxyAuthorizationPolicy.class));
        }
        if (conduit.getTlsClientParameters() == null) {
            conduit.setTlsClientParameters((TLSClientParameters)endpointInfo.getTraversedExtensor(null, TLSClientParameters.class));
        }
        if (conduit.getTrustDecider() == null) {
            conduit.setTrustDecider((MessageTrustDecider)endpointInfo.getTraversedExtensor(null, MessageTrustDecider.class));
        }
        if (conduit.getAuthSupplier() == null) {
            conduit.setAuthSupplier((HttpAuthSupplier)endpointInfo.getTraversedExtensor(null, HttpAuthSupplier.class));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "configureConduitFromEndpointInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void logConfig() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "logConfig", new Object[0]);
        }
        if (!LOG.isLoggable(Level.FINE)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "logConfig");
            }
            return;
        }
        if (this.trustDecider == null) {
            LOG.log(Level.FINE, "No Trust Decider configured for Conduit '" + this.getConduitName() + "'");
        } else {
            LOG.log(Level.FINE, "Message Trust Decider of class '" + this.trustDecider.getClass().getName() + "' with logical name of '" + this.trustDecider.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.authSupplier == null) {
            LOG.log(Level.FINE, "No Auth Supplier configured for Conduit '" + this.getConduitName() + "'");
        } else {
            LOG.log(Level.FINE, "HttpAuthSupplier of class '" + this.authSupplier.getClass().getName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.tlsClientParameters != null) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for TLS keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom() + "Disable Common Name (CN) Check: " + this.tlsClientParameters.isDisableCNCheck());
        } else {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for plain http.");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "logConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void finalizeConfig() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "finalizeConfig", new Object[0]);
        }
        HTTPConduit.configureConduitFromEndpointInfo(this, this.endpointInfo);
        this.logConfig();
        if (this.getClient().getDecoupledEndpoint() != null) {
            this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", (Object)this.getClient().getDecoupledEndpoint());
        }
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
            this.clientSidePolicy.addPropertyChangeListener(this);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "finalizeConfig");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Cookie> getCookies() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getCookies", new Object[0]);
        }
        Map<String, Cookie> map = this.cookies.getSessionCookies();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getCookies", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpURLConnection createConnection(Message message, URL url) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "createConnection", new Object[]{message, url});
        }
        HTTPClientPolicy csPolicy = this.getClient(message);
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, url);
        HttpURLConnection httpURLConnection = this.connectionFactory.createConnection(this.tlsClientParameters, proxy, url);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "createConnection", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void prepare(Message message) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "prepare", new Object[]{message});
        }
        URL currentURL = this.setupURL(message);
        boolean needToCacheRequest = false;
        HTTPClientPolicy csPolicy = this.getClient(message);
        HttpURLConnection connection = this.createConnection(message, currentURL);
        connection.setDoOutput(true);
        int ctimeout = HTTPConduit.determineConnectionTimeout(message, csPolicy);
        connection.setConnectTimeout(ctimeout);
        int rtimeout = HTTPConduit.determineReceiveTimeout(message, csPolicy);
        connection.setReadTimeout(rtimeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        connection.setRequestMethod(null != httpRequestMethod ? httpRequestMethod : HTTP_POST_METHOD);
        boolean isChunking = false;
        int chunkThreshold = 0;
        AuthorizationPolicy effectiveAuthPolicy = this.getEffectiveAuthPolicy(message);
        if (this.authSupplier == null) {
            this.authSupplier = this.createAuthSupplier(effectiveAuthPolicy.getAuthorizationType());
        }
        if (this.proxyAuthSupplier == null) {
            this.proxyAuthSupplier = this.createAuthSupplier(this.proxyAuthorizationPolicy.getAuthorizationType());
        }
        if (this.authSupplier.requiresRequestCaching()) {
            needToCacheRequest = true;
            isChunking = false;
            LOG.log(Level.FINE, "Auth Supplier, but no Premeptive User Pass or Digest auth (nonce may be stale) We must cache request.");
        }
        if (csPolicy.isAutoRedirect()) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "AutoRedirect is turned on.");
        }
        if (csPolicy.getMaxRetransmits() > 0) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "MaxRetransmits is set > 0.");
        }
        if (csPolicy.isAllowChunking() && this.isChunkingSupported(message, connection.getRequestMethod())) {
            isChunking = true;
            chunkThreshold = csPolicy.getChunkingThreshold();
            if (chunkThreshold <= 0) {
                chunkThreshold = 0;
                connection.setChunkedStreamingMode(-1);
            }
        }
        this.cookies.writeToMessageHeaders(message);
        message.put((Object)KEY_HTTP_CONNECTION, (Object)connection);
        if (this.certConstraints != null) {
            message.put((Object)CertConstraints.class.getName(), (Object)this.certConstraints);
            message.getInterceptorChain().add((Interceptor)CertConstraintsInterceptor.INSTANCE);
        }
        this.setHeadersByAuthorizationPolicy(message, currentURL);
        new Headers(message).setFromClientPolicy(this.getClient(message));
        message.setContent(OutputStream.class, (Object)this.createOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "prepare");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isChunkingSupported(Message message, String httpMethod) {
        Object obj;
        MessageContentsList objs;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "isChunkingSupported", new Object[]{message, httpMethod});
        }
        if (HTTP_POST_METHOD.equals(httpMethod)) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "isChunkingSupported", bl);
            }
            return bl;
        }
        if (HTTP_PUT_METHOD.equals(httpMethod) && (objs = MessageContentsList.getContentsList((Message)message)) != null && objs.size() > 0 && ((obj = objs.get(0)).getClass() != String.class || obj.getClass() == String.class && ((String)obj).length() > 0)) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "isChunkingSupported", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "isChunkingSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected OutputStream createOutputStream(Message message, HttpURLConnection connection, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "createOutputStream", new Object[]{message, connection, needToCacheRequest, isChunking, chunkThreshold});
        }
        WrappedOutputStream wrappedOutputStream = new WrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrappedOutputStream = wrappedOutputStream;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "createOutputStream", (Object)wrappedOutputStream);
        }
        return wrappedOutputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpAuthSupplier createAuthSupplier(String authType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "createAuthSupplier", new Object[]{authType});
        }
        if ("Negotiate".equals(authType)) {
            SpnegoAuthSupplier spnegoAuthSupplier = new SpnegoAuthSupplier();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                spnegoAuthSupplier = spnegoAuthSupplier;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "createAuthSupplier", spnegoAuthSupplier);
            }
            return spnegoAuthSupplier;
        }
        if ("Digest".equals(authType)) {
            DigestAuthSupplier digestAuthSupplier = new DigestAuthSupplier();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                digestAuthSupplier = digestAuthSupplier;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "createAuthSupplier", digestAuthSupplier);
            }
            return digestAuthSupplier;
        }
        DefaultBasicAuthSupplier defaultBasicAuthSupplier = new DefaultBasicAuthSupplier();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            defaultBasicAuthSupplier = defaultBasicAuthSupplier;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "createAuthSupplier", defaultBasicAuthSupplier);
        }
        return defaultBasicAuthSupplier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static int determineReceiveTimeout(Message message, HTTPClientPolicy csPolicy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "determineReceiveTimeout", new Object[]{message, csPolicy});
        }
        long rtimeout = csPolicy.getReceiveTimeout();
        if (message.get((Object)"javax.xml.ws.client.receiveTimeout") != null) {
            Object obj = message.get((Object)"javax.xml.ws.client.receiveTimeout");
            try {
                rtimeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.receiveTimeout", obj.toString()});
            }
        }
        if (rtimeout > Integer.MAX_VALUE) {
            rtimeout = Integer.MAX_VALUE;
        }
        int n = (int)rtimeout;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "determineReceiveTimeout", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static int determineConnectionTimeout(Message message, HTTPClientPolicy csPolicy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "determineConnectionTimeout", new Object[]{message, csPolicy});
        }
        long ctimeout = csPolicy.getConnectionTimeout();
        if (message.get((Object)"javax.xml.ws.client.connectionTimeout") != null) {
            Object obj = message.get((Object)"javax.xml.ws.client.connectionTimeout");
            try {
                ctimeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.connectionTimeout", obj.toString()});
            }
        }
        if (ctimeout > Integer.MAX_VALUE) {
            ctimeout = Integer.MAX_VALUE;
        }
        int n = (int)ctimeout;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "determineConnectionTimeout", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close(Message msg) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "close", new Object[]{msg});
        }
        InputStream in = (InputStream)msg.getContent(InputStream.class);
        try {
            if (in != null) {
                byte[] buffer = new byte[1024];
                for (int count = 0; in.read(buffer) != -1 && count < 25; ++count) {
                }
            }
        }
        finally {
            super.close(msg);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private URL setupURL(Message message) throws MalformedURLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setupURL", new Object[]{message});
        }
        String result = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        if (result == null) {
            if (pathInfo == null && queryString == null) {
                URL url = this.getURL();
                message.put((Object)Message.ENDPOINT_ADDRESS, (Object)this.defaultEndpointURLString);
                URL uRL = url;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    uRL = uRL;
                    LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setupURL", uRL);
                }
                return uRL;
            }
            result = this.getURL().toString();
            message.put((Object)Message.ENDPOINT_ADDRESS, (Object)result);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        URL uRL = new URL(result);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setupURL", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "close", new Object[0]);
        }
        if (this.defaultEndpointURL != null) {
            try {
                URLConnection connect = this.defaultEndpointURL.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getAddress() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getAddress", new Object[0]);
        }
        if (this.defaultEndpointURL != null) {
            String string = this.defaultEndpointURLString;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getAddress", string);
            }
            return string;
        }
        if (this.fromEndpointReferenceType) {
            String string = this.getTarget().getAddress().getValue();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getAddress", string);
            }
            return string;
        }
        String string = this.endpointInfo.getAddress();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getAddress", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected URL getURL() throws MalformedURLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getURL", new Object[0]);
        }
        URL uRL = this.getURL(true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getURL", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected synchronized URL getURL(boolean createOnDemand) throws MalformedURLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getURL", new Object[]{createOnDemand});
        }
        if (this.defaultEndpointURL == null && createOnDemand) {
            if (this.fromEndpointReferenceType && this.getTarget().getAddress().getValue() != null) {
                this.defaultEndpointURL = new URL(this.getTarget().getAddress().getValue());
                this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
                URL uRL = this.defaultEndpointURL;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    uRL = uRL;
                    LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getURL", uRL);
                }
                return uRL;
            }
            if (this.endpointInfo.getAddress() == null) {
                throw new MalformedURLException("Invalid address. Endpoint address cannot be null.");
            }
            this.defaultEndpointURL = new URL(this.endpointInfo.getAddress());
            this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
        }
        URL uRL = this.defaultEndpointURL;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getURL", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setHeadersByAuthorizationPolicy(Message message, URL url) {
        String proxyAuthString;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setHeadersByAuthorizationPolicy", new Object[]{message, url});
        }
        Headers headers = new Headers(message);
        AuthorizationPolicy effectiveAuthPolicy = this.getEffectiveAuthPolicy(message);
        String authString = this.authSupplier.getAuthorization(effectiveAuthPolicy, url, message, null);
        if (authString != null) {
            headers.setAuthorization(authString);
        }
        if ((proxyAuthString = this.authSupplier.getAuthorization((AuthorizationPolicy)this.proxyAuthorizationPolicy, url, message, null)) != null) {
            headers.setProxyAuthorization(proxyAuthString);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setHeadersByAuthorizationPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getBeanName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getBeanName", new Object[0]);
        }
        if (this.endpointInfo.getName() != null) {
            String string = this.endpointInfo.getName().toString() + SC_HTTP_CONDUIT_SUFFIX;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getBeanName", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getBeanName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AuthorizationPolicy getEffectiveAuthPolicy(Message message) {
        AuthorizationPolicy newPolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getEffectiveAuthPolicy", new Object[]{message});
        }
        AuthorizationPolicy authPolicy = this.getAuthorization();
        AuthorizationPolicy effectivePolicy = newPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (effectivePolicy == null) {
            effectivePolicy = authPolicy;
        }
        if (effectivePolicy == null) {
            effectivePolicy = new AuthorizationPolicy();
        }
        AuthorizationPolicy authorizationPolicy = effectivePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            authorizationPolicy = authorizationPolicy;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getEffectiveAuthPolicy", authorizationPolicy);
        }
        return authorizationPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AuthorizationPolicy getAuthorization() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getAuthorization", new Object[0]);
        }
        AuthorizationPolicy authorizationPolicy = this.authorizationPolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            authorizationPolicy = authorizationPolicy;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getAuthorization", authorizationPolicy);
        }
        return authorizationPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAuthorization(AuthorizationPolicy authorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setAuthorization", new Object[]{authorization});
        }
        this.authorizationPolicy = authorization;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HTTPClientPolicy getClient(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getClient", new Object[]{message});
        }
        ClientPolicyCalculator cpc = new ClientPolicyCalculator();
        HTTPClientPolicy pol = (HTTPClientPolicy)((Object)message.get(HTTPClientPolicy.class));
        pol = pol != null ? cpc.intersect(pol, this.clientSidePolicy) : this.clientSidePolicy;
        PolicyDataEngine policyDataEngine = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        if (policyDataEngine == null) {
            HTTPClientPolicy hTTPClientPolicy = pol;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                hTTPClientPolicy = hTTPClientPolicy;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getClient", (Object)hTTPClientPolicy);
            }
            return hTTPClientPolicy;
        }
        HTTPClientPolicy hTTPClientPolicy = (HTTPClientPolicy)((Object)policyDataEngine.getPolicy(message, (Object)pol, (PolicyCalculator)cpc));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hTTPClientPolicy = hTTPClientPolicy;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getClient", (Object)hTTPClientPolicy);
        }
        return hTTPClientPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HTTPClientPolicy getClient() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getClient", new Object[0]);
        }
        HTTPClientPolicy hTTPClientPolicy = this.clientSidePolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hTTPClientPolicy = hTTPClientPolicy;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getClient", (Object)hTTPClientPolicy);
        }
        return hTTPClientPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setClient(HTTPClientPolicy client) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setClient", new Object[]{client});
        }
        if (this.clientSidePolicy != null) {
            this.clientSidePolicy.removePropertyChangeListener(this);
        }
        this.clientSidePolicy = client;
        this.clientSidePolicy.removePropertyChangeListener(this);
        this.clientSidePolicy.addPropertyChangeListener(this);
        this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", (Object)client.getDecoupledEndpoint());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setClient");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ProxyAuthorizationPolicy getProxyAuthorization() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getProxyAuthorization", new Object[0]);
        }
        ProxyAuthorizationPolicy proxyAuthorizationPolicy = this.proxyAuthorizationPolicy;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            proxyAuthorizationPolicy = proxyAuthorizationPolicy;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getProxyAuthorization", proxyAuthorizationPolicy);
        }
        return proxyAuthorizationPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProxyAuthorization(ProxyAuthorizationPolicy proxyAuthorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setProxyAuthorization", new Object[]{proxyAuthorization});
        }
        this.proxyAuthorizationPolicy = proxyAuthorization;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setProxyAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TLSClientParameters getTlsClientParameters() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getTlsClientParameters", new Object[0]);
        }
        TLSClientParameters tLSClientParameters = this.tlsClientParameters;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            tLSClientParameters = tLSClientParameters;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getTlsClientParameters", tLSClientParameters);
        }
        return tLSClientParameters;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTlsClientParameters(TLSClientParameters params) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setTlsClientParameters", new Object[]{params});
        }
        this.tlsClientParameters = params;
        if (this.tlsClientParameters != null) {
            CertificateConstraintsType constraints;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re) configured for TLS keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
            if ((constraints = params.getCertConstraints()) != null) {
                this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints(constraints);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re)configured for plain http.");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setTlsClientParameters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MessageTrustDecider getTrustDecider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getTrustDecider", new Object[0]);
        }
        MessageTrustDecider messageTrustDecider = this.trustDecider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageTrustDecider = messageTrustDecider;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getTrustDecider", messageTrustDecider);
        }
        return messageTrustDecider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTrustDecider(MessageTrustDecider decider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setTrustDecider", new Object[]{decider});
        }
        this.trustDecider = decider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setTrustDecider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpAuthSupplier getAuthSupplier() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getAuthSupplier", new Object[0]);
        }
        HttpAuthSupplier httpAuthSupplier = this.authSupplier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpAuthSupplier = httpAuthSupplier;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getAuthSupplier", httpAuthSupplier);
        }
        return httpAuthSupplier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAuthSupplier(HttpAuthSupplier supplier) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setAuthSupplier", new Object[]{supplier});
        }
        this.authSupplier = supplier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setAuthSupplier");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpAuthSupplier getProxyAuthSupplier() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "getProxyAuthSupplier", new Object[0]);
        }
        HttpAuthSupplier httpAuthSupplier = this.proxyAuthSupplier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpAuthSupplier = httpAuthSupplier;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "getProxyAuthSupplier", httpAuthSupplier);
        }
        return httpAuthSupplier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProxyAuthSupplier(HttpAuthSupplier proxyAuthSupplier) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "setProxyAuthSupplier", new Object[]{proxyAuthSupplier});
        }
        this.proxyAuthSupplier = proxyAuthSupplier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "setProxyAuthSupplier");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpURLConnection processRetransmit(HttpURLConnection origConnection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "processRetransmit", new Object[]{origConnection, message, cachedStream});
        }
        int responseCode = origConnection.getResponseCode();
        if (message != null && message.getExchange() != null) {
            message.getExchange().put((Object)Message.RESPONSE_CODE, (Object)responseCode);
        }
        HttpURLConnection connection = origConnection;
        switch (responseCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                connection = this.redirectRetransmit(origConnection, message, cachedStream);
                break;
            }
            case 401: {
                connection = this.authorizationRetransmit(origConnection, message, cachedStream);
                break;
            }
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "processRetransmit", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpURLConnection redirectRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "redirectRetransmit", new Object[]{connection, message, cachedStream});
        }
        if (!this.getClient(message).isAutoRedirect()) {
            HttpURLConnection httpURLConnection = connection;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpURLConnection = httpURLConnection;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "redirectRetransmit", httpURLConnection);
            }
            return httpURLConnection;
        }
        URL newURL = this.extractLocation(connection.getHeaderFields());
        HTTPConduit.detectRedirectLoop(this.getConduitName(), connection.getURL(), newURL, message);
        if (newURL != null) {
            new Headers(message).removeAuthorizationHeaders();
            this.setHeadersByAuthorizationPolicy(message, newURL);
            connection.disconnect();
            HttpURLConnection httpURLConnection = this.retransmit(newURL, message, cachedStream);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpURLConnection = httpURLConnection;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "redirectRetransmit", httpURLConnection);
            }
            return httpURLConnection;
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "redirectRetransmit", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpURLConnection authorizationRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "authorizationRetransmit", new Object[]{connection, message, cachedStream});
        }
        HttpAuthHeader authHeader = new HttpAuthHeader(connection.getHeaderField("WWW-Authenticate"));
        URL currentURL = connection.getURL();
        String realm = authHeader.getRealm();
        HTTPConduit.detectAuthorizationLoop(this.getConduitName(), message, currentURL, realm);
        AuthorizationPolicy effectiveAthPolicy = this.getEffectiveAuthPolicy(message);
        String authorizationToken = this.authSupplier.getAuthorization(effectiveAthPolicy, currentURL, message, authHeader.getFullHeader());
        if (authorizationToken == null) {
            HttpURLConnection httpURLConnection = connection;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpURLConnection = httpURLConnection;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "authorizationRetransmit", httpURLConnection);
            }
            return httpURLConnection;
        }
        try {
            this.closeInputStream(connection);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new Headers(message).setAuthorization(authorizationToken);
        this.cookies.writeToMessageHeaders(message);
        HttpURLConnection httpURLConnection = this.retransmit(currentURL, message, cachedStream);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "authorizationRetransmit", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private HttpURLConnection retransmit(URL newURL, Message message, CacheAndWriteOutputStream stream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "retransmit", new Object[]{newURL, message, stream});
        }
        HTTPClientPolicy cp = this.getClient(message);
        HttpURLConnection connection = this.createConnection(message, newURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)cp.getConnectionTimeout());
        connection.setReadTimeout((int)cp.getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        message.put((Object)"http.retransmit.url", (Object)newURL.toString());
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        connection.setRequestMethod(null != httpRequestMethod ? httpRequestMethod : HTTP_POST_METHOD);
        message.put((Object)KEY_HTTP_CONNECTION, (Object)connection);
        if (stream != null && stream.size() < Integer.MAX_VALUE) {
            connection.setFixedLengthStreamingMode((int)stream.size());
        }
        new Headers(message).setProtocolHeadersInConnection(connection);
        TrustDecisionUtil.makeTrustDecision(this.trustDecider, message, connection, this.getConduitName());
        if (connection.getRequestMethod().equals("GET")) {
            HttpURLConnection httpURLConnection = connection;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                httpURLConnection = httpURLConnection;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "retransmit", httpURLConnection);
            }
            return httpURLConnection;
        }
        OutputStream out = connection.getOutputStream();
        stream.writeCacheTo(out);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Conduit \"" + this.getConduitName() + "\" Retransmit message to: " + connection.getURL() + ": " + new String(stream.getBytes()));
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "retransmit", httpURLConnection);
        }
        return httpURLConnection;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void detectAuthorizationLoop(String conduitName, Message message, URL currentURL, String realm) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "detectAuthorizationLoop", new Object[]{conduitName, message, currentURL, realm});
        }
        HashSet<String> authURLs = (HashSet<String>)message.get((Object)KEY_AUTH_URLS);
        if (authURLs == null) {
            authURLs = new HashSet<String>();
            message.put((Object)KEY_AUTH_URLS, authURLs);
        }
        if (authURLs.contains(currentURL.toString() + realm)) {
            String logMessage = "Authorization loop detected on Conduit \"" + conduitName + "\" on URL \"" + currentURL + "\" with realm \"" + realm + "\"";
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, logMessage);
            }
            throw new IOException(logMessage);
        }
        authURLs.add(currentURL.toString() + realm);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "detectAuthorizationLoop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void detectRedirectLoop(String conduitName, URL lastURL, URL newURL, Message message) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "detectRedirectLoop", new Object[]{conduitName, lastURL, newURL, message});
        }
        HashSet<String> visitedURLs = (HashSet<String>)message.get((Object)KEY_VISITED_URLS);
        if (visitedURLs == null) {
            visitedURLs = new HashSet<String>();
            message.put((Object)KEY_VISITED_URLS, visitedURLs);
        }
        visitedURLs.add(lastURL.toString());
        if (newURL != null && visitedURLs.contains(newURL.toString())) {
            String msg = "Redirect loop detected on Conduit '" + conduitName + "' on '" + newURL + "'";
            LOG.log(Level.INFO, msg);
            throw new IOException(msg);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "detectRedirectLoop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private URL extractLocation(Map<String, List<String>> headers) throws MalformedURLException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "extractLocation", new Object[]{headers});
        }
        for (Map.Entry<String, List<String>> head : headers.entrySet()) {
            List<String> locs;
            if (!"Location".equalsIgnoreCase(head.getKey()) || (locs = head.getValue()) == null || locs.size() <= 0) continue;
            String location = locs.get(0);
            if (location != null) {
                URL uRL = new URL(location);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    uRL = uRL;
                    LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "extractLocation", uRL);
                }
                return uRL;
            }
            URL uRL = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                uRL = uRL;
                LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "extractLocation", uRL);
            }
            return uRL;
        }
        URL uRL = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            uRL = uRL;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "extractLocation", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void assertMessage(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "assertMessage", new Object[]{message});
        }
        PolicyDataEngine policyDataEngine = (PolicyDataEngine)this.bus.getExtension(PolicyDataEngine.class);
        policyDataEngine.assertMessage(message, (Object)this.getClient(), (PolicyCalculator)new ClientPolicyCalculator());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "assertMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void closeInputStream(HttpURLConnection connection) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "closeInputStream", new Object[]{connection});
        }
        InputStream ins = connection.getErrorStream();
        if (ins == null) {
            ins = connection.getInputStream();
        }
        if (ins != null) {
            IOUtils.consume((InputStream)ins);
            ins.close();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "closeInputStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean canAssert(QName type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "canAssert", new Object[]{type});
        }
        boolean bl = new ClientPolicyCalculator().equals(type);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "canAssert", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "propertyChange", new Object[]{evt});
        }
        if (evt.getSource() == this.clientSidePolicy && "decoupledEndpoint".equals(evt.getPropertyName())) {
            this.endpointInfo.setProperty("org.apache.cxf.ws.addressing.replyto", evt.getNewValue());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.HTTPConduit", "propertyChange");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleHttpRetryException(HttpRetryException e, HttpURLConnection connection) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.HTTPConduit", "handleHttpRetryException", new Object[]{e, connection});
        }
        String msg = "HTTP response '" + e.responseCode() + ": " + connection.getResponseMessage() + "' invoking " + connection.getURL();
        switch (e.responseCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                msg = msg + " that returned location header '" + e.getLocation() + "'";
                break;
            }
            case 401: {
                if (this.authorizationPolicy == null || this.authorizationPolicy.getUserName() == null) {
                    msg = msg + " with NO authorization username configured in conduit " + this.getConduitName();
                    break;
                }
                msg = msg + " with authorization username '" + this.authorizationPolicy.getUserName() + "'";
                break;
            }
            case 407: {
                msg = this.proxyAuthorizationPolicy == null || this.proxyAuthorizationPolicy.getUserName() == null ? msg + " with NO proxy authorization configured in conduit " + this.getConduitName() : msg + " with proxy authorization username '" + this.proxyAuthorizationPolicy.getUserName() + "'";
                if (this.clientSidePolicy == null || this.clientSidePolicy.getProxyServer() == null) {
                    if (connection.usingProxy()) {
                        msg = msg + " using a proxy even if NONE is configured in CXF conduit " + this.getConduitName() + " (maybe one is configured by java.net.ProxySelector)";
                        break;
                    }
                    msg = msg + " but NO proxy was used by the connection (none configured in cxf conduit and none selected by java.net.ProxySelector)";
                    break;
                }
                msg = msg + " using " + (Object)((Object)this.clientSidePolicy.getProxyServerType()) + " proxy " + this.clientSidePolicy.getProxyServer() + ":" + this.clientSidePolicy.getProxyServerPort();
                break;
            }
        }
        throw (IOException)new IOException(msg).initCause(e);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class InterposedMessageObserver
    implements MessageObserver {
        static final long serialVersionUID = 7246180210169585288L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.getExchange().put(Bus.class, (Object)HTTPConduit.this.bus);
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            Headers.getSetProtocolHeaders(inMessage);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"HTTP.REQUEST");
            inMessage.remove((Object)"HTTP.RESPONSE");
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            try {
                InputStream in = (InputStream)inMessage.getContent(InputStream.class);
                if (in != null) {
                    CachedOutputStream cos = new CachedOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)cos);
                    inMessage.setContent(InputStream.class, (Object)cos.getInputStream());
                }
                HTTPConduit.this.incomingObserver.onMessage(inMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.HTTPConduit$InterposedMessageObserver", InterposedMessageObserver.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class WrappedOutputStream
    extends AbstractThresholdOutputStream {
        protected HttpURLConnection connection;
        protected boolean cachingForRetransmission;
        protected final boolean chunking;
        protected CacheAndWriteOutputStream cachedStream;
        protected Message outMessage;
        protected String conduitName;
        static final long serialVersionUID = 95360967366061562L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected WrappedOutputStream(Message outMessage, HttpURLConnection connection, boolean possibleRetransmit, boolean isChunking, int chunkThreshold, String conduitName) {
            super(chunkThreshold);
            this.outMessage = outMessage;
            this.connection = connection;
            this.cachingForRetransmission = possibleRetransmit;
            this.chunking = isChunking;
            this.conduitName = conduitName;
        }

        protected WrappedOutputStream(WrappedOutputStream wos) {
            super(wos.threshold);
            this.outMessage = wos.outMessage;
            this.connection = wos.connection;
            this.cachingForRetransmission = wos.cachingForRetransmission;
            this.chunking = wos.chunking;
            this.conduitName = wos.conduitName;
        }

        public void thresholdNotReached() {
            if (this.chunking) {
                this.connection.setFixedLengthStreamingMode(this.buffer.size());
            }
        }

        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(HTTPConduit.this.getClient().getChunkLength());
            }
        }

        protected void onFirstWrite() throws IOException {
            try {
                this.handleHeadersTrustCaching();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("HTTPS hostname wrong:")) {
                    throw new IOException("The https URL hostname does not match the Common Name (CN) on the server certificate in the client's truststore.  Make sure server certificate is correct, or to disable this check (NOT recommended for production) set the CXF client TLS configuration property \"disableCNCheck\" to true.");
                }
                throw e;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending " + this.connection.getRequestMethod() + " Message with Headers to " + this.connection.getURL() + " Conduit :" + this.conduitName + "\n");
            }
        }

        protected void handleHeadersTrustCaching() throws IOException {
            new Headers(this.outMessage).setProtocolHeadersInConnection(this.connection);
            TrustDecisionUtil.makeTrustDecision(HTTPConduit.this.trustDecider, this.outMessage, this.connection, this.conduitName);
            if (!HTTPConduit.HTTP_POST_METHOD.equals(this.connection.getRequestMethod()) && !HTTPConduit.HTTP_PUT_METHOD.equals(this.connection.getRequestMethod())) {
                return;
            }
            if (this.outMessage.get((Object)"org.apache.cxf.post.empty") != null) {
                return;
            }
            OutputStream cout = null;
            try {
                cout = this.connection.getOutputStream();
            }
            catch (SocketException e) {
                if ("Socket Closed".equals(e.getMessage())) {
                    this.connection.connect();
                    cout = this.connection.getOutputStream();
                }
                throw e;
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(cout);
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = cout;
            }
        }

        public void close() throws IOException {
            try {
                if (this.buffer != null && this.buffer.size() > 0) {
                    this.thresholdNotReached();
                    LoadingByteArrayOutputStream tmp = this.buffer;
                    this.buffer = null;
                    super.write(tmp.getRawBytes(), 0, tmp.size());
                }
                if (!this.written) {
                    this.handleHeadersTrustCaching();
                }
                if (!this.cachingForRetransmission) {
                    super.close();
                } else if (this.cachedStream != null) {
                    super.flush();
                    this.cachedStream.getOut().close();
                    this.cachedStream.closeFlowthroughStream();
                }
                try {
                    this.handleResponse();
                }
                finally {
                    if (this.cachingForRetransmission && this.cachedStream != null) {
                        this.cachedStream.close();
                    }
                }
            }
            catch (HttpRetryException e) {
                HTTPConduit.this.handleHttpRetryException(e, this.connection);
            }
            catch (IOException e) {
                String url = this.connection.getURL().toString();
                String origMessage = e.getMessage();
                if (origMessage != null && origMessage.contains(url)) {
                    throw e;
                }
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, IOException.class);
            }
            catch (RuntimeException e) {
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, RuntimeException.class);
            }
        }

        private <T extends Exception> T mapException(String msg, T ex, Class<T> cls) {
            Object ex2 = ex;
            try {
                ex2 = (Exception)cls.cast(ex.getClass().getConstructor(String.class).newInstance(msg));
                ((Throwable)ex2).initCause(ex);
            }
            catch (Throwable e) {
                ex2 = ex;
            }
            return (T)ex2;
        }

        protected void handleRetransmits() throws IOException {
            if (this.cachedStream != null || "GET".equals(this.connection.getRequestMethod()) && HTTPConduit.this.getClient().isAutoRedirect()) {
                if (LOG.isLoggable(Level.FINE) && this.cachedStream != null) {
                    StringBuilder b = new StringBuilder(4096);
                    b.append("Conduit \"").append(HTTPConduit.this.getConduitName()).append("\" Transmit cached message to: ").append(this.connection.getURL()).append(": ");
                    this.cachedStream.writeCacheTo(b, 16384L);
                    LOG.fine(b.toString());
                }
                int maxRetransmits = this.getMaxRetransmits();
                HTTPConduit.this.cookies.readFromConnection(this.connection);
                HttpURLConnection oldcon = null;
                for (int nretransmits = 0; this.connection != oldcon && (maxRetransmits < 0 || nretransmits < maxRetransmits); ++nretransmits) {
                    oldcon = this.connection;
                    this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                }
            }
        }

        private int getMaxRetransmits() {
            HTTPClientPolicy policy = HTTPConduit.this.getClient(this.outMessage);
            return policy == null ? -1 : policy.getMaxRetransmits();
        }

        protected void handleResponse() throws IOException {
            this.handleRetransmits();
            if (this.outMessage == null || this.outMessage.getExchange() == null || this.outMessage.getExchange().isSynchronous()) {
                this.handleResponseInternal();
            } else {
                Runnable runnable = new Runnable(){
                    static final long serialVersionUID = 238727084433669944L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        try {
                            WrappedOutputStream.this.handleResponseInternal();
                        }
                        catch (Exception e) {
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).abort();
                            WrappedOutputStream.this.outMessage.setContent(Exception.class, (Object)e);
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).unwind(WrappedOutputStream.this.outMessage);
                            WrappedOutputStream.this.outMessage.getInterceptorChain().getFaultObserver().onMessage(WrappedOutputStream.this.outMessage);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.HTTPConduit$WrappedOutputStream$1", 1.class, null, null);
                    }
                };
                HTTPClientPolicy policy = HTTPConduit.this.getClient(this.outMessage);
                try {
                    Executor ex = (Executor)this.outMessage.getExchange().get(Executor.class);
                    if (ex == null) {
                        WorkQueueManager mgr = (WorkQueueManager)((Bus)this.outMessage.getExchange().get(Bus.class)).getExtension(WorkQueueManager.class);
                        AutomaticWorkQueue qu = mgr.getNamedWorkQueue("http-conduit");
                        if (qu == null) {
                            qu = mgr.getAutomaticWorkQueue();
                        }
                        long timeout = 5000L;
                        if (policy != null && policy.isSetAsyncExecuteTimeout()) {
                            timeout = policy.getAsyncExecuteTimeout();
                        }
                        if (timeout > 0L) {
                            qu.execute(runnable, timeout);
                        } else {
                            qu.execute(runnable);
                        }
                    } else {
                        this.outMessage.getExchange().put((Object)(Executor.class.getName() + ".USING_SPECIFIED"), (Object)Boolean.TRUE);
                        ex.execute(runnable);
                    }
                }
                catch (RejectedExecutionException rex) {
                    if (policy != null && policy.isSetAsyncExecuteTimeoutRejection() && policy.isAsyncExecuteTimeoutRejection()) {
                        throw rex;
                    }
                    if (!hasLoggedAsyncWarning) {
                        LOG.warning("EXECUTOR_FULL_WARNING");
                        hasLoggedAsyncWarning = true;
                    }
                    LOG.fine("EXECUTOR_FULL");
                    this.handleResponseInternal();
                }
            }
        }

        private boolean isOneway(Exchange exchange) {
            return exchange != null && exchange.isOneWay();
        }

        private boolean doProcessResponse(Message message) {
            if (!this.isOneway(message.getExchange())) {
                return true;
            }
            return MessageUtils.getContextualBoolean((Message)message, (String)"org.apache.cxf.transport.processOneWayResponse", (boolean)false);
        }

        protected void handleResponseInternal() throws IOException {
            Exchange exchange = this.outMessage.getExchange();
            int responseCode = this.connection.getResponseCode();
            if (responseCode == -1) {
                LOG.warning("HTTP Response code appears to be corrupted");
            }
            if (exchange != null) {
                exchange.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            }
            this.logResponseInfo(responseCode);
            boolean noExceptions = MessageUtils.isTrue((Object)this.outMessage.getContextualProperty("org.apache.cxf.http.no_io_exceptions"));
            if (responseCode >= 400 && responseCode != 500 && !noExceptions) {
                throw new HTTPException(responseCode, this.connection.getResponseMessage(), this.connection.getURL());
            }
            InputStream in = null;
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            new Headers((Message)inMessage).readFromConnection(this.connection);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            HTTPConduit.this.cookies.readFromConnection(this.connection);
            if (this.isOneway(exchange) || 202 == responseCode) {
                in = ChunkedUtil.getPartialResponse(this.connection, responseCode);
                if (in == null || !this.doProcessResponse(this.outMessage)) {
                    Endpoint ep;
                    HTTPConduit.this.closeInputStream(this.connection);
                    if (this.isOneway(exchange) && responseCode > 300) {
                        throw new HTTPException(responseCode, this.connection.getResponseMessage(), this.connection.getURL());
                    }
                    ClientCallback cc = (ClientCallback)exchange.get(ClientCallback.class);
                    if (null != cc && null != (ep = exchange.getEndpoint()) && null != ep.getEndpointInfo() && null == ep.getEndpointInfo().getProperty("org.apache.cxf.ws.addressing.MAPAggregator.decoupledDestination")) {
                        cc.handleResponse(null, null);
                    }
                    if (in != null) {
                        in.close();
                    }
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
                if (this.cachingForRetransmission && this.cachedStream != null) {
                    this.cachedStream.close();
                }
                this.cachedStream = null;
            }
            String ct = this.connection.getContentType();
            inMessage.put((Object)"Content-Type", (Object)ct);
            String charset = HttpHeaderHelper.findCharset((String)ct);
            String normalizedEncoding = HttpHeaderHelper.mapCharset((String)charset);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{charset}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
            if (in == null) {
                if (responseCode >= 400) {
                    in = this.connection.getErrorStream();
                    if (in == null) {
                        try {
                            in = this.connection.getInputStream();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    in = this.connection.getInputStream();
                }
            }
            if (in == null) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            inMessage.setContent(InputStream.class, (Object)in);
            HTTPConduit.this.incomingObserver.onMessage((Message)inMessage);
        }

        private void logResponseInfo(int responseCode) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response Code: " + responseCode + " Conduit: " + this.conduitName);
                LOG.fine("Content length: " + this.connection.getContentLength());
                Map<String, List<String>> headerFields = this.connection.getHeaderFields();
                if (null != headerFields) {
                    String newLine = SystemPropertyAction.getProperty((String)"line.separator");
                    StringBuilder buf = new StringBuilder();
                    buf.append("Header fields: " + newLine);
                    for (String headerKey : headerFields.keySet()) {
                        buf.append("    " + headerKey + ": " + headerFields.get(headerKey) + newLine);
                    }
                    LOG.fine(buf.toString());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.HTTPConduit$WrappedOutputStream", WrappedOutputStream.class, null, null);
        }
    }
}

