/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.GatewayBundleFactory;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.ParentLastClassLoader;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.CanonicalStore;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingConfigurationException;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ClassLoaderFactory
extends GatewayBundleFactory {
    static final TraceComponent tc = Tr.register(ClassLoaderFactory.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final CanonicalStore<ClassLoaderIdentity, AppClassLoader> store;
    private final CompositeResourceProvider resourceProviders;
    private List<Container> classPath;
    private List<File> sharedLibPath;
    private ClassLoaderConfiguration config;
    private GatewayConfiguration gwConfig;
    private ClassLoader parentClassLoader;
    private DeclaredApiAccess access;
    private PostCreateAction postCreateAction;
    private ClassLoader externalBundleLoader;
    private final ClassRedefiner redefiner;
    private final ClassGenerator generator;
    private final GlobalClassloadingConfiguration globalConfig;
    static final long serialVersionUID = -5281894230271387393L;

    ClassLoaderFactory(BundleContext bundleContext, RegionDigraph digraph, Map<Bundle, Set<GatewayClassLoader>> classloaders, CanonicalStore<ClassLoaderIdentity, AppClassLoader> store, CompositeResourceProvider resourceProviders, ClassRedefiner redefiner, ClassGenerator generator, GlobalClassloadingConfiguration globalConfig) {
        super(bundleContext, digraph, classloaders);
        this.store = store;
        this.resourceProviders = resourceProviders;
        this.redefiner = redefiner;
        this.generator = generator;
        this.globalConfig = globalConfig;
    }

    private <P extends ClassLoader> void setParent(P p) {
        this.parentClassLoader = p;
        this.access = (DeclaredApiAccess)((Object)p);
    }

    ClassLoaderFactory setClassPath(List<Container> classPath) {
        this.classPath = classPath;
        return this;
    }

    ClassLoaderFactory setSharedLibPath(List<File> classPath) {
        this.sharedLibPath = classPath;
        return this;
    }

    ClassLoaderFactory configure(ClassLoaderConfiguration config) {
        this.config = config;
        return this;
    }

    ClassLoaderFactory configure(GatewayConfiguration gwConfig) {
        this.gwConfig = gwConfig;
        return this;
    }

    ClassLoaderFactory useBundleAddOnLoader(ClassLoader loader) {
        this.externalBundleLoader = loader;
        return this;
    }

    ClassLoaderFactory onCreate(PostCreateAction action) {
        this.postCreateAction = action;
        return this;
    }

    AppClassLoader create() {
        AppClassLoader result = this.createClassLoader();
        this.store.store(this.config.getId(), result);
        return result;
    }

    AppClassLoader getCanonical() {
        AppClassLoader canonical = this.store.retrieveOrCreate(this.config.getId(), new Factory<AppClassLoader>(){
            static final long serialVersionUID = -1702879880528288096L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public AppClassLoader createInstance() {
                return ClassLoaderFactory.this.createClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ClassLoaderFactory$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
        return canonical;
    }

    private AppClassLoader createClassLoader() {
        this.validate();
        this.inferParentLoader();
        AppClassLoader result = this.config.getDelegateToParentAfterCheckingLocalClasspath() ? new ParentLastClassLoader(this.parentClassLoader, this.config, this.classPath, this.access, this.redefiner, this.generator, this.globalConfig) : new AppClassLoader(this.parentClassLoader, this.config, this.classPath, this.access, this.redefiner, this.generator, this.globalConfig);
        this.addSharedLibPaths(result);
        this.runPostCreateAction(result);
        return result;
    }

    private void validate() {
        if (this.config == null) {
            throw new ClassLoadingConfigurationException("ClassLoadingConfiguration must not be null");
        }
        if (this.gwConfig == null) {
            Util.ensure("Child classloader must have a parent id set in its config", this.config.getParentId() != null);
        } else {
            Util.ensure("Top-level classloader should not have a parent id set in its config", this.config.getParentId() == null);
        }
    }

    private void inferParentLoader() {
        if (this.gwConfig != null) {
            if (this.externalBundleLoader == null) {
                this.setParent(this.createGatewayBundleClassLoader(this.gwConfig, this.config, this.resourceProviders));
            } else {
                this.setParent(GatewayClassLoader.createGatewayClassLoader(this.classloaders, this.gwConfig, this.externalBundleLoader, this.resourceProviders));
            }
        } else if (this.parentClassLoader == null) {
            ClassLoaderIdentity parentID = this.config.getParentId();
            this.setParent((ClassLoader)Util.ensureNotNull("Could not find parent classloader with id '" + parentID + "'.", this.store.retrieve(parentID)));
        }
    }

    private void addSharedLibPaths(AppClassLoader result) {
        if (this.sharedLibPath != null) {
            for (File f : this.sharedLibPath) {
                result.addLibraryFile(f);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runPostCreateAction(AppClassLoader result) {
        block3: {
            if (this.postCreateAction == null) {
                return;
            }
            String methodName = "runPostCreateAction(): ";
            try {
                this.postCreateAction.invoke(result);
            }
            catch (Exception exception) {
                void swallowed;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.classloading.internal.ClassLoaderFactory", (String)"187", (Object)this, (Object[])new Object[]{result});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("runPostCreateAction(): Caught exception running post-create action for class loader: " + swallowed), (Object[])new Object[0]);
            }
        }
    }

    static interface PostCreateAction {
        public void invoke(AppClassLoader var1);
    }
}

