/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.sib.utils.comms.ProviderEndPoint;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ClientAttachProperties {
    private static final TraceComponent tc = SibTr.register(ClientAttachProperties.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private Map props = null;
    private String busName = null;
    private String targetGroupName = null;
    private String targetGroupType = null;
    private String targetSignificance = null;
    private String targetTransportChain = null;
    private String connectionProximity = null;
    private List<ProviderEndPoint> endpoints = new ArrayList<ProviderEndPoint>();
    private String connectionMode = null;
    private boolean userDefinedEPs = false;

    public ClientAttachProperties(Map ps, boolean isPasswordSpecified) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ClientAttachProperties", (Object)new Object[]{ps, isPasswordSpecified});
        }
        this.props = ps;
        this.busName = (String)this.props.get("busName");
        if (this.busName == null) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_PROPERTY_CWSIT0003", new Object[]{"busName"}, null));
        }
        this.targetGroupName = (String)this.props.get("targetGroup");
        if (this.targetGroupName != null && this.targetGroupName.trim().equals("")) {
            this.targetGroupName = null;
        }
        this.targetGroupType = (String)this.props.get("targetType");
        if (this.targetGroupType != null && this.targetGroupType.trim().equals("")) {
            this.targetGroupType = null;
        }
        if (this.targetGroupType == null) {
            this.targetGroupType = "BusMember";
        }
        if (!(this.targetGroupType.equals("BusMember") || this.targetGroupType.equals("Destination") || this.targetGroupType.equals("Custom") || this.targetGroupType.equals("ME") || this.targetGroupType.equals("MEUuid"))) {
            String correctValues = "BusMember,Destination,Custom,ME,MEUuid";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.targetGroupType, "targetType", correctValues}, null));
        }
        this.targetSignificance = (String)this.props.get("targetSignificance");
        if (this.targetSignificance != null && this.targetSignificance.trim().equals("")) {
            this.targetSignificance = null;
        }
        if (this.targetSignificance == null) {
            this.targetSignificance = "Preferred";
        }
        if (!this.targetSignificance.equals("Required") && !this.targetSignificance.equals("Preferred")) {
            String correctValues = "Required,Preferred";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.targetSignificance, "targetSignificance", correctValues}, null));
        }
        this.connectionProximity = (String)this.props.get("connectionProximity");
        if (this.connectionProximity != null && this.connectionProximity.trim().equals("")) {
            this.connectionProximity = null;
        }
        if (this.connectionProximity == null) {
            this.connectionProximity = "Bus";
        }
        if (!(this.connectionProximity.equals("Server") || this.connectionProximity.equals("Cluster") || this.connectionProximity.equals("Host") || this.connectionProximity.equals("Bus"))) {
            String correctValues = "Server,Cluster,Host,Bus";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.connectionProximity, "connectionProximity", correctValues}, null));
        }
        String p = (String)this.props.get("remoteServerAddress");
        try {
            this.userDefinedEPs = ProviderEndPoint.parseProviderEndpoints((String)p, this.endpoints, (boolean)isPasswordSpecified);
        }
        catch (ProviderEndPoint.IncorrectCallException e) {
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", (Object[])e.getInserts(), null));
        }
        this.targetTransportChain = (String)this.props.get("targetTransportChain");
        if (this.targetTransportChain != null && this.targetTransportChain.trim().equals("")) {
            this.targetTransportChain = null;
        }
        if (this.targetTransportChain == null) {
            ProviderEndPoint pEp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No targetTransportChain specified");
            }
            this.targetTransportChain = "InboundBasicMessaging";
            if (!this.endpoints.isEmpty() && !(pEp = this.endpoints.get(0)).getChain().equalsIgnoreCase("BootstrapBasicMessaging")) {
                this.targetTransportChain = "InboundSecureMessaging";
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Defaulting to " + this.targetTransportChain));
            }
        }
        this.connectionMode = (String)this.props.get("connectionMode");
        if (this.connectionMode != null && this.connectionMode.trim().equals("")) {
            this.connectionMode = null;
        }
        if (this.connectionMode == null) {
            this.connectionMode = "Normal";
        }
        if (!this.connectionMode.equals("Normal") && !this.connectionMode.equals("Recovery")) {
            String correctValues = "Normal,Recovery";
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_TARGET_TYPE_CWSIT0055", new Object[]{this.connectionMode, "connectionMode", correctValues}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ClientAttachProperties", (Object)this);
        }
    }

    Map getProperties() {
        return this.props;
    }

    String getBusName() {
        return this.busName;
    }

    String getTargetGroupName() {
        return this.targetGroupName;
    }

    String getTargetGroupType() {
        return this.targetGroupType;
    }

    String getTargetSignificance() {
        return this.targetSignificance;
    }

    String getTargetTransportChain() {
        return this.targetTransportChain;
    }

    String getConnectionProximity() {
        return this.connectionProximity;
    }

    List getProviderEPs() {
        return this.endpoints;
    }

    String getConnectionMode() {
        return this.connectionMode;
    }

    boolean isUserDefinedProviderEPs() {
        return this.userDefinedEPs;
    }
}

