/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BindingsHelper;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.csi.HomeWrapperSet;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.container.service.naming.LocalColonEJBNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.HomeRecordImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBJavaColonNamingHelper;
import com.ibm.ws.ejbcontainer.runtime.NameSpaceBinder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NameSpaceBinderImpl
implements NameSpaceBinder<EJBBinding> {
    private static TraceComponent tc = Tr.register(NameSpaceBinderImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    protected final EJBModuleMetaDataImpl moduleMetaData;
    private final EJBJavaColonNamingHelper ejbJavaColonHelper;
    private final EJBLocalNamingHelper<EJBBinding> ejbLocalNamingHelper;
    private final LocalColonEJBNamingHelper<EJBBinding> localColonNamingHelper;
    private final EJBRemoteRuntime remoteRuntime;
    static final long serialVersionUID = 1771490709390820791L;

    NameSpaceBinderImpl(EJBModuleMetaDataImpl mmd, EJBJavaColonNamingHelper jcnh, EJBLocalNamingHelper<EJBBinding> ejblocal, LocalColonEJBNamingHelper<EJBBinding> localColon, EJBRemoteRuntime remoteRuntime) {
        this.moduleMetaData = mmd;
        this.ejbJavaColonHelper = jcnh;
        this.ejbLocalNamingHelper = ejblocal;
        this.localColonNamingHelper = localColon;
        this.remoteRuntime = remoteRuntime;
    }

    @Override
    public void beginBind() {
    }

    @Override
    public EJBBinding createBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local) {
        return new EJBBinding(hr, interfaceName, interfaceIndex, local);
    }

    @Override
    public EJBBinding createJavaBindingObject(HomeRecord hr, HomeWrapperSet homeSet, String interfaceName, int interfaceIndex, boolean local, EJBBinding bindingObject) {
        return bindingObject;
    }

    @Override
    public void bindJavaGlobal(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaGlobalName(name);
        this.ejbJavaColonHelper.addGlobalBinding(bindingName, bindingObject);
    }

    @Override
    public void bindJavaApp(String name, EJBBinding bindingObject) {
        String bindingName = this.buildJavaAppName(name);
        this.ejbJavaColonHelper.addAppBinding(this.moduleMetaData, bindingName, bindingObject);
    }

    @Override
    public void bindJavaModule(String name, EJBBinding bindingObject) {
        this.ejbJavaColonHelper.addModuleBinding(this.moduleMetaData, name, bindingObject);
    }

    @Override
    public void bindDefaultEJBLocal(EJBBinding bindingObject, HomeRecord hr) {
        HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
        if (hrImpl.bindToContextRoot()) {
            BeanMetaData bmd = hr.getBeanMetaData();
            J2EEName eeName = hrImpl.getJ2EEName();
            String bindingName = eeName.getApplication() + "/" + eeName.getModule() + "/" + eeName.getComponent() + "#" + bindingObject.interfaceName;
            this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
            BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
            bh.ivEJBLocalBindings.add(bindingName);
            this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
            this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingObject.interfaceName);
            this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingObject.interfaceName, bmd);
        }
    }

    @Override
    public void bindSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, boolean local) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        BeanMetaData bmd = hr.getBeanMetaData();
        if (local) {
            this.bindLocalSimpleBindingName(bindingObject, hr, bmd.simpleJndiBindingName);
        }
    }

    private void bindLocalSimpleBindingName(EJBBinding bindingObject, HomeRecord hr, String bindingName) {
        boolean priorToVersion3;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        BeanMetaData bmd = hr.getBeanMetaData();
        boolean bl = priorToVersion3 = bmd.ivModuleVersion < 30;
        if (priorToVersion3) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"binding to local:", (Object[])new Object[0]);
            }
            String localColonBindingName = "ejb/" + bindingName;
            this.localColonNamingHelper.bind((Object)bindingObject, localColonBindingName);
            BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
            bh.ivLocalColonBindings.add(localColonBindingName);
            this.sendBindingMessage(bindingObject.interfaceName, "local:" + localColonBindingName, bmd);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"binding to ejblocal:", (Object[])new Object[0]);
        }
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, "ejblocal:" + bindingName, bmd);
    }

    @Override
    public void bindLocalHomeBindingName(EJBBinding bindingObject, HomeRecord hr) {
        BeanMetaData bmd = hr.getBeanMetaData();
        String bindingName = bmd.localHomeJndiBindingName;
        this.ejbLocalNamingHelper.bind((Object)bindingObject, bindingName);
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        bh.ivEJBLocalBindings.add(bindingName);
        this.sendBindingMessage(bindingObject.interfaceName, bindingName, bmd);
    }

    private void sendBindingMessage(String interfaceName, String jndiName, BeanMetaData bmd) {
        Tr.info((TraceComponent)tc, (String)"JNDI_BINDING_LOCATION_INFO_CNTR0167I", (Object[])new Object[]{interfaceName, bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication(), jndiName});
    }

    @Override
    public void bindBindings(EJBBinding bindingObject, HomeRecord hr, int numInterfaces, boolean singleGlobalInterface, int interfaceIndex, String interfaceName, boolean local, boolean deferred) {
        if (!local && this.remoteRuntime != null) {
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData == null) {
                BeanMetaData bmd = hr.getBeanMetaData();
                EJBModuleMetaDataImpl mmd = bmd._moduleMetaData;
                EJBApplicationMetaData amd = mmd.getEJBApplicationMetaData();
                String appLogicalName = amd.isStandaloneModule() ? null : amd.getLogicalName();
                hrImpl.remoteBindingData = this.remoteRuntime.createBindingData(bmd, appLogicalName, mmd.ivLogicalName);
            }
            this.remoteRuntime.bind(hrImpl.remoteBindingData, interfaceIndex, interfaceName);
        }
        if (ContainerProperties.customBindingsEnabledBeta) {
            BeanMetaData bmd = hr.getBeanMetaData();
            boolean hasCustomBindings = false;
            if (bmd.simpleJndiBindingName != null) {
                hasCustomBindings = true;
                this.bindSimpleBindingName(bindingObject, hr, local);
            }
            if (bmd.localHomeJndiBindingName != null && bindingObject.isLocal && bindingObject.interfaceIndex == -1) {
                hasCustomBindings = true;
                this.bindLocalHomeBindingName(bindingObject, hr);
            }
            if (!hasCustomBindings && local) {
                this.bindDefaultEJBLocal(bindingObject, hr);
            }
        }
    }

    @Override
    public void bindEJBFactory() {
    }

    @Override
    public void beginUnbind(boolean error) {
    }

    @Override
    public void unbindJavaGlobal(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaGlobalName(name));
        }
        this.ejbJavaColonHelper.removeGlobalBindings(fullNames);
    }

    @Override
    public void unbindJavaApp(List<String> names) {
        ArrayList<String> fullNames = new ArrayList<String>(names.size());
        for (String name : names) {
            fullNames.add(this.buildJavaAppName(name));
        }
        this.ejbJavaColonHelper.removeAppBindings(this.moduleMetaData, fullNames);
    }

    @Override
    public void unbindBindings(HomeRecord hr) throws NamingException {
        if (this.remoteRuntime != null) {
            HomeRecordImpl hrImpl = HomeRecordImpl.cast(hr);
            if (hrImpl.remoteBindingData != null) {
                this.remoteRuntime.unbindAll(hrImpl.remoteBindingData);
            }
        }
        BindingsHelper bh = BindingsHelper.getLocalHelper(hr);
        this.unbindEJBLocal(bh.ivEJBLocalBindings);
        this.unbindLocalColonEJB(bh.ivLocalColonBindings);
    }

    @Override
    public void unbindEJBFactory() {
    }

    @Override
    public void end() {
    }

    private String buildJavaGlobalName(String name) {
        StringBuffer bindingName = new StringBuffer();
        if (!this.moduleMetaData.getEJBApplicationMetaData().isStandaloneModule()) {
            bindingName.append(this.moduleMetaData.getEJBApplicationMetaData().getLogicalName());
            bindingName.append("/");
        }
        bindingName.append(this.moduleMetaData.ivLogicalName);
        bindingName.append("/");
        bindingName.append(name);
        return bindingName.toString();
    }

    private String buildJavaAppName(String name) {
        return this.moduleMetaData.ivLogicalName + "/" + name;
    }

    @Override
    public void unbindEJBLocal(List<String> names) throws NamingException {
        this.ejbLocalNamingHelper.removeBindings(names);
    }

    @Override
    public void unbindLocalColonEJB(List<String> names) throws NamingException {
        this.localColonNamingHelper.removeBindings(names);
    }
}

