/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.naming;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBNamingInstancer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={EJBLocalNamingHelper.class, EJBLocalNamingHelperImpl.class})
public class EJBLocalNamingHelperImpl
extends EJBNamingInstancer
implements EJBLocalNamingHelper<EJBBinding> {
    private static final TraceComponent tc = Tr.register(EJBLocalNamingHelperImpl.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
    private final HashMap<String, EJBBinding> EJBLocalBindings = new HashMap();
    private final ReentrantReadWriteLock javaColonLock = new ReentrantReadWriteLock();
    static final long serialVersionUID = -1175534923715618526L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(String name) throws NamingException {
        EJBBinding binding;
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        try {
            binding = this.EJBLocalBindings.get(name);
        }
        finally {
            readLock.unlock();
        }
        return this.initializeEJB(binding, "ejblocal:" + name);
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public synchronized void bind(EJBBinding binding, String name) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (name.toLowerCase().startsWith("ejblocal:")) {
            name = name.substring(9);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bind: " + name), (Object[])new Object[0]);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.EJBLocalBindings.put(name, binding);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void unbind(String name) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("unbinding: " + name), (Object[])new Object[0]);
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.EJBLocalBindings.remove(name);
        }
        finally {
            writeLock.unlock();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unbind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings(List<String> names) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            for (String name : names) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("unbinding: " + name), (Object[])new Object[0]);
                }
                this.EJBLocalBindings.remove(name);
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

