/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public class ByteCodeMetaData
extends ClassVisitor {
    private static final String CLASS_NAME = ByteCodeMetaData.class.getName();
    static final TraceComponent tc = Tr.register(ByteCodeMetaData.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    static final TraceComponent tcMetaData = Tr.register(ByteCodeMetaData.class, (String)"MetaData", (String)"com.ibm.ejs.container.container");
    private static ClassLoader bootClassLoader;
    private final Class<?> ivClass;
    private final Method[] ivPublicMethods;
    private Map<String, Method> ivPublicMethodMap;
    private boolean ivScanned;
    private Throwable ivScanException;
    private String ivCurrentClassName;
    private Map<String, MethodMetaData> ivCurrentPrivateMethodMetaData;
    private String ivCurrentMethodName;
    private String ivCurrentMethodDesc;
    private final Map<String, MethodMetaData> ivNonPrivateMethodMetaData = new HashMap<String, MethodMetaData>();
    private final Map<String, Map<String, MethodMetaData>> ivPrivateMethodMetaData = new HashMap<String, Map<String, MethodMetaData>>();
    private Map<String, BridgeMethodMetaData> ivBridgeMethodMetaData;

    private static synchronized ClassLoader getBootClassLoader() {
        if (bootClassLoader == null) {
            bootClassLoader = new ClassLoader(null){};
        }
        return bootClassLoader;
    }

    ByteCodeMetaData(Class<?> implClass, Method[] publicMethods) {
        super(458752);
        this.ivClass = implClass;
        this.ivPublicMethods = publicMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void scan() {
        if (this.ivScanned) {
            return;
        }
        this.ivScanned = true;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        for (Class<?> klass = this.ivClass; klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            String resourceName;
            InputStream input;
            if (isTraceOn && (tc.isDebugEnabled() || tcMetaData.isDebugEnabled())) {
                Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcMetaData), (String)("scanning " + klass.getName()), (Object[])new Object[0]);
            }
            this.ivCurrentClassName = klass.getName();
            this.ivCurrentPrivateMethodMetaData = null;
            ClassLoader classLoader = klass.getClassLoader();
            if (classLoader == null) {
                classLoader = ByteCodeMetaData.getBootClassLoader();
            }
            if ((input = classLoader.getResourceAsStream(resourceName = klass.getName().replace('.', '/') + ".class")) == null) {
                if (isTraceOn && (tc.isDebugEnabled() || tcMetaData.isDebugEnabled())) {
                    Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcMetaData), (String)("failed to find " + resourceName + " from " + classLoader), (Object[])new Object[0]);
                }
                this.ivScanException = new FileNotFoundException(resourceName);
                return;
            }
            ClassReader classReader = new ClassReader(input);
            classReader.accept((ClassVisitor)this, 6);
            try {
                input.close();
            }
            catch (IOException ex) {
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"error closing input stream", (Object[])new Object[]{ex});
            }
            continue;
            catch (Throwable t) {
                block17: {
                    try {
                        FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".scan"), (String)"168", (Object)((Object)this), (Object[])new Object[]{resourceName, klass, classLoader});
                        if (isTraceOn && (tc.isDebugEnabled() || tcMetaData.isDebugEnabled())) {
                            Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcMetaData), (String)"scan exception", (Object[])new Object[]{t});
                        }
                        this.ivScanException = t;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            try {
                                input.close();
                            }
                            catch (IOException ex) {
                                if (!isTraceOn || !tc.isDebugEnabled()) break block18;
                                Tr.debug((TraceComponent)tc, (String)"error closing input stream", (Object[])new Object[]{ex});
                            }
                        }
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException ex) {
                        if (!isTraceOn || !tc.isDebugEnabled()) break block17;
                        Tr.debug((TraceComponent)tc, (String)"error closing input stream", (Object[])new Object[]{ex});
                    }
                }
                return;
            }
        }
    }

    public Throwable getScanException() {
        return this.ivScanException;
    }

    public Method getBridgeMethodTarget(Method method) {
        this.scan();
        if (this.ivBridgeMethodMetaData == null) {
            return null;
        }
        BridgeMethodMetaData md = this.ivBridgeMethodMetaData.get(this.getNonPrivateMethodKey(method));
        return md == null ? null : md.ivTarget;
    }

    public MethodMetaData getByteCodeMethodMetaData(Method method) {
        this.scan();
        if (Modifier.isPrivate(method.getModifiers())) {
            Map<String, MethodMetaData> map = this.ivPrivateMethodMetaData.get(method.getDeclaringClass().getName());
            return map == null ? null : map.get(method.getName());
        }
        return this.ivNonPrivateMethodMetaData.get(this.getNonPrivateMethodKey(method));
    }

    private String getNonPrivateMethodKey(Method method) {
        return this.getNonPrivateMethodKey(method.getName(), MethodAttribUtils.jdiMethodSignature(method));
    }

    private String getNonPrivateMethodKey(String methodName, String desc) {
        return methodName + desc;
    }

    Method getPublicMethod(String key) {
        if (this.ivPublicMethodMap == null) {
            this.ivPublicMethodMap = new HashMap<String, Method>();
            for (Method method : this.ivPublicMethods) {
                this.ivPublicMethodMap.put(this.getNonPrivateMethodKey(method), method);
            }
        }
        return this.ivPublicMethodMap.get(key);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.ivCurrentMethodName = name;
        this.ivCurrentMethodDesc = desc;
        if ((access & 0x40) != 0) {
            int flags = 4097;
            if ((access & flags) != flags) {
                if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": non-public/synthetic bridge method"), (Object[])new Object[0]);
                }
                return null;
            }
            String key = this.getNonPrivateMethodKey(name, desc);
            if (this.ivBridgeMethodMetaData == null) {
                this.ivBridgeMethodMetaData = new HashMap<String, BridgeMethodMetaData>();
            } else if (this.ivBridgeMethodMetaData.containsKey(key)) {
                if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": overridden bridge method"), (Object[])new Object[0]);
                }
                return null;
            }
            BridgeMethodMetaData md = new BridgeMethodMetaData();
            this.ivBridgeMethodMetaData.put(key, md);
            if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": bridge method"), (Object[])new Object[0]);
            }
            return md;
        }
        if ((access & 1) == 0) {
            Map<String, MethodMetaData> map;
            if (this.ivCurrentPrivateMethodMetaData == null) {
                this.ivCurrentPrivateMethodMetaData = new HashMap<String, MethodMetaData>();
                this.ivPrivateMethodMetaData.put(this.ivCurrentClassName, this.ivCurrentPrivateMethodMetaData);
            }
            if ((map = this.ivPrivateMethodMetaData.get(this.ivCurrentClassName)) == null) {
                map = new HashMap<String, MethodMetaData>();
                this.ivPrivateMethodMetaData.put(this.ivCurrentClassName, map);
            }
            MethodMetaData md = new MethodMetaData();
            map.put(name, md);
            if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": private"), (Object[])new Object[0]);
            }
            return md;
        }
        String key = this.getNonPrivateMethodKey(name, desc);
        if (this.ivNonPrivateMethodMetaData.containsKey(key)) {
            if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": overridden"), (Object[])new Object[0]);
            }
            return null;
        }
        MethodMetaData md = new MethodMetaData();
        this.ivNonPrivateMethodMetaData.put(key, md);
        if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcMetaData, (String)("visitMethod: " + name + desc + ": non-private"), (Object[])new Object[0]);
        }
        return md;
    }

    private class BridgeMethodMetaData
    extends AbstractMethodVisitor {
        Method ivTarget;

        private BridgeMethodMetaData() {
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.ivTarget = ByteCodeMetaData.this.getPublicMethod(ByteCodeMetaData.this.getNonPrivateMethodKey(name, desc));
        }

        public void visitEnd() {
            if (TraceComponent.isAnyTracingEnabled() && (tc.isDebugEnabled() || tcMetaData.isDebugEnabled()) && this.ivTarget != null) {
                Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcMetaData), (String)("bridge method " + ByteCodeMetaData.this.ivCurrentMethodName + ByteCodeMetaData.this.ivCurrentMethodDesc + ", target " + this.ivTarget), (Object[])new Object[0]);
            }
        }
    }

    class MethodMetaData
    extends AbstractMethodVisitor {
        boolean ivTrivial;

        MethodMetaData() {
            this.ivTrivial = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled() && this.ivTrivial) {
                String opcodeName;
                if (opcode == 185) {
                    opcodeName = "interface";
                } else {
                    String string = opcode == 183 ? "special" : (opcode == 184 ? "static" : (opcodeName = opcode == 182 ? "virtual" : Integer.toString(opcode)));
                    if (itf) {
                        opcodeName = opcodeName + " (interface)";
                    }
                }
                Tr.debug((TraceComponent)tcMetaData, (String)("non-trivial method " + ByteCodeMetaData.this.ivCurrentMethodName + ByteCodeMetaData.this.ivCurrentMethodDesc + ": " + opcodeName + ' ' + owner + '.' + name + desc), (Object[])new Object[0]);
            }
            this.ivTrivial = false;
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (TraceComponent.isAnyTracingEnabled() && tcMetaData.isDebugEnabled() && this.ivTrivial) {
                Tr.debug((TraceComponent)tcMetaData, (String)("non-trivial method " + ByteCodeMetaData.this.ivCurrentMethodName + ByteCodeMetaData.this.ivCurrentMethodDesc + ": dynamic [" + bsm.getOwner() + '.' + bsm.getName() + bsm.getDesc() + "] " + name + desc), (Object[])new Object[0]);
            }
            this.ivTrivial = false;
        }

        public void visitEnd() {
            if (TraceComponent.isAnyTracingEnabled() && (tc.isDebugEnabled() || tcMetaData.isDebugEnabled()) && this.ivTrivial) {
                Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcMetaData), (String)("trivial method " + ByteCodeMetaData.this.ivCurrentMethodName + ByteCodeMetaData.this.ivCurrentMethodDesc), (Object[])new Object[0]);
            }
        }
    }

    private abstract class AbstractMethodVisitor
    extends MethodVisitor {
        public AbstractMethodVisitor() {
            super(458752);
        }

        public abstract void visitMethodInsn(int var1, String var2, String var3, String var4, boolean var5);
    }
}

