/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.impl.SyncExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.state.FallbackState;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FallbackStateImpl
implements FallbackState {
    private static final TraceComponent tc = Tr.register(FallbackStateImpl.class, (String)"FAULTTOLERANCE", null);
    private final FallbackPolicy policy;
    private final MetricRecorder metricRecorder;
    static final long serialVersionUID = 8862431039651633121L;

    public FallbackStateImpl(FallbackPolicy policy, MetricRecorder metricRecorder) {
        this.policy = policy;
        this.metricRecorder = metricRecorder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> MethodResult<R> runFallback(MethodResult<R> result, SyncExecutionContextImpl executionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} calling fallback", (Object[])new Object[]{executionContext.getId()});
        }
        this.metricRecorder.incrementFallbackCalls();
        executionContext.setFailure(result.getFailure());
        try {
            result = MethodResult.success(this.policy.getFallbackFunction().execute((Object)executionContext));
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.FallbackStateImpl", (String)"46", (Object)this, (Object[])new Object[]{result, executionContext});
            result = MethodResult.failure((Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} fallback result: {1}", (Object[])new Object[]{executionContext.getId(), result});
        }
        return result;
    }

    @Override
    public boolean shouldApplyFallback(MethodResult<?> result) {
        boolean apply = !result.isFailure() ? false : (this.isSkipOn(result.getFailure()) ? false : this.isApplyOn(result.getFailure()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Fallback considers {0} to be {1}", (Object[])new Object[]{result, apply});
        }
        return apply;
    }

    private boolean isApplyOn(Throwable methodException) {
        for (Class applyExClazz : this.policy.getApplyOn()) {
            if (!applyExClazz.isInstance(methodException)) continue;
            return true;
        }
        return false;
    }

    private boolean isSkipOn(Throwable methodException) {
        for (Class skipExClazz : this.policy.getSkipOn()) {
            if (!skipExClazz.isInstance(methodException)) continue;
            return true;
        }
        return false;
    }
}

