/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.AllowAllHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.DefaultHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.PublicSuffixMatcherLoader;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class SSLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SSLUtils.class);
    private static boolean performHostNameVerification = true;
    static final long serialVersionUID = 2348893204302534926L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SSLUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static HostnameVerifier getHostnameVerifier(TLSClientParameters tlsClientParameters) {
        HostnameVerifier verifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "getHostnameVerifier", new Object[]{tlsClientParameters});
        }
        if (tlsClientParameters.getHostnameVerifier() != null) {
            LOG.fine("Getting HostnameVerifier from tlsClientParameters.");
            verifier = tlsClientParameters.getHostnameVerifier();
        } else if (tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier()) {
            LOG.fine("Getting DefaultHostnameVerifier from HttpsURLConnection.");
            verifier = HttpsURLConnection.getDefaultHostnameVerifier();
        } else if (tlsClientParameters.isDisableCNCheck()) {
            LOG.fine("isDisableCNCheck is true, setting verifier to AllowAllHostnameVerifier.");
            verifier = new AllowAllHostnameVerifier();
        } else if (!performHostNameVerification) {
            LOG.fine("performHostNameVerification is false, setting verifier to AllowAllHostnameVerifier.");
            verifier = new AllowAllHostnameVerifier();
        } else {
            LOG.fine("Getting new DefaultHostnameVerifier from PublicSuffixMatcherLoader.");
            verifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        }
        LOG.fine("getHostnameVerifier() returning: " + verifier.getClass().getCanonicalName());
        HostnameVerifier hostnameVerifier = verifier;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hostnameVerifier = hostnameVerifier;
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "getHostnameVerifier", hostnameVerifier);
        }
        return hostnameVerifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SSLContext getSSLContext(TLSParameterBase parameters) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "getSSLContext", new Object[]{parameters});
        }
        String provider = parameters.getJsseProvider();
        String protocol = parameters.getSecureSocketProtocol() != null ? parameters.getSecureSocketProtocol() : "TLS";
        LOG.fine("getSSLContext: provider = " + provider + " and protocol = " + protocol);
        SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        KeyManager[] keyManagers = parameters.getKeyManagers();
        if (keyManagers == null && parameters instanceof TLSClientParameters) {
            LOG.fine("Calling getDefaultKeyStoreManagers...");
            keyManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultKeyStoreManagers((Logger)LOG);
        }
        KeyManager[] configuredKeyManagers = SSLUtils.configureKeyManagersWithCertAlias(parameters, keyManagers);
        TrustManager[] trustManagers = parameters.getTrustManagers();
        if (trustManagers == null && parameters instanceof TLSClientParameters) {
            LOG.fine("Calling getDefaultTrustStoreManagers...");
            trustManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultTrustStoreManagers((Logger)LOG);
        }
        LOG.fine("keyManagers: " + keyManagers);
        LOG.fine("trustManagers: " + trustManagers);
        LOG.fine("configuredkeyManagers: " + configuredKeyManagers);
        ctx.init(configuredKeyManagers, trustManagers, parameters.getSecureRandom());
        if (parameters instanceof TLSClientParameters && ctx.getClientSessionContext() != null) {
            ctx.getClientSessionContext().setSessionTimeout(((TLSClientParameters)parameters).getSslCacheTimeout());
        }
        LOG.fine("getSSLContext returning: " + ctx.getClass().getCanonicalName());
        SSLContext sSLContext = ctx;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sSLContext = sSLContext;
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "getSSLContext", sSLContext);
        }
        return sSLContext;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static KeyManager[] configureKeyManagersWithCertAlias(TLSParameterBase tlsParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "configureKeyManagersWithCertAlias", new Object[]{tlsParameters, keyManagers});
        }
        if (tlsParameters.getCertAlias() == null || keyManagers == null) {
            LOG.fine("Alias or keyManagers is NULL.");
            KeyManager[] keyManagerArray = keyManagers;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                keyManagerArray = keyManagerArray;
                LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "configureKeyManagersWithCertAlias", keyManagerArray);
            }
            return keyManagerArray;
        }
        KeyManager[] copiedKeyManagers = Arrays.copyOf(keyManagers, keyManagers.length);
        for (int idx = 0; idx < copiedKeyManagers.length; ++idx) {
            if (!(copiedKeyManagers[idx] instanceof X509KeyManager) || copiedKeyManagers[idx] instanceof AliasedX509ExtendedKeyManager) continue;
            try {
                copiedKeyManagers[idx] = new AliasedX509ExtendedKeyManager(tlsParameters.getCertAlias(), (X509KeyManager)copiedKeyManagers[idx]);
                continue;
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.transport.https.SSLUtils", (String)"141", null, (Object[])new Object[]{tlsParameters, keyManagers});
                throw new GeneralSecurityException((Throwable)e);
            }
        }
        KeyManager[] keyManagerArray = copiedKeyManagers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            keyManagerArray = keyManagerArray;
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "configureKeyManagersWithCertAlias", keyManagerArray);
        }
        return keyManagerArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SSLEngine createServerSSLEngine(TLSServerParameters parameters) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "createServerSSLEngine", new Object[]{parameters});
        }
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(parameters.getClientAuthentication().isRequired());
        SSLEngine sSLEngine = serverEngine;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sSLEngine = sSLEngine;
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "createServerSSLEngine", sSLEngine);
        }
        return sSLEngine;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SSLEngine createClientSSLEngine(TLSClientParameters parameters) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.SSLUtils", "createClientSSLEngine", new Object[]{parameters});
        }
        SSLContext sslContext = SSLUtils.getSSLContext((TLSParameterBase)parameters);
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        SSLEngine sSLEngine = clientEngine;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sSLEngine = sSLEngine;
            LOG.exiting("org.apache.cxf.transport.https.SSLUtils", "createClientSSLEngine", sSLEngine);
        }
        return sSLEngine;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 2081431533875751703L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                String propValue = System.getProperty("com.ibm.ssl.performURLHostNameVerification");
                return propValue != null ? Boolean.valueOf(propValue) : true;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.https.SSLUtils$1", 1.class, null, null);
            }
        });
        performHostNameVerification = b;
        LOG.fine("Property com.ibm.ssl.performURLHostNameVerification is set to: " + performHostNameVerification);
    }
}

