/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health31.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health30.internal.HealthCheck30HttpResponseBuilder;
import io.openliberty.microprofile.health31.internal.HealthCheck31Service;
import io.openliberty.microprofile.health31.services.HealthCheck31Executor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HealthCheck31Service.class}, property={"service.vendor=IBM"})
public class HealthCheck31ServiceImpl
implements HealthCheck31Service {
    private static final TraceComponent tc = Tr.register(HealthCheck31ServiceImpl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private AppTracker appTracker;
    private HealthCheck31Executor hcExecutor;
    final AtomicBoolean readinessWarningAlreadyShown = new AtomicBoolean(false);
    final AtomicBoolean startupWarningAlreadyShown = new AtomicBoolean(false);
    AtomicInteger unstartedAppsCounter = new AtomicInteger(0);
    static final long serialVersionUID = -6811364343228180257L;

    @Reference(service=AppTracker.class)
    protected void setAppTracker(AppTracker service) {
        this.appTracker = service;
        this.appTracker.setHealthCheckService(this);
    }

    protected void unsetAppTracker(AppTracker service) {
        if (this.appTracker == service) {
            this.appTracker = null;
        }
    }

    @Reference(service=HealthCheck31Executor.class)
    protected void setHealthExecutor(HealthCheck31Executor service) {
        this.hcExecutor = service;
    }

    protected void unsetHealthExecutor(HealthCheck31Executor service) {
        if (this.hcExecutor == service) {
            this.hcExecutor = null;
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is deactivated", (Object[])new Object[0]);
        }
    }

    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse) {
        this.performHealthCheck(request, httpResponse, "ALL");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse, String healthCheckProcedure) {
        HealthCheckResponse.Status defaultOverallStartup;
        Set<HealthCheckResponse> hcResponses = null;
        HashSet<String> unstartedAppsSet = new HashSet<String>();
        Set<String> apps = this.appTracker.getAllAppNames();
        Iterator<String> appsIt = apps.iterator();
        boolean anyAppsInstalled = false;
        HealthCheck30HttpResponseBuilder hcHttpResponseBuilder = new HealthCheck30HttpResponseBuilder();
        String defaultReadinessProp = ConfigProvider.getConfig().getOptionalValue("mp.health.default.readiness.empty.response", String.class).orElse("");
        String defaultStartupProp = ConfigProvider.getConfig().getOptionalValue("mp.health.default.startup.empty.response", String.class).orElse("");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Readiness status was configured to be overriden: mp.health.default.readiness.empty.response=" + defaultReadinessProp), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): The default overall Startup status was configured to be overriden: mp.health.default.startup.empty.response=" + defaultStartupProp), (Object[])new Object[0]);
        }
        HealthCheckResponse.Status defaultOverallReadiness = defaultReadinessProp.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        HealthCheckResponse.Status status = defaultOverallStartup = defaultStartupProp.equalsIgnoreCase("UP") ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        while (appsIt.hasNext()) {
            String appName = appsIt.next();
            if (this.appTracker.isInstalled(appName)) {
                anyAppsInstalled = true;
                if (healthCheckProcedure.equals("LIVE") || unstartedAppsSet.contains(appName)) continue;
                unstartedAppsSet.add(appName);
                continue;
            }
            if (!this.appTracker.isUninstalled(appName) && !this.appTracker.isStarted(appName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Application : " + appName + " has not started yet."), (Object[])new Object[0]);
                }
                if (!healthCheckProcedure.equals("LIVE")) {
                    if (healthCheckProcedure.equals("START")) {
                        hcHttpResponseBuilder.setOverallStatus(defaultOverallStartup);
                    } else if (healthCheckProcedure.equals("READY")) {
                        hcHttpResponseBuilder.setOverallStatus(defaultOverallReadiness);
                    } else {
                        hcHttpResponseBuilder.setOverallStatus(defaultOverallStartup.equals((Object)HealthCheckResponse.Status.UP) && defaultOverallReadiness.equals((Object)HealthCheckResponse.Status.UP) ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN);
                    }
                    if (!unstartedAppsSet.contains(appName)) {
                        unstartedAppsSet.add(appName);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): unstartedAppsSet after adding the unstarted app : " + unstartedAppsSet), (Object[])new Object[0]);
                    continue;
                }
                hcHttpResponseBuilder.setOverallStatus(HealthCheckResponse.Status.UP);
                continue;
            }
            Set<String> modules = this.appTracker.getModuleNames(appName);
            if (modules == null) continue;
            for (String moduleName : modules) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                }
                try {
                    hcResponses = this.hcExecutor.runHealthChecks(appName, moduleName, healthCheckProcedure);
                }
                catch (HealthCheckBeanCallException healthCheckBeanCallException) {
                    FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"io.openliberty.microprofile.health31.internal.HealthCheck31ServiceImpl", (String)"167", (Object)this, (Object[])new Object[]{request, httpResponse, healthCheckProcedure});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Caught the exception " + e + " for appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                    }
                    hcHttpResponseBuilder.handleUndeterminedResponse(httpResponse);
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): hcResponses = " + hcResponses), (Object[])new Object[0]);
                }
                if (hcResponses.isEmpty()) continue;
                hcHttpResponseBuilder.addResponses(hcResponses);
            }
        }
        if (unstartedAppsSet.isEmpty()) {
            this.unstartedAppsCounter.set(0);
        } else if (!unstartedAppsSet.isEmpty() && this.unstartedAppsCounter.get() != unstartedAppsSet.size()) {
            this.unstartedAppsCounter.set(unstartedAppsSet.size());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps after unstarted app set was updated. = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (!unstartedAppsSet.isEmpty()) {
                this.readinessWarningAlreadyShown.set(false);
                this.startupWarningAlreadyShown.set(false);
            } else {
                this.readinessWarningAlreadyShown.set(true);
                this.startupWarningAlreadyShown.set(true);
            }
        }
        if (!unstartedAppsSet.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): numOfUnstartedApps = " + this.unstartedAppsCounter.get()), (Object[])new Object[0]);
            }
            if (healthCheckProcedure.equals("START") && this.startupWarningAlreadyShown.compareAndSet(false, true) && !defaultOverallStartup.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"startup.healthcheck.applications.not.started.down.CWMMH0054W", (Object[])new Object[]{unstartedAppsSet});
            } else if (healthCheckProcedure.equals("READY") && this.readinessWarningAlreadyShown.compareAndSet(false, true) && !defaultOverallReadiness.equals((Object)HealthCheckResponse.Status.UP)) {
                Tr.warning((TraceComponent)tc, (String)"readiness.healthcheck.applications.not.started.down.CWMMH0053W", (Object[])new Object[]{unstartedAppsSet});
            }
        }
        if (anyAppsInstalled && !healthCheckProcedure.equals("LIVE")) {
            hcHttpResponseBuilder.setOverallStatus(HealthCheckResponse.Status.DOWN);
        }
        hcHttpResponseBuilder.setHttpResponse(httpResponse);
    }

    @Override
    public void removeModuleReferences(String appName, String moduleName) {
        if (this.hcExecutor != null) {
            this.hcExecutor.removeModuleReferences(appName, moduleName);
        }
    }
}

