/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.ExtendedTransactionManager;
import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTranManagerSet;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.TMService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.JTMConfigurationProvider;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.tx.UOWEventListener;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAResource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={TransactionManager.class, EmbeddableWebSphereTransactionManager.class, UOWCurrent.class, ServerQuiesceListener.class}, immediate=true)
public class TransactionManagerService
implements ExtendedTransactionManager,
TransactionManager,
EmbeddableWebSphereTransactionManager,
UOWCurrent,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(TransactionManagerService.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private boolean isClient;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    boolean xaFlowCallbacksInitialised;
    private final AtomicBoolean addRestoreHook = new AtomicBoolean(true);
    private final AtomicBoolean deferRecoveryAtRestore = new AtomicBoolean(false);
    static final long serialVersionUID = -8880666654901510028L;

    private EmbeddableWebSphereTransactionManager etm() {
        return EmbeddableTransactionManagerFactory.getTransactionManager();
    }

    protected void activate(BundleContext ctxt) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  context " + ctxt), (Object[])new Object[0]);
        }
        if (ctxt.getProperty("wlp.process.type").equals("client")) {
            this.isClient = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not activating Transaction Service: client", (Object[])new Object[0]);
            }
            return;
        }
        EmbeddableTransactionManagerFactory.getTransactionManager();
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        if (cp != null && cp instanceof JTMConfigurationProvider) {
            JTMConfigurationProvider jtmCP = (JTMConfigurationProvider)cp;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"its a jtmconfigurationprovider ", (Object[])new Object[0]);
            }
            jtmCP.setTMS(this);
        }
    }

    @ManualTrace
    public void doStartup(final ConfigurationProvider cp, final boolean isSQLRecoveryLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doStartup with cp: " + cp + " and flag: " + isSQLRecoveryLog), (Object[])new Object[0]);
        }
        if (CheckpointPhase.getPhase().restored()) {
            this.doStartup0(cp, isSQLRecoveryLog);
        } else if (this.addRestoreHook.compareAndSet(true, false)) {
            CheckpointPhase.getPhase().addMultiThreadedHook(new CheckpointHook(){
                static final long serialVersionUID = 9167181674101640436L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void restore() {
                    TransactionManagerService.this.doStartup0(cp, isSQLRecoveryLog);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.transaction.services.TransactionManagerService$1", 1.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doStartup");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void doStartup0(ConfigurationProvider cp, boolean isSQLRecoveryLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doStartup0 with cp: " + cp + " and flag: " + isSQLRecoveryLog), (Object[])new Object[0]);
        }
        if (this.isStarted.compareAndSet(false, true)) {
            String userDirEnv = System.getenv("WLP_USER_DIR");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TMS, WLP_USER_DIR env variable is - " + userDirEnv), (Object[])new Object[0]);
            }
            String serverName = cp.getServerName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TMS, serverName is - " + serverName), (Object[])new Object[0]);
            }
            String hostName = "";
            hostName = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -391605905281598270L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    String theHost = "";
                    try {
                        InetAddress addr = InetAddress.getLocalHost();
                        theHost = addr.getCanonicalHostName().toLowerCase();
                    }
                    catch (UnknownHostException addr) {
                        FFDCFilter.processException((Throwable)addr, (String)"com.ibm.ws.transaction.services.TransactionManagerService$2", (String)"170", (Object)this, (Object[])new Object[0]);
                        theHost = "localhost";
                    }
                    return theHost;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.transaction.services.TransactionManagerService$2", 2.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
                }
            });
            byte[] theApplId = this.createApplicationId(userDirEnv, serverName, hostName);
            cp.setApplId(theApplId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TMS, cp - " + cp + " set applid - " + Util.toHexString((byte[])theApplId)), (Object[])new Object[0]);
            }
            if (!this.xaFlowCallbacksInitialised) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"initialise the XA Flow callbacks", (Object[])new Object[0]);
                }
                XAFlowCallbackControl.initialize();
                this.xaFlowCallbacksInitialised = true;
            }
            if (cp.isRecoverOnStartup()) {
                try {
                    TMHelper.start((boolean)cp.isWaitForRecovery());
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.TransactionManagerService", (String)"195", (Object)this, (Object[])new Object[]{cp, isSQLRecoveryLog});
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.TransactionManagerService.doStartup", (String)"60", (Object)this);
                }
            } else {
                this.deferRecoveryAtRestore.set(CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE && CheckpointPhase.getPhase().restored());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doStartup0");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doDeferredRecoveryAtRestore(ConfigurationProvider cp) {
        if (this.deferRecoveryAtRestore.compareAndSet(true, false) && cp.isRecoverOnStartup()) {
            try {
                TMHelper.start((boolean)cp.isWaitForRecovery());
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.TransactionManagerService", (String)"217", (Object)this, (Object[])new Object[]{cp});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.TransactionManagerService.doDeferredRecoveryAtRestore", (String)"60", (Object)this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void doShutdown(boolean isSQLRecoveryLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doShutdown with flag: " + isSQLRecoveryLog), (Object[])new Object[0]);
        }
        if (isSQLRecoveryLog) {
            try {
                TMHelper.shutdown();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.TransactionManagerService", (String)"237", (Object)this, (Object[])new Object[]{isSQLRecoveryLog});
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.TransactionManagerService.doShutdown", (String)"60", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doShutdown");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
    }

    @Reference
    protected void setTmService(TMService tm) {
    }

    protected void unsetTmService(TMService tm) {
    }

    @Reference(service=UOWEventListener.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void setUOWEventListener(UOWEventListener el) {
        ((UOWCurrent)this.etm()).setUOWEventListener(el);
    }

    public void unsetUOWEventListener(UOWEventListener el) {
        if (ConfigurationProviderManager.getConfigurationProvider() != null) {
            ((UOWCurrent)this.etm()).unsetUOWEventListener(el);
        }
    }

    public boolean delist(XAResource xaRes, int flag) {
        return false;
    }

    public boolean enlist(XAResource xaRes, int recoveryId) throws RollbackException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        return this.etm().enlist(xaRes, recoveryId);
    }

    public int registerResourceInfo(String xaResFactoryClassName, Serializable xaResInfo) {
        if (this.isClient) {
            return -1;
        }
        int ret = this.etm().registerResourceInfo(xaResFactoryClassName, xaResInfo);
        if (!this.xaFlowCallbacksInitialised) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initialise the XA Flow callbacks", (Object[])new Object[0]);
            }
            XAFlowCallbackControl.initialize();
            this.xaFlowCallbacksInitialised = true;
        }
        return ret;
    }

    public int registerResourceInfo(String xaResFactoryClassName, Serializable xaResInfo, int priority) {
        if (this.isClient) {
            return -1;
        }
        int ret = this.etm().registerResourceInfo(xaResFactoryClassName, xaResInfo, priority);
        if (!this.xaFlowCallbacksInitialised) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initialise the XA Flow callbacks", (Object[])new Object[0]);
            }
            XAFlowCallbackControl.initialize();
            this.xaFlowCallbacksInitialised = true;
        }
        return ret;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().begin();
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().begin(timeout);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().commit();
    }

    public int getStatus() throws SystemException {
        if (this.isClient) {
            return 6;
        }
        return this.etm().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        if (this.isClient) {
            return null;
        }
        return this.etm().getTransaction();
    }

    public void resume(Transaction t) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().resume(t);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().setRollbackOnly();
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().setTransactionTimeout(arg0);
    }

    public Transaction suspend() throws SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        return this.etm().suspend();
    }

    public boolean enlist(UOWCoordinator coord, XAResource xaRes, int recoveryId, int branchCoupling) throws RollbackException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        return this.etm().enlist(coord, xaRes, recoveryId, branchCoupling);
    }

    public boolean enlistOnePhase(UOWCoordinator coord, OnePhaseXAResource opXaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        return this.etm().enlistOnePhase(coord, opXaRes);
    }

    public boolean startInactivityTimer(Transaction t, EmbeddableWebSphereTransactionManager.InactivityTimer iat) {
        if (this.isClient) {
            throw new IllegalStateException();
        }
        return this.etm().startInactivityTimer(t, iat);
    }

    public void stopInactivityTimer(Transaction t) {
        if (this.isClient) {
            throw new IllegalStateException();
        }
        this.etm().stopInactivityTimer(t);
    }

    public void registerSynchronization(UOWCoordinator coord, Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().registerSynchronization(coord, sync);
    }

    public void registerSynchronization(UOWCoordinator coord, Synchronization sync, int tier) throws RollbackException, IllegalStateException, SystemException {
        if (this.isClient) {
            throw new SystemException();
        }
        this.etm().registerSynchronization(coord, sync, tier);
    }

    public void completeTxTimeout() throws TransactionRolledbackException {
        this.etm().completeTxTimeout();
    }

    public void registerCallback(UOWScopeCallback callback) {
        if (this.isClient) {
            throw new IllegalStateException();
        }
        this.etm().registerCallback(callback);
    }

    public UOWCoordinator getUOWCoord() {
        if (this.isClient) {
            return null;
        }
        return ((EmbeddableTranManagerSet)this.etm()).getUOWCoord();
    }

    public int getUOWType() {
        if (this.isClient) {
            return 0;
        }
        return ((EmbeddableTranManagerSet)this.etm()).getUOWType();
    }

    public void registerLTCCallback(UOWCallback arg0) {
        if (this.isClient) {
            throw new IllegalStateException();
        }
        ((EmbeddableTranManagerSet)this.etm()).registerLTCCallback(arg0);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private byte[] createApplicationId(String userDir, String serverName, String hostName) {
        byte[] result;
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createApplicationId", (Object[])new Object[]{userDir, serverName, hostName});
        }
        try {
            String s = userDir + serverName + hostName + System.currentTimeMillis();
            result = MessageDigest.getInstance("SHA").digest(s.getBytes());
        }
        catch (Throwable s) {
            void t;
            FFDCFilter.processException((Throwable)s, (String)"com.ibm.ws.transaction.services.TransactionManagerService", (String)"543", (Object)this, (Object[])new Object[]{userDir, serverName, hostName});
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.transaction.createApplicationId", (String)"608", (Object)this);
            String tempStr = "j" + System.currentTimeMillis() % 9997L + ":" + userDir + hostName;
            result = tempStr.getBytes();
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createApplicationId", (Object)Util.toHexString((byte[])result));
        }
        return result;
    }

    public void serverStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"serverStopping", (Object[])new Object[]{"Server is stopping"});
        }
        ((EmbeddableTranManagerSet)this.etm()).quiesce();
    }
}

