/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.logging.SensitiveIntrospector;
import io.openliberty.microprofile.config.internal.common.ConfigIntrospectionProvider;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ConfigIntrospector
extends SensitiveIntrospector
implements Introspector {
    @Reference
    private ConfigIntrospectionProvider introspectionProvider;
    private static final Pattern MAYBE_SENSITIVE;
    static final long serialVersionUID = 2899385110297550237L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getIntrospectorName() {
        return "MicroProfileConfig";
    }

    public String getIntrospectorDescription() {
        return "Lists the config properties available to each application via MicroProfile Config";
    }

    public void introspect(PrintWriter pw) {
        Map<String, Set<Config>> configs = this.introspectionProvider.getConfigsByApplication();
        for (Map.Entry<String, Set<Config>> entry : configs.entrySet()) {
            this.introspectApp(pw, entry.getKey(), entry.getValue());
        }
    }

    private void introspectApp(PrintWriter pw, String appName, Set<Config> configs) {
        pw.println();
        pw.println("########################");
        pw.println("Config for " + appName);
        pw.println("########################");
        for (Config config : configs) {
            this.introspectConfig(pw, config);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void introspectConfig(PrintWriter pw, Config config) {
        try {
            pw.println("Config: " + config.toString());
            for (ConfigSource source : config.getConfigSources()) {
                this.introspectConfigSource(pw, source);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.config.internal.common.ConfigIntrospector", (String)"83", (Object)((Object)this), (Object[])new Object[]{pw, config});
            pw.printf("Exception introspecting config: %s", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void introspectConfigSource(PrintWriter pw, ConfigSource source) {
        try {
            pw.printf(" - %s config source (ordinal %d)\n", source.getName(), source.getOrdinal());
            Map properties = source.getProperties();
            if (properties == null) {
                pw.println("     Cannot list properties from this config source because ConfigSource.getProperties() returned null.");
                return;
            }
            for (Map.Entry entry : properties.entrySet()) {
                String obscuredValue = this.getObscuredValue((String)entry.getKey(), entry.getValue());
                pw.printf("   - %s = %s\n", entry.getKey(), obscuredValue);
            }
        }
        catch (Exception properties) {
            void e;
            FFDCFilter.processException((Throwable)properties, (String)"io.openliberty.microprofile.config.internal.common.ConfigIntrospector", (String)"102", (Object)((Object)this), (Object[])new Object[]{pw, source});
            pw.printf("Exception introspecting config source: %s\n", e);
        }
    }

    @Sensitive
    protected String getObscuredValue(String key, Object value) {
        if (MAYBE_SENSITIVE.matcher(key).find()) {
            return "*****";
        }
        return super.getObscuredValue(key, value);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.config.internal.common.ConfigIntrospector", ConfigIntrospector.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.common");
        MAYBE_SENSITIVE = Pattern.compile("password|pass$|pwd|key$", 2);
    }
}

