/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIRuntimeException;
import com.ibm.ws.cdi.internal.interfaces.Resource;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Extension;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.interceptor.WeldInvocationContext;
import org.jboss.weld.resources.spi.ResourceLoadingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CDIUtils {
    private static final TraceComponent tc = Tr.register(CDIUtils.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    public static final String CDI_TRACE_GROUP = "JCDI";
    public static final String CDI_NLS = "com.ibm.ws.cdi.impl.resources.CDI";
    public static final String BDA_FOR_CLASSES_LOADED_BY_ROOT_CLASSLOADER = "BdaForClassesLoadedByRootClassLoader";
    public static final Set<String> BEAN_DEFINING_ANNOTATION_NAMES;
    public static final Set<String> BEAN_DEFINING_META_ANNOTATION_NAMES;
    public static final List<Class<? extends Annotation>> BEAN_DEFINING_ANNOTATIONS;
    public static final List<Class<? extends Annotation>> BEAN_DEFINING_META_ANNOTATIONS;
    public static final String CLASS_EXT = ".class";
    public static final int CLASS_EXT_LENGTH;
    public static final String DOT = ".";
    public static final String BEANS_XML = "beans.xml";
    public static final String WEB_INF = "WEB-INF/";
    public static final String META_INF = "META-INF/";
    public static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    public static final String WEB_INF_CLASSES_META_INF_BEANS_XML = "WEB-INF/classes/META-INF/beans.xml";
    public static final String META_INF_SERVICES = "META-INF/services/";
    public static final String SPI_EXTENSION;
    public static final String META_INF_SERVICES_CDI_EXTENSION;
    public static final String WEB_INF_CLASSES_META_INF_SERVICES_CDI_EXTENSION;
    private static final String IGNORE_INJECTION_FAILURE = "com.ibm.ws.cdi.ignoreInjectionFailure";
    private static final boolean ignoreInjectionFailure;
    static final long serialVersionUID = 684265372184066309L;

    public static boolean isInjectionFailureIgnored() {
        return ignoreInjectionFailure;
    }

    public static Map<String, Class<?>> loadClasses(ClassLoader classLoader, Set<String> classNames) {
        HashMap classes = new HashMap();
        for (String className : classNames) {
            Class<?> clazz = CDIUtils.loadClass(classLoader, className);
            if (clazz == null) continue;
            classes.put(className, clazz);
        }
        return classes;
    }

    @FFDCIgnore(value={Throwable.class})
    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Skipping class which can't be loaded", (Object[])new Object[]{className, classLoader, t});
            }
        }
        return clazz;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> parseServiceSPIExtensionFile(Resource metaInfServicesEntry) {
        HashSet<String> serviceClazz = new HashSet<String>();
        URL metaInfServicesUrl = metaInfServicesEntry == null ? null : metaInfServicesEntry.getURL();
        if (metaInfServicesUrl == null) return serviceClazz;
        InputStream is = null;
        BufferedReader bfReader = null;
        InputStreamReader isReader = null;
        try {
            String line22;
            is = metaInfServicesUrl.openStream();
            isReader = new InputStreamReader(is, StandardCharsets.UTF_8);
            bfReader = new BufferedReader(isReader);
            while ((line22 = bfReader.readLine()) != null) {
                if ((line22 = line22.trim()).isEmpty() || line22.startsWith("#")) continue;
                int hashPos = line22.indexOf("#");
                if (hashPos != -1) {
                    line22 = line22.substring(0, hashPos);
                }
                serviceClazz.add(line22);
            }
        }
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"205", null, (Object[])new Object[]{metaInfServicesEntry});
                throw new CDIRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (isReader != null) {
                        isReader.close();
                    }
                    if (bfReader == null) throw throwable;
                    bfReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"219", null, (Object[])new Object[]{metaInfServicesEntry});
                    throw new CDIRuntimeException((Throwable)e2);
                }
            }
        }
        try {
            if (is != null) {
                is.close();
            }
            if (isReader != null) {
                isReader.close();
            }
            if (bfReader == null) return serviceClazz;
            bfReader.close();
            return serviceClazz;
        }
        catch (IOException line22) {
            FFDCFilter.processException((Throwable)line22, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"219", null, (Object[])new Object[]{metaInfServicesEntry});
            throw new CDIRuntimeException((Throwable)e);
        }
    }

    public static Metadata<Extension> loadExtension(String extensionClass, ClassLoader classloader) {
        Class<Extension> serviceClass = CDIUtils.loadClass(Extension.class, extensionClass, classloader);
        if (serviceClass == null) {
            return null;
        }
        Extension serviceInstance = CDIUtils.prepareInstance(serviceClass);
        if (serviceInstance == null) {
            return null;
        }
        return new MetadataImpl((Object)serviceInstance, extensionClass);
    }

    /*
     * WARNING - void declaration
     */
    public static <S> Class<? extends S> loadClass(Class<S> expectedType, String serviceClassName, ClassLoader classloader) {
        Class<S> serviceClass;
        block6: {
            Class<?> clazz = null;
            serviceClass = null;
            try {
                clazz = classloader.loadClass(serviceClassName);
                serviceClass = clazz.asSubclass(expectedType);
            }
            catch (ResourceLoadingException resourceLoadingException) {
                FFDCFilter.processException((Throwable)resourceLoadingException, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"261", null, (Object[])new Object[]{expectedType, serviceClassName, classloader});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"loadClass()", (Object[])new Object[]{e});
                }
            }
            catch (ClassCastException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"266", null, (Object[])new Object[]{expectedType, serviceClassName, classloader});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"loadClass()", (Object[])new Object[]{e});
                }
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"271", null, (Object[])new Object[]{expectedType, serviceClassName, classloader});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"loadClass()", (Object[])new Object[]{e});
            }
        }
        return serviceClass;
    }

    /*
     * WARNING - void declaration
     */
    public static <S> S prepareInstance(Class<? extends S> serviceClass) {
        try {
            final Constructor<S> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -5029138899539616257L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    constructor.setAccessible(true);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils$2", 2.class, (String)CDIUtils.CDI_TRACE_GROUP, (String)"com.ibm.ws.cdi.internal.resources.CDI");
                }
            });
            return constructor.newInstance(new Object[0]);
        }
        catch (LinkageError constructor) {
            FFDCFilter.processException((Throwable)constructor, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"297", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): Could not instantiate service class " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"303", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"309", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"314", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"319", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (SecurityException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"324", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils", (String)"329", null, (Object[])new Object[]{serviceClass});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareInstance(): The exception happened on loading " + serviceClass.getName()), (Object[])new Object[]{e});
            }
            return null;
        }
    }

    public static void addWiring(WebSphereBeanDeploymentArchive bda1, WebSphereBeanDeploymentArchive bda2) throws CDIException {
        ClassLoader child1CL = bda1.getClassLoader();
        ClassLoader child2CL = bda2.getClassLoader();
        if (CDIUtils.isVisible(child2CL, child1CL)) {
            bda1.addBeanDeploymentArchive(bda2);
        }
        if (CDIUtils.isVisible(child1CL, child2CL)) {
            bda2.addBeanDeploymentArchive(bda1);
        }
    }

    private static boolean isVisible(ClassLoader loaderA, ClassLoader loaderB) {
        return loaderB == loaderA || loaderB.getParent() == loaderA;
    }

    public static ClassLoader getAndSetLoader(ClassLoader newCL) {
        ThreadContextAccessor tca = ThreadContextAccessor.getThreadContextAccessor();
        Object maybeOldCL = tca.pushContextClassLoaderForUnprivileged(newCL);
        if (maybeOldCL instanceof ClassLoader) {
            return (ClassLoader)maybeOldCL;
        }
        return newCL;
    }

    public static boolean isWeldProxy(Class<?> clazz) {
        return ProxyObject.class.isAssignableFrom(clazz);
    }

    public static boolean isWeldProxy(Object obj) {
        Class<?> clazz = obj.getClass();
        boolean result = CDIUtils.isWeldProxy(clazz);
        return result;
    }

    public static Set<Annotation> getInterceptorBindingsFromInvocationContext(InvocationContext invocationContext) throws IllegalArgumentException {
        if (invocationContext instanceof WeldInvocationContext) {
            WeldInvocationContext weldInvocationContext = (WeldInvocationContext)invocationContext;
            return weldInvocationContext.getInterceptorBindings();
        }
        throw new IllegalArgumentException("InvocationContext was not an instance of WeldInvocationContext");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        BEAN_DEFINING_ANNOTATIONS = Arrays.asList(ApplicationScoped.class, SessionScoped.class, ConversationScoped.class, RequestScoped.class, Interceptor.class, Decorator.class, Dependent.class, Model.class);
        BEAN_DEFINING_META_ANNOTATIONS = Arrays.asList(NormalScope.class, Stereotype.class);
        CLASS_EXT_LENGTH = CLASS_EXT.length();
        SPI_EXTENSION = Extension.class.getName();
        META_INF_SERVICES_CDI_EXTENSION = META_INF_SERVICES + SPI_EXTENSION;
        WEB_INF_CLASSES_META_INF_SERVICES_CDI_EXTENSION = WEB_INF_CLASSES + META_INF_SERVICES_CDI_EXTENSION;
        HashSet<String> names = new HashSet<String>();
        for (Class<? extends Annotation> anno : BEAN_DEFINING_ANNOTATIONS) {
            names.add(anno.getName());
        }
        BEAN_DEFINING_ANNOTATION_NAMES = Collections.unmodifiableSet(names);
        HashSet<String> metaNames = new HashSet<String>();
        for (Class<? extends Annotation> anno : BEAN_DEFINING_META_ANNOTATIONS) {
            metaNames.add(anno.getName());
        }
        BEAN_DEFINING_META_ANNOTATION_NAMES = Collections.unmodifiableSet(metaNames);
        ignoreInjectionFailure = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -7550684282199328181L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty(CDIUtils.IGNORE_INJECTION_FAILURE));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.internal.interfaces.CDIUtils$1", 1.class, (String)CDIUtils.CDI_TRACE_GROUP, (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
    }
}

