/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.PagesVersionHandler;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.generator.CleanupTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateJspResult;
import com.ibm.ws.jsp.translator.visitor.generator.GenerateVisitor;
import com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils;
import com.ibm.ws.jsp.translator.visitor.generator.InitTaglibLookupWriter;
import com.ibm.ws.jsp.translator.visitor.generator.JavaFileWriter;
import com.ibm.ws.jsp.translator.visitor.generator.MethodWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class GenerateJspVisitor
extends GenerateVisitor {
    protected GenerateJspResult result;
    protected ArrayList interfaces;
    protected String jspServletBase;
    protected String serviceMethodName;
    protected String jspClassName;
    protected String jspPackageName;
    protected String jspSourceFileName;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GenerateJspVisitor";
    static final long serialVersionUID = 4405131169070902964L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GenerateJspVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap, "JspValidate");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{visitorUsage, jspConfiguration, context, resultMap, inputMap});
        }
        this.result = null;
        this.interfaces = new ArrayList();
        this.jspServletBase = "com.ibm.ws.jsp.runtime.HttpJspBase";
        this.serviceMethodName = "_jspService";
        this.jspClassName = null;
        this.jspPackageName = null;
        this.jspSourceFileName = null;
        this.result = new GenerateJspResult(visitorUsage.getJspVisitorDefinition().getId());
        JspResources jspFiles = (JspResources)inputMap.get("JspFiles");
        this.jspClassName = jspFiles.getClassName();
        this.jspPackageName = jspFiles.getPackageName();
        this.jspSourceFileName = jspFiles.getGeneratedSourceFile().toString();
        this.jspSourceFileName = this.jspSourceFileName.replace('\\', '/');
        this.createWriter(jspFiles.getGeneratedSourceFile().getPath(), this.jspClassName, this.result.getCustomTagMethodJspIdMap());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspVisitorResult getResult() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResult", new Object[0]);
        }
        this.closeWriter();
        GenerateJspResult generateJspResult = this.result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            generateJspResult = generateJspResult;
            logger.exiting(CLASS_NAME, "getResult", generateJspResult);
        }
        return generateJspResult;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void visit(Document jspDocument, int visitCount) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visit", new Object[]{jspDocument, visitCount});
        }
        ValidateJspResult validatorResult = (ValidateJspResult)this.resultMap.get("JspValidate");
        boolean genSessionVariable = validatorResult.isGenSessionVariable();
        switch (visitCount) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase IMPORT_SECTION");
                }
                this.generateImportSection(validatorResult);
                break;
            }
            case 2: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase CLASS_SECTION");
                }
                this.generateClassSection(validatorResult);
                if (!PagesVersionHandler.isPages31Loaded()) break;
                this.generateIsErrorOnELFoundMethod(this.jspConfiguration.errorOnELNotFound());
                this.generateImportGetters();
                break;
            }
            case 3: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase STATIC_SECTION");
                }
                this.generateStaticSection();
                break;
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase INIT_SECTION");
                }
                this.generateInitSection(validatorResult);
                break;
            }
            case 5: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_INIT_SECTION");
                }
                this.generateServiceInitSection(validatorResult, genSessionVariable);
                break;
            }
            case 6: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase METHOD_SECTION");
                }
                this.generateServiceSection(validatorResult, genSessionVariable, jspDocument);
                break;
            }
            case 7: {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "visit", "entering code generation phase FINALLY_SECTION");
                }
                this.generateFinallySection();
            }
        }
        super.visit(jspDocument, visitCount);
        if (visitCount == 7) {
            this.writer.println("}");
            this.writer.println("}");
            boolean poolingTagMethodsCreated = false;
            for (MethodWriter methodWriter : this.methodWriterList) {
                MethodWriter w;
                if (methodWriter instanceof InitTaglibLookupWriter) {
                    w = (InitTaglibLookupWriter)methodWriter;
                    ((InitTaglibLookupWriter)w).complete();
                    poolingTagMethodsCreated = true;
                } else if (methodWriter instanceof CleanupTaglibLookupWriter) {
                    w = (CleanupTaglibLookupWriter)methodWriter;
                    ((CleanupTaglibLookupWriter)w).complete();
                }
                this.writer.printMultiLn(methodWriter.toString());
            }
            if ((this.jspOptions.isUsePageTagPool() || this.jspOptions.isUseThreadTagPool()) && !poolingTagMethodsCreated) {
                InitTaglibLookupWriter initTaglibLookupWriter = new InitTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                initTaglibLookupWriter.complete();
                this.writer.printMultiLn(initTaglibLookupWriter.toString());
                CleanupTaglibLookupWriter cleanupTaglibLookupWriter = new CleanupTaglibLookupWriter(this.jspOptions.isUseThreadTagPool());
                cleanupTaglibLookupWriter.complete();
                this.writer.printMultiLn(cleanupTaglibLookupWriter.toString());
            }
            if (this.fragmentHelperClassWriter.isUsed()) {
                this.fragmentHelperClassWriter.generatePostamble();
                this.writer.printMultiLn(this.fragmentHelperClassWriter.toString());
            }
            this.writer.println("}");
            if (this.jspOptions.isKeepGenerated()) {
                this.writer.println("/*");
                this.writer.println(this.jspSourceFileName + " was generated @ " + new Date());
                this.writer.println(GeneratorUtils.fullClassfileInformation);
                this.writer.println(" ");
                this.writer.println("********************************************************");
                this.writer.println("The JSP engine configuration parameters were set as follows:");
                this.writer.println(this.jspOptions.toString());
                this.writer.println("********************************************************");
                this.writer.println("The following JSP Configuration Parameters were obtained from web.xml:");
                this.writer.println(" ");
                this.writer.println("prelude list = [" + this.jspConfiguration.getPreludeList() + "]");
                this.writer.println("coda list = [" + this.jspConfiguration.getCodaList() + "]");
                this.writer.println("elIgnored = [" + this.jspConfiguration.elIgnored() + "]");
                this.writer.println("pageEncoding = [" + this.jspConfiguration.getPageEncoding() + "]");
                this.writer.println("isXML = [" + this.jspConfiguration.isXml() + "]");
                this.writer.println("scriptingInvalid = [" + this.jspConfiguration.scriptingInvalid() + "]");
                this.writer.println("trimDirectiveWhitespaces = [" + this.jspConfiguration.isTrimDirectiveWhitespaces() + "]");
                this.writer.println("deferredSyntaxAllowedAsLiteral = [" + this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral() + "]");
                this.writer.println("*/");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visit");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void generateIsErrorOnELFoundMethod(boolean flag) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateIsErrorOnELFoundMethod", new Object[]{flag});
        }
        this.writer.println("public boolean isErrorOnELNotFound() {");
        this.writer.println("return " + flag + ";");
        this.writer.println("}");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateIsErrorOnELFoundMethod");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void generateImportGetters() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateImportGetters", new Object[0]);
        }
        this.writer.println("public java.util.List<String> getImportClassList() {");
        this.writer.println("return importClassList;");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public java.util.List<String> getImportPackageList() {");
        this.writer.println("return importPackageList;");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public java.util.List<String> getImportStaticList() {");
        this.writer.println("return importStaticList;");
        this.writer.println("}");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateImportGetters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateImportSection(ValidateJspResult validatorResult) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateImportSection", new Object[]{validatorResult});
        }
        String servletPackageName = this.jspPackageName;
        this.writer.println("package " + servletPackageName + ";");
        this.writer.println();
        for (int i = 0; i < Constants.STANDARD_IMPORTS.length; ++i) {
            this.writer.println("import " + Constants.STANDARD_IMPORTS[i] + ";");
        }
        this.writer.println();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateImportSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateClassSection(ValidateJspResult validatorResult) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateClassSection", new Object[]{validatorResult});
        }
        this.writer.println();
        this.writer.print("public final class " + this.jspClassName + " extends ");
        String extendsClass = validatorResult.getExtendsClass();
        this.writer.print(extendsClass == null ? this.jspServletBase : extendsClass);
        this.interfaces.add("com.ibm.ws.jsp.runtime.JspClassInformation");
        if (PagesVersionHandler.isPages31OrHigherLoaded()) {
            this.interfaces.add("com.ibm.ws.jsp.runtime.DirectiveInfo");
        }
        boolean singleThreaded = validatorResult.isSingleThreaded();
        if (PagesVersionHandler.isPages30OrLowerLoaded()) {
            if (singleThreaded) {
                this.interfaces.add("SingleThreadModel");
            }
        } else if (singleThreaded) {
            logger.logp(Level.WARNING, CLASS_NAME, "generateClassSection", "jsp.isthreadsafe.warning");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.print("     implements");
            for (int i = 0; i < this.interfaces.size() - 1; ++i) {
                this.writer.print(" " + this.interfaces.get(i) + ",");
            }
            this.writer.print(" " + this.interfaces.get(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.println();
        GeneratorUtils.generateFactoryInitialization(this.writer, this.jspConfiguration.getConfigManager().isJCDIEnabled());
        this.writer.println();
        GeneratorUtils.generateDependencyList(this.writer, validatorResult, this.context, this.jspOptions.isTrackDependencies());
        this.writer.println();
        if (!this.jspOptions.isDisableResourceInjection()) {
            GeneratorUtils.generateInjectionSection(this.writer);
        }
        this.writer.println();
        GeneratorUtils.generateVersionInformation(this.writer, this.jspOptions.isDebugEnabled());
        this.writer.println();
        this.writer.println("private boolean _jspx_isJspInited = false;");
        this.writer.println();
        if (PagesVersionHandler.isPages31OrHigherLoaded()) {
            this.writer.println();
            this.writer.println("private static java.util.List<String> importPackageList = new java.util.ArrayList<String>();");
            this.writer.println("private static java.util.List<String> importClassList = new java.util.ArrayList<String>();");
            this.writer.println("private static java.util.List<String> importStaticList = new java.util.ArrayList<String>();");
            this.writer.println();
            this.writer.println("static {");
            this.writer.println("importPackageList.add(\"jakarta.servlet\");");
            this.writer.println("importPackageList.add(\"jakarta.servlet.jsp\");");
            this.writer.println("importPackageList.add(\"jakarta.servlet.http\");");
            this.writer.println("}");
        }
        if (validatorResult.getInfo() != null) {
            this.writer.println();
            this.writer.println("public String getServletInfo() {");
            this.writer.print("return ");
            this.writer.print(GeneratorUtils.quote(validatorResult.getInfo()));
            this.writer.println(";");
            this.writer.print("}");
            this.writer.println();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateClassSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateStaticSection() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateStaticSection", new Object[0]);
        }
        this.writer.println();
        this.writer.println("static {");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateStaticSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateInitSection(ValidateJspResult validatorResult) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateInitSection", new Object[]{validatorResult});
        }
        this.writer.println("}");
        this.writer.println();
        GeneratorUtils.generateInitSectionCode(this.writer, GeneratorUtils.JSP_FILE_TYPE, this.jspOptions);
        this.writer.println();
        GeneratorUtils.generateELFunctionCode(this.writer, validatorResult);
        this.writer.println();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateInitSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateServiceInitSection(ValidateJspResult validatorResult, boolean genSessionVariable) {
        boolean isErrorPage;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateServiceInitSection", new Object[]{validatorResult, genSessionVariable});
        }
        this.writer.println();
        String sync = "";
        if (PagesVersionHandler.isPages31OrHigherLoaded() && validatorResult.isSingleThreaded()) {
            sync = " synchronized";
        }
        this.writer.println("public" + sync + " void " + this.serviceMethodName + "(HttpServletRequest request, HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.println();
        this.result.setServiceMethodLineNumber(((JavaFileWriter)this.writer).getCurrentLineNumber());
        this.writer.println("PageContext pageContext = null;");
        if (genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (isErrorPage = validatorResult.isErrorPage()) {
            this.writer.println("Throwable exception = org.apache.jasper.runtime.JspRuntimeLibrary.getThrowable(request);");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println();
        this.writer.println("JspWriter _jspx_out = null;");
        this.writer.println();
        this.writer.println();
        this.writer.println("if(!_jspx_isJspInited){");
        this.writer.println("this._jspInit();");
        this.writer.println("}");
        this.writer.println();
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup();");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("java.util.HashMap _jspx_TagLookup = initTaglibLookup(request);");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateServiceInitSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateServiceSection(ValidateJspResult validatorResult, boolean genSessionVariable, Document jspDocument) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateServiceSection", new Object[]{validatorResult, genSessionVariable, jspDocument});
        }
        this.writer.println();
        this.writer.println("try {");
        this.writer.println();
        String contentType = validatorResult.getContentType();
        boolean autoResponseEncoding = this.jspOptions.isAutoResponseEncoding();
        if (contentType == null) {
            contentType = this.jspConfiguration.isXml() ? "text/xml" : "text/html";
        }
        if (contentType.indexOf("charset=") < 0) {
            if (this.jspConfiguration.isXml()) {
                if (!autoResponseEncoding) {
                    contentType = contentType + ";charset=UTF-8";
                }
            } else {
                String pageEncoding = validatorResult.getPageEncoding();
                if (pageEncoding != null && !pageEncoding.equals("")) {
                    contentType = contentType + ";charset=" + pageEncoding;
                } else {
                    String responseEncoding = this.jspConfiguration.getResponseEncoding();
                    if (responseEncoding != null && !responseEncoding.equals("")) {
                        contentType = contentType + ";charset=" + responseEncoding;
                    } else {
                        logger.logp(Level.FINEST, CLASS_NAME, "generateServiceSection", "JSP did not specify charset; defer to webcontainer");
                    }
                }
            }
        }
        this.writer.println("response.setContentType(" + this.writer.quoteString(contentType) + ");");
        String error = validatorResult.getError();
        int bufferSize = validatorResult.getBufferSize();
        boolean autoFlush = validatorResult.isAutoFlush();
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response, " + this.writer.quoteString(error) + ", " + genSessionVariable + ", " + bufferSize + ", " + autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
        this.writer.println("_jspx_out = out;");
        this.writer.println();
        this.writer.println("pageContext.setAttribute(\"_jspx_ExpressionFactoryImplObject\", _el_expressionfactory);");
        if (this.jspConfiguration.isXml()) {
            boolean omitXmlDeclaration = false;
            if (jspDocument.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "root").getLength() > 0) {
                omitXmlDeclaration = true;
            }
            Element outputElement = null;
            if (jspDocument.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").getLength() > 0) {
                outputElement = (Element)jspDocument.getDocumentElement().getElementsByTagNameNS("http://java.sun.com/JSP/Page", "output").item(0);
                String s = outputElement.getAttribute("omit-xml-declaration");
                if (s.equalsIgnoreCase("no") || s.equalsIgnoreCase("false")) {
                    omitXmlDeclaration = false;
                } else if (s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("true")) {
                    omitXmlDeclaration = true;
                }
            }
            if (!omitXmlDeclaration) {
                String pageEncoding = validatorResult.getPageEncoding();
                if ((pageEncoding == null || pageEncoding.equals("")) && ((pageEncoding = this.jspConfiguration.getPageEncoding()) == null || pageEncoding.equals(""))) {
                    pageEncoding = "UTF-8";
                }
                this.writer.println("out.write(\"<?xml version=\\\"1.0\\\" encoding=\\\"" + pageEncoding + "\\\"?>\\n\");");
            }
            String doctype = "";
            if (outputElement != null) {
                doctype = outputElement.getAttribute("doctype-root-element");
            }
            if (outputElement != null && !doctype.equals("")) {
                String docTypeRootElement = outputElement.getAttribute("doctype-root-element");
                String docTypeSystem = outputElement.getAttribute("doctype-system");
                String docTypePublic = outputElement.getAttribute("doctype-public");
                this.writer.print("out.write(\"<!DOCTYPE " + docTypeRootElement);
                if (!docTypePublic.equals("")) {
                    this.writer.print(" PUBLIC \\\"" + docTypePublic + "\\\" \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                } else {
                    this.writer.print(" SYSTEM \\\"" + docTypeSystem + "\\\">\\n\");");
                    this.writer.println();
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateServiceSection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void generateFinallySection() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateFinallySection", new Object[0]);
        }
        this.writer.println();
        this.writer.println("} catch (Throwable t) {");
        this.writer.println("if (!(t instanceof javax.servlet.jsp.SkipPageException)){");
        this.writer.println("out = _jspx_out;");
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.println("out.clearBuffer();");
        this.writer.println("if (pageContext != null) pageContext.handlePageException(t);");
        this.writer.println("}");
        this.writer.println("else if (t instanceof com.ibm.ws.jsp.runtime.WsSkipPageException){");
        this.writer.println("((com.ibm.ws.jsp.runtime.WsSkipPageException)t).printStackTraceIfTraceEnabled();");
        this.writer.println("}");
        this.writer.println("} finally {");
        this.writer.println("_jspxFactory.releasePageContext(pageContext);");
        if (this.jspOptions.isUsePageTagPool()) {
            this.writer.println("cleanupTaglibLookup(_jspx_TagLookup);");
        } else if (this.jspOptions.isUseThreadTagPool()) {
            this.writer.println("cleanupTaglibLookup(request, _jspx_TagLookup);");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateFinallySection");
        }
    }
}

