/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpServiceContextImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOSCBodyReadCallback;
import com.ibm.ws.http.channel.internal.outbound.HttpOSCReadAhead;
import com.ibm.ws.http.channel.internal.outbound.HttpOSCReadCallback;
import com.ibm.ws.http.channel.internal.outbound.HttpOSCWriteCallback;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundLink;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.exception.IllegalRequestObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import java.io.IOException;

public class HttpOutboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpOutboundServiceContext {
    private static final TraceComponent tc = Tr.register(HttpOutboundServiceContextImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected static final int CALLBACK_STATE_IDLE = 0;
    protected static final int CALLBACK_STATE_PENDING = 1;
    protected static final int CALLBACK_STATE_ERROR = 2;
    protected static final int CALLBACK_STATE_COMPLETE = 4;
    protected static final int READ_STATE_IDLE = 0;
    protected static final int READ_STATE_TIME_RESET = 1;
    protected static final int READ_STATE_SYNC = 3;
    protected static final int READ_STATE_ASYNC = 4;
    private HttpOutboundLink myLink = null;
    private int[] positionList = null;
    private int callback_state = 0;
    private int read_state = 0;
    private final Object readAheadSyncer = new Object(){};
    protected Object stateSyncObject = new Object(){};
    private IOException readException = null;
    private boolean bReadAheadEnabled = false;
    private boolean bImmediateRead = false;
    private boolean bTempResponsesUsed = false;
    private boolean bEarlyReads = false;
    private int numResponsesReceived = 0;

    public HttpOutboundServiceContextImpl(TCPConnectionContext tsc, HttpOutboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        this.init(tsc, link, vc, hcc);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.positionList = new int[this.getPendingBuffers().length];
    }

    public void init(TCPConnectionContext tsc, HttpOutboundLink link, VirtualConnection vc, HttpChannelConfig hcc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing OSC: " + this), (Object[])new Object[0]);
        }
        this.init(tsc, hcc);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.setLink(link);
        this.setVC(vc);
        this.getVC().getStateMap().put(CallbackIDs.CALLBACK_HTTPOSC, this);
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying OSC: " + this), (Object[])new Object[0]);
        }
        this.getVC().getStateMap().remove(CallbackIDs.CALLBACK_HTTPOSC);
        super.destroy();
        this.myLink = null;
        this.readException = null;
    }

    @Override
    public void clear() {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clearing OSC: " + this), (Object[])new Object[0]);
            }
            if (null != this.getLink()) {
                this.getLink().clear();
            }
            if (this.getHttpConfig().shouldPurgeRemainingResponseBody()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempting to purge remaining response body", (Object[])new Object[0]);
                }
                try {
                    WsByteBuffer remainingData = this.getResponseBodyBuffer();
                    while (remainingData != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found data remaining on the response: " + remainingData), (Object[])new Object[0]);
                        }
                        remainingData.release();
                        remainingData = null;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Remaining response data released, reading for more", (Object[])new Object[0]);
                        }
                        remainingData = this.getResponseBodyBuffer();
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("Encountered an exception while reading for remaining response data: " + e), (Object[])new Object[0]);
                }
            }
        }
        super.clear();
        this.setReadBuffer(null);
        this.getTSC().getReadInterface().setBuffers(null);
        this.callback_state = 0;
        this.read_state = 0;
        this.readException = null;
        this.bReadAheadEnabled = false;
        this.bImmediateRead = false;
        this.bTempResponsesUsed = false;
        this.bEarlyReads = false;
        this.numResponsesReceived = 0;
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().remove("HTTPFinalWrite");
        }
    }

    protected void reConnect(VirtualConnection inVC, IOException ioe) {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempting reconnect: " + this.getLink().getVirtualConnection()), (Object[])new Object[0]);
            }
            this.getTSC().getReadInterface().setBuffer(null);
            this.getLink().reConnectAsync(ioe);
        } else {
            this.callErrorCallback(inVC, ioe);
        }
    }

    void callErrorCallback(VirtualConnection inVC, IOException ioe) {
        this.setPersistent(false);
        if (this.bEarlyReads && null != this.getAppReadCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Early read failure calling error() on appside", (Object[])new Object[0]);
            }
            this.getAppReadCallback().error(inVC, (Throwable)ioe);
        } else if (null != this.getAppWriteCallback()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling write.error() on appside", (Object[])new Object[0]);
            }
            this.getAppWriteCallback().error(inVC, (Throwable)ioe);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No appside, closing connection", (Object[])new Object[0]);
            }
            this.getLink().getDeviceLink().close(inVC, (Exception)ioe);
        }
    }

    protected void reConnect(IOException originalExcep) throws IOException {
        if (this.getLink().isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempting synchronous reconnect", (Object[])new Object[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reconnect sync not allowed", (Object[])new Object[0]);
            }
            this.setPersistent(false);
            throw originalExcep;
        }
        this.getTSC().getReadInterface().setBuffer(null);
        this.getLink().reConnectSync(originalExcep);
        this.nowReconnectedSync(originalExcep);
    }

    @Override
    protected WsByteBuffer[] getBuffList() {
        int start;
        if (!this.getLink().isReconnectAllowed()) {
            return super.getBuffList();
        }
        int stop = this.getPendingStop();
        int size = stop - (start = this.getPendingStart());
        if (0 == size) {
            return null;
        }
        WsByteBuffer[] buffs = this.getPendingBuffers();
        WsByteBuffer[] list = new WsByteBuffer[size];
        if (this.positionList.length < buffs.length) {
            int[] newList = new int[buffs.length];
            System.arraycopy(this.positionList, 0, newList, 0, this.positionList.length);
            this.positionList = newList;
        }
        int i = start;
        for (int x = 0; x < size; ++x) {
            list[x] = buffs[i];
            this.positionList[i] = buffs[i].position();
            ++i;
        }
        this.setPendingStart(stop);
        return list;
    }

    private boolean resetWriteBuffers() {
        int stop = this.getPendingStop();
        WsByteBuffer[] list = this.getPendingBuffers();
        if (null == this.positionList || null == list) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error in resetBuffers: posList: " + this.positionList + " list: " + list), (Object[])new Object[0]);
            }
            this.getTSC().getWriteInterface().setBuffer(null);
            return false;
        }
        for (int i = 0; i < stop; ++i) {
            list[i].position(this.positionList[i]);
        }
        this.getTSC().getWriteInterface().setBuffers(list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reset positions on (" + stop + ") write buffers"), (Object[])new Object[0]);
        }
        return true;
    }

    protected void nowReconnectedAsync() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reconnected async for " + this), (Object[])new Object[0]);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resetting buffers (async) failed", (Object[])new Object[0]);
            }
            IOException ioe = new IOException("Failed reconnect");
            if (null != this.getAppWriteCallback()) {
                this.getAppWriteCallback().error(this.getVC(), (Throwable)ioe);
            } else {
                this.getLink().getDeviceLink().close(this.getVC(), (Exception)ioe);
            }
            return;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        this.resetRead();
        VirtualConnection rc = this.getTSC().getWriteInterface().write(-1L, (TCPWriteCompletedCallback)HttpOSCWriteCallback.getRef(), this.isForceAsync(), this.getWriteTimeout());
        if (null != rc) {
            if (!this.isMessageSent()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling callback.complete of app channel.", (Object[])new Object[0]);
                }
                this.getAppWriteCallback().complete(this.getLink().getVirtualConnection());
            } else {
                if (this.isReadAheadEnabled()) {
                    this.bReadAheadEnabled = false;
                }
                this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
                this.getTSC().getReadInterface().read(1L, (TCPReadCompletedCallback)HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
            }
        }
    }

    protected void nowReconnectedSync(IOException originalExcep) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reconnected sync for " + this), (Object[])new Object[0]);
        }
        if (!this.resetWriteBuffers()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resetting buffers (sync) failed", (Object[])new Object[0]);
            }
            throw originalExcep;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        if (this.isReadAheadEnabled()) {
            this.bReadAheadEnabled = false;
        }
        try {
            this.getTSC().getWriteInterface().write(-1L, this.getWriteTimeout());
        }
        catch (IOException ioe) {
            this.setPersistent(false);
            throw ioe;
        }
    }

    @Override
    public boolean disallowRewrites() {
        boolean rc = this.getLink().disallowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Rewrites disabled: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public boolean allowRewrites() {
        boolean rc = this.getLink().allowRewrites();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Rewrites enabled: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public boolean isInboundConnection() {
        return false;
    }

    @Override
    protected boolean isCompressionAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCompressionAllowed", (Object[])new Object[0]);
        }
        boolean rc = true;
        if (!this.getRequest().getVersionValue().equals(VersionValues.V11)) {
            boolean bl = rc = !this.isPartialBody();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isCompressionAllowed: " + rc));
        }
        return rc;
    }

    private VirtualConnection startEarlyRead(InterChannelCallback cb, boolean forceQueue) {
        this.getLink().disallowRewrites();
        this.setAppReadCallback(cb);
        if (this.headersParsed() && !this.getResponseImpl().isTemporaryStatusCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"earlyRead: Final response already received.", (Object[])new Object[0]);
            }
            if (forceQueue) {
                cb.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("earlyRead: Message exists, isOwner: " + this.isResponseOwner()), (Object[])new Object[0]);
            }
            this.resetMsgParsedState();
            if (!this.isResponseOwner()) {
                this.setMyResponse(null);
                this.getResponseImpl();
            } else {
                this.getResponseImpl().clear();
            }
        }
        VirtualConnection vc = this.parseResponseMessageAsync();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("earlyRead: return vc=" + vc), (Object[])new Object[0]);
        }
        if (null != vc && forceQueue) {
            cb.complete(this.getVC());
            return null;
        }
        return vc;
    }

    @Override
    public VirtualConnection readNextResponse(InterChannelCallback cb, boolean forceQueue) {
        if (null == cb) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readNext: Invalid null callback as input.", (Object[])new Object[0]);
            }
            throw new NullPointerException("Null callback");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App channel requesting next response on " + this.getVC()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Async forcequeue flag is " + forceQueue), (Object[])new Object[0]);
        }
        this.bTempResponsesUsed = true;
        return this.startEarlyRead(cb, forceQueue);
    }

    @Override
    public void registerEarlyRead(InterChannelCallback cb) {
        if (null == cb) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"registerEarlyRead: Invalid null callback as input.", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException("Callback is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App channel requesting early response read on " + this.getVC()), (Object[])new Object[0]);
        }
        this.bEarlyReads = true;
        this.startEarlyRead(cb, true);
    }

    @Override
    public boolean deregisterEarlyRead() {
        if (!this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"User tried to deregister non-existent early read", (Object[])new Object[0]);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"User deregistering early read interest", (Object[])new Object[0]);
        }
        this.bEarlyReads = false;
        super.cancelOutstandingRead();
        if (this.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error: full request already sent", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected boolean isEarlyRead() {
        return this.bEarlyReads;
    }

    public void readAsyncResponse() {
        VirtualConnection vc = null;
        if (!this.isReadDataAvailable() && null == this.getNextReadBuffer()) {
            this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            vc = this.getTSC().getReadInterface().read(1L, (TCPReadCompletedCallback)HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readAsyncResponse found existing data", (Object[])new Object[0]);
            }
            vc = this.getVC();
        }
        if (null != vc && null != this.parseResponseMessageAsync()) {
            this.handleParsedMessage();
        }
    }

    public void readSyncResponse() throws IOException {
        do {
            this.parseResponseMessageSync();
            int code = this.getResponse().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readSyncReponse: code is " + code), (Object[])new Object[0]);
            }
            if (this.isImmediateReadEnabled()) {
                return;
            }
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                return;
            }
            if (this.bTempResponsesUsed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"readSyncResponse: using temp response", (Object[])new Object[0]);
                }
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != code) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expect 100-continue failed with " + code), (Object[])new Object[0]);
                    }
                    this.setPersistent(false);
                    throw new ExpectationFailedException(code + " " + this.getResponseImpl().getReasonPhrase());
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    this.resetRead();
                    return;
                }
            }
            this.resetRead();
        } while (this.numberResponsesReceived() <= this.getHttpConfig().getLimitOnNumberOfResponses());
        this.setPersistent(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readSyncResponse: too many responses: " + this.numberResponsesReceived()), (Object[])new Object[0]);
        }
        throw new IOException("Max temp responses received: " + this.numberResponsesReceived());
    }

    @Override
    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    private final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
        }
        return this.getMyRequest();
    }

    @Override
    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    private final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
            this.getMyResponse().setLimitOfTokenSize(this.getMyRequest().getLimitOfTokenSize());
            this.getMyResponse().setLimitOnNumberOfHeaders(this.getMyRequest().getLimitOnNumberOfHeaders());
        }
        return this.getMyResponse();
    }

    @Override
    public void setRequest(HttpRequestMessage msg) throws IllegalRequestObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setRequest: " + msg), (Object[])new Object[0]);
        }
        if (null == msg) {
            throw new IllegalRequestObjectException("Illegal null message");
        }
        HttpRequestMessageImpl temp = null;
        try {
            temp = (HttpRequestMessageImpl)msg;
        }
        catch (ClassCastException cce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non msg impl passed to setRequest", (Object[])new Object[0]);
            }
            throw new IllegalRequestObjectException("Invalid message provided");
        }
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            if (!this.getMyRequest().equals(temp)) {
                this.getMyRequest().destroy();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caller overlaying same message", (Object[])new Object[0]);
            }
        }
        this.setMyRequest(temp);
        VersionValues version = temp.getVersionValue();
        this.getMyRequest().init(this);
        this.getMyRequest().setVersion(version);
        this.updatePersistence(this.getMyRequest());
        this.getResponseImpl().setHeaderChangeLimit(this.getMyRequest().getHeaderChangeLimit());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRequest");
        }
    }

    @Override
    public void sendRequestHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestHeaders(sync)", (Object[])new Object[0]);
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.setPartialBody(true);
        this.getLink().setAllowReconnect(true);
        try {
            this.sendHeaders(this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (this.shouldReadResponseImmediately()) {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRequestHeaders(sync)");
        }
    }

    @Override
    public VirtualConnection sendRequestHeaders(InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestHeaders(async)", (Object[])new Object[0]);
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.setPartialBody(true);
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendHeaders(this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != vc && this.shouldReadResponseImmediately()) {
            vc = this.startResponseRead();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRequestHeaders(async): " + vc));
        }
        return vc;
    }

    @Override
    public void sendRequestBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestBody(sync)", (Object[])new Object[0]);
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body true", (Object[])new Object[0]);
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendOutgoing(body, this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRequestBody(sync)");
        }
    }

    @Override
    public VirtualConnection sendRequestBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestBody(async)", (Object[])new Object[0]);
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body true", (Object[])new Object[0]);
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bForce);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendOutgoing(body, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRequestBody(async): " + vc));
        }
        return vc;
    }

    @Override
    public void sendRawRequestBody(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawRequestBody(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        this.sendRequestBody(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRawRequestBody(sync)");
        }
    }

    @Override
    public VirtualConnection sendRawRequestBody(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawRequestBody(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.sendRequestBody(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRawRequestBody(async): " + vc));
        }
        return vc;
    }

    @Override
    public void finishRequestMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRequestMessage(sync)", (Object[])new Object[0]);
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body false", (Object[])new Object[0]);
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendFullOutgoing(body, this.getRequestImpl());
        }
        catch (IOException e) {
            this.reConnect(e);
        }
        if (this.bEarlyReads) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(sync): early read is active");
            }
            return;
        }
        if (this.headersParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response headers already parsed", (Object[])new Object[0]);
            }
            if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(sync): already parsed");
                }
                return;
            }
            this.resetRead();
            this.readSyncResponse();
        } else {
            this.startResponseReadSync();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(sync)");
        }
    }

    @Override
    public VirtualConnection finishRequestMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRequestMessage(async)", (Object[])new Object[0]);
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body false", (Object[])new Object[0]);
            }
            this.setPartialBody(false);
        }
        if (this.getHttpConfig().runningOnZOS()) {
            this.getVC().getStateMap().put("HTTPFinalWrite", "true");
        }
        this.setForceAsync(bForce);
        this.getLink().setAllowReconnect(true);
        this.setAppWriteCallback(callback);
        VirtualConnection vc = this.sendFullOutgoing(body, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != vc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request write completed immediately.", (Object[])new Object[0]);
            }
            if (this.bEarlyReads) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(async): early read is active");
                }
                return this.getVC();
            }
            if (this.headersParsed()) {
                if (this.bTempResponsesUsed || !this.getResponseImpl().isTemporaryStatusCode()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(async): already parsed");
                    }
                    return this.getVC();
                }
                this.resetRead();
                this.readAsyncResponse();
                vc = null;
            } else {
                vc = this.startResponseRead();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finishRequestMessage(async): " + vc));
        }
        return vc;
    }

    @Override
    public void finishRawRequestMessage(WsByteBuffer[] body) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawRequestMessage(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        this.finishRequestMessage(body);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawRequestMessage(sync)");
        }
    }

    @Override
    public VirtualConnection finishRawRequestMessage(WsByteBuffer[] body, InterChannelCallback callback, boolean bForce) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawRequestMessage(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.finishRequestMessage(body, callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawRequestMessage(async)");
        }
        return vc;
    }

    private HttpInvalidMessageException checkRequestValidity() {
        if (this.shouldReadResponseImmediately()) {
            return null;
        }
        long len = this.getRequest().getContentLength();
        long num = this.getNumBytesWritten();
        if (-1L != len && num != len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Request had content-length of " + len + " but sent " + num), (Object[])new Object[0]);
            }
            this.setPersistent(false);
            return new HttpInvalidMessageException("Request length " + len + " but sent " + num);
        }
        return null;
    }

    protected void handleParsedMessage() {
        InterChannelCallback cb = null;
        cb = this.bEarlyReads || this.bTempResponsesUsed ? this.getAppReadCallback() : this.getAppWriteCallback();
        VirtualConnection vc = null;
        do {
            ++this.numResponsesReceived;
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Notifying app channel of final response.", (Object[])new Object[0]);
                }
                cb.complete(this.getVC());
                return;
            }
            int code = this.getResponseImpl().getStatusCodeAsInt();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received response (#" + this.numberResponsesReceived() + "): " + code), (Object[])new Object[0]);
            }
            if (this.numberResponsesReceived() > this.getHttpConfig().getLimitOnNumberOfResponses()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Too many async temp responses received.", (Object[])new Object[0]);
                }
                cb.error(this.getVC(), (Throwable)new IOException("Max temp responses received: " + this.numberResponsesReceived()));
                return;
            }
            if (this.bTempResponsesUsed) {
                cb.complete(this.getVC());
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != code) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expect 100-continue failed with " + code), (Object[])new Object[0]);
                    }
                    this.setPersistent(false);
                    cb.error(this.getVC(), (Throwable)new ExpectationFailedException(code + " " + this.getResponseImpl().getReasonPhrase()));
                    return;
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Notifying channel of first 100-continue", (Object[])new Object[0]);
                    }
                    cb.complete(this.getVC());
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring temporary response...", (Object[])new Object[0]);
            }
            this.resetRead();
            vc = this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false) ? this.getVC() : this.getTSC().getReadInterface().read(1L, (TCPReadCompletedCallback)HttpOSCReadCallback.getRef(), false, this.getReadTimeout());
            if (null == vc) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempting a parse of response data.", (Object[])new Object[0]);
            }
            vc = this.parseResponseMessageAsync();
        } while (null != vc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualConnection startResponseRead() {
        HttpInvalidMessageException inv;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startResponseRead", (Object[])new Object[0]);
        }
        if (null != (inv = this.checkRequestValidity())) {
            this.getAppWriteCallback().error(this.getVC(), (Throwable)inv);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: error");
            }
            return null;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int state = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                state = this.getCallbackState();
                this.setReadState(4);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Async response read, callback state: " + state), (Object[])new Object[0]);
            }
            switch (state) {
                case 4: {
                    this.readAsyncResponse();
                    break;
                }
                case 2: {
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), this.readException);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpected state (" + state + ") during async readahead"), (Object[])new Object[0]);
                    }
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), new IOException("Read-ahead state failure"));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: read-ahead");
            }
            return null;
        }
        if (this.bEarlyReads || this.bTempResponsesUsed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: temp resp env");
            }
            this.getAppWriteCallback().complete(this.getVC());
            return null;
        }
        this.getResponseImpl();
        this.readAsyncResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startResponseRead");
        }
        return null;
    }

    VirtualConnection parseResponseMessageAsync() {
        VirtualConnection readVC = null;
        try {
            do {
                if (this.parseMessage()) {
                    return this.getVC();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reading for more data to parse", (Object[])new Object[0]);
                }
                this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (readVC = this.getTSC().getReadInterface().read(1L, (TCPReadCompletedCallback)HttpOSCReadCallback.getRef(), false, this.getReadTimeout())));
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing response: " + e), (Object[])new Object[0]);
            }
            this.setPersistent(false);
            if (this.bEarlyReads || this.bTempResponsesUsed) {
                this.getAppReadCallback().error(this.getVC(), (Throwable)e);
            } else {
                this.getAppWriteCallback().error(this.getVC(), (Throwable)e);
            }
            return null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private void parseResponseMessageSync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResponseReadSync() throws IOException {
        HttpInvalidMessageException inv;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startResponseReadSync", (Object[])new Object[0]);
        }
        if (null != (inv = this.checkRequestValidity())) {
            throw inv;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int state = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                state = this.getCallbackState();
                this.setReadState(3);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Sync response read, callback state: " + state), (Object[])new Object[0]);
            }
            switch (state) {
                case 4: {
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Read-ahead reports previous failure", (Object[])new Object[0]);
                    }
                    if (null == this.readException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Callback indicates error but no exception", (Object[])new Object[0]);
                        }
                        throw new IOException("Bad read-ahead state");
                    }
                    throw this.readException;
                }
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for read-ahead to finish", (Object[])new Object[0]);
                    }
                    while (1 == this.getCallbackState()) {
                        try {
                            object = this.readAheadSyncer;
                            synchronized (object) {
                                this.readAheadSyncer.wait(2 * this.getHttpConfig().getReadTimeout());
                            }
                        }
                        catch (InterruptedException ie) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"Read-ahead block wait timed out", (Object[])new Object[0]);
                        }
                    }
                    if (null == this.readException) break;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Read-ahead reports new failure", (Object[])new Object[0]);
                    }
                    throw this.readException;
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpected state (" + state + ") during sync readahead"), (Object[])new Object[0]);
                    }
                    throw new IOException("Read-ahead state failure: " + state);
                }
            }
        }
        this.getResponseImpl();
        this.readSyncResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startResponseReadSync");
        }
    }

    private boolean checkBodyValidity() throws IOException {
        if (this.isImmediateReadEnabled() || this.bEarlyReads) {
            if (!this.headersParsed()) {
                IOException ioe = new IOException("Request headers not sent yet");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempt to read response prior to sendRequest", (Object[])new Object[0]);
                }
                throw ioe;
            }
        } else if (!this.isMessageSent()) {
            IOException ioe = new IOException("Request not finished yet");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read response prior to finishRequest", (Object[])new Object[0]);
            }
            throw ioe;
        }
        return this.isIncomingBodyValid();
    }

    @Override
    public WsByteBuffer[] getResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffers(sync)", (Object[])new Object[0]);
            }
            if (!this.checkBodyValidity()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(sync): No body allowed");
                }
                return null;
            }
            this.setMultiRead(true);
            if (!this.isBodyComplete()) {
                try {
                    this.readBodyBuffers(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException ihe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + ihe), (Object[])new Object[0]);
                }
            }
        }
        WsByteBuffer[] buffers = this.getAllStorageBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffers(sync): " + (null == buffers ? 0 : buffers.length)));
        }
        return buffers;
    }

    @Override
    public VirtualConnection getResponseBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffers(async)", (Object[])new Object[0]);
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): read not needed");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            callback.error(this.getVC(), (Throwable)ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffers(async): error=" + ioe));
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): read already");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodybuffers(async): exception: " + ioe));
            }
            callback.error(this.getVC(), (Throwable)ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): null");
        }
        return null;
    }

    @Override
    public WsByteBuffer getResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffer(sync)", (Object[])new Object[0]);
        }
        if (!this.checkBodyValidity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer retVal = this.getNextBuffer();
        if (null == retVal && !this.isBodyComplete()) {
            block9: {
                try {
                    this.readBodyBuffer(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException ihe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + ihe), (Object[])new Object[0]);
                }
            }
            retVal = this.getNextBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffer(sync): " + retVal));
        }
        return retVal;
    }

    @Override
    public VirtualConnection getResponseBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffer(async)", (Object[])new Object[0]);
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): read not needed");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            callback.error(this.getVC(), (Throwable)ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffer(async): error " + ioe));
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): body complete");
            }
            if (bForce) {
                callback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(callback);
        this.setForceAsync(bForce);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getResponseImpl(), true)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): read finished");
                }
                if (bForce) {
                    callback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffer(async): exception: " + ioe));
            }
            callback.error(this.getVC(), (Throwable)ioe);
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): null");
        }
        return null;
    }

    @Override
    public WsByteBuffer getRawResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffer(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        WsByteBuffer buffer = this.getResponseBodyBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffer(sync): " + buffer));
        }
        return buffer;
    }

    @Override
    public WsByteBuffer[] getRawResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffers(sync)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        WsByteBuffer[] list = this.getResponseBodyBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffers(sync): " + list));
        }
        return list;
    }

    @Override
    public VirtualConnection getRawResponseBodyBuffer(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffer(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getResponseBodyBuffer(callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffer(async): " + vc));
        }
        return vc;
    }

    @Override
    public VirtualConnection getRawResponseBodyBuffers(InterChannelCallback callback, boolean bForce) throws BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffers(async)", (Object[])new Object[0]);
        }
        this.setRawBody(true);
        VirtualConnection vc = this.getResponseBodyBuffers(callback, bForce);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffers(async): " + vc));
        }
        return vc;
    }

    @Override
    protected boolean readUntilEnd(boolean async) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Called readUntilEnd", (Object[])new Object[0]);
        }
        if (!this.isReadDataAvailable()) {
            try {
                if (this.fillABuffer(1L, async, false)) {
                    return true;
                }
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + ioe), (Object[])new Object[0]);
                }
                return false;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"End of body found in new buffer", (Object[])new Object[0]);
                }
                return false;
            }
        }
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current body buffer " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        if (0 == position && limit == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Return a full buffer", (Object[])new Object[0]);
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.setReadBuffer(null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Slice the return buffer", (Object[])new Object[0]);
            }
            this.storeTempBuffer(this.getReadBuffer().slice());
            this.getReadBuffer().position(limit);
        }
        return false;
    }

    @Override
    protected final HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getResponseImpl();
    }

    @Override
    protected final HttpBaseMessageImpl getMessageBeingSent() {
        return this.getRequestImpl();
    }

    public final HttpOutboundLink getLink() {
        return this.myLink;
    }

    private final void setLink(HttpOutboundLink link) {
        this.myLink = link;
    }

    @Override
    protected boolean reconnectAllowed() {
        return this.getLink().isReconnectAllowed();
    }

    @Override
    public HttpObjectFactory getObjectFactory() {
        return null == this.getLink() ? null : this.getLink().getObjectFactory();
    }

    @Override
    protected WsByteBuffer createChunkHeader(byte[] length) {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkHeader(length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OSC creating chunk length buffer", (Object[])new Object[0]);
        }
        WsByteBuffer header = this.allocateBuffer(32);
        header.put(length);
        header.put(BNFHeaders.EOL);
        header.flip();
        return header;
    }

    @Override
    protected WsByteBuffer createChunkTrailer() {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkTrailer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OSC creating chunk trailer", (Object[])new Object[0]);
        }
        WsByteBuffer buffer = this.allocateBuffer(32);
        buffer.put(CHUNK_TRAILER_DATA);
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerReadAhead(InterChannelCallback cb, int timeout) {
        int myState;
        int state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read-ahead requested (timeout=" + timeout + ") " + this.getVC()), (Object[])new Object[0]);
        }
        if (-1 > timeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid timeout used by caller.", (Object[])new Object[0]);
            }
            return false;
        }
        Object object = this.stateSyncObject;
        synchronized (object) {
            state = this.getCallbackState();
            myState = this.getReadState();
            this.setCallbackState(1, null);
        }
        if (0 != state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Callback state is invalid: " + state), (Object[])new Object[0]);
            }
            return false;
        }
        if (0 != myState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read for response state is invalid: " + myState), (Object[])new Object[0]);
            }
            return false;
        }
        this.bReadAheadEnabled = true;
        int time = -1 == timeout ? this.getReadTimeout() : timeout;
        this.setAppReadCallback(cb);
        this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
        this.getTSC().getReadInterface().read(1L, (TCPReadCompletedCallback)HttpOSCReadAhead.getRef(), true, time);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App channel called init: " + this), (Object[])new Object[0]);
        }
        int cbState = 0;
        int myState = 0;
        if (this.isReadAheadEnabled()) {
            this.getReadCancel().init();
            if (!super.cancelOutstandingRead()) {
                this.getReadCancel().clear();
                return false;
            }
            if (!this.getReadCancel().block(2000L)) {
                return false;
            }
            Object object = this.stateSyncObject;
            synchronized (object) {
                cbState = this.getCallbackState();
                myState = this.getReadState();
                this.setReadState(1);
            }
        }
        if (0 == cbState) {
            return true;
        }
        if (1 != cbState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Callback state indicates error: " + cbState), (Object[])new Object[0]);
            }
            return false;
        }
        if (0 != myState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read for response state indicates error: " + myState), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected int getCallbackState() {
        return this.callback_state;
    }

    protected void setCallbackState(int state, IOException ioe) {
        this.callback_state = state;
        this.readException = ioe;
    }

    protected int getReadState() {
        return this.read_state;
    }

    protected void setReadState(int state) {
        this.read_state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Received synchronous read-ahead wake-up call.", (Object[])new Object[0]);
        }
        Object object = this.readAheadSyncer;
        synchronized (object) {
            this.readAheadSyncer.notify();
        }
    }

    private int numberResponsesReceived() {
        return this.numResponsesReceived;
    }

    private boolean isReadAheadEnabled() {
        return this.bReadAheadEnabled;
    }

    protected boolean isImmediateReadEnabled() {
        return this.bImmediateRead;
    }

    @Override
    public boolean enableImmediateResponseRead() {
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request hdrs already sent, too late for immediate read", (Object[])new Object[0]);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Immediate response read requested: " + this.getVC()), (Object[])new Object[0]);
        }
        this.bImmediateRead = true;
        return true;
    }

    protected boolean shouldReadResponseImmediately() {
        return this.isImmediateReadEnabled() || this.getRequestImpl().isExpect100Continue() || this.getRequestImpl().containsHeader(HttpHeaderKeys.HDR_UPGRADE);
    }

    @Override
    public boolean cancelOutstandingRead() {
        this.disallowRewrites();
        return super.cancelOutstandingRead();
    }

    @Override
    public boolean cancelOutstandingWrite() {
        this.disallowRewrites();
        return super.cancelOutstandingWrite();
    }

    @Override
    public HttpAddress getTargetAddress() {
        return this.myLink.getTargetAddress();
    }

    @Override
    public void setStartTime() {
    }

    @Override
    public long getStartNanoTime() {
        return 0L;
    }

    @Override
    public void resetStartTime() {
    }

    @Override
    public WsByteBuffer getRemainingData() {
        if (!this.isReadDataAvailable()) {
            return null;
        }
        WsByteBuffer retBuf = null;
        int position = this.getReadBuffer().position();
        int limit = this.getReadBuffer().limit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current body buffer " + this.getReadBuffer()), (Object[])new Object[0]);
        }
        if (0 == position && limit == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Return a full buffer", (Object[])new Object[0]);
            }
            retBuf = this.returnLastBuffer();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Slice the return buffer", (Object[])new Object[0]);
            }
            retBuf = this.getReadBuffer().slice();
        }
        return retBuf;
    }
}

