/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.container.Container;
import com.ibm.ws.webcontainer.VirtualHost;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostConfiguration;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.container.DeployedModule;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.osgi.webapp.WebGroup;
import com.ibm.ws.webcontainer.osgi.webapp.WebGroupConfiguration;
import com.ibm.ws.webcontainer.util.URIMatcher;
import com.ibm.ws.webcontainer.util.WSURLDecoder;
import com.ibm.wsspi.http.HttpContainer;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DynamicVirtualHost
extends VirtualHost
implements HttpContainer {
    private static final TraceComponent tc = Tr.register(DynamicVirtualHost.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.osgi.DynamicVirtualHost";
    private final WebContainer webContainerParent;
    private final DynamicVirtualHostConfiguration dhostConfig;
    private URIMatcher predefinedMatcher;
    private static boolean normalizeRequestURI = WCCustomProperties.NORMALIZE_REQUEST_URI;

    DynamicVirtualHost(DynamicVirtualHostConfiguration vHostConfig, WebContainer parent) {
        super(vHostConfig, (Container)parent);
        this.dhostConfig = vHostConfig;
        this.webContainerParent = parent;
    }

    public DynamicVirtualHostConfiguration getHostConfiguration() {
        return this.dhostConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWebApplication(com.ibm.ws.container.DeployedModule deployedModule, List extensionFactories) throws WebAppNotLoadedException {
        try {
            WebGroup webGroup;
            this.dhostConfig.incrementAppStartingCount();
            DeployedModule deployedModuleImpl = (DeployedModule)deployedModule;
            String ct = deployedModuleImpl.getProperContextRoot();
            String contextRoot = deployedModuleImpl.getMappingContextRoot();
            String displayName = deployedModule.getDisplayName();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "enter [" + displayName + "]");
            }
            if ((webGroup = (WebGroup)this.requestMapper.map(contextRoot)) != null && ct.equalsIgnoreCase(webGroup.getConfiguration().getContextRoot())) {
                ArrayList list = webGroup.getWebApps();
                String originalName = "";
                if (list != null && list.size() > 0) {
                    WebApp originalWebApp = (WebApp)list.get(0);
                    originalName = originalWebApp.getWebAppName();
                }
                logger.logp(Level.SEVERE, CLASS_NAME, "addWebApplication", "context.root.already.in.use", new Object[]{displayName, contextRoot, originalName, displayName});
                throw new WebAppNotLoadedException("Context root " + contextRoot + " is already bound. Cannot start application " + displayName);
            }
            webGroup = new WebGroup(contextRoot, this);
            WebGroupConfiguration wgConfig = new WebGroupConfiguration(deployedModule.getName());
            wgConfig.setContextRoot(deployedModule.getContextRoot());
            wgConfig.setVersionID(deployedModule.getWebAppConfig().getVersion());
            com.ibm.ws.webcontainer.webapp.WebAppConfiguration baseAppConfig = deployedModule.getWebAppConfig();
            try {
                ((WebAppConfiguration)baseAppConfig).setVirtualHost(this);
            }
            catch (ClassCastException cce) {
                baseAppConfig.setVirtualHostName(this.getName());
            }
            wgConfig.setWebAppHost(this);
            webGroup.initialize(wgConfig);
            try {
                webGroup.addWebApplication(deployedModule, extensionFactories);
                Object[] args = new Object[]{displayName, this.vHostConfig.toString()};
                logger.logp(Level.INFO, CLASS_NAME, "addWebApplication", "module.[{0}].successfully.bound.to.virtualhost.[{1}]", args);
            }
            catch (Throwable t) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "error adding web app [" + displayName + "]");
                }
                webGroup.destroy();
                webGroup = null;
                throw new WebAppNotLoadedException(t.getMessage(), t);
            }
            try {
                this.addMapping(contextRoot, webGroup);
                webGroup.notifyStart();
            }
            catch (Exception exc) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addWebApplication", "error adding mapping ", exc);
                }
                webGroup.destroy();
                throw new WebAppNotLoadedException("Context root " + contextRoot + " mapping unable to be bound. Application " + displayName + " unavailable.", exc);
            }
        }
        finally {
            this.dhostConfig.decrementAppStartingCount();
        }
    }

    public Iterator<WebApp> getWebApps() {
        Iterator mappings = this.requestMapper.targetMappings();
        ArrayList webApps = new ArrayList();
        while (mappings.hasNext()) {
            WebGroup wg = (WebGroup)mappings.next();
            if (wg == null) continue;
            webApps.addAll(wg.getWebApps());
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "getWebApps", "add apps ", wg.getWebApps());
        }
        return webApps.iterator();
    }

    public Runnable createRunnableHandler(final IRequest ireq, final IResponse ires, final HttpInboundConnection inboundConnection) {
        WebApp webApp;
        WebApp sc;
        String requestUri = ireq.getRequestURI();
        if (normalizeRequestURI) {
            requestUri = WebApp.normalize(requestUri);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"normalized request uri --> ", (Object[])new Object[]{requestUri});
            }
        }
        if ((sc = (WebApp)this.findContext(requestUri)) == null && requestUri.indexOf("%") >= 0) {
            try {
                requestUri = WCCustomProperties.DECODE_URL_PLUS_SIGN ? URLDecoder.decode(requestUri, this.webContainerParent.getURIEncoding()) : WSURLDecoder.decode(requestUri, this.webContainerParent.getURIEncoding());
            }
            catch (IOException e) {
                FFDCWrapper.processException(e, CLASS_NAME, "222", this);
                return null;
            }
            sc = (WebApp)this.findContext(requestUri);
        }
        if ((webApp = sc) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("request for--> [" + requestUri + "], inboundConnection --> [" + inboundConnection + "], this --> " + this), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Context not found, return null", (Object[])new Object[0]);
            }
            if (this.predefinedMatcher != null && this.predefinedMatcher.match(requestUri) != null) {
                return new Runnable(){

                    @Override
                    public void run() {
                        DynamicVirtualHost.this.sendError(inboundConnection, ireq, ires);
                    }
                };
            }
            return null;
        }
        if (!webApp.isInitialized() && !this.startWebApp(webApp)) {
            return null;
        }
        return new Bridge(){
            HttpInboundConnection httpInboundConnection;
            {
                this.httpInboundConnection = inboundConnection;
            }

            @Override
            public void run() {
                IOException error = null;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Webcontainer handleRequest start for--> [" + ireq.getRequestURI() + "], mapped webApp context [" + webApp + "], inboundConnection --> [" + inboundConnection + "], this --> " + this), (Object[])new Object[0]);
                    }
                    DynamicVirtualHost.this.webContainerParent.handleRequest(ireq, ires, DynamicVirtualHost.this, this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Webcontainer handleRequest complete for--> [" + ireq.getRequestURI() + "], mapped webApp context [" + webApp + "], inboundConnection --> [" + inboundConnection + "], this --> " + this), (Object[])new Object[0]);
                    }
                }
                catch (IOException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Error during request handling; " + e), (Object[])new Object[]{inboundConnection, ireq});
                    }
                    error = e;
                }
                finally {
                    if (!ireq.isStartAsync()) {
                        inboundConnection.finish((Exception)error);
                    }
                }
            }

            @Override
            public String getName() {
                return DynamicVirtualHost.this.getName();
            }

            @Override
            public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
                String hostAlias = WebContainer.getHostAliasKey(req.getServerName(), req.getServerPort());
                DynamicVirtualHost.this.addSecureRedirect(req, hostAlias);
                webApp.handleRequest(req, res, this.httpInboundConnection);
            }

            @Override
            public boolean isInternal() {
                return DynamicVirtualHost.this.isInternal();
            }
        };
    }

    public Runnable createRunnableHandler(HttpInboundConnection inboundConnection) {
        IRequest ireq = this.webContainerParent.getRequestFactory().createRequest(inboundConnection);
        IResponse ires = this.webContainerParent.getResponseFactory().createResponse(ireq, inboundConnection);
        return this.createRunnableHandler(ireq, ires, inboundConnection);
    }

    @Override
    protected void addSecureRedirect(ServletRequest req, String hostAlias) {
        block3: {
            int secureRedirect = this.vHostConfig.getSecureHttpPort(hostAlias);
            if (secureRedirect > 0) {
                try {
                    ((IPrivateRequestAttributes)req).setPrivateAttribute("SecurityRedirectPort", secureRedirect);
                }
                catch (ClassCastException cce) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"failed to set the security redirect port", (Object[])new Object[]{this.getName(), hostAlias});
                }
            }
        }
    }

    @Override
    protected synchronized void addMapping(String contextRoot, com.ibm.ws.webcontainer.webapp.WebGroup group) throws Exception {
        super.addMapping(contextRoot, group);
        this.dhostConfig.addContextRoot(contextRoot, this);
    }

    @Override
    protected synchronized void removeMapping(String contextRoot) {
        this.dhostConfig.removeContextRoot(contextRoot, this);
        super.removeMapping(contextRoot);
    }

    @Override
    protected synchronized Object removeMappedObject(String contextRoot) {
        this.dhostConfig.removeContextRoot(contextRoot, this);
        return super.removeMappedObject(contextRoot);
    }

    public String getMimeType(String extension) {
        return this.dhostConfig.getMimeType(extension);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "," + this.dhostConfig + "]";
    }

    private void sendError(HttpInboundConnection inboundConnection, IRequest ireq, IResponse irsp) {
        IOException error = null;
        StatusCodes code = StatusCodes.UNAVAILABLE;
        irsp.setStatusCode(code.getIntCode());
        irsp.setHeader(HttpHeaderKeys.HDR_CONNECTION.getByteArray(), ConnectionValues.CLOSE.getByteArray());
        irsp.resetBuffer();
        if (code.isBodyAllowed()) {
            try {
                ServletOutputStream body = irsp.getOutputStream();
                byte[][] bits = new byte[][]{"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">".getBytes(), "<html><head><title>".getBytes(), "</title></head><body><h1>".getBytes(), "</h1><p>".getBytes(), "</p><hr /><address>".getBytes(), "</address></body></html>".getBytes()};
                body.write(bits[0]);
                body.write(bits[1]);
                byte[] msg = code.getStatusWithPhrase();
                body.write(msg);
                body.write(bits[2]);
                msg = code.getDefaultPhraseBytes();
                body.write(msg);
                body.write(bits[3]);
                msg = ireq.getRequestURI().getBytes();
                body.write(msg);
                body.write(bits[4]);
                body.write(bits[5]);
            }
            catch (IOException e) {
                error = e;
            }
        }
        inboundConnection.finish(error);
    }

    void setPredefinedContextRoots(Set<String> ctxRoots) {
        URIMatcher newMatcher = null;
        if (ctxRoots != null && !ctxRoots.isEmpty()) {
            newMatcher = new URIMatcher(true, true);
            for (String ctxRoot : ctxRoots) {
                try {
                    newMatcher.put(ctxRoot, ctxRoot);
                }
                catch (Exception exception) {}
            }
        }
        URIMatcher oldMatcher = this.predefinedMatcher;
        this.predefinedMatcher = newMatcher;
        if (oldMatcher == null && newMatcher != null) {
            this.dhostConfig.addContextRoot(null, this);
        } else if (oldMatcher != null && newMatcher == null) {
            this.dhostConfig.removeContextRoot(null, this);
        }
    }

    public boolean startWebApplication(com.ibm.ws.container.DeployedModule dm) {
        String ct;
        WebApp webApp;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "startWebApplication", "Enter ");
        }
        if ((webApp = (WebApp)this.findContext(ct = DynamicVirtualHost.makeProperContextRoot(dm.getContextRoot()))) == null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "startWebApplication", "No webapp mapping found for contextroot ->" + ct);
            }
            return false;
        }
        return this.startWebApp(webApp);
    }

    private boolean startWebApp(WebApp webApp) {
        try {
            webApp.initialize();
            return !webApp.getDestroyed();
        }
        catch (Throwable th) {
            try {
                FFDCWrapper.processException(th, CLASS_NAME, "startWebApp", new Object[]{this, webApp});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Error starting web app: " + webApp + "; " + th), (Object[])new Object[0]);
                }
            }
            finally {
                this.stopWebApp(webApp);
            }
            return false;
        }
    }

    public boolean stopWebApplication(com.ibm.ws.container.DeployedModule dm) {
        String ct;
        WebApp webApp;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "stopWebApplication", "Enter ");
        }
        if ((webApp = (WebApp)this.findContext(ct = DynamicVirtualHost.makeProperContextRoot(dm.getContextRoot()))) != null) {
            return this.stopWebApp(webApp);
        }
        return false;
    }

    private boolean stopWebApp(WebApp webApp) {
        webApp.failed();
        webApp.destroy();
        return true;
    }

    static interface Bridge
    extends RequestProcessor,
    Runnable {
    }
}

