/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.framework.FrameworkException;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnectionFactory;
import com.ibm.ws.sib.jfapchannel.framework.NetworkTransportFactory;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OutboundConnectionTracker {
    private static final TraceComponent tc = SibTr.register(OutboundConnectionTracker.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls;
    private int conversationsPerConnection;
    private final HashMap<EndPointDescriptor, ConnectionDataGroup> endPointToGroupMap = new HashMap();
    private Framework framework;
    private final BridgeServiceEndPointDescriptor bridgeServiceDescriptor = new BridgeServiceEndPointDescriptor();
    private final LinkedList<OutboundConnection> closeList = new LinkedList();

    public OutboundConnectionTracker(Framework channelFramework) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)channelFramework);
        }
        this.framework = channelFramework;
        this.conversationsPerConnection = 5;
        try {
            this.conversationsPerConnection = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.CONVERSATIONS_PER_CONNECTION"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.conversationsPerConnection < 1) {
            this.conversationsPerConnection = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("conversationsPerConnection=" + this.conversationsPerConnection));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllOutboundConversations() {
        HashMap endPointToGroupMapClone;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllOutboundConversations");
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
        synchronized (hashMap) {
            endPointToGroupMapClone = (HashMap)this.endPointToGroupMap.clone();
        }
        for (ConnectionDataGroup group : endPointToGroupMapClone.values()) {
            List connectionData = group.getConnections();
            for (ConnectionData thisConnectionData : connectionData) {
                Conversation[] conversationArray;
                OutboundConnection connection = thisConnectionData.getConnection();
                for (Conversation conv : conversationArray = connection.getConversations()) {
                    if (conv == null) continue;
                    result.add(conv);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllOutboundConversations", result);
        }
        return result;
    }

    public List getAllOutboundConversationsForFfdc() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllOutboundConversationsForFfdc");
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        HashMap endPointToGroupMapClone = null;
        for (int cloneRetryCount = 0; endPointToGroupMapClone == null && cloneRetryCount < 3; ++cloneRetryCount) {
            try {
                endPointToGroupMapClone = (HashMap)this.endPointToGroupMap.clone();
                continue;
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            }
        }
        if (endPointToGroupMapClone == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllOutboundConversationsForFfdc", null);
            }
            return null;
        }
        for (ConnectionDataGroup group : endPointToGroupMapClone.values()) {
            List connectionData = group.getConnections();
            for (ConnectionData thisConnectionData : connectionData) {
                Conversation[] conversationArray;
                OutboundConnection connection = thisConnectionData.getConnection();
                for (Conversation conv : conversationArray = connection.getConversations()) {
                    if (conv == null) continue;
                    result.add(conv);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllOutboundConversationsForFfdc", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConversation(OutboundConnection connectionHostingConversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeConversation", (Object)connectionHostingConversation);
        }
        boolean closeOnThisThread = false;
        LinkedList<OutboundConnection> linkedList = this.closeList;
        synchronized (linkedList) {
            closeOnThisThread = this.closeList.isEmpty();
            this.closeList.addLast(connectionHostingConversation);
            if (closeOnThisThread) {
                connectionHostingConversation = this.closeList.getFirst();
            }
        }
        while (closeOnThisThread) {
            ConnectionData connectionData = connectionHostingConversation.getConnectionData();
            if (connectionData != null) {
                EndPointDescriptor endPointDescriptior = connectionData.getEndPointDescriptor();
                HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
                synchronized (hashMap) {
                    ConnectionDataGroup group = this.endPointToGroupMap.get(endPointDescriptior);
                    if (group == null || group != connectionData.getConnectionDataGroup()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            if (group == null) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"group == nul");
                            } else {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"group != connectionData.getConnectionDataGroup()");
                            }
                        }
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker", (String)"00110001", (Object)connectionData);
                    } else {
                        group.close(connectionHostingConversation);
                        if (group.isEmpty()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("group: " + group + " has become empty"));
                            }
                            this.endPointToGroupMap.remove(group.getEndPointDescriptor());
                        }
                    }
                }
            }
            LinkedList<OutboundConnection> linkedList2 = this.closeList;
            synchronized (linkedList2) {
                this.closeList.removeFirst();
                boolean bl = closeOnThisThread = !this.closeList.isEmpty();
                if (closeOnThisThread) {
                    connectionHostingConversation = this.closeList.getFirst();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("close list has an entry: " + connectionHostingConversation));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeConversation");
        }
    }

    public void removeConnectionDataFromGroup(OutboundConnection oc) {
        ConnectionData connectionData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeConnectionDataFromGroup", (Object)new Object[]{oc});
        }
        if ((connectionData = oc.getConnectionData()) != null) {
            ConnectionDataGroup cdGroup = connectionData.getConnectionDataGroup();
            cdGroup.removeConnectionDataFromGroup(connectionData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionDataFromGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(Object endPoint, ConversationReceiveListener receiveListener, Conversation.ConversationType conversationType) throws SIResourceException {
        ConnectionDataGroup connGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{endPoint, receiveListener, conversationType});
        }
        CFEndPointDescriptor testEndPoint = new CFEndPointDescriptor(endPoint, conversationType);
        HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
        synchronized (hashMap) {
            connGroup = this.endPointToGroupMap.get(testEndPoint);
            Map properties = this.framework.getOutboundConnectionProperties(endPoint);
            int heartbeatInterval = this.determineHeartbeatInterval(properties);
            int heartbeatTimeout = this.determineHeartbeatTimeout(properties);
            if (connGroup == null) {
                connGroup = new ConnectionDataGroup(this, testEndPoint, this.conversationsPerConnection, this.framework, heartbeatInterval, heartbeatTimeout);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("created new connection data group: " + connGroup));
                }
                this.endPointToGroupMap.put(testEndPoint, connGroup);
            }
            connGroup.connectionPending();
        }
        Conversation retConversation = connGroup.connect(endPoint, receiveListener, conversationType);
        if (retConversation != null) {
            retConversation.setConversationType(conversationType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(InetSocketAddress remoteHost, ConversationReceiveListener receiveListener, String chainName, Conversation.ConversationType conversationType) throws SIResourceException {
        ConnectionDataGroup connGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{remoteHost, receiveListener, chainName, conversationType});
        }
        HostPortEndPointDescriptor testEndPoint = new HostPortEndPointDescriptor(remoteHost, chainName, conversationType);
        HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
        synchronized (hashMap) {
            connGroup = this.endPointToGroupMap.get(testEndPoint);
            if (connGroup == null) {
                try {
                    NetworkTransportFactory transportFactory = this.framework.getNetworkTransportFactory();
                    NetworkConnectionFactory virtualConnectionFactory = transportFactory.getOutboundNetworkConnectionFactoryByName(chainName);
                    if (virtualConnectionFactory == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown chain name: " + chainName));
                        }
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    int heartbeatInterval = 300;
                    int heartbeatTimeout = 7;
                    connGroup = new ConnectionDataGroup(this, virtualConnectionFactory, testEndPoint, this.conversationsPerConnection, heartbeatInterval, heartbeatTimeout);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("created new connection data group: " + connGroup));
                    }
                    this.endPointToGroupMap.put(testEndPoint, connGroup);
                }
                catch (FrameworkException frameworkException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)frameworkException);
                    }
                    throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"), (Throwable)frameworkException);
                }
            }
            connGroup.connectionPending();
        }
        Conversation retConversation = connGroup.connect(remoteHost, chainName, receiveListener, conversationType);
        if (retConversation != null) {
            retConversation.setConversationType(conversationType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(ConversationReceiveListener receiveListener, Conversation.ConversationType conversationType, ConversationUsageType usageType) throws SIResourceException {
        ConnectionDataGroup connGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{receiveListener, conversationType, usageType});
        }
        BridgeServiceEndPointDescriptor testEndPoint = this.bridgeServiceDescriptor;
        String chainName = "_OutboundTCPProxyBridgeService";
        HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
        synchronized (hashMap) {
            connGroup = this.endPointToGroupMap.get(testEndPoint);
            if (connGroup == null) {
                try {
                    NetworkTransportFactory transportFactory = this.framework.getNetworkTransportFactory();
                    NetworkConnectionFactory virtualConnectionFactory = transportFactory.getOutboundNetworkConnectionFactoryByName(chainName);
                    if (virtualConnectionFactory == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown chain name: " + chainName));
                        }
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    connGroup = new ConnectionDataGroup(this, virtualConnectionFactory, testEndPoint, this.framework);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("created new connection data group: " + connGroup));
                    }
                    this.endPointToGroupMap.put(testEndPoint, connGroup);
                }
                catch (FrameworkException frameworkException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)frameworkException);
                    }
                    throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"), (Throwable)frameworkException);
                }
            }
            connGroup.connectionPending();
        }
        Conversation retConversation = connGroup.connect(receiveListener, usageType);
        if (retConversation != null) {
            retConversation.setConversationType(conversationType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retConversation);
        }
        return retConversation;
    }

    private int determineHeartbeatInterval(Map properties) {
        String intervalStr;
        int heartbeatInterval = 300;
        try {
            heartbeatInterval = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL", (String)("" + heartbeatInterval)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (intervalStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY")) != null) {
            try {
                heartbeatInterval = Integer.parseInt(intervalStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return heartbeatInterval;
    }

    private int determineHeartbeatTimeout(Map properties) {
        String timeoutStr;
        int heartbeatTimeout = 7;
        try {
            heartbeatTimeout = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT", (String)("" + heartbeatTimeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (properties != null && (timeoutStr = (String)properties.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY")) != null) {
            try {
                heartbeatTimeout = Integer.parseInt(timeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return heartbeatTimeout;
    }

    public Conversation cloneConversation(OutboundConnection connection, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneConversation", (Object)new Object[]{connection, conversationReceiveListener});
        }
        Conversation clonedConversation = connection.getConnectionData().getConnectionDataGroup().clone(connection, conversationReceiveListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneConversation", (Object)clonedConversation);
        }
        return clonedConversation;
    }

    public void purgeFromInvalidateImpl(OutboundConnection connection, boolean notifyPeer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purgeFromInvalidateImpl", (Object)new Object[]{connection, "" + notifyPeer});
        }
        connection.getConnectionData().getConnectionDataGroup().purgeFromInvalidateImpl(connection, notifyPeer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purgeFromInvalidateImpl");
        }
    }

    public void purgeClosedConnection(OutboundConnection connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purgeClosedConnection", (Object)connection);
        }
        connection.getConnectionData().getConnectionDataGroup().purgeClosedConnection(connection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purgeClosedConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateConnectionsAssociatedWithChain(String chainName) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain", (Object[])new Object[]{chainName});
        }
        HashMap<EndPointDescriptor, ConnectionDataGroup> hashMap = this.endPointToGroupMap;
        synchronized (hashMap) {
            try {
                HashMap endPointToGroupMapClone = (HashMap)this.endPointToGroupMap.clone();
                for (EndPointDescriptor ed : endPointToGroupMapClone.keySet()) {
                    block19: {
                        if (!((HostPortEndPointDescriptor)ed).chainName.equals(chainName)) continue;
                        ConnectionDataGroup cdGroup = (ConnectionDataGroup)endPointToGroupMapClone.get(ed);
                        List connectionData = cdGroup.getConnections();
                        for (ConnectionData thisConnectionData : connectionData) {
                            Conversation[] conv;
                            OutboundConnection oc = thisConnectionData.getConnection();
                            for (Conversation c : conv = oc.getConversations()) {
                                try {
                                    c.fastClose();
                                }
                                catch (Exception e) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                    SibTr.debug((TraceComponent)tc, (String)"Error while fast closing the conversation", (Object)e);
                                }
                            }
                            try {
                                this.purgeFromInvalidateImpl(oc, false);
                            }
                            catch (Exception e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                SibTr.debug((TraceComponent)tc, (String)"Error while purging the physical connection", (Object)e);
                            }
                        }
                        try {
                            cdGroup.getNetworkConnectionFactory().getOutboundVirtualConFactory().destroy();
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                            SibTr.debug((TraceComponent)tc, (String)"Error while destroying the outbound virtual connection", (Object)e);
                        }
                    }
                    this.endPointToGroupMap.remove(ed);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain");
                }
            }
        }
    }

    public void setChanelFramework(Framework framework) {
        this.framework = framework;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/OutboundConnectionTracker.java, SIB.comms, WASX.SIB, uu1215.01 1.39");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    }

    private static class BridgeServiceEndPointDescriptor
    extends EndPointDescriptor {
        private BridgeServiceEndPointDescriptor() {
        }
    }

    private class CFEndPointDescriptor
    extends EndPointDescriptor {
        private final Object endPoint;
        private final Conversation.ConversationType convType;

        protected CFEndPointDescriptor(Object cfEndPoint, Conversation.ConversationType convType) {
            this.endPoint = cfEndPoint;
            this.convType = convType;
        }

        public boolean equals(Object o) {
            boolean isEqual = false;
            if (o instanceof CFEndPointDescriptor) {
                CFEndPointDescriptor cfDescriptor = (CFEndPointDescriptor)o;
                isEqual = OutboundConnectionTracker.this.framework.areEndPointsEqual(cfDescriptor.endPoint, this.endPoint) && cfDescriptor.convType == this.convType;
            }
            return isEqual;
        }

        public int hashCode() {
            return OutboundConnectionTracker.this.framework.getEndPointHashCode(this.endPoint) ^ this.convType.hashCode();
        }

        public String toString() {
            return "CFEndPointDescriptor@" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.endPoint + " -> " + this.convType;
        }
    }

    private static class HostPortEndPointDescriptor
    extends EndPointDescriptor {
        private final InetSocketAddress address;
        private final String chainName;
        private final Conversation.ConversationType convType;

        protected HostPortEndPointDescriptor(InetSocketAddress address, String chainName, Conversation.ConversationType convType) {
            this.address = address;
            this.chainName = chainName;
            this.convType = convType;
        }

        public boolean equals(Object o) {
            boolean isEqual = false;
            if (o instanceof HostPortEndPointDescriptor) {
                HostPortEndPointDescriptor hped = (HostPortEndPointDescriptor)o;
                isEqual = hped.address.equals(this.address) && hped.chainName.equals(this.chainName) && hped.convType == this.convType;
            }
            return isEqual;
        }

        public int hashCode() {
            return this.address.hashCode() ^ this.chainName.hashCode() ^ this.convType.hashCode();
        }

        public String toString() {
            return "HostPortEndPointDescriptor@" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.address + ":" + this.chainName + " -> " + this.convType;
        }
    }
}

