/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.crypto.ltpakeyutil.LTPACrypto;
import com.ibm.ws.crypto.ltpakeyutil.LTPADigSignature;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyPair;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.kernel.service.util.JavaInfo;

public final class LTPAKeyUtil {
    public static boolean ibmJCEAvailable = false;
    public static boolean openJCEPlusAvailable = false;
    public static boolean providerChecked = false;
    public static boolean zosProviderChecked = false;
    public static boolean javaVersionChecked = false;
    public static boolean isJava11orHigher = false;
    public static boolean zOSAndJAVA11orHigherChecked = false;
    public static boolean iszOSAndJava11orHigher = false;
    public static String osName = System.getProperty("os.name");
    public static boolean isZOS = false;
    public static boolean osVersionChecked = false;
    public static String IBM_JCE_PROVIDER = "com.ibm.crypto.provider.IBMJCE";
    public static String OPENJCEPLUS_PROVIDER = "com.ibm.crypto.plus.provider.OpenJCEPlus";

    public static byte[] encrypt(byte[] data, byte[] key, String cipher) throws Exception {
        return LTPACrypto.encrypt(data, key, cipher);
    }

    public static byte[] decrypt(byte[] msg, byte[] key, String cipher) throws Exception {
        return LTPACrypto.decrypt(msg, key, cipher);
    }

    public static boolean verifyISO9796(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) throws Exception {
        return LTPACrypto.verifyISO9796(key, data, off, len, sig, sigOff, sigLen);
    }

    public static byte[] signISO9796(byte[][] key, byte[] data, int off, int len) throws Exception {
        return LTPACrypto.signISO9796(key, data, off, len);
    }

    public static void setRSAKey(byte[][] key) {
        LTPACrypto.setRSAKey(key);
    }

    public static byte[][] getRawKey(LTPAPrivateKey privKey) {
        return privKey.getRawKey();
    }

    public static byte[][] getRawKey(LTPAPublicKey pubKey) {
        return pubKey.getRawKey();
    }

    public static LTPAKeyPair generateLTPAKeyPair() {
        return LTPADigSignature.generateLTPAKeyPair();
    }

    public static byte[] generate3DESKey() {
        return LTPACrypto.generate3DESKey();
    }

    public static boolean isIBMJCEAvailable() {
        if (providerChecked) {
            return ibmJCEAvailable;
        }
        ibmJCEAvailable = JavaInfo.isSystemClassAvailable((String)IBM_JCE_PROVIDER);
        providerChecked = true;
        return ibmJCEAvailable;
    }

    public static boolean isOpenJCEPlusAvailable() {
        if (zosProviderChecked) {
            return openJCEPlusAvailable;
        }
        openJCEPlusAvailable = JavaInfo.isSystemClassAvailable((String)OPENJCEPLUS_PROVIDER);
        zosProviderChecked = true;
        return openJCEPlusAvailable;
    }

    private static boolean isJava11orHigher() {
        if (javaVersionChecked) {
            return isJava11orHigher;
        }
        isJava11orHigher = JavaInfo.majorVersion() >= 11;
        javaVersionChecked = true;
        return isJava11orHigher;
    }

    private static boolean isZOS() {
        if (osVersionChecked) {
            return isZOS;
        }
        isZOS = osName.equalsIgnoreCase("z/OS") || osName.equalsIgnoreCase("OS/390");
        osVersionChecked = true;
        return isZOS;
    }

    public static boolean isZOSandRunningJava11orHigher() {
        if (zOSAndJAVA11orHigherChecked) {
            return iszOSAndJava11orHigher;
        }
        iszOSAndJava11orHigher = LTPAKeyUtil.isJava11orHigher() && LTPAKeyUtil.isZOS();
        zOSAndJAVA11orHigherChecked = true;
        return iszOSAndJava11orHigher;
    }
}

