/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.hpel;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.boot.logging.LoggerHandlerManager;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceConfig;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceWriter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.RoutedMessageImpl;
import com.ibm.wsspi.logging.MessageRouter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HpelBaseTraceService
extends BaseTraceService {
    private final HpelTraceServiceWriter trWriter = new HpelTraceServiceWriter(this);
    private final String SYSOUT = "SystemOut";
    private final String SYSERR = "SystemErr";

    public void echo(BaseTraceService.SystemLogHolder holder, LogRecord logRecord) {
        if (logRecord.getLoggerName() != null && (logRecord.getLoggerName().equals("SystemOut") || logRecord.getLoggerName().equals("SystemErr"))) {
            logRecord.setSourceClassName("");
            logRecord.setSourceMethodName("");
        }
        RoutedMessageImpl routedMessage = null;
        if (this.externalMessageRouter.get() != null) {
            String message = this.formatter.messageLogFormat(logRecord, logRecord.getMessage());
            routedMessage = new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), message, logRecord);
        } else {
            routedMessage = new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), null, logRecord);
        }
        this.invokeMessageRouters((RoutedMessage)routedMessage);
        if (this.logSource != null) {
            this.publishToLogSource((RoutedMessage)routedMessage);
        }
        this.trWriter.repositoryPublish(logRecord);
    }

    boolean notifyConsole(LogRecord logRecord) {
        int levelValue = logRecord.getLevel().intValue();
        if (levelValue >= Level.INFO.intValue()) {
            boolean logNormally;
            String txt = this.formatter.formatMessage(logRecord);
            MessageRouter router = (MessageRouter)this.externalMessageRouter.get();
            if (router != null && !(logNormally = router.route(txt, logRecord))) {
                return false;
            }
        }
        return true;
    }

    public void publishLogRecord(LogRecord logRecord) {
        String formattedMsg = null;
        String formattedVerboseMsg = null;
        Level level = logRecord.getLevel();
        int levelValue = level.intValue();
        if (levelValue >= Level.INFO.intValue()) {
            formattedMsg = this.formatter.formatMessage(logRecord);
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg);
            RoutedMessageImpl routedMessage = null;
            if (this.externalMessageRouter.get() != null || this.internalMessageRouter.get() != null) {
                String message = this.formatter.messageLogFormat(logRecord, formattedVerboseMsg);
                routedMessage = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, message, logRecord);
            } else {
                routedMessage = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, null, logRecord);
            }
            boolean logNormally = this.invokeMessageRouters((RoutedMessage)routedMessage);
            if (!logNormally) {
                return;
            }
            this.trWriter.repositoryPublish(logRecord);
            if (this.isMessageHidden(formattedMsg)) {
                return;
            }
            if (this.logSource != null) {
                this.publishToLogSource((RoutedMessage)routedMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTraceLogRecord(BaseTraceService.TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        if (formattedVerboseMsg == null) {
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg, false);
        }
        RoutedMessageImpl routedTrace = new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, null, logRecord);
        this.invokeTraceRouters((RoutedMessage)routedTrace);
        try {
            if (counterForTraceSource.incrementCount() <= 2 && this.traceSource != null) {
                this.traceSource.publish((RoutedMessage)routedTrace, id);
            }
        }
        finally {
            counterForTraceRouter.decrementCount();
        }
        this.trWriter.repositoryPublish(logRecord);
    }

    protected void initializeWriters(LogProviderConfigImpl config) {
        this.trWriter.configure((HpelTraceServiceConfig)config);
    }

    protected void registerLoggerHandlerSingleton() {
        LoggerHandlerManager.setSingleton((Handler)new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                Level level = logRecord.getLevel();
                int levelValue = level.intValue();
                if (levelValue >= Level.INFO.intValue()) {
                    HpelBaseTraceService.this.publishLogRecord(logRecord);
                } else if (TraceComponent.isAnyTracingEnabled()) {
                    HpelBaseTraceService.this.publishTraceLogRecord(HpelBaseTraceService.this.traceLog, logRecord, BaseTraceService.NULL_ID, null, null);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
    }

    protected void unregisterLoggerHandlerSingleton() {
        LoggerHandlerManager.unsetSingleton();
        this.trWriter.stop();
    }
}

