/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections.internal;

import com.ibm.ws.repository.common.enums.FilterPredicate;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryBackendRequestFailureException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.ResourceCollector;
import com.ibm.ws.repository.resources.internal.ResourceFactory;
import com.ibm.ws.repository.resources.internal.SampleResourceImpl;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.Asset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractRepositoryConnection
implements RepositoryConnection {
    @Override
    public boolean isRepositoryAvailable() {
        try {
            this.checkRepositoryStatus();
        }
        catch (IOException ex) {
            return false;
        }
        catch (RequestFailureException e) {
            return false;
        }
        return true;
    }

    @Override
    public void checkRepositoryStatus() throws IOException, RequestFailureException {
        this.createClient().checkRepositoryStatus();
    }

    @Override
    public RepositoryResource getResource(String id) throws RepositoryBackendException, RepositoryBadDataException {
        RepositoryReadableClient client = this.createClient();
        RepositoryResourceImpl res = null;
        try {
            Asset ass = client.getAsset(id);
            if (null != ass) {
                res = ResourceFactory.getInstance().createResourceFromAsset(ass, this);
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to create resource from Asset", ioe, this);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("BadVersion reading attachment", id, bvx);
        }
        catch (RequestFailureException bfe) {
            throw new RepositoryBackendRequestFailureException(bfe, (RepositoryConnection)this);
        }
        return res;
    }

    public Collection<RepositoryResource> getAllResources() throws RepositoryBackendException {
        return this.getAllResources(new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES));
    }

    public Collection<RepositoryResource> getAllResourcesWithDupes() throws RepositoryBackendException {
        return this.getAllResources(new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.ALLOW_DUPLICATES));
    }

    public Collection<RepositoryResource> getAllResources(ResourceType type) throws RepositoryBackendException {
        return this.getAllResources(type, new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES));
    }

    public Collection<RepositoryResource> getAllResourcesWithDupes(ResourceType type) throws RepositoryBackendException {
        return this.getAllResources(type, new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.ALLOW_DUPLICATES));
    }

    @Override
    public Map<ResourceType, Collection<? extends RepositoryResource>> getResources(Collection<ProductDefinition> productDefinitions, Collection<ResourceType> types, Visibility visibility) throws RepositoryBackendException {
        Visibility visibilityForMassiveFilter = null;
        if (visibility != null && types != null && types.size() == 1 && types.contains((Object)ResourceType.FEATURE)) {
            visibilityForMassiveFilter = visibility;
        }
        HashSet<String> productIds = new HashSet<String>();
        HashSet<String> productVersions = new HashSet<String>();
        if (productDefinitions != null) {
            for (ProductDefinition productDefinition : productDefinitions) {
                Object version;
                String id = productDefinition.getId();
                if (id != null) {
                    productIds.add(id);
                }
                if ((version = productDefinition.getVersion()) == null) continue;
                productVersions.add((String)version);
            }
        }
        ResourceCollector<RepositoryResourceImpl> resources = new ResourceCollector<RepositoryResourceImpl>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES);
        try {
            RepositoryReadableClient client = this.createClient();
            Collection<Asset> assets = client.getAssets(types, productIds, visibilityForMassiveFilter, productVersions);
            assets.addAll(client.getAssetsWithUnboundedMaxVersion(types, productIds, visibilityForMassiveFilter));
            for (Asset asset : assets) {
                resources.add(ResourceFactory.getInstance().createResourceFromAsset(asset, this));
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        HashMap<ResourceType, Collection<? extends RepositoryResource>> returnMap = new HashMap<ResourceType, Collection<? extends RepositoryResource>>();
        for (RepositoryResourceImpl massiveResource : resources.getResourceCollection()) {
            if (!massiveResource.doesResourceMatch(productDefinitions, visibility)) continue;
            ResourceType type = massiveResource.getType();
            ArrayList<RepositoryResourceImpl> resourcesOfType = (ArrayList<RepositoryResourceImpl>)returnMap.get((Object)type);
            if (resourcesOfType == null) {
                resourcesOfType = new ArrayList<RepositoryResourceImpl>();
                returnMap.put(type, resourcesOfType);
            }
            resourcesOfType.add(massiveResource);
        }
        return returnMap;
    }

    @Override
    public Collection<SampleResource> getMatchingSamples(FilterableAttribute attribute, String identifier) throws RepositoryBackendException {
        ResourceCollector<SampleResourceImpl> results = new ResourceCollector<SampleResourceImpl>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES);
        HashMap<FilterableAttribute, Collection<String>> filters = new HashMap<FilterableAttribute, Collection<String>>();
        filters.put(FilterableAttribute.TYPE, Arrays.asList(ResourceType.OPENSOURCE.getValue(), ResourceType.PRODUCTSAMPLE.getValue()));
        filters.put(attribute, Collections.singleton(identifier));
        RepositoryReadableClient client = this.createClient();
        try {
            Collection<Asset> assets = client.getFilteredAssets(filters);
            for (Asset ass : assets) {
                SampleResourceImpl res = (SampleResourceImpl)ResourceFactory.getInstance().createResourceFromAsset(ass, this);
                results.add(res);
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        return results.getResourceCollection();
    }

    @Override
    public Collection<EsaResource> getMatchingEsas(FilterableAttribute attribute, String identifier) throws RepositoryBackendException {
        ResourceCollector<EsaResourceImpl> resources = new ResourceCollector<EsaResourceImpl>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES);
        HashMap<FilterableAttribute, Collection<String>> filters = new HashMap<FilterableAttribute, Collection<String>>();
        filters.put(FilterableAttribute.TYPE, Collections.singleton(ResourceType.FEATURE.getValue()));
        filters.put(attribute, Collections.singleton(identifier));
        RepositoryReadableClient client = this.createClient();
        try {
            Collection<Asset> assets = client.getFilteredAssets(filters);
            for (Asset ass : assets) {
                EsaResourceImpl res = (EsaResourceImpl)ResourceFactory.getInstance().createResourceFromAsset(ass, this);
                resources.add(res);
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        return resources.getResourceCollection();
    }

    @Override
    public Collection<RepositoryResource> getMatchingResources(FilterPredicate ... predicates) throws RepositoryBackendException {
        ArrayList<RepositoryResource> resources = new ArrayList<RepositoryResource>();
        HashMap<FilterableAttribute, Collection<String>> filters = new HashMap<FilterableAttribute, Collection<String>>();
        for (FilterPredicate predicate : predicates) {
            filters.put(predicate.getAttribute(), predicate.getValues());
        }
        RepositoryReadableClient client = this.createClient();
        try {
            Collection<Asset> assets = client.getFilteredAssets(filters);
            for (Asset ass : assets) {
                RepositoryResourceImpl res = ResourceFactory.getInstance().createResourceFromAsset(ass, this);
                resources.add(res);
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        return resources;
    }

    @Override
    public Collection<? extends RepositoryResource> findResources(String searchTerm, Collection<ProductDefinition> productDefinitions, Collection<ResourceType> types, Visibility visibility) throws RepositoryBackendException {
        ResourceCollector<? extends RepositoryResource> resources;
        block6: {
            List<Asset> assets;
            block5: {
                resources = new ResourceCollector<RepositoryResource>(ResourceCollector.DuplicatePolicy.FORBID_DUPLICATES);
                if (null != searchTerm && !searchTerm.isEmpty()) break block5;
                Map<ResourceType, Collection<? extends RepositoryResource>> mapResults = this.getResources(productDefinitions, types, visibility);
                for (Collection<? extends RepositoryResource> mapEntry : mapResults.values()) {
                    resources.addAll(mapEntry);
                }
                break block6;
            }
            if (!(this instanceof RestRepositoryConnection)) break block6;
            RepositoryReadableClient client = this.createClient();
            try {
                assets = client.findAssets(searchTerm, types);
            }
            catch (IOException ioe) {
                throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
            }
            catch (RequestFailureException e) {
                throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
            }
            for (Asset ass : assets) {
                RepositoryResourceImpl resource = ResourceFactory.getInstance().createResourceFromAsset(ass, this);
                if (!resource.doesResourceMatch(productDefinitions, visibility)) continue;
                resources.add(resource);
            }
        }
        return resources.getResourceCollection();
    }

    public abstract RepositoryReadableClient createClient();

    private Collection<RepositoryResource> getAllResources(ResourceCollector<RepositoryResource> resources) throws RepositoryBackendException {
        RepositoryReadableClient client = this.createClient();
        try {
            Collection<Asset> assets = client.getAllAssets();
            for (Asset ass : assets) {
                resources.add(ResourceFactory.getInstance().createResourceFromAsset(ass, this));
            }
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        return resources.getResourceCollection();
    }

    private Collection<RepositoryResource> getAllResources(ResourceType type, ResourceCollector<RepositoryResource> resources) throws RepositoryBackendException {
        Collection<Asset> assets;
        RepositoryReadableClient client = this.createClient();
        try {
            assets = client.getAssets(type);
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to obtain the assets from massive", ioe, this);
        }
        catch (RequestFailureException e) {
            throw new RepositoryBackendRequestFailureException(e, (RepositoryConnection)this);
        }
        for (Asset ass : assets) {
            RepositoryResourceImpl res = ResourceFactory.getInstance().createResourceFromAsset(ass, this);
            resources.add(res);
        }
        return resources.getResourceCollection();
    }
}

