/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.ConfigFileMonitor;
import com.ibm.ws.config.xml.internal.ConfigRefresher;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ServerXMLConfiguration;
import com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.variables.VariableMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigurationMonitor
implements ManagedService {
    static final TraceComponent tc = Tr.register(ConfigurationMonitor.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final String CONFIG_PID = "com.ibm.ws.config";
    private final String UPDATE_TRIGGER = "updateTrigger";
    private final String UPDATE_TRIGGER_PROP = "com.ibm.ws.config.updateTrigger";
    private final String MONITOR_INTERVAL = "monitorInterval";
    private final String MONITOR_INTERVAL_PROP = "com.ibm.ws.config.monitorInterval";
    private final BundleContext bundleContext;
    private final ServerXMLConfiguration serverXMLConfig;
    private final ConfigRefresher configRefresher;
    private ServiceRegistration<ManagedService> managedServiceRegistration;
    private boolean isFirstUpdate = true;
    private ConfigFileMonitor fileMonitor;
    private VariableMonitor variableMonitor;
    private final ConfigVariableRegistry variableRegistry;
    static final long serialVersionUID = 6669627043809303500L;

    public ConfigurationMonitor(BundleContext bc, ServerXMLConfiguration serverXMLConfig, ConfigRefresher configRefresher, ConfigVariableRegistry variableRegistry) {
        this.bundleContext = bc;
        this.serverXMLConfig = serverXMLConfig;
        this.configRefresher = configRefresher;
        this.variableRegistry = variableRegistry;
    }

    public void registerService() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "com.ibm.ws.config");
        this.managedServiceRegistration = this.bundleContext.registerService(ManagedService.class, (Object)this, properties);
    }

    public void unregisterService() {
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
    }

    @Override
    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String fileMonitorType;
        boolean monitorConfiguration;
        if (properties == null || properties.get("monitorInterval") == null) {
            return;
        }
        String updateTriggerSetting = this.bundleContext.getProperty("com.ibm.ws.config.updateTrigger");
        if (updateTriggerSetting == null || !updateTriggerSetting.isEmpty()) {
            updateTriggerSetting = (String)properties.get("updateTrigger");
        }
        ErrorHandler.INSTANCE.setOnError((OnErrorUtil.OnError)properties.get("onError"));
        if ("disabled".equals(updateTriggerSetting)) {
            monitorConfiguration = false;
            fileMonitorType = null;
        } else {
            monitorConfiguration = true;
            fileMonitorType = updateTriggerSetting.equals("mbean") ? "external" : "timed";
        }
        String monitorIntervalProp = this.bundleContext.getProperty("com.ibm.ws.config.monitorInterval");
        Long monitorInterval = monitorIntervalProp == null ? (Long)properties.get("monitorInterval") : Long.valueOf(monitorIntervalProp);
        this.resetConfigurationMonitoring(monitorConfiguration, monitorInterval, fileMonitorType);
        this.isFirstUpdate = false;
    }

    synchronized void resetConfigurationMonitoring(boolean monitorConfiguration, Long monitorInterval, String fileMonitorType) {
        if (this.variableMonitor == null) {
            if (monitorConfiguration) {
                this.variableMonitor = new VariableMonitor(this.bundleContext, monitorInterval, fileMonitorType, this.configRefresher, this.variableRegistry);
                this.variableMonitor.register();
            }
        } else if (monitorConfiguration) {
            this.variableMonitor.update(monitorInterval, fileMonitorType);
        } else {
            this.variableMonitor.unregister();
            this.variableMonitor = null;
        }
        if (this.fileMonitor == null) {
            if (monitorConfiguration) {
                boolean modified = this.isFirstUpdate ? false : this.serverXMLConfig.isModified();
                Collection<String> filesToMonitor = this.serverXMLConfig.getFilesToMonitor();
                Collection<String> directoriesToMonitor = this.serverXMLConfig.getDirectoriesToMonitor();
                this.fileMonitor = new ConfigFileMonitor(this.bundleContext, filesToMonitor, directoriesToMonitor, monitorInterval, modified, fileMonitorType, this.configRefresher);
                this.fileMonitor.register();
            }
        } else if (monitorConfiguration) {
            this.fileMonitor.updateFileMonitor(monitorInterval, fileMonitorType);
        } else {
            this.fileMonitor.unregister();
            this.fileMonitor = null;
        }
    }

    public synchronized void stopConfigurationMonitoring() {
        if (this.fileMonitor != null) {
            this.fileMonitor.unregister();
        }
        this.unregisterService();
    }

    public synchronized void updateFileMonitor(Collection<String> filesToMonitor) {
        if (this.fileMonitor != null) {
            this.fileMonitor.updateFileMonitor(filesToMonitor);
        }
    }

    public synchronized void updateDirectoryMonitor(Collection<String> directoriesToMonitor) {
        if (this.fileMonitor != null) {
            this.fileMonitor.updateDirectoryMonitor(directoriesToMonitor);
        }
    }
}

