/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.writer;

import com.ibm.ws.logging.hpel.LogFileWriter;
import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.impl.AbstractHPELRepositoryExporter;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HPELZipRepositoryExporter
extends AbstractHPELRepositoryExporter {
    private static final String BUNDLE_NAME = "com.ibm.ws.logging.hpel.resources.HpelMessages";
    private static final String className = HPELZipRepositoryExporter.class.getName();
    private static final Logger logger = Logger.getLogger(className, "com.ibm.ws.logging.hpel.resources.HpelMessages");
    private final ZipOutputStream outputStream;
    private final HashSet<String> dirs = new HashSet();
    private LogRepositoryZipManager parentManager = null;

    public HPELZipRepositoryExporter(File archiveFile) throws IOException {
        FileOutputStream output = new FileOutputStream(archiveFile, false);
        this.outputStream = new ZipOutputStream(new BufferedOutputStream(output));
    }

    public void close() {
        super.close();
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            logger.logp(Level.WARNING, className, "finish", "HPEL_ErrorClosingZipStream", ex);
        }
    }

    protected LogRepositoryWriter createWriter(final String pid, final String label) {
        this.parentManager = new LogRepositoryZipManager(){

            @Override
            protected String constructSubDirectory(long timestamp) {
                return this.getLogDirectoryName(timestamp, pid, label);
            }
        };
        return new LogRepositoryZipWriter(this.parentManager);
    }

    protected LogRepositoryWriter createSubWriter(final String pid, final String label, String superPid) {
        return new LogRepositoryZipWriter(new LogRepositoryZipManager(){

            @Override
            protected String constructSubDirectory(long timestamp) {
                if (HPELZipRepositoryExporter.this.parentManager.ivSubDirectory == null) {
                    HPELZipRepositoryExporter.this.parentManager.ivSubDirectory = HPELZipRepositoryExporter.this.parentManager.constructSubDirectory(timestamp);
                }
                return HPELZipRepositoryExporter.this.parentManager.ivSubDirectory + "/" + this.getLogDirectoryName(-1L, pid, label);
            }
        });
    }

    private abstract class LogRepositoryZipManager
    extends LogRepositoryBaseImpl
    implements LogRepositoryManager {
        private static final long MAX_LOG_FILE_SIZE = 0x500000L;
        private String ivSubDirectory;

        private LogRepositoryZipManager() {
            super(new File(""));
            this.ivSubDirectory = null;
        }

        public File checkForNewFile(long total, long timestamp) {
            if (total <= 0x500000L) {
                return null;
            }
            return this.startNewFile(timestamp);
        }

        public boolean purgeOldFiles() {
            return false;
        }

        public File startNewFile(long timestamp) {
            if (this.ivSubDirectory == null) {
                this.ivSubDirectory = this.constructSubDirectory(timestamp);
            }
            return this.getLogFile(new File(this.ivSubDirectory), timestamp);
        }

        public void stop() {
        }

        protected abstract String constructSubDirectory(long var1);
    }

    private class LogRepositoryZipWriter
    extends LogRepositoryWriterImpl {
        public LogRepositoryZipWriter(LogRepositoryZipManager zipManager) {
            super((LogRepositoryManager)zipManager);
            this.setOutOfSpaceAction(2);
        }

        protected LogFileWriter createNewWriter(File file) throws IOException {
            if (!HPELZipRepositoryExporter.this.dirs.contains(file.getParent())) {
                LinkedList<String> missingDirs = new LinkedList<String>();
                for (File dir = file.getParentFile(); dir != null && !HPELZipRepositoryExporter.this.dirs.contains(dir.getPath()); dir = dir.getParentFile()) {
                    missingDirs.addFirst(dir.getPath());
                }
                for (String newDir : missingDirs) {
                    ZipEntry subDirEntry = new ZipEntry(newDir + "/");
                    try {
                        HPELZipRepositoryExporter.this.outputStream.putNextEntry(subDirEntry);
                        HPELZipRepositoryExporter.this.dirs.add(newDir);
                    }
                    catch (IOException ex) {
                        logger.logp(Level.WARNING, className, "createNewWriter", "Exception while adding ZipEntry for directory " + newDir + ": " + ex.getMessage(), ex);
                    }
                }
            }
            return new LogFileZipWriter(file);
        }
    }

    private class LogFileZipWriter
    implements LogFileWriter {
        private final File file;
        private long total = 0L;
        private final byte[] size = new byte[4];

        public LogFileZipWriter(File file) throws IOException {
            this.file = file;
            ZipEntry entry = new ZipEntry(file.getPath());
            HPELZipRepositoryExporter.this.outputStream.putNextEntry(entry);
        }

        public void close(byte[] tail) throws IOException {
            if (tail != null) {
                this.write(tail);
            }
            HPELZipRepositoryExporter.this.outputStream.closeEntry();
        }

        public void write(byte[] b) throws IOException {
            this.writeLength(b.length);
            HPELZipRepositoryExporter.this.outputStream.write(b);
            this.writeLength(b.length);
            this.total += (long)(b.length + 8);
        }

        public long checkTotal(byte[] buffer, byte[] tail) {
            return this.total + (long)buffer.length + (long)tail.length + 16L;
        }

        private void writeLength(int value) throws IOException {
            this.size[3] = (byte)(value >>> 0);
            this.size[2] = (byte)(value >>> 8);
            this.size[1] = (byte)(value >>> 16);
            this.size[0] = (byte)(value >>> 24);
            HPELZipRepositoryExporter.this.outputStream.write(this.size);
        }

        public File currentFile() {
            return this.file;
        }

        public void flush() throws IOException {
        }
    }
}

