/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import com.ibm.ws.kernel.internal.classloader.JarResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarResourceHandler
implements ResourceHandler {
    private final URL url;
    private final boolean verify;
    private File file;
    private boolean downloadedFile;
    private volatile JarFile jarFile;

    public JarResourceHandler(URL url, boolean verify) throws URISyntaxException {
        this.url = url;
        this.verify = verify;
        if ("file".equals(url.getProtocol())) {
            this.file = new File(url.toURI().getPath());
        }
    }

    private File downloadJarFile() throws IOException {
        File file = null;
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            file = File.createTempFile("jarclassloader.", ".jar");
            out = new BufferedOutputStream(new FileOutputStream(file), 2048);
            in = new BufferedInputStream(this.url.openStream(), 2048);
            JarFileClassLoader.copy(in, out);
            file.deleteOnExit();
        }
        catch (Exception e) {
            try {
                JarFileClassLoader.close(out);
                if (file != null) {
                    file.delete();
                }
                throw new IOException("Unable to cache JarFile", e);
            }
            catch (Throwable throwable) {
                JarFileClassLoader.close(in);
                JarFileClassLoader.close(out);
                throw throwable;
            }
        }
        JarFileClassLoader.close(in);
        JarFileClassLoader.close(out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen() throws IOException {
        if (this.jarFile == null) {
            JarResourceHandler jarResourceHandler = this;
            synchronized (jarResourceHandler) {
                if (this.jarFile == null) {
                    if (this.file == null) {
                        this.file = this.downloadJarFile();
                        this.downloadedFile = true;
                    }
                    this.jarFile = new JarFile(this.file, this.verify);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
        if (this.downloadedFile) {
            this.file.delete();
        }
    }

    @Override
    public ResourceEntry getEntry(String name) {
        try {
            this.ensureOpen();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        JarEntry jarEntry = this.jarFile.getJarEntry(name);
        if (jarEntry == null) {
            return null;
        }
        return new JarResourceEntry(this, jarEntry);
    }

    @Override
    public URL toURL() {
        return this.url;
    }

    @Override
    public Manifest getManifest() throws IOException {
        try {
            this.ensureOpen();
        }
        catch (IOException e) {
            return null;
        }
        return this.jarFile.getManifest();
    }

    @Override
    public Set<String> getClassPackages() {
        try {
            this.ensureOpen();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
        Enumeration<JarEntry> enumer = this.jarFile.entries();
        HashSet<String> packageResourceNames = new HashSet<String>();
        while (enumer.hasMoreElements()) {
            String name;
            JarEntry jarEntry = enumer.nextElement();
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).endsWith(".class")) continue;
            int index = name.lastIndexOf(47);
            packageResourceNames.add(index <= 0 ? "" : name.substring(0, index));
        }
        HashSet<String> packageNames = new HashSet<String>(packageResourceNames.size());
        for (String packageResourceName : packageResourceNames) {
            packageNames.add(packageResourceName.replace('/', '.'));
        }
        return packageNames;
    }

    JarFile getJarFile() {
        return this.jarFile;
    }
}

