/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServiceCaller<S> {
    private final Bundle bundle;
    private final Class<S> serviceType;
    private final String filter;
    private final ServicePermission servicePermission;
    private volatile ReferenceAndService service = null;
    static final long serialVersionUID = 8808788513929154057L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static <S> boolean callOnce(Class<?> caller, Class<S> serviceType, Consumer<S> consumer) {
        return ServiceCaller.callOnce(caller, serviceType, null, consumer);
    }

    public static <S> boolean callOnce(Class<?> caller, Class<S> serviceType, String filter, Consumer<S> consumer) {
        return super.getCurrent().map(r -> {
            try {
                consumer.accept(r.instance);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            finally {
                r.unget();
            }
        }).orElse(Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, R> Optional<R> callOnce(Class<?> caller, Class<S> serviceType, Function<S, R> function) {
        ServiceCaller<S> sc = new ServiceCaller<S>(caller, serviceType);
        try {
            Optional<R> optional = sc.call(function);
            return optional;
        }
        finally {
            sc.unget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S, R> Optional<R> callOnce(Class<?> caller, Class<S> serviceType, String filter, Function<S, R> function) {
        ServiceCaller<S> sc = new ServiceCaller<S>(caller, serviceType, filter);
        try {
            Optional<R> optional = sc.call(function);
            return optional;
        }
        finally {
            sc.unget();
        }
    }

    private static int getRank(ServiceReference<?> ref) {
        Object rank = ref.getProperty("service.ranking");
        if (rank instanceof Integer) {
            return (Integer)rank;
        }
        return 0;
    }

    public ServiceCaller(Class<?> caller, Class<S> serviceType) {
        this(caller, serviceType, null);
    }

    /*
     * WARNING - void declaration
     */
    public ServiceCaller(Class<?> caller, Class<S> serviceType, String filter) {
        this.serviceType = Objects.requireNonNull(serviceType);
        this.bundle = Optional.of(Objects.requireNonNull(caller)).map(FrameworkUtil::getBundle).orElseThrow(IllegalStateException::new);
        this.filter = filter;
        this.servicePermission = new ServicePermission(serviceType.getName(), "get");
        if (filter != null) {
            try {
                FrameworkUtil.createFilter((String)filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.service.util.ServiceCaller", (String)"399", (Object)this, (Object[])new Object[]{caller, serviceType, filter});
                throw new IllegalArgumentException((Throwable)e);
            }
        }
    }

    private BundleContext getContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> this.bundle.getBundleContext());
        }
        return this.bundle.getBundleContext();
    }

    public boolean call(Consumer<S> consumer) {
        return this.trackCurrent().map(r -> {
            consumer.accept(r.instance);
            return Boolean.TRUE;
        }).orElse(Boolean.FALSE);
    }

    public <R> Optional<R> call(Function<S, R> function) {
        return Optional.ofNullable(this.trackCurrent().map(r -> function.apply(r.instance)).orElse(null));
    }

    public Optional<S> current() {
        return this.trackCurrent().map(r -> r.instance);
    }

    private Optional<ReferenceAndService> trackCurrent() {
        ReferenceAndService current = this.service;
        if (current != null) {
            return Optional.of(current);
        }
        return this.getCurrent().flatMap(r -> {
            ServiceCaller serviceCaller = this;
            synchronized (serviceCaller) {
                if (this.service != null) {
                    r.unget();
                    return Optional.of(this.service);
                }
                return r.track();
            }
        });
    }

    private Optional<ReferenceAndService> getCurrent() {
        BundleContext context = this.getContext();
        if (System.getSecurityManager() != null && this.bundle.hasPermission((Object)this.servicePermission)) {
            return AccessController.doPrivileged(() -> this.getCurrentInternal(context));
        }
        return this.getCurrentInternal(context);
    }

    private Optional<ReferenceAndService> getCurrentInternal(BundleContext context) {
        return this.getServiceReference(context).map(r -> {
            Object current = context.getService(r);
            return current == null ? null : new ReferenceAndService(context, r, current);
        });
    }

    private Optional<ServiceReference<S>> getServiceReference(BundleContext context) {
        if (context == null) {
            return Optional.empty();
        }
        if (this.filter == null) {
            return Optional.ofNullable(context.getServiceReference(this.serviceType));
        }
        try {
            return context.getServiceReferences(this.serviceType, this.filter).stream().findFirst();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.service.util.ServiceCaller", (String)"515", (Object)this, (Object[])new Object[]{context});
            return Optional.empty();
        }
    }

    public void unget() {
        ReferenceAndService current = this.service;
        if (current != null) {
            current.unget();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.ServiceCaller", ServiceCaller.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ReferenceAndService
    implements SynchronousBundleListener,
    ServiceListener {
        final BundleContext context;
        final ServiceReference<S> ref;
        final S instance;
        final int rank;
        static final long serialVersionUID = 837119217919020694L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ReferenceAndService(BundleContext context, ServiceReference<S> ref, S instance) {
            this.context = context;
            this.ref = ref;
            this.instance = instance;
            this.rank = ServiceCaller.getRank(ref);
        }

        void unget() {
            this.untrack();
            try {
                this.context.ungetService(this.ref);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.kernel.service.util.ServiceCaller$ReferenceAndService", (String)"261", (Object)this, (Object[])new Object[0]);
            }
        }

        public void bundleChanged(BundleEvent e) {
            if (ServiceCaller.this.bundle.equals(e.getBundle()) && e.getType() == 256) {
                this.unget();
            }
        }

        public void serviceChanged(ServiceEvent e) {
            if (this.requiresUnget(e)) {
                this.unget();
            }
        }

        private boolean requiresUnget(ServiceEvent e) {
            if (e.getServiceReference().equals(this.ref)) {
                return e.getType() == 4 || ServiceCaller.this.filter != null && e.getType() == 8 || e.getType() == 2 && ServiceCaller.getRank(this.ref) != this.rank;
            }
            return e.getType() == 2 && ServiceCaller.getRank(e.getServiceReference()) > this.rank;
        }

        /*
         * WARNING - void declaration
         */
        Optional<ReferenceAndService> track() {
            try {
                ServiceCaller.this.service = this;
                this.context.addServiceListener((ServiceListener)this, "(&(objectClass=" + ServiceCaller.this.serviceType.getName() + ")" + (ServiceCaller.this.filter == null ? "" : ServiceCaller.this.filter) + ")");
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(() -> {
                        this.context.addBundleListener((BundleListener)this);
                        return null;
                    });
                } else {
                    this.context.addBundleListener((BundleListener)this);
                }
                if ((this.ref.getBundle() == null || this.context.getBundle() == null) && ServiceCaller.this.service == this) {
                    this.unget();
                }
                if (ServiceCaller.getRank(this.ref) != this.rank) {
                    this.unget();
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.kernel.service.util.ServiceCaller$ReferenceAndService", (String)"318", (Object)this, (Object[])new Object[0]);
                ServiceCaller.this.service = null;
                throw new IllegalStateException((Throwable)e);
            }
            catch (IllegalStateException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.service.util.ServiceCaller$ReferenceAndService", (String)"322", (Object)this, (Object[])new Object[0]);
                ServiceCaller.this.service = null;
            }
            return Optional.of(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack() {
            ServiceCaller serviceCaller = ServiceCaller.this;
            synchronized (serviceCaller) {
                if (ServiceCaller.this.service == this) {
                    ServiceCaller.this.service = null;
                }
                try {
                    this.context.removeServiceListener((ServiceListener)this);
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(() -> {
                            this.context.removeBundleListener((BundleListener)this);
                            return null;
                        });
                    } else {
                        this.context.removeBundleListener((BundleListener)this);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.kernel.service.util.ServiceCaller$ReferenceAndService", (String)"350", (Object)this, (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.util.ServiceCaller$ReferenceAndService", ReferenceAndService.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
        }
    }
}

